// FILE:		z0dd_gamma.cs
// VERSION:		1.0
// DATE:		1/19/2001
// AUTHOR:		Paul "z0dd" Paella
// EMAIL:		z0dd@adelphia.net
// WEBPAGE:		http://home.adelphia.net/~z0dd/
//
// DESCRIPTION:
//
//	This script allows you increase and decrease your gamma WHILE
//	playing! One key bind is set up to increase gamme and another is
//	decreasing.
//
//
// Version history:
//	1.0	- Initial version.
//
//
// INSTALLATION:
//	This script doesn't require and won't conflict with presto pack.
//
//	Put z0dd_gamma.cs into your:
//		...\tribes\config
// 	directory.
//
//	Insert this line into your autoexec.cs:
//	exec("z0dd_gamma.cs");
//
//	Edit the key binds in the USER CONFIGURATION SECTION before
//	running this script. 
//
//

// Don't edit the following line
editActionMap("playMap.sae");

////////////////////////////////////////////////////////////////////////////
//////////////////////// USER CONFIGURATION SECTION ////////////////////////
////////////////////////////////////////////////////////////////////////////
//
// INCREASE GAMMA KEY
// The key to increase gamma while playing.
// The default key is "shift numpad+"
bindCommand(keyboard0, make, shift, "numpad+", TO, "z0dd_gamma::ChangeGamma(0.25);");
bindCommand(keyboard0, break, shift, "numpad+", TO, "");

// DECREASE GAMMA KEY
// The key to decrease gamma while playing.
// The default key is "shift numpad-"
bindCommand(keyboard0, make, shift, "numpad-", TO, "z0dd_gamma::ChangeGamma(-0.25);");
bindCommand(keyboard0, break, shift, "numpad-", TO, "");

// LOWEST GAMMA SETTING
// This value is the lowest value your gamma will go to when using this script.
// Don't change this value if you don't know what you're doing
$z0dd_gamma::low = 0.25;

// HIGHEST GAMMA SETTING
// This value is the highest value your gamma will go to when using this script.
// Don't change this value if you don't know what you're doing
$z0dd_gamma::high = 10.0;


/////////////////////////////////////////////////////////////////////////////////////////
// controls how long msgs are displayed
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0dd_gamma::TurnOffCP()
{
	$z0dd::CenterPrintCounter--;
	if(!$z0dd::CenterPrintCounter)
		Client::centerPrint("", 1);
}

function z0dd_gamma::ChangeGamma(%val)
{
	$pref::VideoGamma += %val;
	
	if($pref::VideoGamma < $z0dd_gamma::low) {
		Client::centerPrint("<jc>MINIMUM gamma set!", 1);
		$pref::VideoGamma = $z0dd_gamma::low;
	}
	else if($pref::VideoGamma > $z0dd_gamma::high) {
		Client::centerPrint("<jc>MAXIMUM gamma set!", 1);
		$pref::VideoGamma = $z0dd_gamma::high;
	}
	else {
		setGamma(MainWindow, 0.05 + (1.95 * $pref::VideoGamma));
		flushTextureCache();
		resetUpdateRegion(MainWindow);	
		Control::setValue(IDCTG_OPTS_VID_GAMMA, $pref::VideoGamma);
		return;
	}

	$z0dd::CenterPrintCounter++;
	schedule("z0dd_gamma::TurnOffCP();", 2);	
}
