//////////////////////////////////////////////////////////////////////////////
//////////////////////////////// DESCRIPTION: ////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Filename:	z0dd_hud.cs
// Version:	v2.1
// Date:	2/24/01
// Author:	Paul "z0dd" Paella (z0dd@adelphia.net)
// Based on:	Some work from Prodigy (matt1001@earthlink.com)
// Description:	A HUD (pack?) for Tribes 1
// URL:		http://home.adelphia.net/~z0dd/
//
//////////////////////////////////////////////////////////////////////////////
////////////////////////////// VERSION HISTORY: //////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// Version history:
//	2.1	- Fixed problems encountered when players used nicknames
//		  simliar to some server messages. The following global
//		  message will be displayed when a player with a problem nick 
//		  enters a server you're on: "nickname is a Nick Weasel!! You
//		  should kick this player from the server."
//		  One or more of the following features will be deactivated
//		  while a Nick Weasel is on the same server as you:
//			a) "I'm repairing ____" team messager
//			b) Filtering of "SOLD ____" messages
//			c) Filtering of "____ is not damaged" message
//		- Added more functionality to the Mute feature. There's a key
//		  to cycle through 4 mute options: No muting, Mute everyone,
//		  mute teammates, mute enemies.
//		- Increased performance. I rewrote the Kill Tracker and
//		  optimized the other intensive functions.
//
//	2.01	- Fixed a problem that prevented the Pack HUD from working
//		  when the Ammo HUD option was off.
//
//	2.0	- Number of players per team HUD
//		- Option to use one of two HUD displays. You can choose the
//		  new, thinner, icon-based HUD or the original layout.
//		- Reduced the size of the text on the original layout HUD.
//		- Option to pick how dark you want the component backgrounds.
//		- Ammo HUD displays ammo of currnt weapon near your crosshair.
//		- Pack HUD displays the backpack you're using. Created so you
//		  could turn off the default Weapon/Pack HUD and use my ammo
//		  and pack hud.
//		- Optimized much of the code, resulting in better performance.
//		- Removed the "HUD CHOICE" options. No one used them. You can
//		  still move the HUD components around by modifying the x & y
//		  coordinates in the function:
//		  z0ddhud::CreateGUI()
//		  See that function for details.
//		- Removed the broken objective tracking code. z0dd_hud no
//		  longer takes into account ANY objectives. They don't belong
//		  in CTF maps anyways.
//
//	1.81	- Added documentation describing how to set favorites with
//		  this HUD. See the section labeled: AUTO-FAVORITES.
//
//	1.8	- Auto-rejoin full servers. Option to try and rejoin a full
//		  server. If on, this feature will automatically keep trying
//		  to join that server until either you get in (duh) or you
//		  click on a different server in the server list.
//		  See the AUTO-REJOIN section in the USER CONFIGURATION
//		  SECTION
//		- MUTE ALL PLAYERS feature. This allows you to mute ALL
//		  messages from ALL players. you will still see game messages
//		  such as ""=V= Sepultura was gunned down by =V= z0dd". It
//		  only mutes messages from players. See the MUTE ALL PLAYERS
//		  section in the USER CONFIGURATION SECTION. I added this 
//		  because pub games with idiots running useless team spam
//		  messages such as "The enemy has our flag" were driving me
//		  crazy!!!!!
//		- Changed the script messages to print in the bottom middle
//		  of the screen instead of bottom left.
//
//	1.7	- Added options to turn of individual HUD components.
//		  Search for: DISPLAY OPTIONS
//		- Added option to have flag carriers (both friendly and enemy)
//		  automatically targeted when they pick up the flag.
//		  Search for: $z0ddhud::autoTargFriendlyCarrier 
//		         and: $z0ddhud::autoTargEnemyCarrier
//		- Cleaned up the centerprint messaging code
//		- Made auto-fav purchases quicker. Unfortunately, I now have
//		  no way to disquish a remote inventory from a full sized
//		  inventory when the inventory list is turned off. So, items
//		  will be spewed from remotes when the inv list is off. Also,
//		  this hid will try to purchase the currently set auto-fav
//		  when you enter a remote inventory. This is fine if you are in
//		  a light and request a light fav. Obviously, you won't get
//		  MED or HVY armor from a remote.  :)
//		  Another side effect is auto-favs will be purchased when the
//		  inv list is off and you enter a full-sized inventory.
//		  Auto-favs are NOT purchsed when you have the inv list off and
//		  enter a remote inventory. This was a design decision and can
//		  be changed. I like it this way. 
//		- Added an option to have a team msg displayed when you leave
//		  a station. Search for: $z0ddhud::AutoMsgAtStations
//
//	1.6	- Added option to filter useless mesages from appearing in the
//		  msg box.
//		- Added popup timers. There's a generic timer that you can
//		  specify where the countdown starts. There is also a timer
//		  that tracks Repair Pack respawn times.
//		  Search for: TIMER
//		- Support for all CTF map objectives (except OlympusMons; I'll
//		  fix this some other time)
//
//	1.5	- Added Auto favorites.
//		  This allows you to have your favorites automatically
//		  purchased when you enter a base inventory station.  If you
//		  use my z0dd_spew.cs script, I have an option to automatically
//	 	  activate the cluster spew mode everytime you enter a base
//		  inventory station.
//		  See the section labeled: STATION OPTIONS to configure the new
//		  options. 
//		  NOTE1: Base inventory station means it only works for regular,
//		         non-deployed, non-vehicle, non-command stations.
//		  NOTE2: If you're using my z0dd_spew.cs, make sure the line
//			 exec("z0dd_spew.cs");
//			 comes before the line
//                       exec("z0dd_hud.cs");
//			 in your autoexec.cs file.
//		  Thanks to writer for fast favorites idea.
//
//	1.41	- Put in checks for when the Dropped Flag timer is < 0.
//		  Fixed a couple of other issues with switching teams and
//		  the dropped flag timers.
//
//	1.4	- Added Flag targeting (setting waypoint to flag carriers).
//		  See TARGET FLAG KEYS in the USER CONFIGURABLE SECTION to
//		  change the default keys used for flag targeting.
//
//	1.3	- Fixed(?) a never ending scheduling problem occurring when
//		  you disconnect form a server and reconnect (not neccessarily
//		  to same server)
//
//	1.2	- Added auto-turnaround at stations
//
//	1.1	- Added dropped flag timers
//
//	1.0	- Fixed a few bugs.
//		- Sped the HUD up quit a bit.
//
//	0.96	- Added HUD modularity allowing user to place individual HUD
//		  components wherever they choose, or use 1 of 4 default
//		  layouts.
//
//	0.95	- Added support for automatic blaster dropping.  You can bind
//		  blaster dropping to a key.
//		- Fix a bug that would cause tribes to crash if you connected
//		  to a server after already having played on a server during
//		  the same tribes session.
//
//////////////////////////////////////////////////////////////////////////////
///////////////////////////// ADDTIONAL CREDIT: //////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	- This code is based on the work of many other people including:
//	  KillerBunny and his classic Dyn-HUD.
//
//	- Presto for his PrestoPak - AMAZING amount of thought in the
//	  prestopak.
//
//	- killtraking is based on the JHUD code by Josh.
//
//	- Writer for idea on how to determine what type of station you're at.
//
//	- And most of all, the dedicated Tribes players for suggesting most
//	  of the groovy features.
//
//////////////////////////////////////////////////////////////////////////////
/////////////////////////////// INSTALLATION: ////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	(1) Put z0dd_hud.cs in your: 
//		...\tribes\config
//	    directory
//
//      (2) Put this line:
//	  	exec("z0dd_hud.cs");
//	    in your autoexec.cs file. This file should be in the
//          ...\tribes\config
//          directory. Create this text file if it isn't there.
//
// 	(3) Edit the user options in the area labeled:
//          USER CONFIGURATION SECTION
//
//      (4) Run tribes. Make sure you edit the key binds and otpions
//	    before you run tribes.
//
//////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// NOTES: ///////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	- This HUD will most likely conflict with other HUDs and will
//	  defintely conflict with Presto Pack.
//
//	- This HUD is mainly for base CTF. It will act strange while playing
//	  mods or other Tribes game types such as C&H, D&D, etc.
//
// 	Bugs:
// 	1) "z0dd gets real friendly with a rocket" doesn't give the shooter of
//	   the rocket a point.  The problem lies in the tribes msg code.  The
//	   tribes engine doesn't display who fired the the missile.
//	   This may be fixed. I haven't seen it rear it's ugly head in over
//	   a year.
//
//	2) There may be times when Tribes crashes when you play on a server,
//	   exit the game, and enter another server (not neccessarily the same
//	   one). Add 5 to the user-variable $z0ddhud::reconnectTime if this
//	   happens to you.
//
//
//	Notes to other Tribes scripters:
//	1) You may notice this script isn't easy to work with. I sacrifced
// 	   elegance and ease-of-use for performance. Every elegeant, easy to
//	   use piece of code I wrote was much slower than it's optimized
//	   counterpart. This was a neccessary price for speed.
//	   

// Don't edit the line below
editActionMap("playMap.sae");


//////////////////////////////////////////////////////////////////////////////
///////////////////////// USER CONFIGURATION SECTION /////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//
// --------------------------- KEY BINDING NOTES -----------------------------
//
// The following are some notes on binding keys. This is a typical key binding
// showing CONTROL+r being bound to a function named: z0ddhud::Reset()
//
// bindCommand(keyboard0, make, control, "r", TO, "z0ddhud::Reset();");
// bindCommand(keyboard0, break, control, "r", TO, "");
//
// You don't need to be concerned with the function it calls. As a user, you
// should only need to edit this part: control, "r"
//
// The key binding is specified in quotes. In this example, "r" tells tribes
// that you want to use the r key for this feature. The "control, " part tells
// tribes that you want CONTROL+r to activate this feature. Remove the
// "control, " part if you don't want a key-combo to activate the given
// feature. Here is a list of key-combo identifiers:
//
// control	(left or right control key)
// lcontrol	(left control key)
// rcontrol	(right control key)
// shift	(left or right shift key)
// lshift	(left shift key)
// rshift	(right shift key)
//
// Don't use lkey or rkey key-combo bindings if you are using one of their
// sideless counterparts. For example, don't bind lshift+t if you have the
// shift key already bound to something.
//

// ---------------------------- HUD LAYOUT CHOICE ----------------------------
// HUD LAYOUT CHOICE
// You can choose between the new icon-based layout or the original layout.
// The default is the new layout.
// 1: new layout
// 0: old layout
//		
$z0ddhud::NewLayout = 1;

// TRANSPARENCY LEVEL
// Transparency/background display level.
// This controls how many dark backgrounds you want drawn behind the HUDs.
// Enter a value between 0 and however many backgrounds you want. I wouldnt
// use more then 5.
// 0 equals no background. 1 is a single black background. 2 is darker than
// 1, etc. The original z0dd_hud used 2 backgrounds.
// Default = 2
$z0ddhud::bgLevel = 2;


// ------------------------- HUD COMPONENT LOCATIONS -------------------------
// You can move the on screen HUD components anywhere you like if you don't
// like the default locations. Make sure you know what you're doing before
// trying this. You can move the components around by modifying the x & y
// coordinate values in the function: z0ddhud::CreateGUI()
// Go there for more details.
//
// Toggle z0dd_hud off (default key is control+h) to move the built in Tribes
// displays, such as the chat box, game timer, compass, etc..


// ------------------------------ HUD AUTO-START -----------------------------
// AUTO START
// Controls whether or not the HUD will automatically be on when enter a game.
// 0: HUD is off when you enter a game until you toggle it on
// non-zero: HUD is up when you enter a game
// Default is 1
$z0ddhud::autoStartHUD = 1;

// ----------------------------- DISPLAY OPTIONS -----------------------------
// HUD DISPLAYED
// Turns the following HUDs on or off: 'myScore', 'Greandes', 'Mines',
// 'Beacons', 'Kit', 'Team', Pack', 'Ammo'
// Turning off the 'myScore' display may increase fps on slower systems.
//
// zero: disable (turn off) that HUD
// non-zero: enable that HUD element
// Default: all 1
$z0ddhud::myScoreHudOn = 1;	// "MyScore" HUD. Displays your score
$z0ddhud::grensHudOn = 1;  	// "Grens" HUD. Shows # of grenades
$z0ddhud::minesHudOn = 1;  	// "Mines" HUD. Shows # of mines
$z0ddhud::beacsHudOn = 1;  	// "Beacs" HUD. Shows # of beacons
$z0ddhud::kitHudOn = 1;    	// "Kit" HUD. Shows if you have repair kit
$z0ddhud::teamHudOn = 1;	// "Team count" HUD. Shows # of players/team
$z0ddhud::packHudOn = 1;	// "Pack" HUD. Shows the pack you're using
$z0ddhud::ammoHudOn = 1;   	// Ammo count hud. Displays ammo near xhair

// AMMO HUD COORDINATES
// The next two values specify the top left location of the ammo HUD.
// The X value is the number of pixels from the left side of the screen.
// The Y value is the number of pixels from the top of the screen.
// The default values, 410 and 305, put the ammo HUD slighty down and to the
// right from the middle of a 800x600 screen. 800/2=400, 600/2=300.
// These default values put the ammo counter in a nice spot for my crosshair.
// Adjust the values based on your crosshair. You may need to tweak them
// a few times to find the perfect spot.
// These values have no relevence if you disable the Ammo HUD.
$z0ddhud::ammoHudX = 410;
$z0ddhud::ammoHudY = 305;
                  
                           
// --------------------------- STATION OPTIONS -------------------------------
// DISPLAY INVENTORY LIST
// Controls whether or not you want see the inventory station list when you
// enter a base inventory station, or to automatically be brought to 1st
// person point of view. You can toggle this option on when you want to
// purchase items, or vehicles, from a remote inv station or vehciel station.
// You can also enter a station and press the 'inventory' key to see the
// inventory list (the default tribes bind is 'i').
//
// 0: Don't display purcahse list when entering inventory stations.
// non-zero: the station purchasing display comes up as normal.
// Default: 0
$z0ddhud::ShowInvList = 0;

// TOGGLE INVENTORY LIST KEY
// The key to toggle the displaying of the inventory purchasing list.
// Default key: 'CONTROL+i'
bindCommand(keyboard0, make, control, "i", TO, "z0ddhud::ToggleShowInvList();");
bindCommand(keyboard0, break, control, "i", TO, "");


//                             AUTO-FAVORITES
//
// The following are instructions to set your favorites when using z0dd_hud.
// Follow these steps in order.
//
// 1)  Decide how many favorites you want and what they will include.
//
// 2)  Add one key binding line in the "Auto-favorite set key binds" section for
//     every favorite you want. For example, if you have 12 favorites you'll
//     have 12 key binding lines in that section. By default, there are ten
//     favorites bound to alt+1 to alt+0. Simply copy one of the lines, add 1 to
//     the part in the parenthesis, and change the key bind.
//     For example, to add an 11th favorite bound to the 'alt+q' key, you would
//     add this line after the 10th entry:
//     bindCommand(keyboard0, make, alt, "q", TO, "z0ddhud::ChangeAutoFav(11);");
//
// 3)  Once you're done with the "Auto-favorite set key binds" section you should
//     edit the "AUTO-FAVORITE MESSAGES" section. You should have one line in
//     this section for every favorite bound in the "Auto-favorite set key binds"
//     section. These lines tell tribes what message will be printed at the
//     bottom of the screen when you select a favorite. This does NOT specify
//     what's contained in your favorite. We'll do this in steps 6-10.
//
// 4)  Once your done with the "AUTO-FAVORITE MESSAGES" section you should edit
//     the "AUTO-FAVORITE BUY KEY BINDS" section. You should have one line in
//     this section for every fav bound in the "Auto-favorite set key binds"
//     section. These binds allow you to buy a specific favorite when you're
//     at an inventory.
//
// 5)  Load tribes.
//
// 6)  Enter a station. z0dd_hud will try to buy a favorite. Don't worry if
//     it does or doesn't.
//
// 7)  Display the inventory list (if it isn't already displayed) by pressing
//     the "i" key. 'i' is the default key to bring up the inventory list. 
//     It might be bound to a different key.
//
// 8)  BUY the first favorite in your list by pressing the buy key for your
//     fav #1. This key was defined in the "AUTO-FAVORITE BUY KEY BINDS"
//     section. The default key for buying your first favorite is bound to
//     "shift+1".
//
// 9)  Buy the items you want for this favorite (Armor, weapons, etc..).
//
// 10) Press the "MARK FAVORITE" button.
//
// Don't worry if this screen shows a different fav# highlighted. You have
// just set whatever fav# you selected prior to enetering the station.
// Repaet steps 6 through 10 for the rest of your favorites.
// 

// Auto-favs ON when Tribes loads:
// Controls whether or not you want to automatically purchase favorites when
// you enter a base inventory station. 
// Make this 1 if you want to use auto-favorites when you load tribes.
// Make this 0 if you DON'T want to use auto-favorites when you load tribes.
//
// 0: don't automatically buy specified favorites at inventory stations
// non-zero: automatically buy specified favorites at inventory stations
// Default: 1
$z0ddhud::AutoFavorites = 1;

// AUTO-FAVORITE SET KEY BINDS
// The keys to pick which favorite will be purchased automatically when you
// enter a inventory station.  The defaults are set to ALT+1 to ALT+0.
// These keys don't select anything if you have $z0ddhud::AutoFavorites
// set to 0.
bindCommand(keyboard0, make, alt, "1", TO, "z0ddhud::ChangeAutoFav(1);");
bindCommand(keyboard0, make, alt, "2", TO, "z0ddhud::ChangeAutoFav(2);");
bindCommand(keyboard0, make, alt, "3", TO, "z0ddhud::ChangeAutoFav(3);");
bindCommand(keyboard0, make, alt, "4", TO, "z0ddhud::ChangeAutoFav(4);");
bindCommand(keyboard0, make, alt, "5", TO, "z0ddhud::ChangeAutoFav(5);");
bindCommand(keyboard0, make, alt, "6", TO, "z0ddhud::ChangeAutoFav(6);");
bindCommand(keyboard0, make, alt, "7", TO, "z0ddhud::ChangeAutoFav(7);");
bindCommand(keyboard0, make, alt, "8", TO, "z0ddhud::ChangeAutoFav(8);");
bindCommand(keyboard0, make, alt, "9", TO, "z0ddhud::ChangeAutoFav(9);");
bindCommand(keyboard0, make, alt, "0", TO, "z0ddhud::ChangeAutoFav(10);");

// AUTO FAVORITE TO START WITH
// The default auto-favorite you want selected when you load tribes.
// The default is  1 
$z0ddhud::AutoFav = 1;

// AUTO-FAVORITE MESSAGES
// The messages that are displayed when the corresponding AutoFav key
// is pressed. Use any string that you like (of a resonably length)
// To add more, simply follow the counting progression of
// $z0ddhud::AutoFavMsg[1], $z0ddhud::AutoFavMsg[2], etc....
$z0ddhud::AutoFavMsg[1] = "Hvy (Energy pack)";
$z0ddhud::AutoFavMsg[2] = "Hvy (Ammo pack)";
$z0ddhud::AutoFavMsg[3] = "Hvy (Shield pack)";
$z0ddhud::AutoFavMsg[4] = "Hvy (Repair pack)";
$z0ddhud::AutoFavMsg[5] = "Hvy (Ammo Station)";
$z0ddhud::AutoFavMsg[6] = "Hvy (Inv Station)";
$z0ddhud::AutoFavMsg[7] = "Med (Inv Station)";
$z0ddhud::AutoFavMsg[8] = "Light (Energy & GL)";
$z0ddhud::AutoFavMsg[9] = "Light (Energy & Rifle)";
$z0ddhud::AutoFavMsg[10] = "Light (Shield & Plasma)";

// AUTO-FAVORITE BUY KEY BINDS
// The keys to buy a specific fav when you are AT an inventory station. 
// The defaults are set to SHIFT+1 to SHIFT+0.
// To add more, simply follow the counting progression as shown below.
// These keys do nothing of you have $z0ddhud::AutoFavorites set to 0.
bindCommand(keyboard0, make, shift, "1", TO, "CmdInventoryGui::buyFavorites(1);");
bindCommand(keyboard0, make, shift, "2", TO, "CmdInventoryGui::buyFavorites(2);");
bindCommand(keyboard0, make, shift, "3", TO, "CmdInventoryGui::buyFavorites(3);");
bindCommand(keyboard0, make, shift, "4", TO, "CmdInventoryGui::buyFavorites(4);");
bindCommand(keyboard0, make, shift, "5", TO, "CmdInventoryGui::buyFavorites(5);");
bindCommand(keyboard0, make, shift, "6", TO, "CmdInventoryGui::buyFavorites(6);");
bindCommand(keyboard0, make, shift, "7", TO, "CmdInventoryGui::buyFavorites(7);");
bindCommand(keyboard0, make, shift, "8", TO, "CmdInventoryGui::buyFavorites(8);");
bindCommand(keyboard0, make, shift, "9", TO, "CmdInventoryGui::buyFavorites(9);");
bindCommand(keyboard0, make, shift, "0", TO, "CmdInventoryGui::buyFavorites(10);");

// AUTO-FAVORITES TOGGLE KEY
// The key to toggle Auto Favorites on and off.
// Default key is 'CONTROL+a'
bindCommand(keyboard0, make, control, "a", TO, "z0ddhud::ToggleAutoFavs();");
bindCommand(keyboard0, break, control, "a", TO, "");

// AUTO-MESSAGES AT STATIONS
// Automatically display a team message when you leave a inventory.
// 0: Turn off "Automatic Station Messages" when leaving stations.
// 1: Will display a team msg every time you leave a station. The msg is
//    taken from the above AutoFavMsg msgs
// Default: 0
$z0ddhud::AutoMsgAtStations = 0;

// AUTO-MESSAGES AT STATIONS TOGGLE KEY
// The key to toggle "Automatic Station Messages" on and off.
// Default key is 'CONTROL+n'
bindCommand(keyboard0, make, control, "n", TO, "z0ddhud::ToggleAutoStationMsgs();");
bindCommand(keyboard0, break, control, "n", TO, "");

// CLUSTER SPEW ON AT START
// Controls whether or not my cluster mode spew script is automatically
// called when you enter a base inventory station.
// You must be using my z0dd_spew.cs script for this to work. Also, 
// in your autoexec.cs file, exec("z0dd_spew.cs"); must come before
// exec("z0dd_hud.cs");
// 0: don't automatically use the cluster spew mode when at base inv stations
// non-zero: automatically use the cluster spew mode when at base inv stations
// Default: 1
$z0ddhud::ClusterSpew = 1;

// CLUSTER SPEW ON AT START TOGGLE KEY
// The key to toggle automatic cluster spew on and off.
// Default key is 'CONTROL+b'
bindCommand(keyboard0, make, control, "b", TO, "z0ddhud::ToggleAutoSpew();");
bindCommand(keyboard0, break, control, "b", TO, "");

// AUTO STATION TURN AROUND
// Controls whether or not you want to be automatically turned around when
// entering stations (Inventory, Command and Remote Inventory)
// 0: don't auto-turnaround at stations.
// non-zero: automatically turn around at stations
// Default: 0
$z0ddhud::StationTurnAround = 0;

// AUTO STATION TURN AROUND SPEEDS
// These are used to turn you around in at an invenory station. If you're
// happy with the turnaround, leave them alone. Otherwise, adjust them
// slightly! Higher time will turn you further around as will a higher turn
// speed. Thank Presto for the default numbers.
// Defaults: 0.65 and 0.18
$z0ddhud::TurnAroundSpeed = 0.65;
$z0ddhud::TurnAroundTime = 0.18;


// ---------------------------- BLASTER AUTODROP -----------------------------
// AUTO-DROP BLASTER
// Turns blaster auto-drop on and off. Default is off, no auto-dropping.
// 0: turn off auto drop blaster.
// non-zero: drop the blaster whenever you pick it up
// Default: 0
$z0ddhud::autoDropBlaster = 0;

// WEAPON PREFENCES FOR POST BLASTER DROP READYING
// These weapon preferences are the order that weapons are picked when you
// pickup, and automatically drop, the Blaster.  For instance. If you pickup
// a blaster while only carrying the Mortar and ELF Gun, you'll drop the
// blaster and ready the mortar (because it comes before ELF Gun in the
// default setup below).
// Note: If you have the auto-drop blaster option turned off, you can still
// use the Drop blaster bind key (in next section) to drop the blaster and
// select a weapon based on the preferecnes below
$z0ddhud::weaponPreference1 = "Disc Launcher";
$z0ddhud::weaponPreference2 = "Chaingun";
$z0ddhud::weaponPreference3 = "Mortar";
$z0ddhud::weaponPreference4 = "Grenade Launcher";
$z0ddhud::weaponPreference5 = "Laser Rifle";
$z0ddhud::weaponPreference6 = "Plasma Gun";
$z0ddhud::weaponPreference7 = "ELF gun";

// AUTO-DROP BLASTER KEY
// The key to drop the blaster.
// Default is 'x'
bindCommand(keyboard0, make, "x", TO, "z0ddhud::dropBlaster();");
bindCommand(keyboard0, break, "x", TO, "");

// TOGGLE DROPPING BLASTER ON/OFF KEY
// Toggle dropping on/off (off means you will only switch to your wpn fav)
// Default is control+x
bindCommand(keyboard0, make, control, "x", TO, "z0ddhud::ToggleDropBlaster();");
bindCommand(keyboard0, break, control, "x", TO, "");


// ---------------------------- TARGET FLAG KEYS -----------------------------
// Pressing these keys will set your waypoint to the friendly or enemy flag
// carriers.  Note: there will be times when the script will not be able to
// properly set your waypoint to the enemy flag carrier.  This is due to the
// requirement that the enemy must be in sensor view to set a waypoint to him.
// The waypoint will be to some out of bounds area if he isn't in your sensor
// grid.
//
// AUTOMATICALLY TARGET FRIENDLY FLAG CARRIER
// 0: don't automatically target teammates when they pick up flag
// non-zero: automatically target teammates when they pick up flag
// Default: 0
$z0ddhud::autoTargFriendlyCarrier = 0;

// TOGGLE AUTOMATICALLY TARGETING OF FRIENDLY FLAG CARRIER
// The key to toggle the "auto friendly carrier targeting"
// Default: CONTROL+k
bindCommand(keyboard0, make, control, "k", TO, "z0ddhud::ToggleAutoTarget(friendly);");
bindCommand(keyboard0, break, control, "k", TO, "");

// AUTOMATICALLY TARGET ENEMY FLAG CARRIER
// 0: don't automatically target enemies when they pick up flag
// non-zero: automatically target enemies when they pick up flag
// Default: 0
$z0ddhud::autoTargEnemyCarrier = 0;

// TOGGLE AUTOMATICALLY TARGETING OF ENEMY FLAG CARRIER
// The key to toggle the "auto enemy carrier targeting"
// Default: CONTROL+l
bindCommand(keyboard0, make, control, "l", TO, "z0ddhud::ToggleAutoTarget(enemy);");
bindCommand(keyboard0, break, control, "l", TO, "");

// TARGET ENEMY FLAG CARRIER KEY
// The key to target the player carrying your flag.
// Default: n
bindCommand(keyboard0, make, "n", TO, "z0ddhud::targCarrier(enemy);");
bindCommand(keyboard0, break, "n", TO, "");

// TARGET FRIENDLY FLAG CARRIER KEY
// The key to target the player carrying enemy flag.
// Default: b
bindCommand(keyboard0, make, "b", TO, "z0ddhud::targCarrier(friendly);");
bindCommand(keyboard0, break, "b", TO, "");


// --------------------------- HUD TOGGLE / RESET ----------------------------
// TOGGLE HUD UP/DOWN KEY
// Default: CONTROL+h
bindCommand(keyboard0, make, control, "h", TO, "z0ddhud::Toggle();");
bindCommand(keyboard0, break, control, "h", TO, "");

// RESET THE HUD NUMBERS KEY
// Resetting the HUD sets all values to zero
// Default: CONTROL+r
bindCommand(keyboard0, make, control, "r", TO, "z0ddhud::Reset();");
bindCommand(keyboard0, break, control, "r", TO, "");


// ---------------------------- ALTER CTF SCORE ------------------------------
// MODIFY FRIENDLY CTF SCORE KEY
// Add and subtract friendly CTF team points. Used to set CTF scores when
// entering a game with scores.
// Defaults: CONTROL+KeypadPlus and CONTROL+KeypadMinus
bindCommand(keyboard0, make, control, "numpad+", TO, "z0ddhud::AddFriendlyPoint();");
bindCommand(keyboard0, break, control, "numpad+", TO, "");
bindCommand(keyboard0, make, control, "numpad-", TO, "z0ddhud::SubtractFriendlyPoint();");
bindCommand(keyboard0, break, control, "numpad-", TO, "");

// MODIFY ENEMY CTF SCORE KEY
// Add and subtract enemy CTF team points. Used to set CTF scores when
// entering a game with scores. 
// Defaults: ALT+KeypadPlus and ALT+KeypadMinus
bindCommand(keyboard0, make, alt, "numpad+", TO, "z0ddhud::AddEnemyPoint();");
bindCommand(keyboard0, break, alt, "numpad+", TO, "");
bindCommand(keyboard0, make, alt, "numpad-", TO, "z0ddhud::SubtractEnemyPoint();");
bindCommand(keyboard0, break, alt, "numpad-", TO, "");


// ---------------------------- MSG BOX FILTER -------------------------------
// MESSAGE FILTERING
// Removes certain (useless) messages from appearing in the message box.
// Look in the function z0ddhud::FilterMsgs to see the filtered messages.
// 0: turns off msg filtering
// non-zero: turn on msg filtering 
// Default: 1
$z0ddhud:filterMsgs = 1;


// -------------------------------- MUTING -----------------------------------
// STARTING MUTE SETTING
// Mute setting you want to start tribes with. You will always see your
// messages.
// There are 4 mute settings:
// 1=None. Don't mute anyone
// 2=Mute everyone (global and team chat)
// 3=Mute messages from your teammates
// 4=Mute messages from enemy team
//
// Default: 1
$z0ddhud:muteSetting = 1;

// MUTE CYCLE KEY
// The key to cycle through the Mute Modes
// Default: numpad*
bindCommand(keyboard0, make, "numpad*", TO, "z0ddhud::cycleMute();");
bindCommand(keyboard0, break, "numpad*", TO, "");


// ------------------------------ AUTO-REJOIN --------------------------------
// AUTO-REJOIN FULL SERVERS
// Option to have auto-rejoin full servers feature on/off when Tribes loads.
// Value of AUTO-REJOIN feature when you load tribes. Default is on.
// 0: Auto-rejoin is turned off.
// non-zero: Auto-rejoin is turned on.
// Default: 1
$z0ddhud:autoRejoinOn = 1;


// -------------------------------- TIMERS -----------------------------------
// TIMER HUDS
// This turns on a 30 second timer every time you pick up a Repair Pack.
// 0: off 
// non-zero: on
// Default: 0
$z0ddhud::RepTimerOn = 0;

// REPAIR PACK TIMER TOGGLE KEY
// The key to toggle the Repair Pack timer on and off.
// Default: control+p
bindCommand(keyboard0, make, control, "p", TO, "z0ddhud::ToggleRepTimer();");
bindCommand(keyboard0, break, control, "p", TO, "");

// GENERIC TIMER
// Print a timer countdown, in seconds.
// The following two lines set the 'j' key to display a 10 second counter.
// You can have other timers by copying these two lines, changing the
// key it's bound to and changing the timer from 31 to whatever you
// like.
// Default is no binding for this key. Remove the // before each of the
// next 2 lines to set the "j" key to a 10 second timer
//bindCommand(keyboard0, make, "j", TO, "z0ddhud::setTimer(10);");
//bindCommand(keyboard0, break, "j", TO, "");


// ------------------------- HUD UPDATE FREQUENCY ----------------------------
// These values controls how often the HUDs are updated.

// LOW PRIORITY HUDS UPDATE TIME
// This value controls how often, in seconds, the following HUDs are updated:
// Grenades, Mines, Beacons, Kit
// The value can be floating number, or fractional number such as 0.25, which
// means 1/4 of a second. The above HUDs would be updated 4 times/sec.
// Setting this value too low may cause Tribes to run slow.
// Default: 2. I suggest leaving it at the default of 2.
$z0ddhud::LowPriorityPulseTime = 2;

// HIGH PRIORITY HUDS UPDATE TIME
// This value controls how often, in seconds, the following HUDs are updated:
// Ammo, Pack
// The value can be floating number, or fractional number such as 0.25, which
// means 1/4 of a second. The above HUD(s) would be updated 4 times/sec.
// Setting this value too low may cause Tribes to run slow.
// Default: 0.5. I suggest leaving it at the default of 0.5.
$z0ddhud::HighPriorityPulseTime = 0.5;

//////////////////////////////////////////////////////////////////////////////
//			END USER CONFIGURABLE SECTION			    //
//////////////////////////////////////////////////////////////////////////////


//**************************************************************************//
//                             START CODE AREA                              //
//          DON'T EDIT THIS AREA IF YOU DON'T KNOW WHAT YOU'RE DOING        //
//**************************************************************************//

function z0ddhud::CenterPrint(%msg, %duration)
{
	Client::centerPrint(%msg, 1);
	$z0dd::CenterPrintCounter++;
	schedule("z0ddhud::TurnOffCP();", %duration);
}


function z0ddhud::assignHudPositions(%x1,  %y1,
				     %x2,  %y2,
				     %x3,  %y3,
				     %x4,  %y4,
				     %x5,  %y5,
				     %x6,  %y6,
				     %x7,  %y7,
				     %x8,  %y8,
				     %x9,  %y9,
				     %x10, %y10,
				     %x11, %y11,
				     %x12, %y12,
				     %x13, %y13)
{
	// Positions the top left corner of the HUD that displays friendly flag and friendly CTF score
	$z0ddhud::ourFlagHudPositionX = %x1;
	$z0ddhud::ourFlagHudPositionY = %y1;	

	// Positions the top left corner of the HUD that displays enemy flag and enemy CTF score
	$z0ddhud::theirFlagHudPositionX = %x2;
	$z0ddhud::theirFlagHudPositionY = %y2;	

	// Positions the top left corner of the HUD containing the name of the player carrying the friendly flag
	$z0ddhud::eCarrierHudPositionX = %x3;	
	$z0ddhud::eCarrierHudPositionY = %y3;	

	// Positions the top left corner of the HUD containing the name of the player carrying the enemy flag
	$z0ddhud::fCarrierHudPositionX = %x4;
	$z0ddhud::fCarrierHudPositionY = %y4;

	// Positions the top left corner of the HUD displaying my score.
	$z0ddhud::meHudPositionX = %x5;
	$z0ddhud::meHudPositionY = %y5;	
		
	// Positions the top left corner of the Grens HUD.
	$z0ddhud::grensHudPositionX = %x6;
	$z0ddhud::grensHudPositionY = %y6;
		
	// Positions the top left corner of the Mines HUD.
	$z0ddhud::minesHudPositionX = %x7;
	$z0ddhud::minesHudPositionY = %y7;	
		
	// Positions the top left corner of the Beacs HUD.
	$z0ddhud::beacsHudPositionX = %x8;	
	$z0ddhud::beacsHudPositionY = %y8;	
		
	// Positions the top left corner of the Kit HUD.
	$z0ddhud::kitHudPositionX = %x9;		
	$z0ddhud::kitHudPositionY = %y9;	
		
	// Positions the top left corner of the Teams HUD	
	$z0ddhud::teamHudPositionX = %x10;
	$z0ddhud::teamHudPositionY = %y10;

	// Positions the top left corner of the Pack HUD
	$z0ddhud::packHudPositionX = %x11;
	$z0ddhud::packHudPositionY = %y11;

	// Positions the top left corner of the timer HUD
	$z0ddhud::timerHudPositionX = %x12;
	$z0ddhud::timerHudPositionY = %y12;

	// Positions the top left corner of the ammo HUD
	$z0ddhud::ammoHudPositionX = %x13;
	$z0ddhud::ammoHudPositionY = %y13;
}


/////////////////////////////////////////////////////////////////////////////////////////
// Create new icon-based layout HUD
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::CreateNewGUI()
{
	// newObject(?, ?, x, y, z, h)
	// x = x axis of top left corner of object
	// y = y axis of top left positioning
	// z = width of object
	// h = height of object

	if($z0ddhud::myScoreHudOn) {
		// Black frame(s) for the MyScore HUD
		for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
			$z0ddhud[%guiCount++] = newObject("z0ddhud_MyScoreFrame" @ %i,
			                                  FearGui::FearGuiMenu,
			                                  $z0ddhud::meHudPositionX,
			                                  $z0ddhud::meHudPositionY,
			                                  33,
			                                  16);
		}
		// Marker for MyScore HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_MyScoreMarker",
		                                  FearGuiFormattedText,
  		                                  $z0ddhud::meHudPositionX-1,
		                                  $z0ddhud::meHudPositionY+2,
		                                  0,
		                                  0);
		// Number text for MyScore HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_MyScoreCount",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::meHudPositionX+14,
		                                  $z0ddhud::meHudPositionY-1,
		                                  0,
		                                  0); 
	}
	
	if($z0ddhud::grensHudOn) {
		// Black frame(s) for the Grenade HUD
		for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
			$z0ddhud[%guiCount++] = newObject("z0ddhud_GrensFrame" @ %i,
			                                  FearGui::FearGuiMenu,
			                                  $z0ddhud::grensHudPositionX,
			                                  $z0ddhud::grensHudPositionY,
			                                  33,
			                                  16); 
		}
		// Marker for Grenade HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_GrensMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::grensHudPositionX-1,
		                                  $z0ddhud::grensHudPositionY+2,
		                                  0,
		                                  0); 
		// Number text for Grenade HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_GrensCount",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::grensHudPositionX+22,
		                                  $z0ddhud::grensHudPositionY-1,
		                                  0,
		                                  0); 
	}

	if($z0ddhud::minesHudOn) {
		// Black frame(s) for the Mine HUD
		for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
			$z0ddhud[%guiCount++] = newObject("z0ddhud_MinesFrame" @ %i,
			                                  FearGui::FearGuiMenu,
			                                  $z0ddhud::minesHudPositionX,
			                                  $z0ddhud::minesHudPositionY,
			                                  33,
			                                  16); 
		}
		// Marker for Mine HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_MinesMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::minesHudPositionX-1,
		                                  $z0ddhud::minesHudPositionY+2,
		                                  0,
		                                  0); 
		// Number text for Mine HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_MinesCount",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::minesHudPositionX+22,
		                                  $z0ddhud::minesHudPositionY-1,
		                                  0,
		                                  0); 
	}

	if($z0ddhud::beacsHudOn) {
		// Black frame(s) for the Beacon HUD
		for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
			$z0ddhud[%guiCount++] = newObject("z0ddhud_BeacsFrame" @ %i,
			                                  FearGui::FearGuiMenu,
			                                  $z0ddhud::beacsHudPositionX,
			                                  $z0ddhud::beacsHudPositionY,
			                                  33,
			                                  16); 
		}
		// Marker for Beacon HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_BeacsMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::beacsHudPositionX-1,
		                                  $z0ddhud::beacsHudPositionY+2,
		                                  0,
		                                  0); 
		// Number text for Beacon HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_BeacsCount",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::beacsHudPositionX+22,
		                                  $z0ddhud::beacsHudPositionY-1,
		                                  0,
		                                  0); 
	}

	if($z0ddhud::kitHudOn) {
		// Black frame(s) for the Kit HUD
		for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
			$z0ddhud[%guiCount++] = newObject("z0ddhud_KitFrame" @ %i,
			                                  FearGui::FearGuiMenu,
			                                  $z0ddhud::kitHudPositionX,
			                                  $z0ddhud::kitHudPositionY,
			                                  33,
			                                  16); 
		}
		// Marker for Kit HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_KitMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::kitHudPositionX-1,
		                                  $z0ddhud::kitHudPositionY+2,
		                                  0,
		                                  0); 
		// Number text for Kit HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_KitCount",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::kitHudPositionX+22,
		                                  $z0ddhud::kitHudPositionY-3,
		                                  0,
		                                  0); 
	}

	if($z0ddhud::teamHudOn) {
		// Black frame(s) for the Team HUD
		for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
			$z0ddhud[%guiCount++] = newObject("z0ddhud_TeamFrame" @ %i,
			                                  FearGui::FearGuiMenu,
			                                  $z0ddhud::teamHudPositionX,
			                                  $z0ddhud::teamHudPositionY,
			                                  33,
			                                  47); 
		}
		// Marker for OurTeam part of Team HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_TeamUsMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::teamHudPositionX-2,
		                                  $z0ddhud::teamHudPositionY+2,
		                                  0,
		                                  0); 
		// Number text for OurTeam part of Team HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_TeamUsCount",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::teamHudPositionX+18,
		                                  $z0ddhud::teamHudPositionY-1,
		                                  0,
		                                  0); 
		// Marker for ThierTeam part of Team HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_TeamThemMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::teamHudPositionX-2,
		                                  $z0ddhud::teamHudPositionY+16,
		                                  0,
		                                  0); 
		// Number text for TheirTeam part of Team HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_TeamThemCount",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::teamHudPositionX+18,
		                                  $z0ddhud::teamHudPositionY+13,
		                                  0,
		                                  0); 
		// Marker for Observer part of Team HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_TeamObMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::teamHudPositionX-2,
		                                  $z0ddhud::teamHudPositionY+30,
		                                  0,
		                                  0); 
		// Number text for Observer part of Team HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_TeamObCount",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::teamHudPositionX+18,
		                                  $z0ddhud::teamHudPositionY+27,
		                                  0,
		                                  0); 
	}

	// Black frame(s) for the Friendly Flag HUD
	for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
		$z0ddhud[%guiCount++] = newObject("z0ddhud_OurFlagFrame" @ %i,
		                                  FearGui::FearGuiMenu,
		                                  $z0ddhud::ourFlagHudPositionX,
		                                  $z0ddhud::ourFlagHudPositionY,
		                                  33,
		                                  16); 
	}
	// Marker for Friendly Flag HUD
	$z0ddhud[%guiCount++] = newObject("z0ddhud_OurTeamMarker",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::ourFlagHudPositionX-2,
	                                  $z0ddhud::ourFlagHudPositionY+4,
	                                  0,
	                                  0); 
	// Flag icon for Friendly Flag HUD
	$z0ddhud[%guiCount++] = newObject("z0ddhud_OurFlagIcon",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::ourFlagHudPositionX+4,
	                                  $z0ddhud::ourFlagHudPositionY+1,
	                                  0,
	                                  0); 
	// Number text for Friendly flag HUD
	$z0ddhud[%guiCount++] = newObject("z0ddhud_OurTeamScore",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::ourFlagHudPositionX+22,
	                                  $z0ddhud::ourFlagHudPositionY-2,
	                                  0,
	                                  0); 

	// Black frame(s) for the Enemy Flag HUD
	for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
		$z0ddhud[%guiCount++] = newObject("z0ddhud_TheirFlagFrame" @ %i,
		                                  FearGui::FearGuiMenu,
		                                  $z0ddhud::theirFlagHudPositionX,
		                                  $z0ddhud::theirFlagHudPositionY,
		                                  33,
		                                  16); 
	}
	// Marker for Enemy Flag HUD
	$z0ddhud[%guiCount++] = newObject("z0ddhud_TheirTeamMarker",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::theirFlagHudPositionX-2,
	                                  $z0ddhud::theirFlagHudPositionY+4,
	                                  10,
	                                  10); 
	// Flag icon for Enemy Flag HUD
	$z0ddhud[%guiCount++] = newObject("z0ddhud_TheirFlagIcon",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::theirFlagHudPositionX+4,
	                                  $z0ddhud::theirFlagHudPositionY+1,
	                                  0,
	                                  0); 
	// Number text for Enemy flag HUD
	$z0ddhud[%guiCount++] = newObject("z0ddhud_TheirTeamScore",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::theirFlagHudPositionX+22,
	                                  $z0ddhud::theirFlagHudPositionY-2,
	                                  0,
	                                  0); 

	// Friendly flag carrier string.  The name of the teammate who is carrying the enemy's flag.
	$z0ddhud[%guiCount++] = newObject("z0ddhud_FCarrierStr",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::fCarrierHudPositionX,
	                                  $z0ddhud::fCarrierHudPositionY,
	                                  0,
	                                  0); 
	// Enemy flag carrier string. The name of the enemy who is carrying our flag.
	$z0ddhud[%guiCount++] = newObject("z0ddhud_ECarrierStr",
	                                  FearGuiFormattedText,
		                          $z0ddhud::eCarrierHudPositionX,
		                          $z0ddhud::eCarrierHudPositionY,
	                                  0,
	                                  0); 

	if ($z0ddhud::packHudOn) {
		// Black frame(s) for the Pack HUD
		for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
			$z0ddhud[%guiCount++] = newObject("z0ddhud_PackFrame" @ %i,
			                                  FearGui::FearGuiMenu,
			                                  $z0ddhud::packHudPositionX,
			                                  $z0ddhud::packHudPositionY,
			                                  33,
			                                  21); 
		}
		// Marker for Pack HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_PackMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::packHudPositionX,
		                                  $z0ddhud::packHudPositionY+2,
		                                  0,
		                                  0); 
	}

	// Black frame(s) for the Timer HUD
	for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
		$z0ddhud[%guiCount++] = newObject("z0ddhud_repairFrame" @ %i,
		                                  FearGui::FearGuiMenu,
		                                  $z0ddhud::timerHudPositionX,
		                                  $z0ddhud::timerHudPositionY,
		                                  33,
		                                  16);
	}
	// Timer string. (either repair or generic timer) 
	$z0ddhud[%guiCount++] = newObject("z0ddhud_TimerStr",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::timerHudPositionX+4,
	                                  $z0ddhud::timerHudPositionY-1,
	                                  0,
	                                  0); 
	                                  
	if($z0ddhud::ammoHudOn) {
		// ammo hud string
		$z0ddhud[%guiCount++] = newObject("z0ddhud_AmmoHudStr",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::ammoHudPositionX,
		                                  $z0ddhud::ammoHudPositionY,
		                                  0,
		                                  0); 
	}
}


/////////////////////////////////////////////////////////////////////////////////////////
// Create Old style layout HUD
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::CreateOldGUI()
{
	// newObject(?, ?, x, y, z, h)
	// x = x axis of top left corner of object
	// y = y axis of top left positioning
	// z = width of object
	// h = height of object

	if($z0ddhud::myScoreHudOn) {
		// Black frame(s) for the MyScore HUD
		for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
			$z0ddhud[%guiCount++] = newObject("z0ddhud_MyScoreFrame" @ %i,
			                                  FearGui::FearGuiMenu,
			                                  $z0ddhud::meHudPositionX,
			                                  $z0ddhud::meHudPositionY,
			                                  53,
			                                  13); 
		}
		// Marker for MyScore HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_MyScoreMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::meHudPositionX+3,
		                                  $z0ddhud::meHudPositionY-3,
		                                  0,
		                                  0);
		// Number text for MyScore HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_MyScoreCount",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::meHudPositionX+30,
		                                  $z0ddhud::meHudPositionY-3,
		                                  0,
		                                  0); 		
	}
	
	if($z0ddhud::grensHudOn) {
		// Black frame(s) for the Grenade HUD
		for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
			$z0ddhud[%guiCount++] = newObject("z0ddhud_GrensFrame" @ %i,
			                                  FearGui::FearGuiMenu,
			                                  $z0ddhud::grensHudPositionX,
			                                  $z0ddhud::grensHudPositionY,
			                                  53,
			                                  13); 
		}
		// Marker for Grenade HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_GrensMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::grensHudPositionX+3,
		                                  $z0ddhud::grensHudPositionY-3,
		                                  0,
		                                  0); 
		
		// Number text for Grenade HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_GrensCount",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::grensHudPositionX+42,
		                                  $z0ddhud::grensHudPositionY-3,
		                                  0,
		                                  0); 
	}

	if($z0ddhud::minesHudOn) {
		// Black frame(s) for the Mine HUD
		for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
			$z0ddhud[%guiCount++] = newObject("z0ddhud_MinesFrame" @ %i,
			                                  FearGui::FearGuiMenu,
			                                  $z0ddhud::minesHudPositionX,
			                                  $z0ddhud::minesHudPositionY,
			                                  53,
			                                  13); 
		}
		// Marker for Mine HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_MinesMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::minesHudPositionX+3,
		                                  $z0ddhud::minesHudPositionY-3,
		                                  0,
		                                  0); 
		// Number text for Mine HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_MinesCount",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::minesHudPositionX+42,
		                                  $z0ddhud::minesHudPositionY-3,
		                                  0,
		                                  0); 
	}

	if($z0ddhud::beacsHudOn) {
		// Black frame(s) for the Beacon HUD
		for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
			$z0ddhud[%guiCount++] = newObject("z0ddhud_BeacsFrame" @ %i,
			                                  FearGui::FearGuiMenu,
			                                  $z0ddhud::beacsHudPositionX,
			                                  $z0ddhud::beacsHudPositionY,
			                                  53,
			                                  13); 
		}
		// Marker for Beacon HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_BeacsMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::beacsHudPositionX+3,
		                                  $z0ddhud::beacsHudPositionY-3,
		                                  0,
		                                  0); 
		// Number text for Beacon HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_BeacsCount",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::beacsHudPositionX+42,
		                                  $z0ddhud::beacsHudPositionY-3,
		                                  0,
		                                  0); 
	}

	if($z0ddhud::kitHudOn) {
		// Black frame(s) for the Kit HUD
		for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
			$z0ddhud[%guiCount++] = newObject("z0ddhud_KitFrame" @ %i,
			                                  FearGui::FearGuiMenu,
			                                  $z0ddhud::kitHudPositionX,
			                                  $z0ddhud::kitHudPositionY,
			                                  53,
			                                  13); 
		}
		// Marker for Kit HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_KitMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::kitHudPositionX+3,
		                                  $z0ddhud::kitHudPositionY-3,
		                                  0,
		                                  0); 
		// Number text for Kit HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_KitCount",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::kitHudPositionX+30,
		                                  $z0ddhud::kitHudPositionY-3,
		                                  0,
		                                  0); 
	}

	if($z0ddhud::teamHudOn) {
		// Black frame(s) for the Team HUD
		for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
			$z0ddhud[%guiCount++] = newObject("z0ddhud_TeamFrame" @ %i,
			                                  FearGui::FearGuiMenu,
			                                  $z0ddhud::teamHudPositionX,
			                                  $z0ddhud::teamHudPositionY,
			                                  53,
			                                  39); 
		}
		// Marker for OurTeam part of Team HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_TeamUsMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::teamHudPositionX+3,
		                                  $z0ddhud::teamHudPositionY-3,
		                                  0,
		                                  0); 
		// Number text for OurTeam part of Team HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_TeamUsCount",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::teamHudPositionX+42,
		                                  $z0ddhud::teamHudPositionY-3,
		                                  0,
		                                  0); 
		// Marker for ThierTeam part of Team HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_TeamThemMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::teamHudPositionX+3,
		                                  $z0ddhud::teamHudPositionY+9,
		                                  0,
		                                  0); 
		// Number text for TheirTeam part of Team HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_TeamThemCount",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::teamHudPositionX+42,
		                                  $z0ddhud::teamHudPositionY+9,
		                                  0,
		                                  0); 		
		// Marker for Observer part of Team HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_TeamObMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::teamHudPositionX+3,
		                                  $z0ddhud::teamHudPositionY+21,
		                                  0,
		                                  0); 
		// Number text for Observer part of Team HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_TeamObCount",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::teamHudPositionX+42,
		                                  $z0ddhud::teamHudPositionY+21,
		                                  0,
		                                  0); 
	}
	
	// Black frame(s) for the Friendly Flag HUD
	for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
		$z0ddhud[%guiCount++] = newObject("z0ddhud_OurFlagFrame" @ %i,
		                                  FearGui::FearGuiMenu,
		                                  $z0ddhud::ourFlagHudPositionX,
		                                  $z0ddhud::ourFlagHudPositionY,
		                                  53,
		                                  67); 
	}
	// Marker for Friendly Flag HUD
	$z0ddhud[%guiCount++] = newObject("z0ddhud_OurFlagIcon",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::ourFlagHudPositionX+3,
	                                  $z0ddhud::ourFlagHudPositionY+26,
	                                  0,
	                                  0); 
	// Flag icon for Friendly Flag HUD
	$z0ddhud[%guiCount++] = newObject("z0ddhud_OurTeamMarker",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::ourFlagHudPositionX+3,
	                                  $z0ddhud::ourFlagHudPositionY-2,
	                                  0,
	                                  0); 
	// Number text for Friendly flag HUD
	$z0ddhud[%guiCount++] = newObject("z0ddhud_OurTeamScore",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::ourFlagHudPositionX+24,
	                                  $z0ddhud::ourFlagHudPositionY+10,
	                                  0,
	                                  0); 

	// Black frame(s) for the Enemy Flag HUD
	for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
		$z0ddhud[%guiCount++] = newObject("z0ddhud_TheirFlagFrame" @ %i,
		                                  FearGui::FearGuiMenu,
		                                  $z0ddhud::theirFlagHudPositionX,
		                                  $z0ddhud::theirFlagHudPositionY,
		                                  53,
		                                  67); 
	}
	// Marker for Enemy Flag HUD
	$z0ddhud[%guiCount++] = newObject("z0ddhud_TheirTeamMarker",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::theirFlagHudPositionX+3,
	                                  $z0ddhud::theirFlagHudPositionY-2,
	                                  10,
	                                  10); 
	// Flag icon for Enemy Flag HUD
	$z0ddhud[%guiCount++] = newObject("z0ddhud_TheirFlagIcon",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::theirFlagHudPositionX+3,
	                                  $z0ddhud::theirFlagHudPositionY+26,
	                                  0,
	                                  0); 
	// Number text for Enemy flag HUD
	$z0ddhud[%guiCount++] = newObject("z0ddhud_TheirTeamScore",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::theirFlagHudPositionX+24,
	                                  $z0ddhud::theirFlagHudPositionY+10,
	                                  0,
	                                  0); 

	// Enemy flag carrier string. The name of the enemy who is carrying our flag.
	$z0ddhud[%guiCount++] = newObject("z0ddhud_ECarrierStr",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::eCarrierHudPositionX,
	                                  $z0ddhud::eCarrierHudPositionY,
	                                  0,
	                                  0); 
	// Friendly flag carrier string.  The name of the teammate who is carrying the enemies flag.
	$z0ddhud[%guiCount++] = newObject("z0ddhud_FCarrierStr",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::fCarrierHudPositionX,
	                                  $z0ddhud::fCarrierHudPositionY,
	                                  0,
	                                  0); 

	if ($z0ddhud::packHudOn) {
		// Black frame(s) for the Pack HUD
		for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
			$z0ddhud[%guiCount++] = newObject("z0ddhud_PackFrame" @ %i,
			                                  FearGui::FearGuiMenu,
			                                  $z0ddhud::packHudPositionX,
			                                  $z0ddhud::packHudPositionY,
			                                  53,
			                                  15);
		}
		// Marker for Pack HUD
		$z0ddhud[%guiCount++] = newObject("z0ddhud_PackMarker",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::packHudPositionX+3,
		                                  $z0ddhud::packHudPositionY-3,
		                                  0,
		                                  0); 
	}

	// Black frame(s) for the Timer HUD
	for(%i = 1; %i <= $z0ddhud::bgLevel; %i++) {
		$z0ddhud[%guiCount++] = newObject("z0ddhud_repairFrame" @ %i,
		                                  FearGui::FearGuiMenu,
		                                  $z0ddhud::timerHudPositionX,
		                                  $z0ddhud::timerHudPositionY,
		                                  53,
		                                  13);
	}
	// Timer string. (either repair or generic timer) 
	$z0ddhud[%guiCount++] = newObject("z0ddhud_TimerStr",
	                                  FearGuiFormattedText,
	                                  $z0ddhud::timerHudPositionX+4,
	                                  $z0ddhud::timerHudPositionY-3,
	                                  0,
	                                  0); 

	if($z0ddhud::ammoHudOn) {
		// ammo hud string
		$z0ddhud[%guiCount++] = newObject("z0ddhud_AmmoHudStr",
		                                  FearGuiFormattedText,
		                                  $z0ddhud::ammoHudPositionX,
		                                  $z0ddhud::ammoHudPositionY,
		                                  0,
		                                  0); 
	}
}


/////////////////////////////////////////////////////////////////////////////////////////
// Create HUD
/////////////////////////////////////////////////////////////////////////////////////////
//
// You can move the HUDs around by changing the numbers below.
// The number pairs below specify the top left coordinate of the HUD.
// Each of the pairs has a label for easy recognition, such as friendly flag hud
//
// Each of the two HUD layouts, original and new icon based layout, have their own
// coordinate sets.
// Edit the following area to change the new layout loctions: // new layout
// Edit the following area to change the original layout loctions: // original layout
//
// For example,
// To move the Mine HUD in the original layout down and to the right, you could change
// the default 1 and 224 numbers to 15 and 372.
// The 1 in this example is the X coordinate. The X value is the # of pixels from the
// top of the screen.
// The 224 in this exmaple is the Y coordinate. The Y value is the # of pixels from the
// left side of the screen.
//
function z0ddhud::CreateGUI()
{
	if($z0ddhud::NewLayout) {
		// new layout
//		z0ddhud::assignHudPositions(1,   80,	// friendly flag HUD
//					    1,   95,	// enemy flag HUD
//					    1,   62,	// enemy carrier HUD
//					    1,   108,	// friendly carrier HUD
//					    1,   127,	// my score HUD
//					    1,   142,	// grenades HUD
//					    1,   157,	// mines HUD
//					    1,   172,	// beacons HUD
//					    1,   187,	// kit HUD
//					    1,   206,	// teams count HUD
//					    1,   256,	// pack HUD
//					    1,   280,	// timer HUD
//					    $z0ddhud::ammoHudX, $z0ddhud::ammoHudY);	// ammo HUD

// z0dd's positions for new layout:
//		z0ddhud::assignHudPositions(1,   19,	// friendly flag HUD
//					    1,   34,	// enemy flag HUD
//					    1,   1,	// enemy carrier HUD
//					    1,   47,	// friendly carrier HUD
//					    1,   66,	// my score HUD
//					    1,   81,	// grenades HUD
//					    1,   96,	// mines HUD
//					    1,   111,	// beacons HUD
//					    1,   126,	// kit HUD
//					    1,   145,	// teams count HUD
//					    1,   195,	// pack HUD
//					    1,   218,	// timer HUD
//					    $z0ddhud::ammoHudX, $z0ddhud::ammoHudY);	// ammo HUD

//		z0ddhud::assignHudPositions(1,   19,	// friendly flag HUD
//					    1,   34,	// enemy flag HUD
//					    1,   1,	// enemy carrier HUD
//					    1,   47,	// friendly carrier HUD
//					    1,   66,	// my score HUD
//					    128, 84,	// grenades HUD
//					    395, 84,	// mines HUD
//					    1,   81,	// beacons HUD
//					    261, 84,	// kit HUD
//					    1,   99,	// teams count HUD
//					    1,   149,	// pack HUD
//					    1,   173,	// timer HUD
//					    $z0ddhud::ammoHudX, $z0ddhud::ammoHudY);	// ammo HUD

		z0ddhud::assignHudPositions(1,   19,	// friendly flag HUD
					    1,   34,	// enemy flag HUD
					    1,   1,	// enemy carrier HUD
					    1,   47,	// friendly carrier HUD
					    1,   66,	// my score HUD
					    667, 0,	// grenades HUD
					    667, 15,	// mines HUD
					    1,   81,	// beacons HUD
					    698, 0,	// kit HUD zzz
					    1,   99,	// teams count HUD
					    1,   149,	// pack HUD
					    1,   173,	// timer HUD
					    $z0ddhud::ammoHudX, $z0ddhud::ammoHudY);	// ammo HUD

		z0ddhud::CreateNewGUI();
	}
	else {
		// original layout
		z0ddhud::assignHudPositions(1,   65,	// friendly flag HUD
		                            1,   131,   // enemy flag HUD      
		                            55,  96,    // enemy carrier HUD
		                            55,  162,   // friendly carrier HUD
		                            1,   200,   // my score HUD
		                            1,   212,   // grenades HUD           
		                            1,   224,   // mines HUD           
		                            1,   236,   // beacons HUD
		                            1,   248,   // kit HUD
		                            1,   263,   // teams count HUD
		                            1,   305,	// pack HUD
		                            1,   322,   // timer HUD
		                            $z0ddhud::ammoHudX, $z0ddhud::ammoHudY);  // ammo hud
		z0ddhud::CreateOldGUI();
	}

	// we start at 1 because ++ operator resolves late. search for: $z0ddhud[%guiCount++]
	for(%i = 1; $z0ddhud[%i] != ""; %i++)
		addToSet(PlayGui, $z0ddhud[%i]);
	
	for(%i = 1; %i <= $z0ddhud::bgLevel; %i++)
		Control::setVisible("z0ddhud_repairFrame" @ %i, 0);
}


function z0ddhud::Reset()
{
	z0ddhud::SetDefaultDynamicValues();
	z0ddhud::SetDynamicDisplay();
}


function z0ddhud::SetStaticForNew() 
{
	// Our team marker
	Control::setValue("z0ddhud_OurTeamMarker", "<BLR_HH_End_Green.bmp>");
	
	// Enemy team marker
	Control::setValue("z0ddhud_TheirTeamMarker", "<BLR_HH_End_Red.bmp>");

	// My Score marker
	if($z0ddhud::myScoreHudOn)
		Control::setValue("z0ddhud_MyScoreMarker", "<BM_player_green.bmp>");

	// Grenade marker
	if($z0ddhud::grensHudOn)
		Control::setValue("z0ddhud_GrensMarker", "<Blr_grenade_on.bmp>");
	
	// Mine marker
	if($z0ddhud::minesHudOn)
		Control::setValue("z0ddhud_MinesMarker", "<Blr_fear_on.bmp>");
	
	// Beacon marker
	if($z0ddhud::beacsHudOn)
		Control::setValue("z0ddhud_BeacsMarker", "<Blr_reticle_on.bmp>");
	
	// Kit marker
	if($z0ddhud::kitHudOn)
		Control::setValue("z0ddhud_KitMarker", "<Blr_backpack_on.bmp>");
	
	// team hud
	if($z0ddhud::teamHudOn) {
		// Our team marker
		Control::setValue("z0ddhud_TeamUsMarker", "<BLR_HH_Icon_Green.bmp>");
		
		// Their team marker
		Control::setValue("z0ddhud_TeamThemMarker", "<BLR_HH_Icon_Red.bmp>");
	
		// Observer marker
		Control::setValue("z0ddhud_TeamObMarker", "");
	}
	
	// Our flag bitmap
	$z0ddhud::OurFlagBMP = "<BM_vehicle_green.bmp>";
	
	// Thier flag bitmap
	$z0ddhud::TheirFlagBMP = "<BM_vehicle_red.bmp>";
}


function z0ddhud::SetStaticForOrig() 
{
	// Our team marker
	Control::setValue("z0ddhud_OurTeamMarker", "Friendly");

	// Enemy team marker
	Control::setValue("z0ddhud_TheirTeamMarker", "Enemy");
	
	// My Score marker
	if($z0ddhud::myScoreHudOn)
		Control::setValue("z0ddhud_MyScoreMarker", "Me");
	
	// Grenade marker
	if($z0ddhud::grensHudOn)
		Control::setValue("z0ddhud_GrensMarker", "Grens");
	
	// Mine marker
	if($z0ddhud::minesHudOn)
		Control::setValue("z0ddhud_MinesMarker", "Mines");

	// Beacon marker
	if($z0ddhud::beacsHudOn)
		Control::setValue("z0ddhud_BeacsMarker", "Beacs");
	
	// Kit marker
	if($z0ddhud::kitHudOn)
		Control::setValue("z0ddhud_KitMarker", "Kit");
	
	// team hud
	if($z0ddhud::teamHudOn) {
		// Our team marker
		Control::setValue("z0ddhud_TeamUsMarker", "<f1>Us");
		
		// Their team marker
		Control::setValue("z0ddhud_TeamThemMarker", "<f1>Them");
	
		// Observer marker
		Control::setValue("z0ddhud_TeamObMarker", "<f1>Obs.");
	}	
	
	// Our flag bitmap
	$z0ddhud::OurFlagBMP = "<Bflag_atbase.bmp>";
	
	// Thier flag bitmap
	$z0ddhud::TheirFlagBMP = "<Bflag_enemycaptured.bmp>";

}


function z0ddhud::SetStaticDisplay() 
{
	if($z0ddhud::NewLayout)
		z0ddhud::SetStaticForNew(); 
	else 
		z0ddhud::SetStaticForOrig(); 
}


// Sets values for displays that are calculated with data from the chat box
function z0ddhud::SetDynamicDisplay()
{
	// Text of player carrying friendly flag
	Control::setValue("z0ddhud_ECarrierStr", $z0ddhud::EnemyCarryingOurFlag);

	// flag icon for friendly team
	Control::setValue("z0ddhud_OurFlagIcon", $z0ddhud::OurFlagIcon);

	// Our team's score text
	Control::setValue("z0ddhud_OurTeamScore", "<f2>" @ $z0ddhud::OurTeamScore);

	// flag icon for enemy team
	Control::setValue("z0ddhud_TheirFlagIcon", $z0ddhud::TheirFlagIcon);

	// Their team's score text
	Control::setValue("z0ddhud_TheirTeamScore", "<f2>" @ $z0ddhud::TheirTeamScore);

	// Text of player carrying enemy flag
	Control::setValue("z0ddhud_FCarrierStr", $z0ddhud::FriendlyCarryingTheirFlag);

	// Text for My Score
	if($z0ddhud::myScoreHudOn)
		Control::setValue("z0ddhud_MyScoreCount", "<f1>" @ $z0ddhud::MeCount);

	// Text for team HUD
	if($z0ddhud::teamHudOn) {
		// Text of number of players on friendly team
		Control::setValue("z0ddhud_TeamUsCount", "<f2>" @ $z0ddhud::TeamCount[$z0ddhud::MyTeam]);
	
		// Text of number of players on enemy team
		Control::setValue("z0ddhud_TeamThemCount", "<f2>" @ $z0ddhud::TeamCount[!$z0ddhud::MyTeam]);
	
		// Text of number of players in observer
		Control::setValue("z0ddhud_TeamObCount", "<f2>" @ $z0ddhud::TeamCount[-1]);
	}

	// Text for timer (generic and/or repair pack timer)
	Control::setValue("z0ddhud_TimerStr", $z0ddhud::TimerString);
}


// This function sets the default values for dynamic displays that aren't
// requested from he server. Meaning, all of the values below are determined
// by info gathered from the chat box.
// The following values are set to their default value when a map changes.
// We don't include team sizes here since it's the only value carried over
// on map change. Some dynamic values 
function z0ddhud::SetDefaultDynamicValues()
{
	$z0ddhud::EnemyCarryingOurFlag = "";
	$z0ddhud::OurFlagIcon = $z0ddhud::OurFlagBMP;
	$z0ddhud::OurTeamScore = 0;
	$z0ddhud::TheirFlagIcon = $z0ddhud::TheirFlagBMP;
	$z0ddhud::TheirTeamScore = 0;
	$z0ddhud::FriendlyCarryingTheirFlag = "";
	if($z0ddhud::myScoreHudOn)
		$z0ddhud::MeCount = 0;

	$z0ddhud::TimerString = "";
	$z0ddhud::repPackRespawnTime = 0;
	schedule("z0ddhud::timerTimedOut();", 1);

	$z0ddhud::friendlyFlagDropTime = -1;
	$z0ddhud::enemyFlagDropTime = -1;
	$z0ddhud::enemyFlagDropped = 0;
	$z0ddhud::friendlyFlagDropped = 0;
	$z0ddhud::lastIpTried = 0;
}


function z0ddhud::SetHUDValues()
{
	z0ddhud::SetStaticDisplay();  
	z0ddhud::SetDefaultDynamicValues();
	z0ddhud::SetDynamicDisplay();
}


/////////////////////////////////////////////////////////////////////////////////////////
// Create HUD
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::Create()
{
	if($z0ddhud::Creating)
		return;

	if(!$ConnectedToServer) {
		schedule("z0ddhud::Create();", 1);
		return;
	}

	$z0ddhud::Creating = 1;
	if($z0ddhud::Loaded)
		z0ddhud::Remove();

	$z0ddhud::Loaded = 1;
	z0ddhud::CreateGUI();
	z0ddhud::SetHUDValues();

	%waitPeriod = $z0ddhud::LowPriorityPulseTime + 1;
	if(%waitPeriod < $z0ddhud::HighPriorityPulseTime + 1)
		%waitPeriod = $z0ddhud::HighPriorityPulseTime + 1;

	z0ddhud::CenterPrint("<jc>z0dd_hud will be updated soon", %waitPeriod);
	schedule("z0ddhud::UpdateHUD();", %waitPeriod);
	schedule("z0ddhud::SecondaryUpdateHUD();", %waitPeriod);
	schedule("$z0ddhud::Creating=0;", %waitPeriod+1);
}


/////////////////////////////////////////////////////////////////////////////////////////
// Remove HUD
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::Remove()
{
	if(!$z0ddhud::Loaded)
		return;

	$z0ddhud::Loaded = 0;
	
	// we start at 1 because ++ operator resolves late. search for: $z0ddhud[%guiCount++]
	for(%i = 1; $z0ddhud[%i] != ""; %i++) {
		deleteObject($z0ddhud[%i]);
		removeFromSet(PlayGui, $z0ddhud[%i]);
	}
}


/////////////////////////////////////////////////////////////////////////////////////////
// shut down clean up
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::CleanUp()
{
	if(!$z0ddhud::Loaded)
		return;

	z0ddhud::Remove();
}
 
 
/////////////////////////////////////////////////////////////////////////////////////////
// Toggle creation and destruction of HUD
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::Toggle()
{
	if($z0ddhud::Loaded)
		z0ddhud::Remove();
	else
		z0ddhud::Create();
}


/////////////////////////////////////////////////////////////////////////////////////////
// Add one point to friendly CTF teams score.
// Used to set the CTF scores when you enter a game that has scores already
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::AddFriendlyPoint()
{
	$z0ddhud::OurTeamScore++;
	%z0ddhud::OurScoreString = "<f2>" @ $z0ddhud::OurTeamScore;
	Control::setValue("z0ddhud_OurTeamScore", %z0ddhud::OurScoreString);
}


/////////////////////////////////////////////////////////////////////////////////////////
// Add one point to friendly CTF teams score.
// Used to set the CTF scores when you enter a game that has scores already
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::SubtractFriendlyPoint()
{
	if($z0ddhud::OurTeamScore > 0) {
		$z0ddhud::OurTeamScore--;
		%z0ddhud::OurScoreString = "<f2>" @ $z0ddhud::OurTeamScore;
	 	Control::setValue("z0ddhud_OurTeamScore", %z0ddhud::OurScoreString);
	 }
}


/////////////////////////////////////////////////////////////////////////////////////////
// Add one point to enemy CTF teams score.
// Used to set the CTF scores when you enter a game that has scores already
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::AddEnemyPoint()
{
	$z0ddhud::TheirTeamScore++;
	%z0ddhud::TheirScoreString = "<f2>" @ $z0ddhud::TheirTeamScore;
	Control::setValue("z0ddhud_TheirTeamScore", %z0ddhud::TheirScoreString);
}


/////////////////////////////////////////////////////////////////////////////////////////
// Add one point to enemy CTF teams score.
// Used to set the CTF scores when you enter a game that has scores already
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::SubtractEnemyPoint()
{
	if($z0ddhud::TheirTeamScore > 0) {
		$z0ddhud::TheirTeamScore--;
		%z0ddhud::TheirScoreString = "<f2>" @ $z0ddhud::TheirTeamScore;
		Control::setValue("z0ddhud_TheirTeamScore", %z0ddhud::TheirScoreString);
	}
}


/////////////////////////////////////////////////////////////////////////////////////////
// Popups
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::PopUp(%objectname, %hold)
{
       	$z0ddhud::CurrentObject = %objectname;
	Control::setVisible(%objectname, 1);

	if(%hold)
		schedule("z0ddhud::PopDown($z0ddhud::CurrentObject);", hold);
}


/////////////////////////////////////////////////////////////////////////////////////////
// PopDown HUD
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::PopDown(%objectname)
{
	Control::setVisible(%objectname, 0);
}


/////////////////////////////////////////////////////////////////////////////////////////
// Processes Frag Events (client messages)
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::FragEvents(%msg)
{
	if (String::FindSubStr(%msg, $PCFG::Name) != -1) {
		%mod = $z0ddhud::KillsData[%msg];
		if(%mod) {
			$z0ddhud::MeCount += %mod;
			Control::setValue("z0ddhud_MyScoreCount", "<f1>" @ $z0ddhud::MeCount);
			return 1;
		}
	}

	return 0;
}                 


function z0ddhud::getAmmo(%weapon)
{
	// if unknown weapon found
	if($z0ddhud::AmmoData[%weapon] == "")
		return "";
	return eval($z0ddhud::AmmoData[%weapon]);
}


/////////////////////////////////////////////////////////////////////////////////////////
// Toggle drop blaster on/off
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddhud::ToggleDropBlaster()
{
	$z0ddhud::DropBlasterOn = z0ddhud::Toggler($z0ddhud::DropBlasterOn, "Drop Blaster is");
}


/////////////////////////////////////////////////////////////////////////////////////////
// Drops the blaster if you are carrying it.
// It will then automatically switch to your next weapon of choice that has ammo.
// The wepons of choice are choosen sequentially from $z0ddhud::weaponPreference1 to
// $z0ddhud::weaponPreference7 
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::dropBlaster()
{
	if($z0ddhud::DropBlasterOn)
		drop("blaster");
		
	if(getItemCount($z0ddhud::weaponPreference1) && (z0ddhud::getAmmo($z0ddhud::weaponPreference1)))
		use($z0ddhud::weaponPreference1);
	else if (getItemCount($z0ddhud::weaponPreference2) && (z0ddhud::getAmmo($z0ddhud::weaponPreference2)))
		use($z0ddhud::weaponPreference2);
	else if (getItemCount($z0ddhud::weaponPreference3) && (z0ddhud::getAmmo($z0ddhud::weaponPreference3)))
		use($z0ddhud::weaponPreference3);
	else if (getItemCount($z0ddhud::weaponPreference4) && (z0ddhud::getAmmo($z0ddhud::weaponPreference4)))
		use($z0ddhud::weaponPreference4);
	else if (getItemCount($z0ddhud::weaponPreference5) && (z0ddhud::getAmmo($z0ddhud::weaponPreference5)))
		use($z0ddhud::weaponPreference5);
	else if (getItemCount($z0ddhud::weaponPreference6) && (z0ddhud::getAmmo($z0ddhud::weaponPreference6)))
		use($z0ddhud::weaponPreference6);
	else if (getItemCount($z0ddhud::weaponPreference7) && (z0ddhud::getAmmo($z0ddhud::weaponPreference7)))
		use($z0ddhud::weaponPreference7);
}


/////////////////////////////////////////////////////////////////////////////////////////
// Periodically called to update HUD data. Called more often then z0ddhud::UpdateHUD()
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::SecondaryUpdateHUD()
{
	if(!$z0ddhud::Loaded)
		return;

	if($z0ddhud::ammoHudOn)
		Control::setValue("z0ddhud_AmmoHudStr", z0ddhud::getAmmo(getMountedItem(0)));

	if($z0ddhud::packHudOn)
		Control::setValue("z0ddhud_PackMarker", $z0ddhud::packMarker[getMountedItem(1)]);

	if($z0ddhud::HighPriorityUpdatesOn)
		schedule("z0ddhud::SecondaryUpdateHUD();", $z0ddhud::HighPriorityPulseTime);
}


/////////////////////////////////////////////////////////////////////////////////////////
// Periodically called to update HUD data
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::UpdateHUD()
{
	if(!$z0ddhud::Loaded)
		return;

	if($z0ddhud::grensHudOn)
		Control::setValue("z0ddhud_GrensCount", "<f1>" @ getItemCount("Grenade"));

	if($z0ddhud::minesHudOn)
		Control::setValue("z0ddhud_MinesCount", "<f1>" @ getItemCount("Mine"));
	
	if($z0ddhud::beacsHudOn)
		Control::setValue("z0ddhud_BeacsCount", "<f1>" @ getItemCount("Beacon"));

	if($z0ddhud::kitHudOn) {
		if (getItemCount("Repair Kit"))
			%z0ddhud::KitStr = "<f1>+";
		else
			%z0ddhud::KitStr = "";
		Control::setValue("z0ddhud_KitCount", %z0ddhud::KitStr);
	}
	
	if($z0ddhud::LowPriorityUpdatesOn)
		schedule("z0ddhud::UpdateHUD();", $z0ddhud::LowPriorityPulseTime);
}

                                          
/////////////////////////////////////////////////////////////////////////////////////////
// Targets flag enemy/friendly flag carrier
/////////////////////////////////////////////////////////////////////////////////////////
function targetClientByName(%name, %msg)
{
	%clientId = getClientByName(%name);
	remoteEval(2048, "IssueTargCommand", 0, %msg, %clientID - 2048, getManagerId());
}


/////////////////////////////////////////////////////////////////////////////////////////
// Administrative functions based on: dynhud by killer bunny
/////////////////////////////////////////////////////////////////////////////////////////
function onExit()
{
	z0ddhud::CleanUp();

	if(isObject(playGui))
		storeObject(playGui, "config\\play.gui");

	saveActionMap("config\\config.cs", "actionMap.sae", "playMap.sae", "pdaMap.sae");

	// update the video mode - since it can be changed with alt-enter
	$pref::VideoFullScreen = isFullScreenMode(MainWindow);

	checkMasterTranslation();
	echo("exporting pref::* to prefs.cs");
	export("pref::*", "config\\ClientPrefs.cs", False);
	export("Server::*", "config\\ServerPrefs.cs", False);
	export("pref::lastMission", "config\\ServerPrefs.cs", True);
	BanList::export("config\\banlist.cs");
}


function z0ddhud::rejoinConnect(%ip)
{
	if(($ConnectedToServer != "True") && ((%ip == $Server::Address)))
		connect(%ip);
}


function z0ddhud::DoConnectTasks()
{
	$z0ddhud::repairingNickWeaselCnt = 0;
	$z0ddhud::SOLDNickWeaselCnt = 0;
	$z0ddhud::isnotdamagedNickWeaselCnt = 0;

	deleteVariables("$z0ddhud::KillsData*");
	deleteVariables("$z0ddhud::AmmoData*");
	deleteVariables("$z0ddhud::TeamCount*");
	deleteVariables("$Flood::*");
	deleteVariables("$z0ddhud::DeployedMsgs*");

	z0ddhud::CreateAmmoTable();
	z0ddhud::CreateDelpoyedTable();

	$z0ddhud::TeamCount[-1] = 0;
	$z0ddhud::TeamCount[0] = 0;
	$z0ddhud::TeamCount[1] = 0;	

	// 64 player max
	for(%i = 2048; %i < 2112; %i++)
		$z0ddhud::PlayersOnServer[%i] = 0;

	$z0ddhud::MyClientID = getManagerID();
	if($PCFG::Gender == "MALE")
		$z0ddhud::MyPronoun = "his";
	else
		$z0ddhud::MyPronoun = "her";
}


/////////////////////////////////////////////////////////////////////////////////////////
// Called client connects to server
/////////////////////////////////////////////////////////////////////////////////////////
function onConnection(%message)
{
	echo("Connection ", %message); 
	$dataFinished = false;
	
	if(%message == "Accepted") {
		z0ddhud::DoConnectTasks();

		if($z0ddhud::autoStartHUD)
			z0ddhud::Create();

		resetSimTime();
		// execute the custom script
		if ($PCFG::Script != "")
			exec($PCFG::Script);

		resetPlayDelegate();
		remoteEval(2048, "SetCLInfo", $PCFG::SkinBase, $PCFG::RealName, $PCFG::EMail, $PCFG::Tribe, $PCFG::URL, $PCFG::Info, $pref::autoWaypoint, $pref::noEnterInvStation, $pref::messageMask);

		if ($Pref::PlayGameMode == "JOIN") {
			cursorOn(MainWindow);
	      		GuiLoadContentCtrl(MainWindow, "gui\\Loading.gui");
			renderCanvas(MainWindow);
		}
	}
   	else if(%message == "Rejected") {
		Quickstart();
      		$errorString = "Connection to server rejected:\n" @ $errorString;
		// GuiPushDialog(MainWindow, "gui\\MessageDialog.gui");  // z0dd: dont need this when we're using auto-join
		schedule("Control::setValue(MessageDialogTextFormat, $errorString);", 0);
		if($z0ddhud:autoRejoinOn) {
			echo("--- In 2 seconds I'll try to connect to server ip: " @ $Server::Address);
			$z0ddhud::lastIpTried = $Server::Address;
			schedule("z0ddhud::rejoinConnect($z0ddhud::lastIpTried);", 1);
		}
 	}
   	else {
      		// startMainMenuScreen();
      		Quickstart();
  		if(%message == "Dropped") {
         		if($errorString == "")
            			$errorString = "Connection to server lost:\nServer went down.";
         		else
            			$errorString = "Connection to server lost:\n" @ $errorString;

         		GuiPushDialog(MainWindow, "gui\\MessageDialog.gui");
		   	schedule("Control::setValue(MessageDialogTextFormat, $errorString);", 0);
      		}
      		else if(%message == "TimedOut") {
        		$errorString = "Connection to server timed out.";
         		GuiPushDialog(MainWindow, "gui\\MessageDialog.gui");
		   	schedule("Control::setValue(MessageDialogTextFormat, $errorString);", 0);
      		}
   	}
}


/////////////////////////////////////////////////////////////////////////////////////////
// Called when new map is loaded
/////////////////////////////////////////////////////////////////////////////////////////
function remoteMissionChangeNotify(%serverManagerId, %nextMission)
{
   	if(%serverManagerId == 2048) {
		echo("Server mission complete - changing to mission: ", %nextMission);
		echo("Flushing Texture Cache");
		flushTextureCache();
		schedule("purgeResources(true);", 3);

		z0ddhud::Reset();
		deleteVariables("$z0ddhud::KillsData*");
		deleteVariables("$z0ddhud::AmmoData*");
		deleteVariables("$Flood::*");
		deleteVariables("$z0ddhud::DeployedMsgs*");

		z0ddhud::CreateAmmoTable();
		z0ddhud::CreateDelpoyedTable();
		
		// rebuild KillsData hash table
		z0ddhud::KillsAddMySuicides();		
		for(%i = 2048; %i < 2112; %i++) {
			if($z0ddhud::PlayersOnServer[%i])
				z0ddhud::KillsAdd(client::getname(%i));
		}
   	}
}


function z0ddhud::nickWeaselCheck(%client, %valChange)
{
	%nick = client::getname(%client);

	if(String::FindSubStr(%nick, "repairing") == 0)
		$z0ddhud::repairingNickWeaselCnt += %valChange;
	else if(String::FindSubStr(%nick, "SOLD ") == 0)
		$z0ddhud::SOLDNickWeaselCnt += %valChange;
	else if (String::FindSubStr(%nick, " is not damaged") != -1)
		$z0ddhud::isnotdamagedNickWeaselCnt += %valChange;
	else
		return;

	if(%valChange == 1)	
		say(0, "\"" @ %nick @ "\"" @ " is a Nick Weasel!! You should kick this player from the server.~wwshoot1" );
}


/////////////////////////////////////////////////////////////////////////////////////////
// Targets enemy or friendly carrier.  
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::targCarrier(%target)
{
	if(%target == friendly) {
		if ($z0ddhud::FriendlyCarryingTheirFlag == "")
			z0ddhud::CenterPrint("<jc>Can't find FRIENDLY capper", 1);
		else {
			targetClientByName($z0ddhud::FriendlyCarryingTheirFlag,
			                   "Escort our flag carrier: " @ $z0ddhud::FriendlyCarryingTheirFlag @ ".~wescfr");
		}
	}	
	else if (%target == enemy) {
		if ($z0ddhud::EnemyCarryingOurFlag == "")
			z0ddhud::CenterPrint("<jc>Can't find ENEMY capper", 1);
		else {
			targetClientByName($z0ddhud::EnemyCarryingOurFlag,
			                   "Kill the enemy carrier: " @ $z0ddhud::EnemyCarryingOurFlag @ ".~wretflag");
		}
	}
}


/////////////////////////////////////////////////////////////////////////////////////////
// Processes Flag Events (client messages)
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::flagEvents(%msg)
{
	// TAKEN
	%posit = String::FindSubStr(%msg, "took the") - 1;
	if(%posit > 0) {
		// redundent message check to prevent nick weasel names such as: "took the"
		if(String::FindSubStr(%msg, " flag! ~wflag1.wav") == -1)
			return;
		$taker = String::GetSubStr(%msg, 0, %posit);
		$modified_taker = $taker;
		while((String::GetSubStr($modified_taker, 0, 1) == "<") &&
		      (String::GetSubStr($modified_taker, Match::strLen($modified_taker)-1, 1) == ">")) {
			if(String::FindSubStr($modified_taker, "<>") != -1)
				$modified_taker = "LOSER";
			else
				$modified_taker = String::GetSubStr($modified_taker, 1, Match::strLen($modified_taker)-2);
		}
		return;
	}

	if(String::FindSubStr(%msg, "Your team has the") != -1)	{
		$z0ddhud::FriendlyCarryingTheirFlag = $taker;
		// auto flag targeting
		if($z0ddhud::autoTargFriendlyCarrier)
			z0ddhud::targCarrier(friendly);
		$z0ddhud::TheirFlagIcon = "";
		Control::setValue("z0ddhud_TheirFlagIcon", $z0ddhud::TheirFlagIcon);
		Control::setValue("z0ddhud_FCarrierStr", "<f0>" @ $modified_taker);
		$z0ddhud::enemyFlagDropped = 0;
	}
	else if(%msg == "Your team's flag has been taken.") {
		$z0ddhud::EnemyCarryingOurFlag = $taker;
		// auto flag targeting
		if($z0ddhud::autoTargEnemyCarrier)
			z0ddhud::targCarrier(enemy);
		$z0ddhud::OurFlagIcon = "";
		Control::setValue("z0ddhud_OurFlagIcon", $z0ddhud::OurFlagIcon);
		Control::setValue("z0ddhud_ECarrierStr", "<f0>" @ $modified_taker);
		$z0ddhud::friendlyFlagDropped = 0;
	}
	// CAPTURED
	else if(%msg == "Your team captured the flag.") {
		$z0ddhud::FriendlyCarryingTheirFlag = "";
		Control::setValue("z0ddhud_FCarrierStr", $z0ddhud::FriendlyCarryingTheirFlag);
		$z0ddhud::OurTeamScore++;
		Control::setValue("z0ddhud_OurTeamScore", "<f2>" @ $z0ddhud::OurTeamScore);
		$z0ddhud::TheirFlagIcon = $z0ddhud::TheirFlagBMP;
		Control::setValue("z0ddhud_TheirFlagIcon", $z0ddhud::TheirFlagIcon);
	}
	else if(String::FindSubStr(%msg, "You captured the ") != -1) {
		if($z0ddhud::myScoreHudOn) {
			$z0ddhud::MeCount += 5;  // z0dd: give the player 5 points for capping
			Control::setValue("z0ddhud_MyScoreCount", "<f1>" @ $z0ddhud::MeCount);
		}
	}
	else if(%msg == "Your team's flag was captured.") {
		$z0ddhud::EnemyCarryingOurFlag = "";
		Control::setValue("z0ddhud_ECarrierStr", $z0ddhud::EnemyCarryingOurFlag);		
		$z0ddhud::TheirTeamScore++;
		Control::setValue("z0ddhud_TheirTeamScore", "<f2>" @ $z0ddhud::TheirTeamScore);
		$z0ddhud::OurFlagIcon = $z0ddhud::OurFlagBMP;
		Control::setValue("z0ddhud_OurFlagIcon", $z0ddhud::OurFlagIcon);
	}
	// RETURNED
	else if(String::FindSubStr(%msg, "Your flag was returned to base.") != -1) {
		$z0ddhud::EnemyCarryingOurFlag = "";
		Control::setValue("z0ddhud_ECarrierStr", $z0ddhud::EnemyCarryingOurFlag);
		$z0ddhud::OurFlagIcon = $z0ddhud::OurFlagBMP;
		Control::setValue("z0ddhud_OurFlagIcon", $z0ddhud::OurFlagIcon);
		$z0ddhud::friendlyFlagDropped = 0;
	}
	else if(String::FindSubStr(%msg, "flag was returned") != -1) {
		// They returned thier flag
		$z0ddhud::FriendlyCarryingTheirFlag = "";
		Control::setValue("z0ddhud_FCarrierStr", $z0ddhud::FriendlyCarryingTheirFlag);
		$z0ddhud::TheirFlagIcon = $z0ddhud::TheirFlagBMP;
		Control::setValue("z0ddhud_TheirFlagIcon", $z0ddhud::TheirFlagIcon);
		$z0ddhud::enemyFlagDropped = 0;		
	}
	// DROPPED 
	else if(%msg == "Your flag was dropped in the field.") {
		$z0ddhud::EnemyCarryingOurFlag = "";
		$z0ddhud::friendlyFlagDropped = 1;
		$z0ddhud::friendlyFlagDropTime = 48;
		Control::setValue("z0ddhud_ECarrierStr", "(DROPPED) 48");
		z0ddhud::displayDropStatus("friendly");
	}
	else if(String::FindSubStr(%msg, "flag was dropped ") != -1) {
		// our team dropped the enemy flag	
		$z0ddhud::FriendlyCarryingTheirFlag = "";
		$z0ddhud::enemyFlagDropped = 1;
		$z0ddhud::enemyFlagDropTime = 48;
		Control::setValue("z0ddhud_FCarrierStr", "(DROPPED) 48");
		z0ddhud::displayDropStatus("enemy");
	}
}


/////////////////////////////////////////////////////////////////////////////////////////
// Displays time left before enemy/friendly flag returns. Calls itself every second
// until flag isn't considered dropped (returned, capped, etc...).
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::displayDropStatus(%TeamWhoseFlagWasDropped)
{
	if ((%TeamWhoseFlagWasDropped == "enemy") && ($z0ddhud::enemyFlagDropped)) {
         	if ($z0ddhud::enemyFlagDropTime >= 0) {
			$z0ddhud::enemyFlagDropTime--;
			$z0ddhud::FriendlyCarryingTheirFlag = "(DROPPED) " @ $z0ddhud::enemyFlagDropTime;
			Control::setValue("z0ddhud_FCarrierStr", $z0ddhud::FriendlyCarryingTheirFlag);
			schedule("z0ddhud::displayDropStatus(\"enemy\");", 1);
		}
		else {
			$z0ddhud::enemyFlagDropTime = -1;
			$z0ddhud::FriendlyCarryingTheirFlag = "";			
			Control::setValue("z0ddhud_FCarrierStr", $z0ddhud::FriendlyCarryingTheirFlag);		
		}
		
        }
        else if ((%TeamWhoseFlagWasDropped == "friendly") && ($z0ddhud::friendlyFlagDropped)) {
		if ($z0ddhud::friendlyFlagDropTime >= 0) {
			$z0ddhud::friendlyFlagDropTime--;
			$z0ddhud::EnemyCarryingOurFlag = "(DROPPED) " @ $z0ddhud::friendlyFlagDropTime;	
			Control::setValue("z0ddhud_ECarrierStr", $z0ddhud::EnemyCarryingOurFlag);
			schedule("z0ddhud::displayDropStatus(\"friendly\");", 1);
		}
		else {
			$z0ddhud::friendlyFlagDropTime = -1;
			$z0ddhud::EnemyCarryingOurFlag = "";				
			Control::setValue("z0ddhud_ECarrierStr", $z0ddhud::EnemyCarryingOurFlag);		
		}
        }
}


/////////////////////////////////////////////////////////////////////////////////////////
// Called when any player changes teams
/////////////////////////////////////////////////////////////////////////////////////////
function onClientChangeTeam(%client, %team)
{
	// if this client isn't me	
	if (%client == $z0ddhud::MyClientID) {
		// switch dropped flag status
		%temp = $z0ddhud::enemyFlagDropped;
	        $z0ddhud::enemyFlagDropped = $z0ddhud::friendlyFlagDropped;
		$z0ddhud::friendlyFlagDropped = %temp;
		%temp = $z0ddhud::enemyFlagDropTime;
		$z0ddhud::enemyFlagDropTime = $z0ddhud::friendlyFlagDropTime;
		$z0ddhud::friendlyFlagDropTime = %temp;
	
		// manage dropped flag count down
		if ($z0ddhud::enemyFlagDropped && (!$z0ddhud::friendlyFlagDropped))
			schedule("z0ddhud::displayDropStatus(\"enemy\");", 1);
		else if ($z0ddhud::friendlyFlagDropped && (!$z0ddhud::enemyFlagDropped))
			schedule("z0ddhud::displayDropStatus(\"friendly\");", 1);
				
		// switch team scores
		%temp = $z0ddhud::OurTeamScore;
		$z0ddhud::OurTeamScore = $z0ddhud::TheirTeamScore;
		$z0ddhud::TheirTeamScore = %temp;
		%z0ddhud::TheirScoreString = "<f2>" @ $z0ddhud::TheirTeamScore;
		%z0ddhud::OurScoreString = "<f2>" @ $z0ddhud::OurTeamScore;
	        
		// switch flag carrier strings
		%temp = $z0ddhud::FriendlyCarryingTheirFlag;
		$z0ddhud::FriendlyCarryingTheirFlag = $z0ddhud::EnemyCarryingOurFlag;
		$z0ddhud::EnemyCarryingOurFlag = %temp;		
	
		// handle flag bitmap values
		%temp = $z0ddhud::TheirFlagIcon;
		if ($z0ddhud::OurFlagIcon == $z0ddhud::OurFlagBMP)
			$z0ddhud::TheirFlagIcon = $z0ddhud::TheirFlagBMP;
		else
			$z0ddhud::TheirFlagIcon = "";
	
		if (%temp == $z0ddhud::TheirFlagBMP)
			$z0ddhud::OurFlagIcon = $z0ddhud::OurFlagBMP;
		else
			$z0ddhud::OurFlagIcon = "";
	
		z0ddhud::SetDynamicDisplay();
	}
	
	z0ddhud::TeamSwitchManageCounts(%client, %team);
}


// Teams:
// -1: obsrv
// 0: BE
// 1: DS
function onClientJoin(%client)
{
	if(%client == $z0ddhud::MyClientID) {
		$z0ddhud::MyTeam = Client::getTeam($z0ddhud::MyClientID);
		$z0ddhud::MyName = Client::GetName($z0ddhud::MyClientID);
		z0ddhud::KillsAddMySuicides();
	}
	else {
		$z0ddhud::PlayersOnServer[%client] = 1;
		z0ddhud::KillsAdd(Client::GetName(%client));
	}
	
	// Team count variables
	$z0ddhud::TeamCount[Client::getTeam(%client)]++;
	$z0ddhud::TeamCountPlayerList[%client, team] = Client::getTeam(%client);

	z0ddhud::nickWeaselCheck(%client, 1);
	z0ddhud::UpdateTeamCountHUDs();
}


function onClientDrop(%client)
{
	// take 1 away from the count of the team he was on
	// This is 1 of two reasons we need the PlayerList data.	
	$z0ddhud::TeamCount[$z0ddhud::TeamCountPlayerList[%client, team]]--;
	z0ddhud::nickWeaselCheck(%client, -1);
	$z0ddhud::PlayersOnServer[%client] = 0;
	z0ddhud::UpdateTeamCountHUDs();
}


function z0ddhud::muteNone(%client)
{
	return 1;
}


function z0ddhud::muteAll(%client)
{
	return 0;
}


function z0ddhud::playerOnMyTeam(%client)
{
	return ($z0ddhud::MyTeam == Client::getTeam(%client));
}


function z0ddhud::playerOnEnemyTeam(%client)
{
	return ($z0ddhud::MyTeam != Client::getTeam(%client));
}


function z0ddhud::sayMsg(%client)
{
	return eval($z0ddhud::muteData[$z0ddhud:muteSetting, func] @ "(%client);");	
}


/////////////////////////////////////////////////////////////////////////////////////////
// Proces and route all client messages
/////////////////////////////////////////////////////////////////////////////////////////
function onClientMessage(%client, %msg)
{
	// if message came from a player
	if(%client) {
		// return true (will display message) if mute isnt on, or if mute is on and message came from me.
		// return false (wont display message) if mute is on and message didnt come from me.
		return (z0ddhud::sayMsg(%client) || (%client == $z0ddhud::MyClientID));
	}

	else if (String::FindSubStr(%msg, "flag") != -1) {
		// if we found a valid flag message
		// else it might be a kill msg
		if(z0ddhud::flagEvents(%msg))
			return 1;  // return all valid flag msgs
	}

	else if (%msg == "Station Access On") {
		z0ddhud::enteredStation(%msg);
		return (!$z0ddhud:filterMsgs);
	}

	else if (String::FindSubStr(%msg, "deployed") != -1) {
		// if we found a valid deploy message (all of which we believe should be filtered)
		// else it might be a kill msg
		if (z0ddhud::OnDeployed(%msg))
			return (!$z0ddhud:filterMsgs); 
	}

	else if (String::FindSubStr(%msg, "repair") != -1) {
		// if we found a valid repair message
		// else it might be a kill msg
		if  (z0ddhud::Repairs(%msg))
			return (!$z0ddhud:filterMsgs);
	}

	// I currently don't have any actions to take on a leave a station event.
	//else if (%msg == "Station Access Off")
	//	z0ddhud::ExitedStation(%client, %msg);

	else if ($z0ddhud::autoDropBlaster && (%msg == "You received 1 Blaster"))
		z0ddhud::dropBlaster();

	else if ($z0ddhud::myScoreHudOn && (%msg == "You receive 5 points for holding your captured tower!")) {
		$z0ddhud::MeCount+=5;
		Control::setValue("z0ddhud_MyScoreCount", "<f1>" @ $z0ddhud::MeCount);
	}

	if($z0ddhud::myScoreHudOn) {
		if(z0ddhud::FragEvents(%msg))
			return true;
	}

	if($z0ddhud:filterMsgs)
		return z0ddhud::FilterMsgs(%msg);

	return true;
}

/////////////////////////////////////////////////////////////////////////////////////////
// Filter out what I consider useless server messages.
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::FilterMsgs(%msg)
{
	if (String::FindSubStr(%msg, "You couldn't buy ") != -1)
		return false;

	if (%msg == "Station Access Off")
		return false;

	// print this message if there's a nick weasel on the server with the name:
	// "SOLD " for the first 5 letters.
	// Otherwise, death messages beginging with "SOLD " won't be printed
	if (String::FindSubStr(%msg, "SOLD ") == 0)
		return $z0ddhud::SOLDNickWeaselCnt;

	if (%msg == "AutoRepair On")
		return false;

	if (%msg == "AutoRepair Off")
		return false;

	if (%msg == "Unit is disabled")
		return false;

	// Print this message if there's a nick weasel on the server with the name
	// " is not damaged" for the first 15 latters.
	// Otherwise, death messages containing " is not damaged" won't be printed
	if (String::FindSubStr(%msg, " is not damaged") != -1)
		return $z0ddhud::isnotdamagedNickWeaselCnt;

	if (%msg == "Nothing in range")
		return false;

	if (%msg == "Cannot sell item ~wC_BuySell.wav")
		return false;

	return true;	
}


/////////////////////////////////////////////////////////////////////////////////////////
// Add a death message to the list of death messages
/////////////////////////////////////////////////////////////////////////////////////////
function KillTrak::DeathMessage(%msg, %weapon)
{
	%num = $KillTrak::message[%msg];

	if (%num == "") {
		%num = $KillTrak::numDeaths;
		if (%num == "")
			%num = 0;
		$KillTrak::numDeaths = %num + 1;
	}

	$KillTrak::message[%msg] = %num;
	$KillTrak::death[%num] = %msg;
	$KillTrak::death[%num, weapon] = %weapon;

	$KillTrak::death[%num, suicide] = ((%weapon == "Falling") || (%weapon == "Crushed") || %weapon == "Suicide");
	$KillTrak::death[%num, friendlyfire] = (%weapon == "FriendlyFire");
	$KillTrak::death[%num, other] = ((%weapon == "Debris") || (%weapon == "Missile") || (%weapon == "Turret"));
}


/////////////////////////////////////////////////////////////////////////////////////////
// controls how long msgs are displayed
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddhud::TurnOffCP()
{
	$z0dd::CenterPrintCounter--;
	if(!$z0dd::CenterPrintCounter)
		Client::centerPrint("", 1);
}


/////////////////////////////////////////////////////////////////////////////////////////
// generic variable toggling function that also centerprints a msg to client
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddhud::Toggler(%variable, %string)
{
	if (%variable) {
		z0ddhud::CenterPrint("<jc>" @ %string @ " OFF", 2);
	        return 0;		
	}
	else {
		z0ddhud::CenterPrint("<jc>" @ %string @ " ON", 2);
	        return 1;		
 	}
}


/////////////////////////////////////////////////////////////////////////////////////////
// Toggle Repair Pack timer on and off
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddhud::ToggleRepTimer()
{
	$z0ddhud::RepTimerOn = z0ddhud::Toggler($z0ddhud::RepTimerOn, "Repair Pack Timer is");
	$z0ddhud::repPackRespawnTime = 0;
}


/////////////////////////////////////////////////////////////////////////////////////////
// Toggle Auto-target flag carriers
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddhud::ToggleAutoTarget(%side)
{
	if(%side == enemy)
		$z0ddhud::autoTargEnemyCarrier = z0ddhud::Toggler($z0ddhud::autoTargEnemyCarrier, "Auto target enemies is");
	else
		$z0ddhud::autoTargFriendlyCarrier = z0ddhud::Toggler($z0ddhud::autoTargFriendlyCarrier, "Auto target friendlies is");
}


/////////////////////////////////////////////////////////////////////////////////////////
// Toggle the auto-POV at inventory stations on and off
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddhud::ToggleShowInvList()
{
	$z0ddhud::ShowInvList = z0ddhud::Toggler($z0ddhud::ShowInvList, "Inventory lists are");
}


/////////////////////////////////////////////////////////////////////////////////////////
// Toggles the auto-purchasing of favs at invs
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddhud::ToggleAutoFavs()
{
	$z0ddhud::AutoFavorites = z0ddhud::Toggler($z0ddhud::AutoFavorites, "Auto-Favorites turned");
}


////////////////////////////////////////////////////////////////////////////////////////
// Toggle Automatic Station Messages on and off
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddhud::ToggleAutoStationMsgs()
{
	$z0ddhud::AutoMsgAtStations = z0ddhud::Toggler($z0ddhud::AutoMsgAtStations, "Automatic Station Messages are");
}


////////////////////////////////////////////////////////////////////////////////////////
// Toggles the auto-tossing of items at invs
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddhud::ToggleAutoSpew()
{
	$z0ddhud::ClusterSpew = z0ddhud::Toggler($z0ddhud::ClusterSpew, "Auto Cluster Spew turned");
}


////////////////////////////////////////////////////////////////////////////////////////
// Toggles the muting of all messages from all players
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddhud::cycleMute()
{
	$z0ddhud:muteSetting = ($z0ddhud:muteSetting % 4) + 1;
	z0ddhud::CenterPrint("<jc>" @ $z0ddhud::muteData[$z0ddhud:muteSetting, msg], 2);
}


/////////////////////////////////////////////////////////////////////////////////////////
// Change the auto fav and centerprint clients message
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddhud::ChangeAutoFav(%newfav)
{
	$z0ddhud::AutoFav = %newfav;
	z0ddhud::CenterPrint("<jc>" @ $z0ddhud::AutoFavMsg[%newfav], 2);
}


/////////////////////////////////////////////////////////////////////////////////////////
// Client entered a station.  Portions by Presto
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddhud::enteredStation(%msg)
{
	if ($z0ddhud::StationTurnAround) {
		postAction(2048, IDACTION_TURNLEFT, $z0ddhud::TurnAroundSpeed);
		schedule("postAction(2048, IDACTION_TURNLEFT, -0);", $z0ddhud::TurnAroundTime);
	}

	if($z0ddhud::ShowInvList)
		remoteEval(2048, ToggleInventoryMode);

	if ($z0ddhud::ClusterSpew && $z0ddhud::StationTurnAround)
		schedule("z0ddspew::dump(cluster, -1);", $z0ddhud::TurnAroundTime);
	else if ($z0ddhud::ClusterSpew)
		z0ddspew::dump(cluster, -1);

	if ($z0ddhud::AutoFavorites)
		CmdInventoryGui::buyFavorites($z0ddhud::AutoFav);
		
	if($z0ddhud::AutoMsgAtStations)
		say(1, "Leaving Station: " @ $z0ddhud::AutoFavMsg[$z0ddhud::AutoFav]);
}


/////////////////////////////////////////////////////////////////////////////////////////
// Client exited a station
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddhud::ExitedStation(%client, %msg)
{
	if (%client != 0)
		return;
}
                           

/////////////////////////////////////////////////////////////////////////////////////////
// Deploying announcements
/////////////////////////////////////////////////////////////////////////////////////////
function z0ddhud::OnDeployed(%msg) 
{
	%item = $z0ddhud::DeployedMsgs[%msg];

	if(%item != "") {
		say(1, "I deployed a " @ %item);
		return 1;
	}
	return 0;
}


$repairSameTime = 5;  // Time between repair messages; prevents flooding

function z0ddhud::Repairs(%msg) 
{
	// prevents player names beginging with "Repairing" from being processed as a legit Repair msg
	if($z0ddhud::repairingNickWeaselCnt)
		return 0;

       	if (%msg == "You received a RepairPack backpack") {
		z0ddhud::repPackPickUp(%msg);
		return 0;
	}

	if (%msg == "Repair Done") {
		say(1, "Repairs completed on " @ $z0ddhud::repairItem);
		return 1;
	}

	if (%msg == "Repair Stopped")
		return 1;

	if(String::FindSubStr(%msg, "Repairing ") == 0) {
		%len = Match::strLen(%msg);
		$z0ddhud::repairItem = String::getSubStr(%msg, 10, %len-10);
		if (Flood::Protect("repair" @ $z0ddhud::repairItem, $repairSameTime))
			say(1, "I'm repairing " @ $z0ddhud::repairItem);
		return 1;
	}
	
	return 0;
}


/////////////////////////////////////////////////////////////////////////////////////////
// Returns true if we dont need to protect against flooding
/////////////////////////////////////////////////////////////////////////////////////////
function Flood::Protect(%tag, %protectTime)
{
	%lastTime = $Flood::[%tag];
	%time = GetSimTime();
	$Flood::[%tag] = %time;
	return %lastTime == "" || (%time - %lastTime >= %protectTime);
}


function z0ddhud::RepRespawnTimer()
{
	if ($z0ddhud::repPackRespawnTime > 0) {
		$z0ddhud::repPackRespawnTime--;
		$z0ddhud::TimerString = $z0ddhud::repPackRespawnTime;	
		Control::setValue("z0ddhud_TimerStr", $z0ddhud::TimerString);
		schedule("z0ddhud::RepRespawnTimer();", 1);
	}
	else {
		for(%i = 1; %i <= $z0ddhud::bgLevel; %i++)
			Control::setVisible("z0ddhud_repairFrame" @ %i, 0);
		$z0ddhud::timedOut = 1;
		$z0ddhud::TimerString = "";
		Control::setValue("z0ddhud_TimerStr", $z0ddhud::TimerString);
	}
}


function z0ddhud::repPackPickUp(%msg)
{
	if($z0ddhud::RepTimerOn) {
		for(%i = 1; %i <= $z0ddhud::bgLevel; %i++)
			Control::setVisible("z0ddhud_repairFrame" @ %i, 1);
		$z0ddhud::repPackRespawnTime = 30;
		if($z0ddhud::timedOut) {
			$z0ddhud::timedOut = 0;
			schedule("z0ddhud::RepRespawnTimer();", 1);
		}
	}
}


function z0ddhud::setTimer(%time)
{
	$z0ddhud::repPackRespawnTime = %time;
	if($z0ddhud::timedOut) {
		$z0ddhud::timedOut = 0;
		schedule("z0ddhud::RepRespawnTimer();", 1);
	}
}


function z0ddhud::timerTimedOut()
{
 	$z0ddhud::timedOut = 1;
}


function z0ddhud::TeamSwitchManageCounts(%client, %team)
{
	$z0ddhud::MyTeam = Client::getTeam($z0ddhud::MyClientID);
	
	// Reduce the count for team player WAS on.
	// This is 1 of two reasons we need the PlayerList data.
	// possibly being obsrver team
	$z0ddhud::TeamCount[$z0ddhud::TeamCountPlayerList[%client, team]]--;

	// set this players team # to new team #
	$z0ddhud::TeamCountPlayerList[%client, team] = %team;

	// increase the count of the team this player just joined
 	// possibly being obsrver team	
	$z0ddhud::TeamCount[%team]++;

	z0ddhud::UpdateTeamCountHUDs();
}


function z0ddhud::UpdateTeamCountHUDs()
{
	// if i'm in observer mode
	if($z0ddhud::MyTeam == -1) {
		Control::setValue("z0ddhud_TeamUsCount", "<f2>-");
		Control::setValue("z0ddhud_TeamThemCount", "<f2>-");	
	}
	else {
		Control::setValue("z0ddhud_TeamUsCount", "<f2>" @ $z0ddhud::TeamCount[$z0ddhud::MyTeam]);
		Control::setValue("z0ddhud_TeamThemCount", "<f2>" @ $z0ddhud::TeamCount[!$z0ddhud::MyTeam]);
	}
	Control::setValue("z0ddhud_TeamObCount", "<f2>" @ $z0ddhud::TeamCount[-1]);
}


function z0ddhud::KillsAddMySuicides()
{
	$z0ddhud::KillsData[$PCFG::Name @ " ends it all."]									= -1;
	$z0ddhud::KillsData[$PCFG::Name @ " takes " @ $z0ddhud::MyPronoun @ " own life."]					= -1;
	$z0ddhud::KillsData[$PCFG::Name @ " kills " @ $z0ddhud::MyPronoun @ " own dumb self."]					= -1;
	$z0ddhud::KillsData[$PCFG::Name @ " decides to see what the afterlife is like."]					= -1;
}


function z0ddhud::KillsAdd(%vic_name)
{
	$z0ddhud::KillsData[%vic_name @ " catches a Frisbee of Death thrown by " @ $PCFG::Name @ "."]				= 1;
	$z0ddhud::KillsData[$PCFG::Name @ " blasts " @ %vic_name @ " with a well-placed disc."]					= 1;
	$z0ddhud::KillsData[$PCFG::Name @ "'s spinfusor caught " @ %vic_name @ " by surprise."]					= 1;
	$z0ddhud::KillsData[%vic_name @ " falls victim to " @ $PCFG::Name @ "'s Stormhammer."]					= 1;
	
	$z0ddhud::KillsData[$PCFG::Name @ " ventilates " @ %vic_name @ " with " @ $z0ddhud::MyPronoun @ " chaingun."]		= 1;
	$z0ddhud::KillsData[$PCFG::Name @ " gives " @ %vic_name @ " an overdose of lead."]					= 1;
	$z0ddhud::KillsData[$PCFG::Name @ " fills " @ %vic_name @ " full of holes."]						= 1;
	$z0ddhud::KillsData[$PCFG::Name @ " guns down " @ %vic_name @ "."]							= 1;
		
	$z0ddhud::KillsData[$PCFG::Name @ " mortars " @ %vic_name @ " into oblivion."]						= 1;
	$z0ddhud::KillsData[%vic_name @ " didn't see that last mortar from " @ $PCFG::Name @ "."]				= 1;
	$z0ddhud::KillsData[$PCFG::Name @ " inflicts a mortal mortar wound on " @ %vic_name @ "."]				= 1;
	$z0ddhud::KillsData[$PCFG::Name @ "'s mortar takes out " @ %vic_name @ "."]						= 1;
		
	$z0ddhud::KillsData[%vic_name @ " feels the warm glow of " @ $PCFG::Name @ "'s plasma."]				= 1;
	$z0ddhud::KillsData[$PCFG::Name @ " gives " @ %vic_name @ " a white-hot plasma injection."]				= 1;	
	$z0ddhud::KillsData[$PCFG::Name @ " asks " @ %vic_name @ ", 'Got plasma?'"]						= 1;	
	$z0ddhud::KillsData[$PCFG::Name @ " gives " @ %vic_name @ " a plasma transfusion."]					= 1;	
		
	$z0ddhud::KillsData[$PCFG::Name @ " adds " @ %vic_name @ " to " @ $z0ddhud::MyPronoun @ " list of sniper victims."]	= 1;	
	$z0ddhud::KillsData[$PCFG::Name @ " fells " @ %vic_name @ " with a sniper shot."]					= 1;
	$z0ddhud::KillsData[%vic_name @ " becomes a victim of " @ $PCFG::Name @ "'s laser rifle."]				= 1;
	$z0ddhud::KillsData[%vic_name @ " stayed in " @ $PCFG::Name @ "'s crosshairs for too long."]				= 1;
		
	$z0ddhud::KillsData[%vic_name @ " gets a blast out of " @ $PCFG::Name @ "."]						= 1;
	$z0ddhud::KillsData[%vic_name @ " succumbs to " @ $PCFG::Name @ "'s rain of blaster fire."]				= 1;
	$z0ddhud::KillsData[$PCFG::Name @ "'s puny blaster shows " @ %vic_name @ " a new world of pain."]			= 1;
	$z0ddhud::KillsData[%vic_name @ " meets " @ $PCFG::Name @ "'s master blaster."]						= 1;
		
	$z0ddhud::KillsData[$PCFG::Name @ " blows " @ %vic_name @ " up real good."]						= 1;
	$z0ddhud::KillsData[%vic_name @ " gets a taste of " @ $PCFG::Name @ "'s explosive temper."]				= 1;
	$z0ddhud::KillsData[$PCFG::Name @ " gives " @ %vic_name @ " a fatal concussion."]					= 1;
	$z0ddhud::KillsData[%vic_name @ " never saw it coming from " @ $PCFG::Name @ "."]					= 1;
		
	$z0ddhud::KillsData[$PCFG::Name @ " mows down " @ $z0ddhud::MyPronoun @ " teammate, " @ %vic_name]			= -1;	
	$z0ddhud::KillsData[$PCFG::Name @ " killed " @ $z0ddhud::MyPronoun @ " teammate, " @ %vic_name @ " with a mine."]	= -1;
			
	$z0ddhud::KillsData[$PCFG::Name @ " makes quite an impact on " @ %vic_name @ "."]					= 1;
	$z0ddhud::KillsData[%vic_name @ " becomes the victim of a fly-by from " @ $PCFG::Name @ "."]				= 1;
	$z0ddhud::KillsData[%vic_name @ " leaves a nasty dent in " @ $PCFG::Name @ "'s fender."]				= 1;
	$z0ddhud::KillsData[$PCFG::Name @ " says, 'Hey " @ %vic_name @ ", you scratched my paint job!'"]			= 1;
	
	$z0ddhud::KillsData[%vic_name @ " gets zapped with " @ $PCFG::Name @ "'s ELF gun."]					= 1;
	$z0ddhud::KillsData[$PCFG::Name @ " gives " @ %vic_name @ " a nasty jolt."]						= 1;
	$z0ddhud::KillsData[%vic_name @ " gets a real shock out of meeting " @ $PCFG::Name @ "."]				= 1;
	$z0ddhud::KillsData[$PCFG::Name @ " short-circuits " @ %vic_name @ "'s systems."]					= 1;
}


function z0ddhud::ReturnAmmoValue(%val)
{
	return %val;
}


function z0ddhud::CreateAmmoTable()
{
	$z0ddhud::AmmoData[-1] 			= "z0ddhud::ReturnAmmoValue(\" \");";	// no weapaon
	$z0ddhud::AmmoData[0] 			= "z0ddhud::ReturnAmmoValue(\" \");";	// unknown
	$z0ddhud::AmmoData[""] 			= "z0ddhud::ReturnAmmoValue(\" \");";
	$z0ddhud::AmmoData["ELF gun"] 		= "z0ddhud::ReturnAmmoValue(1);";
	$z0ddhud::AmmoData["Laser Rifle"] 	= "z0ddhud::ReturnAmmoValue(1);";
	$z0ddhud::AmmoData["Disc Launcher"] 	= "getItemCount(\"Disc\");";
	$z0ddhud::AmmoData["Chaingun"] 		= "getItemCount(\"Bullet\");";
	$z0ddhud::AmmoData["Mortar"] 		= "getItemCount(\"Mortar Ammo\");";
	$z0ddhud::AmmoData["Grenade Launcher"] 	= "getItemCount(\"Grenade Ammo\");";
	$z0ddhud::AmmoData["Plasma Gun"] 	= "getItemCount(\"Plasma Bolt\");";
	$z0ddhud::AmmoData[21] 			= "getItemCount(\"Disc\");";		// Disc launcher
	$z0ddhud::AmmoData[13] 			= "getItemCount(\"Bullet\");";		// Chaingun
	$z0ddhud::AmmoData[17] 			= "getItemCount(\"Grenade Ammo\");";	// Granade Lanucher
	$z0ddhud::AmmoData[19] 			= "getItemCount(\"Mortar Ammo\");";	// Mortar
	$z0ddhud::AmmoData[15] 			= "getItemCount(\"Plasma Bolt\");";	// Plasma Gun
	$z0ddhud::AmmoData[22] 			= "z0ddhud::ReturnAmmoValue(\"\\n\" @ \"<Blr_Infinity_on.bmp>\");";	// Laser Rifle
	$z0ddhud::AmmoData[24] 			= "z0ddhud::ReturnAmmoValue(\"\\n\" @ \"<Blr_Infinity_on.bmp>\");";	// ELF
	$z0ddhud::AmmoData[11]			= "z0ddhud::ReturnAmmoValue(\"\\n\" @ \"<Blr_Infinity_on.bmp>\");";	// Blaster
	$z0ddhud::AmmoData[23] 			= "z0ddhud::ReturnAmmoValue(\" \");";	// targetting laser
	$z0ddhud::AmmoData[25] 			= "z0ddhud::ReturnAmmoValue(\" \");";  	// repair gun
}


function z0ddhud::CreateDelpoyedTable()
{
	$z0ddhud::DeployedMsgs["Remote Turret deployed"]	= "Turret";
	$z0ddhud::DeployedMsgs["Inventory Station deployed"]	= "Inventory Station";
	$z0ddhud::DeployedMsgs["Beacon deployed"]		= "Beacon";
	$z0ddhud::DeployedMsgs["Pulse Sensor deployed"] 	= "Pulse Sensor";
	$z0ddhud::DeployedMsgs["Ammo Station deployed"] 	= "Ammo Station";
	$z0ddhud::DeployedMsgs["Motion Sensor deployed"] 	= "Motion Sensor";
	$z0ddhud::DeployedMsgs["Sensor Jammer deployed"] 	= "Sensor Jammer";
	$z0ddhud::DeployedMsgs["Camera deployed"] 		= "Camera";
}


function Match::strLen(%str)
{
	for (%i = 0; String::GetSubStr(%str, %i, 1) != ""; %i++) {
		
	}
	return %i;
}


if ($z0ddhud::packHudOn) {
	if($z0ddhud::NewLayout) {
		$z0ddhud::packMarker[27] = "<BI_DEPLOYABLE_oN.bmp>";		// Remote Inventory Station
		$z0ddhud::packMarker[28] = "<BI_backpack_on.bmp>"; 		// Remote Ammo Station
		$z0ddhud::packMarker[29] = "<BI_ENERGYPACK_oN.bmp>"; 		// Energy pack
		$z0ddhud::packMarker[30] = "<BI_REPAIRPACK_oN.bmp>"; 		// Repair pack
		$z0ddhud::packMarker[31] = "<BI_SHIELDPACK_oN.bmp>"; 		// Shield pack
		$z0ddhud::packMarker[32] = "<BI_SENSORJAMERPACK_oN.bmp>";	// Sensor Jammer pack
		$z0ddhud::packMarker[33] = "<BI_clock_on.bmp>"; 		// Motion Sensor
		$z0ddhud::packMarker[34] = "<BI_AMMOPACK_oN.bmp>"; 		// Ammo pack
		$z0ddhud::packMarker[35] = "<BI_blaster_on.bmp>"; 		// Pulse Sensor
		$z0ddhud::packMarker[36] = "<BI_targetlaser_on.bmp>"; 		// Sensor Jammer
		$z0ddhud::packMarker[37] = "<BI_compass_on.bmp>"; 		// Camera
		$z0ddhud::packMarker[38] = "<BI_pulse_on.bmp>"; 		// Turret
	}
	else {
		$z0ddhud::packMarker[27] = "  Inv";		// Remote Inventory Station
		$z0ddhud::packMarker[28] = "AmmoS";		// Remote Ammo Station
		$z0ddhud::packMarker[29] = "Energy";		// Energy pack
		$z0ddhud::packMarker[30] = "Repair";		// Repair pack
		$z0ddhud::packMarker[31] = "Shield";		// Shield pack
		$z0ddhud::packMarker[32] = "SJamPk";		// Sensor Jammer pack
		$z0ddhud::packMarker[33] = "Motion";		// Motion Sensor
		$z0ddhud::packMarker[34] = "Ammo"; 		// Ammo pack
		$z0ddhud::packMarker[35] = "Pulse";		// Pulse Sensor
		$z0ddhud::packMarker[36] = "SenJam";		// Sensor Jammer
		$z0ddhud::packMarker[37] = "Camera"; 		// Camera
		$z0ddhud::packMarker[38] = "Turret";		// Turret

	}
}


$z0ddhud::muteData[1, msg] = "Muted: NONE";
$z0ddhud::muteData[2, msg] = "Muted: All";
$z0ddhud::muteData[3, msg] = "Muted: TEAMMATES";
$z0ddhud::muteData[4, msg] = "Muted: ENEMIES";
$z0ddhud::muteData[1, func] = z0ddhud::muteNone;
$z0ddhud::muteData[2, func] = z0ddhud::muteAll;
$z0ddhud::muteData[3, func] = z0ddhud::playerOnEnemyTeam;
$z0ddhud::muteData[4, func] = z0ddhud::playerOnMyTeam;

$z0ddhud::LowPriorityUpdatesOn = ($z0ddhud::grensHudOn ||  
				  $z0ddhud::minesHudOn ||  
				  $z0ddhud::beacsHudOn ||
				  $z0ddhud::kitHudOn);

$z0ddhud::HighPriorityUpdatesOn = ($z0ddhud::ammoHudOn ||
				   $z0ddhud::packHudOn);

$z0ddhud::Creating = 0;
$pref::noEnterInvStation = true;
$z0ddhud::DropBlasterOn = 1;
$z0ddhud::Using = 1; // check this variable to see if client is using z0ddhud


// reminder
// deleteObject(ConsoleScheduler);
