// FILE:		z0dd_drop_blaster.cs
// VERSION:		1.3
// DATE:		1/13/2001
// AUTHOR:		Paul "z0dd" Paella
// EMAIL:		z0dd@adelphia.net
// WEBPAGE:		http://home.adelphia.net/~z0dd/
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////// DESCRIPTION: ////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	Drops blaster and readies a prioritized weapon that has ammo.
//
//////////////////////////////////////////////////////////////////////////////
/////////////////////////////// INSTALLATION: ////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	Put z0dd_drop_blaster.cs into your:
//		...\tribes\config
// 	directory and insert this line into your autoexec.cs:
//		exec("z0dd_drop_blaster.cs");
//
//	Default Keys:
//		x  : Activates drop blaster
//
// 	This script is configured by editing the area labeled:
//	USER CONFIGURATION SECTION
//                            
//////////////////////////////////////////////////////////////////////////////
////////////////////////////// VERSION HISTORY: //////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	1.3	- Changed the script messages to print in the bottom middle
//		  of the screen instead of bottom left.
//
//	1.2	- Better centerprint messeging. Vague huh?  :)
//
//	1.1	- Fixed a major bug that prevented the previous weapon funtion
//		  from working if you weren't using my HUD z0dd_hud.cs
//		  (thanks to =S3w= Raskal)
//
//
//////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// NOTES: ///////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//	1) You don't need to use this script if you are using my z0dd_hud.cs
//	   script. Blaster dropping is in my hud script and you should use
//	   that one instead.

// Don't edit the line below
EditActionMap("playMap.sae");                                                       

                                                               
//////////////////////////////////////////////////////////////////////////////
//////////////////////// USER CONFIGURATION SECTION //////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// DROP KEY
// The key to drop the blaster.  Default is x
bindCommand(keyboard0, make, "x", TO, "z0dd_db::dropBlaster();");
bindCommand(keyboard0, break, "x", TO, "");

// Toggle dropping on/off (off means you will only switch to your wpn fav)
// Default is control+x
bindCommand(keyboard0, make, control, "x", TO, "z0dd_db::ToggleDrop();");
bindCommand(keyboard0, break, control, "x", TO, "");

//
// BEST WEAPON PREFERENCES                                                            
// These weapon preferences are the order that weapons are chosen when you
// drop the Blaster. For instance, if you drop the blaster while only
// carrying the Mortar and ELF Gun, you'll drop the blaster and ready the
// mortar (because it comes before ELF Gun in the default setup below)
$z0dd_db::weaponPreference1 = "Disc Launcher";
$z0dd_db::weaponPreference2 = "Chaingun";
$z0dd_db::weaponPreference3 = "Mortar";
$z0dd_db::weaponPreference4 = "Grenade Launcher";
$z0dd_db::weaponPreference5 = "Plasma Gun";
$z0dd_db::weaponPreference6 = "Laser Rifle";
$z0dd_db::weaponPreference7 = "ELF gun";
                                                               
//////////////////////////////////////////////////////////////////////////////
// DON'T EDIT PAST HERE UNLESS YOU'RE A SCRIPTER AND KNOW WHAT YOU'RE DOING //
//////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////////////
// controls how long msgs are displayed
/////////////////////////////////////////////////////////////////////////////////////////
function z0dd_db::TurnOffDrop()
{
	$z0dd::CenterPrintCounter--;
	if(!$z0dd::CenterPrintCounter)
		Client::centerPrint("", 1);
}

function z0dd_db::ToggleDrop()
{
	if($z0dd_db::DropOn) {
		$z0dd_db::DropOn = 0;
		Client::centerPrint("<jc>Drop Blaster OFF", 1);
	}
	else {
		$z0dd_db::DropOn = 1;
		Client::centerPrint("<jc>Drop Blaster ON", 1);
	}
	$z0dd::CenterPrintCounter++;
	schedule("z0dd_db::TurnOffDrop();", 2);
}

/////////////////////////////////////////////////////////////////////////////////////////
// Returns the ammo quantity for %weapon.
// Returns 1 if %weapon is ELF or Sniper Rifle
// Otherwise, it returns 0
/////////////////////////////////////////////////////////////////////////////////////////
function z0dd_db::getAmmo(%weapon)
{
	if ((%weapon == "ELF gun") || (%weapon == "Laser Rifle"))
		return 1;
	if (%weapon == "Disc Launcher")
		return(getItemCount("Disc"));
	else if (%weapon == "Chaingun")
		return(getItemCount("Bullet"));
	else if (%weapon == "Mortar")
		return(getItemCount("Mortar Ammo"));
	else if (%weapon == "Grenade Launcher")
		return(getItemCount("Grenade Ammo"));
	else if (%weapon == "Plasma Gun")
		return(getItemCount("Plasma Bolt"));
	else {
		echo("\n============ z0ddhud error: You entered an invalid weaponPreference.\n");
		return 0;
	}
}

//////////////////////////////////////////////////////////////////////////////
// Drops the blaster if you are carrying it.
// It will then automatically switch to your next weapon of choice that has
// ammo. The wepons of choice are choosen sequentially from
// $z0dd_db::weaponPreference1 to $z0dd_db::weaponPreference7 
//////////////////////////////////////////////////////////////////////////////
function z0dd_db::dropBlaster()
{
	if($z0dd_db::DropOn) {
		drop("blaster");
	}
		
	if(getItemCount($z0dd_db::weaponPreference1) && (z0dd_db::getAmmo($z0dd_db::weaponPreference1)))
		use($z0dd_db::weaponPreference1);
	else if (getItemCount($z0dd_db::weaponPreference2) && (z0dd_db::getAmmo($z0dd_db::weaponPreference2)))
		use($z0dd_db::weaponPreference2);
	else if (getItemCount($z0dd_db::weaponPreference3) && (z0dd_db::getAmmo($z0dd_db::weaponPreference3)))
		use($z0dd_db::weaponPreference3);
	else if (getItemCount($z0dd_db::weaponPreference4) && (z0dd_db::getAmmo($z0dd_db::weaponPreference4)))
		use($z0dd_db::weaponPreference4);
	else if (getItemCount($z0dd_db::weaponPreference5) && (z0dd_db::getAmmo($z0dd_db::weaponPreference5)))
		use($z0dd_db::weaponPreference5);
	else if (getItemCount($z0dd_db::weaponPreference6) && (z0dd_db::getAmmo($z0dd_db::weaponPreference6)))
		use($z0dd_db::weaponPreference6);
	else if (getItemCount($z0dd_db::weaponPreference7) && (z0dd_db::getAmmo($z0dd_db::weaponPreference7)))
		use($z0dd_db::weaponPreference7);
}

$z0dd_db::DropOn = 1;