// FILE:		z0dd_sensitivity.cs
// VERSION:		1.2
// DATE:		1/13/2001
// AUTHOR:		Paul "z0dd" Paella
// EMAIL:		z0dd@adelphia.net
// WEBPAGE:		http://home.adelphia.net/~z0dd/
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////// DESCRIPTION: ////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	Press a key to cycle between 3 sensitivity settings. The first setting
//	is your regular sesnsistivity value. The second is used to make scout
//	piloting easier. The 3rd is used to make your controls EXTREMELY
//	sesnsitive, thus making you VERY difficult to hit when piloting a
//	scout.
//
//////////////////////////////////////////////////////////////////////////////
////////////////////////////// VERSION HISTORY: //////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	1.2	- Changed the script messages to print in the bottom middle
//		  of the screen instead of bottom left.
//
//	1.1	- Cleaned up the centerprint messaging code
//
//	1.0	- Initial version.

//
//////////////////////////////////////////////////////////////////////////////
/////////////////////////////// INSTALLATION: ////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	Put z0dd_sensitivity.cs into your:
//		...\tribes\config
// 	directory and insert this line into your autoexec.cs:
//		exec("z0dd_sensitivity.cs");
//
//	Default Keys:
//		CONTROL+m : Toggles between close and far toss ranges.
//
//	You MUST, at least, edit the ORIGINAL MOUSE SENSITIVITY section of
//	the USER CONFIGURATION SECTION.
//
// 	This script is configured by editing the area labeled:
//	USER CONFIGURATION SECTION
//
//////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// NOTES: ///////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	1) You MUST, at least, edit the ORIGINAL MOUSE SENSITIVITY section
//	   of the USER CONFIGURATION SECTION.
//	1) This script doesn't require Presto and will not conflict with it.
//
//////////////////////////////////////////////////////////////////////////////
///////////////////////// USER CONFIGURATION SECTION /////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// CYCLE SENSITIVITY KEY
// The key cycles between the 3 sensitivity settings, normal, scout, and spaz
// scout sensitivities.
// Default is CONTROL+m
bindCommand(keyboard0, make, control, "m", TO, "z0ddsens::Cycle();");
bindCommand(keyboard0, break, control, "m", TO, "");

// ORIGINAL MOUSE SENSITIVITY
// You MUST look in your config.cs file in your ...tribes\config directory
// and set the following item to whatever numeric value is in found in the
// following two bindActions:
//  bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Flip, Scale, 0.002779);
//  bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Flip, Scale, 0.002779);
//
// Note: If you want to adjust your normal mouse sensitivity after
// installing this script, set the sensitivity mode to "normal", change
// the sensitivity value in the Tribes options menus, exit the game and
// look in the config.cs file for the new IDACTION_YAW and IDACTION_PITCH
// values (which shuld be the same number) and assign this variable 
// ($z0ddsens::OriginalSensitivity) that number.
//
// In this exmaple, my original mouse sensitivity values are: 0.002779, so
// I put that value in the line below.
$z0ddsens::OriginalSensitivity = 0.002779;

// SCOUT CONTROL SENSITIVITY
// These sensitivity values are used when you are in a scout and want
// slightly more sensitive controls. The first is for Left and Right
// sensitivity, the second is for Up and Down sensitivity. You may need to
// tweak these default values.
$z0ddsens::ScoutLeftRightSensitivity = 0.7;
$z0ddsens::ScoutUpDownSensitivity = 0.02;

// SCOUT SPAZ CONTROL SENSITIVITY
// These sensitivity values are used when you are in a scout and want
// spaztic input controls. Using these (while in a scout) will make you VERY
// difficult to hit! The first is for Left and Right sensitivity, the second
// is for Up and Down sensitivity. You may need to tweak these default
// values.
$z0ddsens::SpazLeftRightSensitivity = 1.0;
$z0ddsens::SpazUpDownSensitivity = 1.0;

//////////////////////////////////////////////////////////////////////////////
// DON'T EDIT PAST HERE UNLESS YOU'RE A SCRIPTER AND KNOW WHAT YOU'RE DOING //
//////////////////////////////////////////////////////////////////////////////

// The current sensitivity mode setting
$z0ddsens::Mode = 1;

function z0ddsens::SetSensitivity(%xSens, %ySens)
{
    EditActionMap("playMap.sae");
    if(Client::getMouseXaxisFlip("playMap.sae"))
        bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Scale, %xSens);
    else
        bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Flip, Scale, %xSens);

    EditActionMap("playMap.sae");
    if(Client::getMouseYaxisFlip("playMap.sae"))
        bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Scale, %ySens);
    else
        bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Flip, Scale, %ySens);
}

/////////////////////////////////////////////////////////////////////////////////////////
// controls how long msgs are displayed
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddsens::TurnOffCP()
{
	$z0dd::CenterPrintCounter--;
	if(!$z0dd::CenterPrintCounter)
		Client::centerPrint("", 1);
}

function z0ddsens::Cycle()
{
	$z0ddsens::Mode = ($z0ddsens::Mode % 3) + 1;
	
	if($z0ddsens::Mode == 1) {
		z0ddsens::SetSensitivity($z0ddsens::OriginalSensitivity, $z0ddsens::OriginalSensitivity);
		Client::centerPrint("<jc>Sensitivity = NORMAL", 1);		
	}
	else if($z0ddsens::Mode == 2) {
		z0ddsens::SetSensitivity($z0ddsens::ScoutLeftRightSensitivity, $z0ddsens::ScoutUpDownSensitivity);
		Client::centerPrint("<jc>Sensitivity = SCOUT", 1);		
	}
	else if($z0ddsens::Mode == 3) {
		z0ddsens::SetSensitivity($z0ddsens::SpazLeftRightSensitivity, $z0ddsens::SpazUpDownSensitivity);
		Client::centerPrint("<jc>Sensitivity = SPAZ", 1);
	}
	
	$z0dd::CenterPrintCounter++;
	schedule("z0ddsens::TurnOffCP();", 2);
}
