// FILE:		z0dd_vcr.cs
// VERSION:		1.0
// DATE:		2/04/01
// AUTHOR:		Paul "z0dd" Paella
// EMAIL:		z0dd@adelphia.net
// WEBPAGE:		http://home.adelphia.net/~z0dd/
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////// DESCRIPTION: ////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	Allow control of the playback speed of demos.
//
//////////////////////////////////////////////////////////////////////////////
////////////////////////////// VERSION HISTORY: //////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	1.0	- Initial version.
//
//////////////////////////////////////////////////////////////////////////////
/////////////////////////////// INSTALLATION: ////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	Put z0dd_vcr.cs into your:
//		...\tribes\config
// 	directory and insert this line into your autoexec.cs:
//		exec("z0dd_vcr.cs");
//	Create the autoexec.cs (as ASCII text) file if you don't have one.
//
//	Default Keys:
//		control+F9   : Slow playback speed
//		control+F11  : Normal playback speed
//		control+F12  : Fast playback speed
//

// Don't edit the following line
editActionMap("playMap.sae");

// SLOW PLAYBACK SPEED KEY
// The key that sets the demo play speed to slow
// Default: control+f9
bindCommand(keyboard0, make, alt, "f9", TO, "$SimGame::TimeScale=0.001;");

// NORMAL PLAYBACK SPEED KEY
// The key that sets the demo play speed to normal
// Default: control+f11
bindCommand(keyboard0, make, alt, "f11", TO, "$SimGame::TimeScale=1.0;"); 

// FAST PLAYBACK SPEED KEY
// The key that sets the demo play speed to fast.
// Note: The maximum speed you can play a demo is dependent on the speed of
// your computer. The default value of 18.0 should be fine for most computers.
// I set this to 25.0 on my P3-733 with 256megs of RAM, and 15.0 on my P3-450
// with 128megs of RAM.
// Default: control+f12
bindCommand(keyboard0, make, alt, "f12", TO, "$SimGame::TimeScale=18.0;");
