// FILE:		z0dd_zoomsnipe.cs
// VERSION:		1.11
// DATE:		1/20/01
// AUTHOR:		Paul "z0dd" Paella
// EMAIL:		z0dd@adelphia.net
// WEBPAGE:		http://home.adelphia.net/~z0dd/
//                           
//
// DESCRIPTION:
//	Holding down a single button will automatically switch your weapon to
//	the Laser Rifle, make you crouch, and zoom in your view.
//	Upon release, you'll un-zoom, stand erect, and you'll switch back to
//	the weapon you held before you pressed the ZoomSnipe key.
//
// INSTALLATION:
//	Put z0dd_zoomsnipe.cs into your:
//		...\tribes\config
// 	directory and insert this line into your autoexec.cs:
//		exec("z0dd_zoomsnipe.cs");
//
// 	This script is configured by editing the area labeled:
//	USER CONFIGURATION SECTION
//
// VERSION HISTORY:
//	1.11	- Added: editActionMap("playMap.sae"); to prevent config.cs
//                problems.
//
//	1.1	- Added more options for crouching and zooming with and
//		  without Laser rifle
//
//////////////////////////////////////////////////////////////////////////////                                                      

// Don't edit the following line
editActionMap("playMap.sae");
                                                               
//////////////////////////////////////////////////////////////////////////////
//////////////////////// USER CONFIGURATION SECTION //////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// ------------------------------ Zoom/Snipe Key -----------------------------
//                                                                 
// The key that will change your weapon to Laser Rifle, zoom in and,
// optionally, make you crouch.
// The default is bound to the left shift key
bindCommand(keyboard0, make, "lshift", TO, "z0ddzoomsnipe::doSnipe();");
bindCommand(keyboard0, break, "lshift", TO, "z0ddzoomsnipe::unDoSnipe();");


// ----------------------- Previous Weapon Auto-Switch -----------------------
//                          
// Set this to 1 if you want to automatically switch back to the weapon you
// were holding prior to pressing the "snipe" key
//
// Set this to 0 to turn off Previous weapon Auto-Switching
$z0ddzoomsnipe::switchBackToWpn = 1;
                                    
                                    
// ---------------------------- Crouch Options -------------------------------
//                          
// Set this to 1 if you want to automatically crouch when you press the
// Zoom/Snipe key.
//
// Set this to 0 to turn off auto-crouching
$z0ddzoomsnipe::autoCrouch = 0;
                          
// Set this to 1 if you want to crouch when you press the Zoom/Snipe
// key when you don't have the Laser Rifle.
//
// Set this to 0 to if you don't want to crouch when you don't have the
// Laser Rifle
//
// Note: This setting is meaningless if you have auto-crouching turned off.
$z0ddzoomsnipe::crouchWithoutRifle = 1;


// --------------------------- Always zoom option ----------------------------
//                          
// Set this to 1 if you want the Zoom/Snipe key to zoom in EVERY time you
// press it regardless of whether or not you have the Laser Rifle.
//
// Set this to 0 to only zoom in if you have the Laser Rifle.
$z0ddzoomsnipe::alwaysZoom = 1;
//////////////////////////////////////////////////////////////////////////////
///////////////////// END OF USER CONFIGURATION SECTION //////////////////////
//////////////////////////////////////////////////////////////////////////////

                                                                
//////////////////////////////////////////////////////////////////////////////
//  SCRIPT SECTION. DON'T EDIT PAST THIS LINE UNLESS YOU WHAT YOU'RE DOING  //
//////////////////////////////////////////////////////////////////////////////
function z0ddzoomsnipe::getCurrentWpn()
{
	%wpn = getMountedItem(0);

	if (%wpn == 21)
		return "Disc Launcher";
	else if (%wpn == 11)
		return "Blaster";
	else if (%wpn == 13)
		return "Chaingun";
	else if (%wpn == 15)
		return "Plasma Gun";
	else if (%wpn == 17)
		return "Grenade Launcher";
	else if (%wpn == 24)
		return "ELF Gun";
	else if (%wpn == 23)
		return "Targeting Laser";
	else
		return "";
}

   
function z0ddzoomsnipe::doSnipe()
{
	if(getItemCount("Laser Rifle")) {
		$z0ddzoomsnipe::ownsLR = 1;		
		if($z0ddzoomsnipe::autoCrouch)
			postAction(2048, IDACTION_CROUCH, 1);
		if($z0ddzoomsnipe::switchBackToWpn)
			$z0ddzoomsnipe::prevWpn = z0ddzoomsnipe::getCurrentWpn();
		use("Laser Rifle");
		postAction(2048, IDACTION_SNIPER_FOV, 1.000000);
	} 
	else {
		if($z0ddzoomsnipe::alwaysZoom)
			postAction(2048, IDACTION_SNIPER_FOV, 1.000000);
		if($z0ddzoomsnipe::autoCrouch && $z0ddzoomsnipe::crouchWithoutRifle)
			postAction(2048, IDACTION_CROUCH, 1);
		$z0ddzoomsnipe::ownsLR = 0;
	}
}
 
function z0ddzoomsnipe::unDoSnipe()
{
	postAction(2048, IDACTION_SNIPER_FOV, 0.000000);
	postAction(2048, IDACTION_STAND, 1);	
	if($z0ddzoomsnipe::ownsLR) {
		if($z0ddzoomsnipe::switchBackToWpn)
			use($z0ddzoomsnipe::prevWpn);
	}
}
