// FILE:		z0dd_ski.cs
// VERSION:		1.0
// DATE:		3/17/00
// AUTHOR:		Paul "z0dd" Paella
// EMAIL:		z0dd@adelphia.net
// WEBPAGE:		http://home.adelphia.net/~z0dd/
// CREDITS:		Based on work from Writer
//			(http://www.planetstarsiege.com/lorne/)
//
// DESCRIPTION:
//	So you want to ski like the pros?  Here is your ticket.
//	Simply hold down the ski key (default is spacebar) and
//	you'll qualify for the olympic skiing team!
//
// INSTALLATION:
//	Put z0dd_ski.cs into your:
//		...\tribes\config
// 	directory and insert this line into your autoexec.cs:
//		exec("z0dd_ski.cs");
//
// NOTES:
//      Sorry, I will NOT offer any help getting this script to work
//      or assisting you in tweaking it for your computer. This script
//      has the potential to slow down "weaker" computers.
//
// 	This script is configured by editing the area labeled:
//	USER CONFIGURATION SECTION
//                            
//      Default ski key is set to "spacebar".
//
// Don't edit the line below
EditActionMap("playMap.sae");                                                       

                                                               
//////////////////////////////////////////////////////////////////////////////
//////////////////////// USER CONFIGURATION SECTION //////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// --------------------------------- Ski Key ---------------------------------
//                                                                 
// The key you use to jump.  The default is the spacebar.
bindCommand(keyboard0, make, "space", TO, "z0ddski::ski(1);");
bindCommand(keyboard0, break, "space", TO, "z0ddski::ski(0);");

//
// -------------------------------- Ski Delay --------------------------------
//                                                                 
// This number is the time delay between successive jumps when you're holding
// down the Ski Key.  The default is set to 0.001.
// You only need to modify this value if tribes gets slow after installing
// this script.  Increase this vlaue by small amounts (such as 0.01) until
// you're happy with the performance of Tribe and your skiing.
// The higher you make this value the worse your skiing will be. 
$z0ddski::skiDelay = 0.001;
//////////////////////////////////////////////////////////////////////////////
///////////////////// END OF USER CONFIGURATION SECTION //////////////////////
//////////////////////////////////////////////////////////////////////////////

                                                                
//////////////////////////////////////////////////////////////////////////////
//  SCRIPT SECTION. DON'T EDIT PAST THIS LINE UNLESS YOU WHAT YOU'RE DOING  //
//////////////////////////////////////////////////////////////////////////////    

//
// Called when client presses/holds ski/jump key and when client releases it
//
function z0ddski::ski(%activate)
{
	// Ski Key Pressed 
	if(%activate) { 
		if(!$z0ddski::jumping) {
			// We aren't jumping yet, so start jumping now       	
			$z0ddski::jumping = 1;
	        	z0ddski::keepJumping();
		}
	}
	else // Ski Key released	
		$z0ddski::jumping = 0;
}


//
// Keep jumping while a key is held down
//
function z0ddski::keepJumping()
{
	if($z0ddski::jumping)
	{
		postAction(2048, IDACTION_MOVEUP, -0);
	    	schedule("z0ddski::keepJumping();", $z0ddski::skiDelay);
	}
}
