// FILE:		z0dd_spew.cs
// VERSION:		1.11
// DATE:		1/20/01
// AUTHOR:		Paul "z0dd" Paella
// EMAIL:		z0dd@adelphia.net
// WEBPAGE:		http://home.adelphia.net/~z0dd/
//
// DESCRIPTION:
//	Allows clients to quickly toss items from Inventory Stations.
// 	There are 3 different spewing modes:
//      	1) cycle
//		2) cluster
//		3) single
//
//	The default configuration assigns the following keys:
//	F9:  (Single mode) Spews 4 turrets.  Does NOT purchase one of your
//	     favorites.
//	F11: (Cycle mode) First time this will spew 2 Repair packs.  Second
//	     time, 4 Inventory Stations.  Third time, 6 turrets.  Fourth time
//	     will bring you back to spewing 2 Repair Packs, ... and so on.
//	     Your Favorite #1 will be purchased after the items are spewed.
//	F12: (Cluster mode) 2 Repair Packs, 4 Inventory Stations, and 6
//	     Turrets will be spewed every time this key is pressed.
//	     Your Favorite #1 will be purchased after all the items are
//	     spewed.
//
// 	When you press the cycle spew key, you'll spew an item a number of
//	times equal to the number in $z0ddspew::cycleCount.
//	The script will then rotate the spewed item to the next one in the
//	list (see below on how to configure this list). The next time you
//	press the cycle spew key you'll spew the next item in the list.
//	When you get to the last item in the list, the next item spewed
//	will be the first item in the list.
// 	This mode is used to make seperate piles of items.
//
// 	Pressing the cluster spew key spews every designated item a
//	number of times equal to the number in the z0ddspew::clusterCount
//      variable. 
//
//	The third mode, single, allows you to bind any number of specific keys
//	to spew a specified number of a speciified item.  For instance, you
//	can bind the 'x' key to spew 7 repair packs every time you press it.
//	You could also bind the 'k' key to spew 3 turrets every time you
//	press 'k'.  You can bind any number of these "single spew" keys.
//
// 	This script is configured by editing the area labeled:
//	USER CONFIGURATION SECTION
//	This script can be considered difficult to configure.  I've
//	tried to make the documentation as clear as possible.  Email me
//	with any configuration questions you have.
//
//
// Version history:
//
//	1.11	- Added: editActionMap("playMap.sae"); to prevent config.cs
//                problems.
//	1.0	- Initial version.
//
//
// INSTALLATION:
//	Put z0dd_spew.cs into your:
//		...\tribes\config
// 	directory and insert this line into your autoexec.cs:
//		exec("z0dd_spew.cs");
//
// NOTES:
//	This script doesn't require Presto Pack and will not conflict with it.
//

// Don't edit the following line
editActionMap("playMap.sae");

////////////////////////////////////////////////////////////////////////////
//////////////////////// USER CONFIGURATION SECTION ////////////////////////
////////////////////////////////////////////////////////////////////////////
//
// ------------------------ cycle spew config area -------------------------
//
// The key that activates the cycle spewing. By default, it's bound to F11.
// The number after "cycle" (the #1) is the favorites choice you want to
// leave the station with. Use -1 if you don't want a favorite selected
// uopn leaving.
//bindCommand(keyboard0, make, control, "f11", TO, "z0ddspew::dump(cycle, 1);");
//bindCommand(keyboard0, break, control, "f11", TO, "");



// ----------------------- cluster spew config area ------------------------
//
// The key that activates the cluster spewing. By default, it's bound to F12.
// The number after "cluster" (the #1) is the favorites choice you want to
// leave the station with. Use -1 if you don't want a favorite selected
// upon leaving.
//bindCommand(keyboard0, make, control, "f12", TO, "z0ddspew::dump(cluster, 1);");    
//bindCommand(keyboard0, break, control, "f12", TO, "");                             



// --------------------- cycle & cluster config area -----------------------
//
// The following lines turn on the items that'll be used for the cycle and
// cluster modes.
// Uncomment the line under the CAPITLAIZED item name for the items you want
// to spew. Uncommenting means removing the // characters from the begining
// of the line.
// Specifiy the quantity you want spewed (for each uncommented line) by
// adjusting the number at the end of the line, the number before ;.
// By default, it's set to spew 2 Repairs Packs and 3 Inventory Stations.
//
// BLASTER
// $z++; $z0ddspew::item[$z] = "Blaster"; $z0ddspew::item[$z, $z] = 1;
//
// CHAINGUN
// $z++; $z0ddspew::item[$z] = "Chaingun"; $z0ddspew::item[$z, $z] = 1;
// 
// PLASMA GUN
// $z++; $z0ddspew::item[$z] = "Plasma Gun"; $z0ddspew::item[$z, $z] = 1;
// 
// GREANDE LAUNCHER
// $z++; $z0ddspew::item[$z] = "Grenade Launcher"; $z0ddspew::item[$z, $z] = 1;
// 
// MORTAR
// $z++; $z0ddspew::item[$z] = "Mortar"; $z0ddspew::item[$z, $z] = 1;
// 
// DISC LAUNCHER
// $z++; $z0ddspew::item[$z] = "Disc Launcher"; $z0ddspew::item[$z, $z] = 1;
// 
// LASER RIFLE
// $z++; $z0ddspew::item[$z] = "Laser Rifle"; $z0ddspew::item[$z, $z] = 1;
// 
// TARGETING LASER
// $z++; $z0ddspew::item[$z] = "Targeting Laser"; $z0ddspew::item[$z, $z] = 1;
// 
// ELF
// $z++; $z0ddspew::item[$z] = "ELF Gun"; $z0ddspew::item[$z, $z] = 1;
// 
// ENERGY PACK
//$z++; $z0ddspew::item[$z] = "Energy Pack"; $z0ddspew::item[$z, $z] = 3;
// 
// REPAIR PACK
$z++; $z0ddspew::item[$z] = "Repair Pack"; $z0ddspew::item[$z, $z] = 2;
// 
// SHIELD PACK
// $z++; $z0ddspew::item[$z] = "Shield Pack"; $z0ddspew::item[$z, $z] = 1;
// 
// SENSOR JAMMER PACK
// $z++; $z0ddspew::item[$z] = "Sensor Jammer Pack"; $z0ddspew::item[$z, $z] = 1;
// 
// AMMO PACK
// $z++; $z0ddspew::item[$z] = "Ammo Pack"; $z0ddspew::item[$z, $z] = 1;
// 
// INVENTORY STATION
//$z++; $z0ddspew::item[$z] = "Inventory Station"; $z0ddspew::item[$z, $z] = 3;
// 
// AMMO STATION
// $z++; $z0ddspew::item[$z] = "Ammo Station"; $z0ddspew::item[$z, $z] = 1;
// 
// MOTION SENSOR
// $z++; $z0ddspew::item[$z] = "Motion Sensor"; $z0ddspew::item[$z, $z] = 1;
// 
// PULSE SENSOR
// $z++; $z0ddspew::item[$z] = "Pulse Sensor"; $z0ddspew::item[$z, $z] = 1;
// 
// SENSOR JAMMER
// $z++; $z0ddspew::item[$z] = "Sensor Jammer"; $z0ddspew::item[$z, $z] = 1;
// 
// CAMERA
// $z++; $z0ddspew::item[$z] = "Camera"; $z0ddspew::item[$z, $z] = 1;
// 
// TURRET
// $z++; $z0ddspew::item[$z] = "Turret"; $z0ddspew::item[$z, $z] = 6;
// 
// REPAIR KIT
// $z++; $z0ddspew::item[$z] = "Repair Kit"; $z0ddspew::item[$z, $z] = 1;
// 
// MINE
// $z++; $z0ddspew::item[$z] = "Mine"; $z0ddspew::item[$z, $z] = 1;
// 
// HAND GRENADE
// $z++; $z0ddspew::item[$z] = "Grenade"; $z0ddspew::item[$z, $z] = 1;
// 
// BEACON
// $z++; $z0ddspew::item[$z] = "Beacon"; $z0ddspew::item[$z, $z] = 1;



// ----------------------- single spew config area -------------------------
//
// This is where you'll configure the keys for single spew mode.
// By default, it's bound to F9.
// The binding below will spew 4 turrets every time you press the f9 key.
bindCommand(keyboard0, make, "f7", TO, "z0ddspew::dump(single, -1, \"repair kit\", 10);");
bindCommand(keyboard0, break, "f7", TO, "");

bindCommand(keyboard0, make, "f8", TO, "z0ddspew::dump(single, -1, \"mine\", 12);");
bindCommand(keyboard0, break, "f8", TO, "");

bindCommand(keyboard0, make, "f9", TO, "z0ddspew::dump(single, -1, \"turret\", 4);");
bindCommand(keyboard0, break, "f9", TO, "");

bindCommand(keyboard0, make, "f11", TO, "z0ddspew::dump(single, -1, \"pulse sensor\", 12);");
bindCommand(keyboard0, break, "f11", TO, "");

bindCommand(keyboard0, make, "f12", TO, "z0ddspew::dump(single, -1, \"inventory station\", 4);");
bindCommand(keyboard0, break, "f12", TO, "");


// ignore the next 9 lines
//bindCommand(keyboard0, make, "f11", TO, "z0ddspew::MultipleDumps(\"repair kit\", 18, \"pulse sensor\", 12);");
//bindCommand(keyboard0, break, "f11", TO, "");

//function z0ddspew::MultipleDumps(%item1, %count1, %item2, %count2, %item3, %count3)
//{
//	z0ddspew::dump(single, -1, %item1, %count1);
//	z0ddspew::dump(single, -1, %item2, %count2);
//	z0ddspew::dump(single, -1, %item3, %count3);
//}





// To make another single spew key binding, copy the above two lines and
// paste them in this USER CONFIGURATION SECTION area.
// Edit these two new lines by replacing the string "turret" (no quotes) with
// whatever you want to spew.  Also, change the number 4 to the number of this
// item you'd like to spew. The number before \"turret\", is the favorites
// choice you want to leave the station with. Use -1 if you don't want a
// favorite selected upon leaving; which I have here for this binding.
//
// Here's a list of the items you can spew (these replace the string: turret):
// ammo pack
// ammo station
// beacon
// blaster
// camera
// chaingun
// disc launcher
// elf gun
// energy pack
// grenade
// grenade launcher
// inventory station
// laser rifle
// mine
// mortar
// motion sensor
// plasma gun
// pulse sensor
// repair kit
// repair pack
// sensor jammer
// sensor jammer pack
// shield pack
// targeting laser
// turret
//////////////////////////////////////////////////////////////////////////////
///////////////////// END OF USER CONFIGURATION SECTION //////////////////////
//////////////////////////////////////////////////////////////////////////////

                                                                
//////////////////////////////////////////////////////////////////////////////
//  SCRIPT SECTION. DON'T EDIT PAST THIS LINE UNLESS YOU WHAT YOU'RE DOING  //
//////////////////////////////////////////////////////////////////////////////
if ($z != "")
	$z0ddspew::cycleSpot = 1;  // keeps track of where in the list we are at in cycle spew mode


function z0ddspew::drop(%item, %quantity)
{
	for(%cnt = 0; %cnt < %quantity; %cnt++)
	{
  		buy(%item);
		drop(%item);
	}
}


function z0ddspew::cluster()
{
	for(%cnt = 1; $z0ddspew::item[%cnt] != ""; %cnt++)
	{
		if($z0ddspew::item[%cnt] == "Laser Rifle")
			buy("Light Armor");

		z0ddspew::drop($z0ddspew::item[%cnt], $z0ddspew::item[%cnt, %cnt]);

		if($z0ddspew::item[%cnt] == "Laser Rifle")
			buy("Heavy Armor");		
	}	
}


function z0ddspew::cycle()
{
	if($z0ddspew::item[$z0ddspew::cycleSpot] == "Laser Rifle")
		buy("Light Armor");

	z0ddspew::drop($z0ddspew::item[$z0ddspew::cycleSpot], 
                       $z0ddspew::item[$z0ddspew::cycleSpot, $z0ddspew::cycleSpot]);
	
	if(getItemCount("Light Armor"))
		buy("Heavy Armor");	

	$z0ddspew::cycleSpot = ($z0ddspew::cycleSpot % $z);  // range is 0 to $z-1
	$z0ddspew::cycleSpot++;  // compentsate for starting at 1 instead of 0
}
                                  
                                  
function z0ddspew::freeSlots()
{
	if(getItemCount("Light Armor"))
		$z0ddspew::lastArmor = "Light Armor";
	else if(getItemCount("Medium Armor"))
		$z0ddspew::lastArmor = "Medium Armor";
	else
		$z0ddspew::lastArmor = "Heavy Armor";
                                
	if(getItemCount("Blaster"))
	{
		sell("Blaster");
		$z0ddspew::freedWpn = "Blaster";
	}
	else if(getItemCount("Chaingun"))
	{
		sell("Chaingun");
		$z0ddspew::freedWpn = "Chaingun";
	}
	else if(getItemCount("Disc Launcher"))
	{
		sell("Disc Launcher");
		$z0ddspew::freedWpn = "Disc Launcher";
	}
	else if(getItemCount("Plasma Gun"))
	{
		sell("Plasma Gun");
		$z0ddspew::freedWpn = "Plasma Gun";
	}
	else if(getItemCount("Grenade Launcher"))
	{
		sell("Grenade Launcher");
		$z0ddspew::freedWpn = "Grenade Launcher";
	}
	else
		$z0ddspew::freedWpn = "";
	// no armor can possibly have all their weapon slots full if one of the above conditions isn't met

	// needed because buying Hvy armor causes you to sell Laser Rifle
	$z0ddspew::laserRifleOwned = getItemCount("Laser Rifle");
	buy("Heavy Armor");  // needed to buy all of the possible items	
}


function z0ddspew::trackItems()
{
	if(getItemCount("energy pack")) 
	{
		$z0ddspew::freedPack = "energy pack";
		return;
	}

	if(getItemCount("shield pack"))
	{
		$z0ddspew::freedPack = "shield pack";
		return;
	}

	if(getItemCount("repair pack"))
	{
		$z0ddspew::freedPack = "repair pack";
		return;
	}

	if(getItemCount("turret"))
	{
		$z0ddspew::freedPack = "turret";
		return;
	}

	if(getItemCount("inventory station"))
	{
		$z0ddspew::freedPack = "inventory station";
		return;
	}

	if(getItemCount("ammo pack"))
	{
		$z0ddspew::freedPack = "ammo pack";
		return;
	}

	if(getItemCount("ammo station"))
	{
		$z0ddspew::freedPack = "ammo station";
		return;
	}

	if(getItemCount("camera"))
	{
		$z0ddspew::freedPack = "camera";
		return;
	}

	if(getItemCount("motion sensor"))
	{
		$z0ddspew::freedPack = "motion sensor";
		return;
	}

	if(getItemCount("pulse sensor"))
	{
		$z0ddspew::freedPack = "pulse sensor";
		return;
	}

	if(getItemCount("sensor jammer"))
	{
		$z0ddspew::freedPack = "sensor jammer";
		return;
	}

	if(getItemCount("sensor jammer pack"))
	{
		$z0ddspew::freedPack = "sensor jammer pack";
		return;
	}

	$z0ddspew::freedPack = "";
}
                       
                       
// Restore armor client entered station with.
// Restore pack client entered station with, if any
// Restore weapon client entered station with, if any
//
// Restore LaserRifle if client entered station with it.  Rifle was dumped
// when Hvy armor was purchased in z0ddspew::freeSlots()
function z0ddspew::restoreItems()
{
	buy($z0ddspew::lastArmor);
	if ($z0ddspew::freedPack != "")
		buy($z0ddspew::freedPack);
	if ($z0ddspew::freedWpn != "")
		buy($z0ddspew::freedWpn);
	if($z0ddspew::laserRifleOwned)
		buy("Laser Rifle");	
}

        
function z0ddspew::dump(%option, %fav, %item, %quantity)
{
	// If user opted not to buy a favorite, keep track of what he had when
	// entering station
	if(%fav == -1)
		z0ddspew::trackItems();
	                         
	// ensure there is at least one weapon slot free and client is in hvy armor
	z0ddspew::freeSlots();

        if(%option == cycle)
        	z0ddspew::cycle();
        else if(%option == cluster)
        	z0ddspew::cluster();
        else if(%option == single)
        	z0ddspew::drop(%item, %quantity);

	if(%fav == -1)
		z0ddspew::restoreItems();
	else
		CmdInventoryGui::buyFavorites(%fav);
}
