// FILE:		z0dd_thrower.cs
// VERSION:		1.3
// DATE:		1/13/2001
// AUTHOR:		Paul "z0dd" Paella
// EMAIL:		z0dd@adelphia.net
// WEBPAGE:		http://home.adelphia.net/~z0dd/
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////// DESCRIPTION: ////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	Press one key to toggle the throwing of all your grenades and/or mines.
//	You can customize this script to throw just mines, just grenades, or
//	both. If both, you can interleave the throwing of grenades and mines
//	or you can throw all grenades then all mines. There's also a key that
//	lets you switch between throwing them close to you and as throwing
//	them as far as possible.
//  	This is a complete rewrite of my z0dd_deathtoss.cs script.
//
//////////////////////////////////////////////////////////////////////////////
////////////////////////////// VERSION HISTORY: //////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	1.3	- Changed the script messages to print in the bottom middle
//		  of the screen instead of bottom left.
//
//	1.1	- Cleaned up the centerprint messaging code
//
//	1.0	- Complete rewrite of my z0dd_deathtoss.cs script.
//
//////////////////////////////////////////////////////////////////////////////
/////////////////////////////// INSTALLATION: ////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	Put z0dd_thrower.cs into your:
//		...\tribes\config
// 	directory and insert this line into your autoexec.cs:
//		exec("z0dd_thrower.cs");
//
//	Default Keys:
//		CAPSLOCK  : Turns the throwing and and off.
//		CONTROL+t : Toggles between close and far throw ranges.
//	Default settings:
//		The default setup for this script is set to only toss grenades
//		and tosses them as far as possible. You can change the default
//		setup by editing the area: USER CONFIGURATION SECTION
//
// 	This script is configured by editing the area labeled:
//	USER CONFIGURATION SECTION
//
//////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// NOTES: ///////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
//	1) This script doesn't require Presto and will not conflict with it.
//
//
// Do NOT edit the following line
editActionMap("playMap.sae");
//
//
//////////////////////////////////////////////////////////////////////////////
///////////////////////// USER CONFIGURATION SECTION /////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// THROW KEY
// The key that activates the throwing.
// Default is CAPSLOCK
bindCommand(keyboard0, make, "capslock", TO, "z0ddthrower::Thrower();");
bindCommand(keyboard0, break, "capslock", TO, "");


// THROW GRENADES OPTION
// 1: You want to throw hand grenades
// 0: You dont want to throw hand grenades
$z0ddthrower::ThrowGrens = 1;

// THROW MINES OPTION
// 1: You want to throw mines
// 0: You dont want to throw mines
$z0ddthrower::ThrowMines = 0;

// THROW GRENADES OR MINES FIRST OPTION
// If you're throwing both grenades and mines, set this to 'grenade'
// (no qoutes) if you want to throw grenades before mines. Set it to 'mine'
// (no qoutes) if you want to throw mines before grenades.
// This setting is only applicable if both the $z0ddthrower::ThrowGrens AND
// $z0ddthrower::ThrowMines options are set to 1. But, you still need to
// set this to 'mine' or 'grenade' if you only have one of of the above
// two options set to 1 ($z0ddthrower::ThrowGrens OR
// $z0ddthrower::Throwmines set to 1)
// If interleaving is on this will decide which item will be thrown first.
// grenade: mines are thrown first, then grenades
// mine: grenades are thrown first, then mines
$z0ddthrower::FirstItem = grenade;

// INTERLEAVING OPTION
// Set to 1 if you're throwing both grens and mines and you want to interleave
// the mine and grenade throwing. 
// This setting is only applicable if both the $z0ddthrower::ThrowGrens and
// $z0ddthrower::ThrowMines options are set to 1.
// 1: mine & gren throwing is alternated. 1 mine, 1 gren, 1 mine, 1 gren, etc.
// 0: all of the first items are thrown then all of the other items are
//    thrown. The 1st item is specified in the $z0ddthrower::FirstItem option.
$z0ddthrower::Interleave = 0;

// FAR THROW OPTION
// Far throwing throws the items as far as possible.
// Set to 1 if you want to start game with far throwing on
// Set to 0 if you want to start game with far throwing off
$z0ddthrower::FarThrow = 1;

// FAR RANGE TOGGLE KEY
// The key to toggle "far throwing" on and off.
// Default key is 'CONTROL+t'
bindCommand(keyboard0, make, control, "t", TO, "z0ddthrower::ToggleFarThrow();");
bindCommand(keyboard0, break, control, "t", TO, "");


//////////////////////////////////////////////////////////////////////////////
// DON'T EDIT PAST HERE UNLESS YOU'RE A SCRIPTER AND KNOW WHAT YOU'RE DOING //
//////////////////////////////////////////////////////////////////////////////
function z0ddthrower::Init()
{
	if ($z0ddthrower::FarThrow)
		$z0ddthrower::ThrowTime  = 100;
	else
		$z0ddthrower::ThrowTime  = 0;
	
	// ensure user typed in valid options
	$z0ddthrower::on = (($z0ddthrower::FirstItem == grenade) && $z0ddthrower::ThrowGrens) || 
			(($z0ddthrower::FirstItem == mine) && $z0ddthrower::ThrowMines);

	$z0ddthrower::TossOrder[0] = $z0ddthrower::FirstItem;

	// set up throw order
	if($z0ddthrower::ThrowGrens && $z0ddthrower::ThrowMines) {
		if($z0ddthrower::FirstItem == grenade)
			$z0ddthrower::TossOrder[1] = mine;
		else
			$z0ddthrower::TossOrder[1] = grenade;
	}
	else {
		$z0ddthrower::TossOrder[1] = $z0ddthrower::FirstItem;
	}
	
	// initialize thrownow
	$z0ddthrower::ThrowNow = 0;
}

z0ddthrower::Init();

function z0ddthrower::ToggleCurrentItemIndex()
{
	$z0ddthrower::CurrentItemIndex = !$z0ddthrower::CurrentItemIndex;
}

/////////////////////////////////////////////////////////////////////////////////////////
// controls how long msgs are displayed
/////////////////////////////////////////////////////////////////////////////////////////                         
function z0ddthrower::TurnOffCP()
{
	$z0dd::CenterPrintCounter--;
	if(!$z0dd::CenterPrintCounter)
		Client::centerPrint("", 1);
}

function z0ddthrower::ToggleFarThrow()
{
	if ($z0ddthrower::FarThrow) {
		$z0ddthrower::ThrowTime  = 0;
		$z0ddthrower::FarThrow = 0;
		Client::centerPrint("<jc>Far throwing is OFF", 1);
	}
	else {
		$z0ddthrower::ThrowTime  = 100;
		$z0ddthrower::FarThrow = 1;
		Client::centerPrint("<jc>Far throwing is ON", 1);
 	}
	$z0dd::CenterPrintCounter++;
	schedule("z0ddthrower::TurnOffCP();", 2);
}

function z0ddthrower::Throw(%item)
{
	if(!$z0ddthrower::ThrowNow)
		return;

	// if we dont have any of current item
	if(!getItemCount($z0ddthrower::TossOrder[$z0ddthrower::CurrentItemIndex])) {
		// check to see if we are also out of other item
		z0ddthrower::ToggleCurrentItemIndex();
		// if we dont have any of other item
		if(!getItemCount($z0ddthrower::TossOrder[$z0ddthrower::CurrentItemIndex])) {
			$z0ddthrower::ThrowNow = 0;
			return;
		}
	}

	remoteEval(2048, throwItem, getItemType($z0ddthrower::TossOrder[$z0ddthrower::CurrentItemIndex]), $z0ddthrower::ThrowTime);
	if($z0ddthrower::Interleave)
		z0ddthrower::ToggleCurrentItemIndex();
	schedule("z0ddthrower::Throw();", 0.6);
}

function z0ddthrower::Thrower()
{
	// if we turned of throwing because of user config error
	if(!$z0ddthrower::on)
 		return;

	// if thrower is on, turn it off
	if($z0ddthrower::ThrowNow)
		$z0ddthrower::ThrowNow = 0;
	else {
		// restore first item thrown
		$z0ddthrower::CurrentItemIndex = 0;
		
		$z0ddthrower::ThrowNow = 1;
		z0ddthrower::Throw();
	}
}

//	echo(getItemType("Grenade"));  THIS EQUATES TO 41
//	echo(getItemType("Mine"));     THIS EQUATES TO 40
