// Weapon/Pack Change Events v1.0
// {FSC}Rayn -PTT- // rayn@planet-tribes.com
// June 16, 1999
// ------------------------------------------------------------------------------------
// VISIT WWW.PLANET-TRIBES.COM 
// the premier Tribes online resource for news, tactics, and more
// -------------------------------------------------------------------------------------
// Usage:  Triggers an eventPackChange when the player switches backpacks and
// a eventWeaponChange when the player switches weapons.  Checks for this
// occurence once every second. 
//
// EVENT:
// eventWeaponChange
// PARAMETERS:
// triggedFunction(current weapon id, previous weapon id)
//
// EVENT
// eventPackChange
// PARAMETERS:
// triggeredFunction(current pack id, previous pack id)
// EXAMPLE:
// If you switch from disc launcher (let's say the id is 13), to the plasma gun (let's
// say the id is 17) your function would be called as such:
// yourFunction(17, 13) { 
//
// Feedback, comments, bug reports to rayn@planet-tribes.com

Include("presto\\Event.cs");

Event::Attach(eventConnected, "switch::checkMounted");


$switch::lastWeapon = "-1";
$switch::lastPack = "-1";


function switch::checkMounted() {
	%wep = getMountedItem(0);	
	%pak = getMountedItem(1);
	
	if (%wep != $switch::lastWeapon) {
		Event::Trigger(eventWeaponChange, %wep, $switch::lastWeapon);
		$switch::lastWeapon = %wep;
	}		
	
	if (%pak != $switch::lastPack) {
		Event::Trigger(eventPackChange, %pak, $switch::lastPack);
		$switch::lastPack = %pak; 
	}			

	schedule("switch::CheckMounted();",1);
}

switch::checkMounted();