// AMMOHUD v1.2.1
// By Rayn (rayn@planet-tribes.com)
// ==============================================================================
// 				VISIT WWW.PLANET-TRIBES.COM
// ===============================================================================
// Thank you for downloading AmmoHUD.  What ammoHud will do is display a meter,
// that is by default placed under your energy bar, representing the percentage
// of ammo you have remaining.  Yes, I know you have a counter on your screen already,
// but what I do is disable the default counter and turn on the ammo count portion 
// of the HUD.  Preferences are below and are explained.  
// Please note the following:
//
// Requires: 
// PrestoPack v0.93 or better  (http://www.planetstarsiege.com/presto)
// Writer's Scripts (included) (http://www.planetstarsiege.com/lorne)
//
// If your fire button is anything other than the left mouse button you will have to
// set it in Writer's keys.cs or in \ammohud\writer\fire.cs otherwise the program will
// not work. 
// -------------------------------------------------------------------------------
// PLEASE SEND ME YOUR FEEDBACK/SUGGESTIONS/ETC: Rayn@planet-tribes.com
// -------------------------------------------------------------------------------
// Thanks to Writer and Presto for the scripts I used to support this and thanks
// go out to the scripting community as a whole for ideas and support!
// -------------------------------------------------------------------------------
// KNOWN ISSUES:
// - Some players who have already installed fire.cs from Writer report that
// other scripts ceased to function.  I've attempted to correct this issue.
// -Report found bugs to me @ rayn@planet-tribes.com
// UPCOMING FEATURES:
// Send me your ideas!
// -------------------------------------------------------------------------------
// Preferences:
// Set these to customize the HUD.
// ===============================================================================
// Toggle key - toggles the HUD on and off. Default "alt, l" .. set to something no yet bound? ;)
//
bindCommand(keyboard0, make, alt, "l" , TO, "ammohud::Toggle();");
bindCommand(keyboard0, break, alt, "l", TO, "");

// Position (X) of upper left corner of the HUD.  Default is 0.
// Using (0,62) Will place the HUD below your energy bar default area.

$ammohud::X = "0";
// Position (Y) of upper left corner of the HUD. Default is 62.
// Using (0, 62) will place the HUD below your energy bar default area.

$ammohud::Y = "62";
// Width of the HUD. Default is 121 pixels.  Changing this may provide a slightly
// not so neat bar, as the scaling of characters is not precise. 121 is fine for me.
// Any smaller is not recommended. Its much less accurate.

$ammohud::widthX = "121";

// It was requested that the option to actually not show the meter be added, thus here it is.
// The meter doesn't actually dissapear because I need it to base all the other HUDS on,
// but it is made tiny so you can't notice it. Default is true, you should probably keep
// it that way.

$ammohud::showMeter = "true";

// Show notches on the bar (every 25% of the meter). Default is true.  Set to false
// to get rid of the notches.

$ammohud::NotchesOn = "true";

// Set notches to top or bottom of the HUD. Default is "bottom", you can set to "top"
// if you like.

$ammohud::NotchPos = "bottom";

// Size of the notches. Default is 5. Bigger values = longer notches. They appear every 25%
// of the meter

$ammohud::NotchHeight = "5";

// Display a message when you are low on ammo? Default is "true". If you don't want the message,
// set to false. 

$ammohud::warnLowAmmo = "true";

// Percent of ammo remaining that triggers warning message.  Default is "10" as in 10%, i.e
// when you reach 10% of your ammo or lower it will warn you (once, it will not warn again until you
// change weapons or rise above the warning %),.

$ammohud::warningLevel = "10";

// Amount of time to display warning level for, 1.5 is default, its fairly quick.

$ammohud::warningTime = "1.5";

// Set the location of the warning message display in percentage of the screen from the top
// Default is 100 (Bottom) but it was interfering with TeamHUD.  Default is now 80.  Set
// as you wish.

$ammohud::warningPos = "80";

// Show Ammo Count HUD. Default is true, setting this to true will add a little HUD on the
// left or right of your ammo meter displaying available rounds or INF for unlimited ammo weapons.
// Utilizes a slight bit more CPU if set to true. False just gets rid of it.

$ammohud::showAmmoCount = "true";

// Set position of Ammo Count HUD. Default is right, setting this to left will move it to
// the other side of the meter.  the GFX hud goes on the opposite side,
// if enabled.

$ammohud::countPosition = "right";
// Shows a small picture of your currently equipped weapon next to your
// ammo bar. Set to true to keep it, false to ditch it.

$ammohud::showGFX = "true";

// Position of the GFX hud (left or right)

$ammohud::GFXpos = "left";


// Use this based on your connection to set delay for checking ammo.  Slower connections
// don't register your ammo being gone fast enough.  1.2 is good for a ping of around 300.
// Adjust based on that, if your ammo meter isn't keeping pace with you experiment and set
// it higher. If it seems to slow you can set it lower.

$ammohud::pingq = "1.2";

// Enable Renegade's support?  The advantage to disabling it is that it will use
// slightly less memory.  So if you don't play renegades and this is an issue 
// set it to false.  Default is true.

$ammohud::enableRenegade = "true";

// ==================================================================================
// END PREFERENCES -- BEGIN CODE!!
// ==================================================================================

Include("presto\\Event.cs");
Include("presto\\HUD.cs");
exec("rayn\\switchEvents.cs");
include("rayn\\writer\\fire.cs",flat);
include("rayn\\writer\\inventory_table.cs");


Event::Attach(eventWeaponFired,"ammohud::startFiring");
Event::Attach(eventResupplyAmmo, "ammohud::updateAmmo");
Event::Attach(eventPickup, "ammohud::pickup");
Event::Attach(eventInventoryOut, "ammohud::updateAmmo");
Event::Attach(eventClientMessage, "ammohud::checkMessage");
Event::Attach(eventFireReleased, "Ammohud::stopFiring");
Event::Attach(eventNoAmmo, "ammohud::emptygun");
Event::Attach(eventWeaponChange, "ammohud::handleWeaponChange");
Event::Attach(eventPackChange, "ammohud::handlePackChange");
Event::Attach(eventInventoryTableReady, "ammohud::newWeapons");
// Event::Attach(eventConnected, "ammohud::newWeapons");

$ammohud::gfx["Blaster"]		= "lr_blaster_on";
$ammohud::gfx["Plasma Gun"]		= "lr_plasma_on";
$ammohud::gfx["Chaingun"]		= "lr_chain_on";
$ammohud::gfx["Disc Launcher"]          = "lr_disk_on";
$ammohud::gfx["Grenade Launcher"]	= "lr_grenade_on";
$ammohud::gfx["Laser Rifle"]		= "lr_sniper_on";
$ammohud::gfx["ELF Gun"]		= "lr_energyrifle_on";
$ammohud::gfx["Mortar"]			= "lr_mortar_on";
$ammohud::gfx["Targeting Laser"]	= "lr_targetlaser_on";
$ammohud::gfx["Repair Gun"]		= "lr_REPAIRPACK_oN";
$ammohud::gfx["EMP Grenade Launcher"]   = "lr_clock_on";
$ammohud::gfx["IX-2000 Sniper Rifle"]	= $ammohud::gfx["Laser Rifle"];
$ammohud::gfx["Pyro-Torch"]		= "lr_ENERGYPACK_oN";
$ammohud::gfx["Phalanxx Cannon"]	= $ammohud::gfx["Chaingun"];
$ammohud::gfx["MAG Gun"]                = $ammohud::gfx["ELF Gun"];
$ammohud::gfx["Shotgun"]		= "lr_AMMOPACK_oN";
$ammohud::gfx["Rocket Launcher"]	= $ammohud::gfx["Blaster"];
$ammohud::gfx["0"]                      = "lr_AMMOPACK_oN";

$ammohud::max[larmor, "Plasma Gun"] = 30;
$ammohud::max[larmor, "Chaingun"] = 100;
$ammohud::max[larmor, "Disc Launcher"] = 15;
$ammohud::max[larmor, "Grenade Launcher"] = 10;
$ammohud::max[larmor, "Mortar"] = 10;
$ammohud::max[marmor, "Plasma Gun"] = 40;
$ammohud::max[marmor, "Chaingun"] = 150;
$ammohud::max[marmor, "Disc Launcher"] = 15;
$ammohud::max[marmor, "Grenade Launcher"] = 10;
$ammohud::max[marmor, "Mortar"] = 10;
$ammohud::max[harmor, "Plasma Gun"] = 50;
$ammohud::max[harmor, "Chaingun"] = 200;
$ammohud::max[harmor, "Disc Launcher"] = 15;
$ammohud::max[harmor, "Grenade Launcher"] = 15;
$ammohud::max[harmor, "Mortar"] = 10;
$Ammohud::PackMax["Chaingun"] = 150;
$Ammohud::PackMax["Plasma Gun"] = 30;
$Ammohud::PackMax["Disc Launcher"] = 15;
$Ammohud::PackMax["Grenade Launcher"] = 15;
$Ammohud::PackMax["Mortar"] = 10;


// IX Support

$ammohud::max[larmor, "Rocket Launcher"] = 5;
$ammohud::max[larmor, "Pyro-Torch"] = 75;
$ammohud::max[larmor, "EMP Grenade Launcher"] = 0;
$ammohud::max[larmor, "Shotgun"] = 15;
$ammohud::max[larmor, "Phalanxx Cannon"] = 0;
$ammohud::max[larmor, "IX-2000 Sniper Rifle"] = 5;
$ammohud::max[marmor, "Rocket Launcher"] = 15;
$ammohud::max[marmor, "Pyro-Torch"] = 100;
$ammohud::max[marmor, "EMP Grenade Launcher"] = 10;
$ammohud::max[marmor, "Shotgun"] = 15;
$ammohud::max[marmor, "Phalanxx Cannon"] = 100;
$ammohud::max[marmor, "IX-2000 Sniper Rifle"] = 0;
$ammohud::max[harmor, "Rocket Launcher"] = 15;
$ammohud::max[harmor, "Pyro-Torch"] = 75;
$ammohud::max[harmor, "EMP Grenade Launcher"] = 15;
$ammohud::max[harmor, "Shotgun"] = 0;
$ammohud::max[harmor, "Phalanxx Cannon"] = 0;
$ammohud::max[harmor, "IX-2000 Sniper Rifle"] = 0;
$ammohud::packmax["Rocket Launcher"] = 15;
$ammohud::packmax["Pyro-Torch"] = 75;
$ammohud::packmax["EMP Grenade Launcher"] = 10;
$ammohud::packmax["Shotgun"] = 10;
$ammohud::packmax["IX-2000 Sniper Rifle"] =  10;
$ammohud::packmax["Phalanxx Cannon"] = 100;

// RENEGADES SUPPORT 2.0
// armors: scout = sarmor, sniper = light, spy = spyarmor, mercenary = marmor, 
// burster = barmor, engineer = armor, alien = alarmor, cyborg = dmarmor

if ($ammohud::enableRenegade) {
$ammohud::maxr[sniper, "Chaingun"] = 100;
$ammohud::maxr[sniper, "Plasma Gun"] = 30;
$ammohud::maxr[sniper, "Grenade Launcher"] = 10;
$ammohud::maxr[sniper, "Disc Launcher"] = 15;
$ammohud::maxr[sniper, "Sniper Rifle"] = 15;
$ammohud::maxr[sniper, "Dart Rifle"] = 20;
$ammohud::maxr[sniper, "Magnum"] = 25;

$ammohud::maxr[scout, "Chaingun"] = 100;
$ammohud::maxr[scout, "Plasma Gun"] = 30;
$ammohud::maxr[scout, "Grenade Launcher"] = 10;
$ammohud::maxr[scout, "Disc Launcher"] = 15;

$ammohud::maxr[spy, "Chaingun"] = 100;
$ammohud::maxr[spy, "Plasma Gun"] = 30;
$ammohud::maxr[spy, "Grenade Launcher"] = 10;
$ammohud::maxr[spy, "Disc Launcher"] = 15;
$ammohud::maxr[spy, "Magnum"] = 25;

$ammohud::maxr[mercenary, "Chaingun"] = 150;
$ammohud::maxr[mercenary, "Plasma Gun"] = 40;
$ammohud::maxr[mercenary, "Grenade Launcher"] = 10;
$ammohud::maxr[mercenary, "Disc Launcher"] = 15;
$ammohud::maxr[mercenary, "Rocket Launcher"] = 5;
$ammohud::maxr[mercenary, "Vulcan"] = 300;

$ammohud::maxr[burster, "Plasma Gun"] = 40;
$ammohud::maxr[burster, "Grenade Launcher"] = 10;
$ammohud::maxr[burster, "Mortar"] = 10;
$ammohud::maxr[burster, "Disc Launcher"] = 15;
$ammohud::maxr[burster, "Rocket Launcher"] = 5;

$ammohud::maxr[engineer, "Chaingun"] = 150;
$ammohud::maxr[engineer, "Plasma Gun"] = 40;
$ammohud::maxr[engineer, "Grenade Launcher"] = 10;
$ammohud::maxr[engineer, "Mortar"] = 10;
$ammohud::maxr[engineer, "Disc Launcher"] = 15;
$ammohud::maxr[engineer, "Rocket Launcher"] = 5;
$ammohud::maxr[engineer, "Railgun"] = 10;

$ammohud::maxr[cyborg, "Chaingun"] = 150;
$ammohud::maxr[cyborg, "Plasma Gun"] = 50;
$ammohud::maxr[cyborg, "Grenade Launcher"] = 15;
$ammohud::maxr[cyborg, "Mortar"] = 10;
$ammohud::maxr[cyborg, "Disc Launcher"] = 15;
$ammohud::maxr[cyborg, "Rocket Launcher"] = 10;
$ammohud::maxr[cyborg, "Vulcan"] = 400;

$ammohud::packmaxr["Rocket Launcher"] = 10;
$ammohud::packmaxr["Magnum"] = 25;
$ammohud::packmaxr["Sniper Rifle"] = 15;
$ammohud::packmaxr["Dart Rifle"] = 20;
$ammohud::packmaxr["Vulcan"] = 100;
$ammohud::packmaxr["Railgun"] = 5;

$ammohud::gfx["Shockwave Cannon"]       = $ammohud::gfx["Disc Launcher"];
$ammohud::gfx["Vulcan"]                 = $ammohud::gfx["Chaingun"];
$ammohud::gfx["Thunderbolt"]            = $ammohud::gfx["ELF Gun"];
$ammohud::gfx["Dart Rifle"]             = $ammohud::gfx["Blaster"];
$ammohud::gfx["Sniper Rifle"]           = $ammohud::gfx["Laser Rifle"];
$ammohud::gfx["Flame Thrower"]          = $ammohud::gfx["Plasma Gun"];
$ammohud::gfx["Hyper Blaster"]          = $ammohud::gfx["Blaster"];
$ammohud::gfx["Engineer Repair-Gun"]    = $ammohud::gfx["Repair Gun"];
$ammohud::gfx["Railgun"]                = $ammohud::gfx["Laser Rifle"]; 
$ammohud::gfx["Ion Rifle"]              = $ammohud::gfx["Laser Rifle"];
$ammohud::gfx["Omega Cannon"]           = $ammohud::gfx["Plasma Gun"];
$ammohud::gfx["Magnum"]                 = $ammohud::gfx["Laser Rifle"];


}

function ammohud::init() {
       
	$ammohud::ammopack = 0;
	$ammohud::warned = 0;
	$ammohud::lastwep = 999;
        $ammohud::armor = "larmor";
	%ratio = (57/121);
	$ammohud::width=(%ratio*$ammohud::WidthX);	
	%qu2 = (($ammohud::widthX)/2);
	%qu  = (3*($ammohud::widthX)/4);
	%qu3 = (($ammohud::widthX)/4);
        %movel = 0;
        %sa = 0;
        %sc = 0;

        if ($ammohud::GFXpos == "left" && $ammohud::showGFX) {
             %movel = %movel+23;
             %sa = 23; }
        if ($ammohud::countposition == "left" && $ammohud::showammocount) {
             %movel = %movel+26;
             %sc = 26; }
	if ($ammohud::showMeter) 
	        HUD::New(amHUD, "ammohud::UpdateAmmoHUD",$ammohud::X+%movel,$ammohud::Y, ($ammohud::widthX),18);
	else
		HUD::New(amHUD, "ammohud::UpdateAmmoHUD", $ammohud::X+%movel, $ammohud::Y, 1, 18);

        if ($ammohud::warnLowAmmo) {
		HUD::New(AmmoMsg, "ammohud::warnLow", "50% "@$ammohud::warningPos@"% 75% 17"); }

	if ($ammohud::showAmmoCount) {
                HUD::New(ammohudcount, "ammohud::counthud", $ammohud::countposition@"(amhud)-"@%sc@" top(amhud) 26 17");
                HUD::Display(ammohudcount);               } 
        
	if ($ammohud::showGFX) {
                if ($ammohud::GFXpos == $ammohud::countposition && $ammohud::showAmmoCount)
                    HUD::New(ammohudgfx, "ammohud::gfxhud", $ammohud::GFXPos@"(ammohudcount)-"@%sa@", top(amhud) 23 17");
                else
                    HUD::New(ammohudgfx, "ammohud::gfxhud", $ammohud::GFXPos@"(amhud)-"@%sa@" top(amhud) 23 17");
                HUD::Display(ammohudgfx);  }              
        
	if ($ammohud::NotchesOn && $ammohud::showMeter) {
		if ($ammohud::NotchPos == "top") {
			%notchLoc = "top";
			%up = 1; }
		else {
			%notchLoc = "bottom";
			$up = 0;
			}

		HUD::New(q1hud, "", "left(amhud)+4 " @%notchLoc@"(amhud)-"@%up*$ammohud::notchHeight@" 2 " @ $ammohud::notchHeight); // add notches!
		HUD::New(q2hud, "", "left(amhud)+"@ %qu2 @ " "@%notchLoc@"(amhud)-"@%up*$ammohud::notchHeight@" 2 " @ $ammohud::notchHeight);
		HUD::New(q3hud, "", "left(amhud)+"@ %qu  @ " "@%notchLoc@"(amhud)-"@%up*$ammohud::notchHeight@" 2 " @ $ammohud::notchHeight);
		HUD::New(q4hud, "", "right(amhud)-5 "@%notchLoc@"(amhud)-"@%up*$ammohud::notchHeight@" 2 "@ $ammohud::notchHeight);
		HUD::New(q5hud, "", "left(amhud)+"@ %qu3 @ " "@%notchLoc@"(amhud)-"@%up*$ammohud::notchHeight@" 2 " @ $ammohud::notchHeight);
		HUD::Display(q1hud);
		HUD::Display(q2hud);
		HUD::Display(q3hud);
		HUD::Display(q4hud);
		HUD::Display(q5hud);
        
	}
	
	$ammohud::hudklop = "<f1>";
	$ammohud::hudblue = "|";
        HUD::Display(amhud);
        // ammohud::updateAmmo(); 
}

function ammohud::newWeapons() {
 Inv::InitWeapon("Phalanxx Cannon", "Phalanxx Ammo");
 Inv::InitWeapon("Shotgun", "Shotgun Shells");
}

function ammohud::reset() {

	ammohud::updateAmmo();	
	$ammohud::warned = 0;
	$ammohud::lastwep = 999;
        $ammohud::armor = "larmor";
	ammohud::UpdateAmmo();
}

function ammohud::toggle() {

	HUD::ToggleDisplay(amhud);
if ($ammohud::NotchesOn == "true") {
	HUD::ToggleDisplay(q1hud);
	HUD::ToggleDisplay(q2hud);
	HUD::ToggleDisplay(q3hud);
	HUD::ToggleDisplay(q4hud);
	HUD::ToggleDisplay(q5hud);}
if ($ammohud::showammocount) {
	HUD::ToggleDisplay(ammohudcount);
	HUD::ToggleDisplay(ammohudgfx); }
}

function ammohud::warnLow() {
	$ammohud::warned = 1;
	HUD::SetText("AmmoMSG", "<f2><jc>LESS THAN " @ $ammohud::WarningLevel@"% OF AMMO REMAINING!");
	HUD::Display("AmmoMSG");
	Schedule("HUD::Display(AmmoMSG,false);",$ammohud::warningTime);
}	

function ammohud::handleWeaponChange(%new, %old) { // V1.2
	if (%new == %old)		// same weapon 
		return; 
	if (%new < 0) {			// no gun
		ammohud::updateAmmo();
		ammohud::emptyGun(); }
	if (%new != %old) {		// new fun
		$ammohud::warned = 0;
		ammohud::updateAmmo(); }
}

function ammohud::handlePackChange(%new, %old) { // V 1.2
	if (%new == $Inv::Ammo_Pack)	// we picked up an ammo pack
		ammohud::updateammo();
	if (%old == $Inv::Ammo_Pack)	// dropped an ammo pack
		ammohud::updateammo();	
}

function ammohud::updateAmmoHUD() {
        HUD::SetText(amHUD,$ammohud::hudklop);
	HUD::Display(amHUD);
}


function ammohud::counthud() 
{   
	HUD::SetText("ammohudcount","<f2><jl>"@$ammohud::cnt);
	HUD::Display(ammohudcount);       
}

function ammohud::gfxhud()
{
	 %w = getMountedItem(0);
         %g = $ammohud::gfx[$Inv::Name[%w]];
         if (%g != "")
             HUD::SetText("ammohudgfx","<B0,4:"@%g@".bmp>");
	 else 
	     HUD::SetText("ammohudgfx","<f2> -");
	 if (%w < 0)
	        HUD::SetText("ammohudgfx","<f2> -");
	 HUD::Display(ammohudgfx);
}

function ammohud::emptyGun() {
        $ammohud::hudklop = "<f1>";
	ammohud::updateAmmo();
}

function ammohud::makeBar(%wi) {

      //  ECHO ("MAKEBAR CALLED:" @ %wi);
        $ammohud::hudklop = "<f1>";
        for (%i = 0; %i < %wi; %i++) {
		%tempText = $ammohud::hudklop @ $ammohud::hudblue;
		$ammohud::hudklop = %tempText; }
                                
}

function ammohud::getPercent(%cur, %max) {
	%pct = %cur/%max;
        // ECHO ("GETPERCENT CALLED:"@%cur@"/"@%max@"/"@%pct);        
        return $ammohud::width*%pct;
}

function ammohud::checkArmor() {

    %armortype = %armorname = "";

    for(%i = $Inv::ArmorCount; %i > 0; %i--)
      {
       if(getItemCount(%armorname = $Inv::Name[%armortype = $Inv::ArmorList[%i]]))
               break;
              }
    //ECHO("ARMOR:"@%armortype@" "@%armorname);
     if (Inv::exists(Vulcan)) {
	$ammohud::armor = $Inv::Name[%armortype];
	return; }

    if (%armortype == "2")
	$ammohud::armor = "larmor";
    if (%armortype == "3")
        $ammohud::armor = "marmor";
    if (%armortype == "4")
	$ammohud::armor = "harmor";

    return $ammohud::armor;
}


function ammohud::startFiring(%wep, %amo, %cnt) {

        $ammohud::fire = 1;
	$ammohud::lastwep = getMountedItem(0);
	$ammohud::lastamo = $Inv::Ammo[$ammohud::lastwep];
        ammohud::checkAmmo(); }

function ammohud::checkAmmo() {
 
     if ($ammohud::fire) {

	$ammohud::lastwep = getMountedItem(0);
	$ammohud::lastamo = $Inv::Ammo[$ammohud::lastwep];
	ammohud::checkArmor();
	if ($ammohud::lastamo != "") {
		$ammohud::cnt = getItemCount($Inv::Ammo[$ammohud::lastwep]);
               // echo ($ammohud::cnt);
		%mx = ammohud::getMax();
        	%w = ammohud::getPercent($ammohud::cnt, %mx);
        	ammohud::makeBar(%w); 
		if ($ammohud::warnLowAmmo && (($ammohud::cnt/%mx)*100) <= $ammohud::warningLevel && !$ammohud::warned) 
			ammohud::warnLow();
		else if($ammohud::warnLowAmmo && ($ammohud::cnt/%mx)*100 > $ammohud::warningLevel)
			$ammohud::warned = 0;
		if ($ammohud::showAmmoCount || $ammohud::showGfx) {			
			HUD::Update("ammohudcount");
                        HUD::Update("ammohudgfx");}
					}
	else {
		if ($ammohud::showAmmoCount || $ammohud::showGfx) {		
			$ammohud::cnt = "<B3,7:i_Infinity_on.bmp>";	
			HUD::Update("ammohudcount");
			HUD::Update("ammohudgfx");
                               }
		ammohud::makeBar($ammohud::width); }
        HUD::Update(amhud); 
	schedule ("ammohud::checkAmmo();",0.5); }
}


function ammohud::updateAmmo() {
       // ECHO ("UPDATE");
        $ammohud::lastwep = getMountedItem(0);
	$ammohud::lastamo = $Inv::Ammo[$ammohud::lastwep];
	ammohud::checkArmor();
	if ($ammohud::lastwep < 0) { 					// no gun
                $ammohud::cnt = "<f2> -";
                ammohud::makeBar(0); 
		$ammohud::lastamo = "";
		if ($ammohud::showAmmoCount || $ammohud::showGfx) {			
			HUD::Update("ammohudcount");
			HUD::Update("ammohudgfx"); }
        	HUD::Update(amhud);	        
		return;
		}
	if ($ammohud::lastamo != "") {					// weapon needs ammo
		$ammohud::cnt = getItemCount($Inv::Ammo[$ammohud::lastwep]);
        	%mx = ammohud::getMax();
        	%w = ammohud::getPercent($ammohud::cnt, %mx);
        	ammohud::makeBar(%w); 
		if ($ammohud::warnLowAmmo && (($ammohud::cnt /%mx)*100) <= $ammohud::warningLevel && !$ammohud::warned) 
			ammohud::warnLow();
		else if($ammohud::warnLowAmmo && ($ammohud::cnt/%mx)*100 > $ammohud::warningLevel)
			$ammohud::warned = 0;
		if ($ammohud::showAmmoCount || $ammohud::showGfx) {			
			HUD::Update("ammohudcount");
                        HUD::Update("ammohudgfx"); }
               } 
	else {
		if ($ammohud::showAmmoCount || $ammohud::showGfx) {  // infinite ammo?
			$ammohud::cnt = "<B3,7:i_Infinity_on.bmp>";	
			HUD::Update("ammohudcount");
			HUD::Update("ammohudgfx");  }
		ammohud::makeBar($ammohud::width); }
        HUD::Update(amhud);
}

function ammohud::getMax() {
 %w = getMountedItem(0);
 if (Inv::exists(Vulcan)) {
	%m = ammohud::getMaxR();
	return %m; }
 %m = $ammohud::max[$ammohud::armor, $Inv::Name[%w]];
 if (getMountedItem(1) == $Inv::Ammo_Pack) 
        %m = (%m + $ammohud::packmax[$Inv::Name[%w]]);
 return %m;
}

function ammohud::getMaxR() {
	%w = getMountedItem(0);
	%m = $ammohud::maxr[$ammohud::armor, $Inv::Name[%w]];

 if (getMountedItem(1) == $Inv::Ammo_Pack)
	%m = (%m + $ammohud::packmaxr[$Inv::Name[%w]]);
 return %m;
}
function ammohud::stopFiring()
{
        $ammohud::fire = 0;
	schedule("ammohud::updateAmmo();",0.5*$ammohud::pingq);
}


function ammohud::pickup()
{
	schedule("ammohud::updateAmmo();",1);
}

function ammohud::checkMessage(%client, %msg) {
	if(%client)
        	return;	
	if(%msg == "Station Access Off")
            Event::Trigger(eventInventoryOut);	
	if(%msg == "Resupply Complete")
            Event::Trigger(eventResupplyAmmo);
	if (String::findSubStr(%msg, "You received") != -1)
	    Event::Trigger(eventPickup);
}

ammohud::init();

// This space intentionally left blank, thanks for reading my script ;)
