// ---------------------------------------------------------------------------
// fire.cs -- Version 1.4 -- May 14, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("presto\\writer\\event.cs");

// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


function onFireButton()
{
    // Protect against mad-firing on respawn?
    postAction(2048, IDACTION_BREAK1, -0); 

    if($PilotMode)
    {
        Event::Trigger(eventPilotModeFirePressed);
    
        if( !Event::Returned(eventPilotModeFirePressed, mute) )
            postAction(2048, IDACTION_FIRE1, -0);

        return;
    }

    %weapon = getMountedItem(0);
    
    if(%weapon != -1) // Do we have a weapon in hand?
    {
        // Yeah, does it have ammo?
    	if((%ammo = $Inv::Ammo[%weapon]) != "")
    	{
        	if( (%ammocount = getItemCount(%ammo)) ) // it has ammo!
        	{
        	    Event::Trigger(eventWeaponFired, %weapon, %ammo, %ammocount);
        	}
        	else // it's out of ammo!
        	{
                Event::Trigger(eventNoAmmo, %weapon, %ammo);
        	}
        }
        else // It doesn't need ammo!
        {
        	Event::Trigger(eventWeaponFired, %weapon);
        }
    }

    Event::Trigger(eventFirePressed, %weapon); // %weapon will be -1 if no weapon mounted
    
    if(   !Event::Returned(eventWeaponFired, mute)
       && !Event::Returned(eventFirePressed, mute)
       && !Event::Returned(eventNoAmmo, mute)      )
        postAction(2048, IDACTION_FIRE1, -0);
    
}

function onFireButtonBreak()
{
    if($PilotMode)
    {
        Event::Trigger(eventPilotModeFireReleased);
    
        if( !Event::Returned(eventPilotModeFireReleased, mute) )
            postAction(2048, IDACTION_BREAK1, -0);

        return;
    }

    %weapon = getMountedItem(0);

    if(%weapon != -1) // we have a weapon in hand
    {
    	if((%ammo = $Inv::Ammo[%weapon]) != "") // it uses ammo
    	{
        	if( !getItemCount(%ammo) ) // it's out of ammo!
        	{
                Event::Trigger(eventNoAmmo, %weapon, %ammo);
        	}
        }
    }

    Event::Trigger(eventFireReleased, %weapon); // %weapon will be -1 if no weapon mounted

    if( !Event::Returned(eventFireReleased, mute) )
        postAction(2048, IDACTION_BREAK1, -0); 
}


// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("playMap.sae"); 

    // Set this to your fire button!
    bindCommand(mouse0, make, button0, TO, "onFireButton();"); 
    bindCommand(mouse0, break, button0, TO, "onFireButtonBreak();");
}
