// .---------------------------------------.
// [** Blasterless v1.0		           ]
// [** 06.20.00				   ]
// [ By    : Rayn			   ]
// [ E-Mail: rayn@tribalwar.com 	   ]
// [ Site  : http://www.tribalwar.com/rayn ]
// `---------------------------------------'
// --------------------------------------------------------------------------------------
// Script to automatically drop your blaster, no matter what.
// This script needs to know your fire button so that it can tell when you spawn.
// Any scripts that need this information will most likely NOT be compatible with this
// script, so be wary. I didn't write it as an uber-compatible script, just a special
// request.
// --------------------------------------------------------------------------------------

// --- Includes
Include("presto\\event.cs");

// --- Script Variables
$rayn::blasterless::enabled = "true";
$rayn::blasterless::preferred = "2";



exec(blasterless_prefs);

// Event Attachments
Event::Attach(eventFirePressed, rayn::blasterless::checkBlaster);
Event::Attach(eventFirePressed, "schedule(\"rayn::blasterless::checkBlaster();\",0.5);");  
Event::Attach(eventClientMessage, rayn::blasterless::parseText);

// --- New Events
function rayn::event::onFirePressed()
{
 Event::Trigger(eventFirePressed);
 postAction(2048, IDACTION_FIRE1, -0);
 
}

function rayn::event::onFireReleased()
{
 Event::Trigger(eventFireReleased);
 postAction(2048, IDACTION_BREAK1, -0);
 
}

function rayn::blasterless::dropBlaster()
{
	
	drop(Blaster);
	if ($rayn::blasterless::preferred != "0" && getItemCount($rayn::blasterless::preferredWeapon))
		use($rayn::blasterless::preferredWeapon);
   	else
		nextWeapon();
	
}

function rayn::blasterless::checkBlaster()
{

if (!$rayn::blasterless::enabled)
	return;
if (getItemCount("Blaster")) {
	rayn::blasterless::dropBlaster();	
	}
}

function rayn::blasterless::parseText(%client, %msg)
{

 if (%client != "0")
	return;

 if (%msg == "Match started.") {
	rayn::blasterless::dropBlaster();
	return;
 }
 if (%msg == "You received 1 Blaster") {
	
	rayn::blasterless::dropBlaster();
	return;
 }
 return;
}

function rayn::blasterless::onGuiOpen()
{
 FGCombo::Clear(rayn::blasterless::weaponsBox);
 FGCombo::AddEntry(rayn::blasterless::weaponsBox, "Next Weapon", 0);
 FGCombo::AddEntry(rayn::blasterless::weaponsBox, "Chaingun", 1);
 FGCombo::AddEntry(rayn::blasterless::weaponsBox, "Disc Launcher", 2);
 FGCombo::AddEntry(rayn::blasterless::weaponsBox, "ELF gun", 3);
 FGCombo::AddEntry(rayn::blasterless::weaponsBox, "Grenade Launcher", 4);
 FGCombo::AddEntry(rayn::blasterless::weaponsBox, "Laser Rifle", 5);
 FGCombo::AddEntry(rayn::blasterless::weaponsBox, "Mortar", 6);
 FGCombo::AddEntry(rayn::blasterless::weaponsBox, "Plasma Gun", 7);
 FGCombo::SetSelected(rayn::blasterless::weaponsBox, $rayn::blasterless::preferred);
}

function rayn::PreferredIndex()
{
 if ($rayn::blasterless::preferred == "1") {
	$rayn::blasterless::preferredWeapon = "Chaingun";
 	return;
 }
 if ($rayn::blasterless::preferred == "2") {
	$rayn::blasterless::preferredWeapon = "Disc Launcher";
 	return;
 }
 if ($rayn::blasterless::preferred == "3") {
	$rayn::blasterless::preferredWeapon = "ELF gun";
 	return;
 }
 if ($rayn::blasterless::preferred == "4") {
	$rayn::blasterless::preferredWeapon = "Grenade Launcher";
 	return;
 }
 if ($rayn::blasterless::preferred == "5") {
	$rayn::blasterless::preferredWeapon = "Laser Rifle";
 	return;
 }
 if ($rayn::blasterless::preferred == "6") {
	$rayn::blasterless::preferredWeapon = "Mortar";
 	return;
 }
 if ($rayn::blasterless::preferred == "7") {
	$rayn::blasterless::preferredWeapon = "Plasma Gun";
 	return;
 }
 $rayn::blasterless::preferredWeapon = "Disc Launcher"; // backup default
}

function rayn::blasterless::onGuiClose()
{
 $rayn::blasterless::preferred = FGCombo::GetSelected(rayn::blasterless::weaponsBox);
 rayn::PreferredIndex();
 export("$rayn::blasterless::enabled", "config\\blasterless_prefs.cs",false);
 export("$rayn::blasterless::preferred", "config\\blasterless_prefs.cs",true);
 export("$rayn::blasterless::preferredWeapon", "config\\blasterless_prefs.cs",false);
}

function rayn::blasterless::AddBanner()
{

	Presto::AddScriptBanner(BlasterLess,
                " <f2>BlasterLess<jr><f0>v1.0 <jl>\n" @
		" <jc><f1>Written by:\n" @
		" <f0>Rayn\n" @
                 "\n\n" @
                 "<f1>rayn@tribalwar.com" @
                 "<f2>WWW.TRIBALWAR.COM" @
		  "<b0,10:rayn\\bmp\\rayn_twbanner.bmp>" );
}
rayn::PreferredIndex();
NewOpts::registerHelp("BlasterLess","<f1>BlasterLess is a script designed to do the obvious:" @
" automatically drop your blaster. Some would argue the blaster is a useful weapon, " @
"this script is not for you.\n\nYour options are as follows:\n\n"@"<f2>Fire Key:<f1> You must bind your" @ 
"fire key here for this to work This is because" @
 " I need to know when you spawn, if you don't do it, the script won't work right." @ 
"\n\n<f2>Manual Drop:<f1> You can bind a key to manual drop, that" @
" way you can either disable automatic dropping and use only this option, or use both " @
"as a safeguard in case the blaster does not drop for some reason." @ 
"\n\n<f2>Preferred Weapon:<f1> Weapon to switch to" @ 
" when you drop a blaster. I recommend the disc launcher," @
" this is the default.\n\n<f2>Auto-Drop"@" Enabled:<f1> If its off, you're not gonna drop" @ " automatically. Plain " @
"and simple.\n\n<f2>Notes:<f1>\n\n- You won't drop the blaster" @ 
" automatically if you buy it at a station until " @
"you fire. I could code that in, but it would" @
" mean a slight performance degradation - " @
"Therefore, don't buy it if you don't want it.\n\n- Ping may affect the" @
" drop after you pick up a blaster and after you spawn. I haven't" @
" thought of how to correct this yet.");

NewOpts::Register("BlasterLess", "config\\rayn\\blasterless.gui", "rayn::blasterless::onGuiOpen();", "rayn::blasterless::onGuiClose();", TRUE);
rayn::blasterless::AddBanner();