
// ================================================================
// CTFHUD v1.4 - {FSC} Rayn -- rayn@tribalwar.com
// ==============================================
// Rayn's Bucket O' Tribes: http://www.tribalwar.com/rayn
// ---------------------------------------------------------------
// 			Visit TRIBALWAR.COM!
// ----------------------------------------------------------------
// CTFHUD is your basic DynHud replacement.  The main idea here is that
// its going to be smaller than the other HUDs out there.  Seriously, do you
// really need to know your kills per minute - mine never goes above 1 anyway ;)
// So I tried to size down the whole HUD idea.  We'll see how it works.
//
// This is version 1.4, and although I've fixed alot, I can't guarantee its bug free.  
// But please send me your bug reports and questions:  rayn@tribalwar.com
//
// I will try to credit everyone who was of great
// help because either I learned from their code or used it as a reference: 
// Presto, Dark Ninja, Writer, Zear, and VeKToR. 
// ----------------------------------------------------------------
// PLEASE NOTE:
// 
// REQUIRED:
// PRESTO PACK 0.93 (or better)
// RECOMMENDED:
// Writer's Script Pack (preinstalled)
// NewOpts
// --------------------------------------------------------------
// INSTALL NOTES:
// Unzip into your tribes/config directory.
// All the .BMP's go into /tribes/config/rayn/bmp/
// The script file ctfhud.cs does into /tribes/config/rayn
// Schedule.cs by Writer goes into /tribes/config/writer
// Then add this line to your autoexec.cs:
// after Include("presto\\install.cs");

// Include("rayn\\ctfhud.cs");	(make sure you use the right slashes I can't remember which to use)

// ---------------------------------------------------------------
// =================================================================
// CONTROLS:
//

// There are three key bindings as follows:
// "control h"	- toggle hud on/off
// "alt h"	- force reset (score etc)
// "shift h"    - toggle auto-waypoint setting (explained below)

//
// ==================================================================
// AUTOWAYPOINTING
// Thanks to |HH|Crunchy for idea I used in creating this
// part of the hud.  When you press the toggle waypoint key it 
// will switch to the next mode and a little hud will pop up on
// the bottom to inform you of its setting. It will also attempt to
// set the appropriate waypoint at that time.
// It toggles from off, to target enemy flag carrier (the guy who has YOUR flag), to target
// friendly flag carrier (the guy on your team with THEIR flag).
// It will automatically set a waypoint.  For the enemy flag carrier this
// only works if your sensors can detect him, once he dissapears the
// waypoint will be inaccurate, but it is still definetly useful.  If
// you have set a waypoint to the enemy, but are getting a bogus reading because
// you didn't know where the guy was at the time, the waypoint will correct itself
// as soon as your target enters sensor range or is seen by a teammate.  Sure it would
// be nice to target a player who is hiding and know where he is, but Tribes doesn't
// let you do that (that would be cheating anyway) .. This will allow you to
// have the waypoint set as soon as it is valid and nothing more ;)
// ------------------------------------------------------------------------
// Version 1.4 - 6.14.00
// Public Release
// - Added support for functional observer mode.
// - Fixed some issues regarding the timer, should now work nicely.
// ------------------------------------------------------------------------
// Version 1.2 - 8/9/99
// Public Release
// - Got word that 1.8 was screwing up the item HUD.  There is a new preference to set:
// $raynhud::version (under preferences) if you have 1.8 or better set this to true
// and it will correct the thing for ya'.
// - Made the item icons dim when you don't have the specified item
// - Added a 'clear waypoints?' preference.  Since the clear waypoints function
// will clear your waypoint - regardless of whether auto waypoint is on or off -
// it can get annoying (specially if you're using Warpoints ;) .. so this option
// is added.  It defaults to false, meaning old waypoints will remain until they 
// are replaced.  If you want them to clear set this to false.
// ------------------------------------------------------------------------
// Version 1.1 - 8/1/99
// FSC Only Release
// Thanks to {FSC}Toes for most of the ideas for updates in this version ;)
//
// - Added the score tracker HUD.  Shows your current score in CTF games as well
// as personal captures.
// - Improved the auto-waypointing feature to clear waypoints when the flag carrier
// you are targetting caps or drops the flag.  Since the only way to clear a waypoint
// from a script is to set a waypoint to yourself, you may notice that you'll still
// have a waypoint set, but it is 'cleared' to avoid confusion.
// - Now when you toggle the auto-waypointer it will attempt to set the appropriate
// waypoint for you.  Thus, if you have it set to target the friendly w/ flag and someone
// steals your flag, toggle over to 'target enemy w/ flag' and it will try to set the waypoint
// to that individual.
// - Added the drop timer from my DropFlagHUD to CTFHuD. Now if a flag is dropped the
// timer will pop up to tell you how long until the flag is automatically returned.
// the default time is 48 seconds on almost ALL servers.  If its altered, well, find another
// server ;) (if you encounter this often tell me and I'll allow a preference but for now
// I'm hardcoding it at 48 to avoid problems)
// - Fixed the toggle bug (my bad, before it wasn't toggling off because I used the wrong syntax)
// - Fixed a bug causing only part of the HUD to move when the coordinates are changed.
//
// Version 1.0 - 7/11/99
// - Totally redesigned the HUD, slimmed it down and optimized the code
// - Its all new baby!
//
// Version 0.6b - 05/27/99
// - Corrected bug that caused the inventory status not to update
// correctly when the player dies or changes teams.
// - Corrected bug that when toggling the HUD, kill and help information
// would remain displayed
// - Corrected bug that caused the kill/help information to pop up when
// HUD was toggled off
// - Implemented option to display objective information in team HUD since
// many levels don't have objectives on base levels (CTF)
// - Removed turret deaths counting as a suicide and -1 points, now they
// just count as a death
// - Added an option to ignore auto-waypointing to enemy while you have
// the flag
// - Added experimental NewOpt GUI Support
// ----------------------------------------------------------------
// Preferences:
// Edit these values to customize the HUD (slightly!)
// ----------------------------------------------------------------
   $raynhud::startX = 0;               // Determine the starting location of the hud
   $raynhud::startY = 85;              // (Upper left corner);
                              // Autostart 1 = true, 0 = false

   $raynhud::wayToggle = 0;   // start-up auto-waypoint setting
                              // 0 = off, 1 = target friendly
                              // 2 = target enemy

   $raynhud::flagway = 1;     // Ignore auto-waypointing when you have the flag
                              // 1 = ignore, 0 = override
                              // (If you have the flag and an enemy takes yours
                              // while you have AW set to enemy flag taker
                              // you will lose your waypoint home.  If you
                              // want to target the enemy set this to 1
                              // if you want to keep your waypoint home set to 0)
   $raynhud::version = "true"; // Do you have 1.8 or better? If so set to true, otherwise
			      // set to false.

   $raynhud::clearPoints = "true"; // Everytime the flag changes status you're old waypoints
				   // will get erased to tell you the new location of the flag
				   // when set to false.  If you don't mind this and want
				   // the waypoints cleared, set to false. Otherwise
				   // set to true (default) to maintain old waypoints.
// ** Toggle specific HUDs on/off **
// To turn them off, just replace the "1" below with a "0" for each HUD you
// don't want to show up:
// ================================================================================
	$raynhud::showTeamScore = "1";
	$raynhud::showPlayerCount = "1";
	$raynhud::showFlagStatus = "1";
	$raynhud::showKills = "1";
	$raynhud::showItems = "1";
	$raynhud::showObjective = "0";
	$raynhud::showWaypointSetting = "1";
	$raynhud::showScore = "1";

// keyboard commands
// ------------------------------------------------------------
// Currently bound to ctl-h for toggle display and alt-h for force reset
// Shift-h will toggle through all available waypoint settings.
// Very unuseful on most people's key sets so customize for your own
// ------------------------------------------------------------

bindCommand(keyboard0, make, control, "h", TO, "raynhud::Toggle();");
bindCommand(keyboard0, break, control, "h", TO, "");
bindCommand(keyboard0, make, alt, "h", TO, "raynhud::Reset();");
bindCommand(keyboard0, break, alt, "h", TO, "");
bindCommand(keyboard0, make, shift, "h", TO, "raynhud::toggleWaypoint();");
bindCommand(keyboard0, break, shift, "h", TO, "");

// ================== END PREFERENCES ==========================
// ------------------------------------------------------------
// PrestoPack Code
// -------------------------------------------------------------
Include("presto\\Event.cs");
Include("presto\\HUD.cs");
Include("presto\\TeamTrak.cs");
Include("presto\\KillTrak.cs");
Include("writer\\schedule.cs");

// Events

Event::Attach(eventKillTrak, raynhud::HandleKill);
Event::Attach(eventFlagsUpdated, raynhud::FlagEvent);
Event::Attach(eventFlagCaptured, raynhud::CaptureFlag);
Event::Attach(eventConnected, raynhud::Reset);
Event::Attach(eventDisconnected, raynhud::Reset);
Event::Attach(eventChangeMission, raynhud::Reset);
Event::Attach(eventClientMessage, raynhud::onClientMessage);
Event::Attach(eventClientChangeTeam, raynhud::Teamchange);              
Event::Attach(eventClientDrop, "schedule(\"HUD::Update(plhud);\",1);"); 
Event::Attach(eventClientTeam, "schedule(\"HUD::Update(plhud);\",1);");          


// Kill Events Not Included in KillTrak.cs 
//

KillTrak::DeathMessage("%1 mows down %3 teammate, %2", "Team Kill");
KillTrak::DeathMessage("%1 killed %3 teammate, %2 with a mine.","Team Kill");
KillTrak::DeathMessage("%2 dies.", "Turret"); // v0.7
$raynhuddr::time = "48";

$raynhud::objStr[0] = "<B0,5:rayn\\bmp\\raynObjNu.bmp>";   // init the obj
$raynhud::objStr[1] = "<B0,5:rayn\\bmp\\raynObjFr.bmp>";   // indicator 
$raynhud::objStr[2] = "<B0,5:rayn\\bmp\\raynObjEn.bmp>";   // grafx array

exec(ctfhudsettings);

function raynhud::Reset()
{       
	
        $raynhuddr::tme[0] = 48;
        $raynhuddr::tme[1] = 48;
        $raynhud::wayText = "";		
	$raynhud::haveFlag = 0;
	$raynhud::waypointSet = 0;	
	$raynhud::teamScore[0] = 0;
        $raynhud::teamScore[1] = 0;
        $raynhud::teamPlay[0] = 0;
        $raynhud::teamPlay[1] = 0;
        $raynhud::flagStr[0] = "?";
        $raynhud::flagStr[1] = "?";
        $raynhud::flagStr2[0] = " ";
        $raynhud::flagStr2[1] = " ";
        $raynhud::objStat = 0;
        $raynhud::invStat = ("<f1>R<f0>Y <f1>M <f0>0 <f1>G <f0>0 <f1>B<f0> 0");       
	$raynhud::playKill = 0;
        $raynhud::playDeath = 0;
        $raynhud::playSue = 0;
        $raynhud::playCap = 0;
        $raynhud::playScore = 0;
	$raynhud::flagKills = 0;
	$raynhud::flagReturns = 0;
	raynhud::FlagEvent();
        raynhud::UpHUDS();
        return;
}


function raynhud::Toggle()
{
	HUD::ToggleDisplay(scorehud);
	HUD::ToggleDisplay(plhud);
	HUD::Toggledisplay(flag1hud);
	HUD::ToggleDisplay(flagshud);
	HUD::ToggleDisplay(dmgkillhud);
	HUD::ToggleDisplay(rschud);
	HUD::ToggleDisplay(itemzhud);
	HUD::toggleDisplay(rhobjhud);
	HUD::ToggleDisplay(wayphud);
        %kh = HUD::getDisplayed(killHUD); 
        %hh = HUD::getDisplayed(helpHUD); 
        if (%kh)                          
          HUD::Display(killHUD, false);   
        else                              
          raynhud::UpdateFlag();        
        if (%hh)                         
          HUD::Display(helpHUD, false);   
        else
          raynhud::UpdateFlag();
        return;
}

function raynhud::Init()
{

	// typo prevented moving of hud here        
	// create our huds
	HUD::New(scorehud, raynhud::UpdateScoreHud, $raynhud::startX, $raynhud::startY, 65, 16*$raynhud::showTeamScore);
        HUD::New(plhud, raynhud::PlayerHud, "left(scorehud) bottom(scorehud) 65 18*"@$raynhud::showPlayerCount);
	HUD::New(flag1hud, raynhud::UpdateFlagsHUD, "left(plhud) bottom(plhud) 65 18*"@$raynhud::showFlagStatus);
        HUD::New(flagshud, raynhud::UpdateEnFlagsHUD, "left(plhud) bottom(flag1hud) 65 18*"@$raynhud::showFlagStatus);
        HUD::New(dmgkillhud, raynhud::UpdateKillz, "left(flagshud) bottom(flagshud) 65 18*"@$raynhud::showKills);
        HUD::New(rschud, raynhud::UpdateScrHud, "left(dmgkillhud) bottom(dmgkillhud) 65 18*"@$raynhud::showScore);
        HUD::New(itemzhud, raynhud::UpdateItemHUD, "left(dmgkillhud) bottom(rschud) 65 30*"@$raynhud::showItems);
        HUD::New(rhobjhud, raynhud::rObjHUD, "left(itemzhud) bottom(itemzhud) 65 21*"@$raynhud::showObjective);
	HUD::New(wayphud, raynhud::showwaystat, "left(rhobjhud) bottom(rhobjhud) 65 18*"@$raynhud::showWaypointSetting);
	HUD::New(msgHUD,"raynhud::updateWaypoint","50% 100% 75% 17");     
 	HUD::New(helpHUD,"raynhud::UpdateHH","right(flagshud) top(flagshud) 100 32");  
        HUD::New(killHUD,"raynhud::UpdateKH","left(helpHUD) top(flagshud)-32 100 32");
	HUD::New(frdrophud, "raynhuddr::frFlag", "right(flagshud) bottom(flagshud)-18 45 18");
	HUD::New(nmedrophud, "raynhuddr::nmeFlag", "right(flag1hud) bottom(flag1hud)-18 45 18");
        raynhud::Reset();
      	raynhud::FlagEvent();
        HUD::Display(scorehud);
   	HUD::Display(plhud);
        HUD::Display(flagshud);
 	HUD::Display(flag1hud);
        HUD::Display(rhobjhud);
        HUD::Display(itemzhud);
	HUD::Display(dmgkillhud);
	HUD::Display(rschud);
 	HUD::Display(fkhud);
	HUD::Display(wayphud);
        $raynhuddr::tme[0] = $raynhuddr::time;
        $raynhuddr::tme[1] = $raynhuddr::time;
        raynhuddr::resOur();
        raynhuddr::resNME();
	
        return;
}


// START DROP FLAG STUFF

function raynhuddr::stTime(%var)
{
 if (%var == 0) {
  HUD::Display(frdrophud);
  schedule::Add("raynhuddr::frTmr();",1,"ctffr"); }
 else {
  HUD::Display(nmedrophud);
  schedule::Add("raynhuddr::NMETmr();",1,"ctfnme"); }
}


function raynhuddr::frFlag()
{
  HUD::SetText(frdrophud, "<f2>0:"@$raynhuddr::tme[0]);
  HUD::Display(frdrophud);
}

function raynhuddr::nmeFlag()
{
  HUD::SetText(nmedrophud, "<f2>0:"@$raynhuddr::tme[1]);
  HUD::Display(nmedrophud);
}

function raynhuddr::resOur()
{ 
  Schedule::Cancel(ctffr);
  $raynhuddr::tme[0] = 48;
  HUD::Display(frdrophud, false);
}

function raynhuddr::resNME()
{
  Schedule::Cancel(ctfnme);
  $raynhuddr::tme[1] = 48;
  HUD::Display(nmedrophud, false);
}
function raynhuddr::frTmr()
{
 if ($raynhuddr::tme[0] > 0) {
  // ECHO($raynhuddr::tme[0]);
   $raynhuddr::tme[0]--;
   if ($raynhuddr::tme[0] < 10)
       $raynhuddr::tme[0] = "0"@$raynhuddr::tme[0];
   HUD::Update(frdrophud);
   schedule::Add("raynhuddr::frTmr();","1.0","ctffr"); 
   return; }
 else
    raynhuddr::resOur();
}

function raynhuddr::NMETmr()
{
 if ($raynhuddr::tme[1] > 0) {
  // ECHO("ENEMY TIMER CALLED"@$raynhuddr::tme[1]);
   $raynhuddr::tme[1]--;
    if ($raynhuddr::tme[1] < 10)
       $raynhuddr::tme[1] = "0"@$raynhuddr::tme[1];
   HUD::Update(nmedrophud);
   schedule::add("raynhuddr::NMETmr();","1.0","ctfnme");
   return;}
 else
    raynhuddr::resNME();
}


// END DROP FLAG STUFF

function raynhud::UpdateScrHud()
{
%cor2 = 5;
//HUD::Addtext(rschud, "<f2><b0,4:rayn\\bmp\\raynFlagEn.bmp>:<jc>"@$raynhud::playScore);
HUD::AddText(rschud,"<jl><f2><B0,4:rayn\\bmp\\RaynS.bmp>"@$raynhud::playscore@" <B"@%cor2@",4:rayn\\bmp\\RaynFlagYellow.bmp>"@$raynhud::playcap);
HUD::Display(rschud);
}
function raynhud::UpHUDS()
{
HUD::Update(scorehud);
HUD::Update(plhud);
raynhud::flagEvent();
HUD::Update(rhobjhud);
HUD::Update(itemzhud);
HUD::Update(dmgkillhud);
HUD::Update(rschud);
HUD::Update(wayphud);
}


function raynhud::UpdateKillz()
{
 HUD::Addtext(dmgkillhud,"<f2><b0,4:rayn\\bmp\\raynSkull.bmP>:<jc>" @ 
 $raynhud::playkill @ "<f1>/<f2>" @ $raynhud::playdeath);
 HUD::Display(dmgkillhud);
}
function raynhud::playerhud()
{
 raynhud::checkPlayerCount();
 HUD::AddTexT(plhud, "<f2><b0,4:rayn\\bmp\\raynPlayers.bmp><l3>:<jc><r1>" @ 
 $raynhud::teamPlay[0] @ "<f1>/<f2>" @ $raynhud::teamPlay[1]);
 HUD::Display(plhud);
}


// Safe Schedule Code.
function Schedule::Add(%eval, %time, %tag) {
	//ECHO(%eval@"/"@%time@"/"@%tag);
 	if (%tag == "")
		%tag = %eval;	// Use function as tag if none provided.
	$Schedule::ID[%tag]++;
	$Schedule::eval[%tag] = %eval;
	schedule("Schedule::Exec(\""@escapestring(%tag)@"\", "@$Schedule::ID[%tag]@");", %time);
	}
function Schedule::Exec(%tag, %id) {
	
	if ($Schedule::ID[%tag] != %id)
		return;
	%eval = $Schedule::eval[%tag];
	Schedule::Cancel(%tag);
	eval(%eval);
	}
function Schedule::Cancel(%tag) {
	$Schedule::ID[%tag]++;
	$Schedule::eval[%tag] = "";
	}

function raynhud::checkPlayerCount()
{
 $raynhud::teamPlay[0] = 0;
        $raynhud::teamPlay[1] = 0;

	%ourteam = Client::getTeam(getManagerId());
	// The original code I tried here did not work, this bit of
	// code is inspired by a routine in Dark Ninja's 
	// HyperHud. the original code is below.
        for (%i = 2180; %i > 2048; %i--)
        {
        %team = Client::getTeam(%i);            // Find out which team this player is on.
	if (%ourteam == "-1") {			// new code for obs
	       %ourteam = 0;
	}					// end new code     		
        if (Client::getName(%i) != "")  
           if (%team == %ourteam)     
             $raynhud::teamPlay[0]++; 
           else if (%team > -1)
             $raynhud::teamPlay[1]++;       
        }
}

function raynhud::updateItemHud()
{
 %r = (getItemCount("Repair Kit"));
 %rp = "Y";
 %rb = "rayn\\bmp\\RaynRepKit.bmp";
 %b =  (getItemCount("Beacon"));
 %m =  (getItemCount("Mine"));
 %g =  (getItemCount("Grenade"));

 if (%b) 
    %bb = "rayn\\bmp\\RaynB.bmp"; 
 else
    %bb = "rayn\\bmp\\RaynNoB.bmp";
 if (%m)
    %mb = "rayn\\bmp\\RaynM.bmp";
 else
    %mb = "rayn\\bmp\\RaynNoM.bmp";
 if (%g)
    %gb = "rayn\\bmp\\raynG.bmp";
 else
    %gb = "rayn\\bmp\\raynNoG.bmp";
 %cor="-39";
 %cor2="-2";
 %cor3="-16";
 %cor4="0";
 if (%r == 0)
 { %rp = "N"; 
   %rb = "rayn\\bmp\\RaynNoRepKit.bmp"; }
 if (!$raynhud::version) {
 HUD::AddText(itemzhud,"<jl><f2><B0,4:"@%rb@">"@%rp@" <B"@%cor2@",4:"@%gb@"><jc><l3>"@%g);
 HUD::AddText(itemzhud,"\n<jl><f2><B"@%cor@",4:"@%rb@"><l3>"@%m@" <B"@%cor2@",4:"@%bb@"><jc><l2>"@%b); }
 else {
HUD::AddText(itemzhud,"<f2><B0,4:"@%rb@">"@%rp@" <B"@%cor4@",4:"@%gb@"><l3>"@%g);
 HUD::AddText(itemzhud,"\n<jl><f2><B"@%cor3@",4:"@%mb@"><l3>"@%m@" <B1,4:"@%bb@"><l2>"@%b); }

 HUD::Display(itemzhud);
 return 1;
}

function raynhud::updateScoreHud()
{

  	$raynhud::scorehudtext = "<jl><B0,5:rayn\\bmp\\rayngreen.bmp><jc><f2><r2>" @          $raynhud::teamScore[0] @ "<f1>/<f2>" 
 	@ $raynhud::teamScore[1] @ "<r1><jr><b2,5:rayn\\bmp\\raynred.bmp>"; 

  HUD::AddText(scorehud, $raynhud::scorehudtext);
  HUD::Display(scorehud);
}

function raynhud::robjhud()
{
  HUD::AddText(rhobjhud, "<f2>Obj: " @ $raynhud::objStr[$raynhud::objStat]);
  HUD::Display(rhobjhud);
}

function raynhud::updateFlagshud() {
 %cor = "-16";
 HUD::Addtext(flag1hud, "<jl><f2><r4><b0,4:rayn\\bmp\\raynFlagFr.bmp><l3>:<jr> " @
 $raynhud::flagstr[0]);
 HUD::Display(flag1hud); }

function raynhud::updateEnFlagsHud() {

HUD::Addtext(flagshud, "<f2><r4><b0,4:rayn\\bmp\\raynFlagEn.bmp><l3>:<jr> " @ $raynhud::flagstr[1]);
//HUD::Addtext(flagshud,"<jl><f2><r4><b0,4:rayn\\bmp\\RaynFlagEn.bmp><l3>:<jr>" );
 HUD::Display(flagshud);
 }

function raynhud::SetObj(%t) 
{
if (%t < 1 || %t > 2)
   %t = 0;
$raynhud::objstat = %t;
HUD::Update(rhobjhud);
}

function raynhud::objToggle()
{
 if ($raynhud::objstat == 1)
    raynhud::SetObj(2);
 else if ($raynhud::objstat == 2)
    raynhud::SetObj(1);
}
function raynhud::teamChange(%c)
{
  HUD::Update(plhud);
  if (%c != getManagerId())
    return;
  $raynhud::haveFlag = 0;
  $raynhud::waypointSet = 0;	
  %te = $raynhud::teamScore[0];
  $raynhud::teamScore[0] = $raynhud::teamScore[1];
  $raynhud::teamScore[1] = %te;
  %te = $raynhud::flagStr[0];
  $raynhud::flagStr[0] = $raynhud::flagStr[1];
  $raynhud::flagStr[1] = %te;
  %te = $raynhud::flagStr2[0];
  $raynhud::flagStr2[0] = $raynhud::flagStr2[1];
  $raynhud::flagStr2[1] = %te;   
  // $raynhud::playScore = 0;  // 1.5
  raynhud::objToggle();
  raynhud::UpHUDS();
}
function raynhud::onClientMessage(%client, %msg)
{
        if (%client != 0)  return;
	
	// Detect Objective Events
        if (String::findSubStr(%msg, "objective")) 
	{	
                if (String::findSubStr(%msg, "has taken an objective") != -1) {
		    raynhud::SetObj(1);
		    return; }
                if (String::findSubStr(%msg, "has taken your objective") != -1) {
		    raynhud::SetObj(2);
		    return; }
	}
	
	if (String::FindSubStr(%msg, "You returned the") != -1) {
		$raynhud::flagReturns++;
		HUD::Update(fkhud);
		}

        if (String::findSubStr(%msg, "5 points for holding") != -1) {
                $raynhud::playScore = $raynhud::playscore+5;
		HUD::Update(rschud);
                 }

	// handle inventory changes
	if ((%msg == "Station Access Off") || (%msg == "Resupply Complete") ||
	    (String::findSubStr(%msg, "You received") != -1) || (%msg == "Match started."))
            schedule("HUD::Update(itemzhud);",1);

	// watch for players joining a team
	if (String::findSubStr(%msg, "joined team") != -1)
	   HUD::Update(plhud);

        return;

	
}
// handles some score functions here also
function raynhud::handleKill(%killer, %victim, %weapon)
{
	%me = getManagerId();
    	%fk = getClientByName(Team::GetFlagLocation(Team::Enemy()));
	if(%victim == %me) {
                if (%weapon == "Suicide" || %weapon == "Crushed" || %weapon == "Falling") {
                        $raynhud::playScore--;
    			$raynhud::playDeath++;
			HUD::Update(dmgkillhud);
			HUD::Update(rschud);
			return; }
		else {
                        $raynhud::playDeath++;
			HUD::Update(dmgkillhud);
			return;
		}
	}

        if (%killer == %me) {
                if (%weapon == "Team Kill") {
                        $raynhud::playScore--;
			HUD::Update(dmgkillhud);
			HUD::Update(rschud);
                        return; }
                $raynhud::playKill++;
                $raynhud::playScore++;
		if (%victim == %fk) {
			$raynhud::flagkills++;
			HUD::Update(fkhud);
		}		 
		HUD::Update(dmgkillhud);
		HUD::Update(rschud);
		return;
		}
		HUD::Update(dmgkillhud);
		HUD::Update(rschud);
		return;
		
}


function raynhud::updateWaypoint()
{
HUD::AddText(msgHUD,$raynhud::wayText);
}

function raynhud::targetEnemyFlagCarrier()
{
	
	if ($raynhud::wayToggle != 1) return;
	%taker = Team::GetFlagLocation(Team::Friendly());
	if (%taker == $rayn::target) return;
	%clientId = getClientByName(%taker);
	%msg = "KILL: " @ %taker;
	$rayn::target = %taker;
        remoteEval(2048, "IssueTargCommand", 0, %msg, %clientID - 2048, getManagerId());	
	
}

function raynhud::targetFriendlyFlagCarrier()
{
        if ($raynhud::wayToggle != 2) return;
        %taker = Team::getFlagLocation(Team::Enemy());
	if (%taker == $rayn::target) return;
	%clientId = getClientByName(%taker);
	if (%clientId == getManagerId()) return;
	%msg = "HELP: " @ %taker;
	$rayn::target = %taker;
	remoteEval(2048, "IssueTargCommand", 0, %msg, %clientID - 2048, getManagerId()); 
}

function raynhud::clearWaypoint()
{
	if ($raynhud::clearPoints) return;
	
	if ($raynhud::wayToggle == 1) {
		%t = "Our ";
		%i = Team::getFlagLocatioN(Team::Friendly());
				      }
	if ($raynhud::wayToggle == 2) {
		%t = "Enemy ";
		%i = Team::getFlagLocation(Team::Enemy());
				      }
	if (getClientByName(%i)) return;
	%msg = %t@"flag is at " @ %i;
	if ($raynhud::wayToggle < 1) 
	  %msg = "Auto-Waypointing Off";
	remoteEval(2048, "IssueTargCommand", 0, %msg, getManagerId() - 2048, getManagerId());
}

function raynhud::toggleWaypoint()
{
 
 if (HUD::getDisplayed(msgHud))
     HUD::Display(msgHud,false); 
    
 if ($raynhud::wayToggle==0) {
  $raynhud::wayText = "<jc><f1>Auto-Waypointing Set To Target Enemy Flag Taker";
  $raynhud::wayToggle=1;
  raynhud::targetEnemyFlagCarrier();
  raynhud::showwaystat();
  HUD::Display(msgHUD);
  schedule("HUD::Display(msgHUD,false);",2);
  return;                    }

 if ($raynhud::wayToggle==1) {
  $raynhud::wayText = "<jc><f1>Auto-Waypointing Set to Target Friendly Flag Carrier";
  $raynhud::wayToggle=2;
  raynhud::targetFriendlyFlagCarrier();
  HUD::Display(msgHUD);
  HUD::Update(wayphud);
  schedule("HUD::Display(msgHUD,false);",2);
  return;                    }

 if ($raynhud::wayToggle==2) {
 $raynhud::wayText = "<jc><f1>Auto-Waypointing Off";
 
  HUD::Display(msgHUD);
  schedule("HUD::Display(msgHUD,false);",2);
  raynhud::clearWaypoint();
  $raynhud::wayToggle=0;
  raynhud::showwaystat();
  return; }                                        

}

function raynhud::showwaystat()
{
 
// ECHO("UPDATE CALLED");
// ECHO($raynhud::wayToggle);
 if ($raynhud::wayToggle == 1)
    %g = "<B0,4:rayn\\bmp\\raynflagfr.bmp>";
 if ($raynhud::wayToggle == 2)
    %g = "<B0,4:rayn\\bmp\\raynflagen.bmp>";
 if ($raynhud::wayToggle == 0) { HUD::Display(wayphud,false);return;}
 HUD::SetText(wayphud,"<jc><B0,4:rayn\\bmp\\raynarrow.bmp>"@%g);
 HUD::Display(wayphud, true);
}

function raynhud::FlagEvent()     // handle flag events here
{
  
	%location = Team::GetFlagLocation(Team::Friendly());
        %location2 = Team::GetFlagLocation(Team::Enemy());
	if (Team::Friendly() == "-1") {				// obs code
		%location = Team::GetFlagLocation(0);
		%location2 = Team::GetFlagLocation(1);
        }							// end obs code
	//echo(%location @ %location2);
        if (%location == $Trak::locationHome) {
                $raynhud::flagStr[0] = "<r2><B2,6:rayn\\bmp\\raynSafe.bmp>";
                $raynhud::flagStr2[0] = (" ");
                raynhud::ToggleSubHud(0,0);
                raynhuddr::resNME();
                if ($raynhud::wayToggle == 1) raynhud::clearWaypoint(); 
		}
        else if (%location == $Trak::locationField){
                $raynhud::flagStr[0] = "<r2><B2,6:rayn\\bmp\\raynField.bmp>";
                $raynhud::flagStr2[0] = (" ");
                raynhuddr::stTime(1);
                raynhud::ToggleSubHud(0,0);
        	 if ($raynhud::wayToggle == 1) raynhud::clearWaypoint();                 
}
        else if (%location != "")  {
                $raynhud::flagStr[0] = "<r2><B0,6:rayn\\bmp\\raynKill.bmp>";
                $raynhud::flagStr2[0] = (%location);
                raynhuddr::resNME();
                raynhud::ToggleSubHud(0,1);
                 if ($raynhud::wayToggle == 1) raynhud::TargetEnemyFlagCarrier();
                }
        else {
                $raynhud::flagStr[0] = ("?");
                $raynhud::flagStr2[0] = (" ");
                raynhuddr::resNME();
                raynhud::ToggleSubHud(0,0);
		 if ($raynhud::wayToggle == 1) raynhud::clearWaypoint();
                }
	HUD::Update(flag1hud);
        if (%location2 == $Trak::locationHome) {                          
                $raynhud::flagStr[1] = "<r2><B2,6:rayn\\bmp\\raynSafe.bmp>";
                $raynhud::flagStr2[1] = (" ");
                raynhud::ToggleSubHud(1,0);
                raynhuddr::resOur();
                if ($raynhud::wayToggle == 2) raynhud::clearWaypoint();
	        }
        else if (%location2 == $Trak::locationField){		                             
                $raynhud::flagStr[1] = "<r2><B2,6:rayn\\bmp\\raynField.bmp>";
                $raynhud::flagStr2[1] = (" ");
                raynhuddr::stTime(0);
                raynhud::ToggleSubHud(1,0);
                if ($raynhud::wayToggle == 2) raynhud::clearWaypoint();
		}
        else if (%location2 != "") {
                $raynhud::haveFlag = 1;
	        $raynhud::flagStr[1] = "<r2><B0,6:rayn\\bmp\\raynHelp.bmp>";
                $raynhud::flagStr2[1] = (%location2);
                raynhuddr::resOur();
                raynhud::ToggleSubHud(1,1);              
                if ($raynhud::wayToggle == 2) raynhud::TargetFriendlyFlagCarrier();
		}
        else {
                $raynhud::haveflag = 0;
                $raynhud::flagStr[1] = ("?");
                $raynhud::flagStr2[1] = (" ");
                raynhuddr::resOur();
                raynhud::ToggleSubHud(1,0);
		if ($raynhud::wayToggle == 2) raynhud::clearWaypoint();                
                 }
        HUD::Update(flagshud);
}

function raynhud::UpdateKH()     // update the kill info
{
 HUD::AddText(KillHUD, "<f2>"@$raynhud::flagStr2[0]);
}

function raynhud::UpdateHH()
{
 HUD::AddText(HelpHUD, "<f2>"@$raynhud::flagStr2[1]);
}

function raynhud::toggleSubHUD(%intg, %switch)
{
	if(!$raynhud::showFlagstatus) return;
        if (!(HUD::getDisplayed(flag1hud)))    // if hud not showing, don't
           return;                              // switch on the subhud
        if (%intg == "0")
           %currentHud = killHUD;
        if (%intg == "1")
           %currentHud = helpHUD;
        HUD::Update(%currentHud);

        if (%switch == "0")
           HUD::Display(%currentHud,false);
        if (%switch == "1")
           HUD::Display(%currentHud);
  return;
}



function raynhud::CaptureFlag(%t, %c) // someone cap'd the flag
{                                               // handle it
  %ourteam = Client::getTeam(getManagerId());
  if (%ourteam == "-1") {		// obs code
	%ourteam = 0;
  }					// end obs code
  %team = Client::getTeam(%c);		// v 0.7
  raynhud::clearWaypoint();
  if (%c == getManagerId()) {
     $raynhud::playScore += 5;
     $raynhud::playCap++;
     }
  if (%team == %ourteam) 
     $raynhud::teamScore[0]++;
  else 
     $raynhud::teamScore[1]++;

  HUD::Update(rschud);
  HUD::Update(scorehud);
  HUD::Update(flagshud);
  HUD::Update(flag1hud);
}

function raynhud::AddBanner()
{
	Presto::AddScriptBanner(CTFHUD,
                " <f2>CTFHuD<jr><f0>Version 1.3 <jl>\n" @
		" <jc><f1>Written by:\n" @
		" <f1>Rayn\n" @
		"\n" @
                 "<f0>The Ultimate DynHUD\n" @
                 "<f2>Replacement\n" @
                 "<f1>rayn@planet-tribes.com" @
                 "<f2>WWW.PLANET-TRIBES.COM");
}

function ctfhud::OpenGUI()
{


if ($raynhud::showTeamScore == "0")
	Control::setValue(ctfhud::teamscoreButton, false);
else
	Control::setValue(ctfhud::teamscoreButton, true);

if ($raynhud::showPlayerCount == "0")
	Control::setValue(ctfhud::teamsizeButton, false);
else
	Control::setValue(ctfhud::teamsizeButton, true);

if ($raynhud::showFlagStatus == "0")
	Control::setValue(ctfhud::flagstatusButton, false);
else
	Control::setValue(ctfhud::flagstatusButton, true);

if ($raynhud::showKills == "0")	
	Control::setValue(ctfhud::killsButton, false);
else
	Control::setValue(ctfhud::killsButton, true);

if ($raynhud::showItems == "0")
	Control::setValue(ctfhud::itemsButton, false);
else
	Control::setValue(ctfhud::itemsButton, true);

if ($raynhud::showObjective == "0")
	Control::setValue(ctfhud::objectiveButton, false);
else
	Control::setValue(ctfhud::objectiveButton, true);

if ($raynhud::showScore == "0")
	Control::setValue(ctfhud::scoreButton, false);
else
	Control::setValue(ctfhud::scoreButton, true);

if ($raynhud::showWaypointSetting == "0")
	Control::setValue(ctfhud::waypointButton, false);
else
	Control::setValue(ctfhud::waypointButton, true);

Control::setValue(ctfhud::clearButton, $raynhud::clearPoints);
Control::setValue(ctfhud::versionButton, $raynhud::version);
}

function ctfhud::CloseGUI()
{
echo ("RAYN: Exporting CTFHuD Settings"); 
export("$raynhud::show*","config\\ctfhudsettings.cs",FALSE);
export("$raynhud::clearpoints","config\\ctfhudsettings.cs",TRUE);
export("$raynhud::version","config\\\ctfhudsettings.cs",TRUE);
}

function ctfhud::optionToggle()
{

if (Control::getValue(ctfhud::teamsizeButton))
     	$raynhud::showPlayerCount = 1;
else
 	$raynhud::showPlayerCount = 0;
if (Control::getValue(ctfhud::flagstatusButton))
     	$raynhud::showFlagStatus = 1;
else
 	$raynhud::showFlagStatus  = 0;
if (Control::getValue(ctfhud::killsButton))
     	$raynhud::showKills = 1;
else
 	$raynhud::showKills  = 0;
if (Control::getValue(ctfhud::itemsButton))
     	$raynhud::showItems = 1;
else
 	$raynhud::showItems = 0;
if (Control::getValue(ctfhud::objectiveButton))
     	$raynhud::showObjective = 1;
else
 	$raynhud::showObjective = 0;
if (Control::getValue(ctfhud::scoreButton))
     	$raynhud::showScore = 1;
else
 	$raynhud::showScore = 0;
if (Control::getValue(ctfhud::waypointButton))
     	$raynhud::showWaypointSetting = 1;
else
 	$raynhud::showWaypointSetting = 0;

echo ($raynhud::showPlayerCount);
echo ($raynhud::showFlagStatus);
echo ($raynhud::showKills);
echo ($raynhud::showScore);
echo ($raynhud::showItems);
echo ($raynhud::showObjective);
echo ($raynhud::showWaypointSetting);


   raynhud::init();
}

raynhud::AddBanner();
raynhud::init();
NewOpts::Register("CTFHUD", "config\\rayn\\ctfhud.gui", "ctfhud::OpenGui();", "ctfhud::closeGui();", TRUE);