// .---------------------------------------.
// [** Speed-O-Meter v1.0		   ]
// [** 06.24.00				   ]
// [ By    : Rayn			   ]
// [ E-Mail: rayn@tribalwar.com 	   ]
// [ Site  : http://www.tribalwar.com/rayn ]
// `---------------------------------------'
//
// SERVER SIDE SCRIPT: This only works on a server you host yourself.
// 
// Used to watch your velocity while practicing offline.
//
// Please refer to the readme for usage instructions.
//
//

// CODE BEGINS BELOW:
// ------------------

Include("Presto\\HUD.cs");
Include("presto\\Event.cs");

Event::Attach(eventConnected, rayn::speed::init);
Event::Attach(eventMissionChange, rayn::speed::init);

$rayn::speed::enabled = false;
$rayn::speed::peakSpeed = 0;

function rayn::speed::init()
{
if ($rayn::speed::enabled) {

$rayn::speed::playerID = Client::getOwnedObject(getManagerId());
HUD::New(rayn::speed::speedhud, "rayn::speed::update", "0% 50% 110 36");
HUD::Display(rayn::speed::speedhud, true);

			   }

}

function rayn::speed::update()
{

if ($rayn::speed::enabled)

{

$rayn::speed::playerID = Client::getOwnedObject(getManagerId());

%x = getWord((Item::getVelocity($rayn::speed::playerID)), 0);  
%y = getWord((Item::getVelocity($rayn::speed::playerID)), 1);
%z = getWord((Item::getVelocity($rayn::speed::playerID)), 2);

if (%x < 0)
  %x = (-1)*(%x);
if (%y < 0)
  %y = (-1)*(%y);
if (%z < 0)
  %z = (-1)*(%z);
 
$rayn::speed::speed = sqrt((%x*%x) + (%y*%y) + (%z*%z));    // vector speed equation
$rayn::speed::speed = String::getSubStr($rayn::speed::speed, 0, 4);

if ($rayn::speed::speed > $rayn::speed::peakSpeed)
	$rayn::speed::peakSpeed = $rayn::speed::speed;

HUD::SetText(rayn::speed::speedhud, "<f2>Speed: <f1>" @ $rayn::speed::speed @ " <f2>m/s\n<f2>Max  : <f1>" @ $rayn::speed::peakSpeed @ " <f2>m/s");
HUD::Display(rayn::speed::speedhud);

schedule("HUD::Update(rayn::speed::speedhud);",0.25);

}

}

function rayn::speed::OpenGui()
{
}

function rayn::speed::CloseGui()
{
rayn::speed::init();
}
NewOpts::registerHelp("Speed-O-Meter","(*) DESCRIPTION:\n\n- Server Side Script. Tracks your velocity while you practice offline (hosting your" @ 
" own server). Its displayed in a HUD on the side of your screen.\n\n" @ 
"(*) CONFIGURATION:\n\n- Use NewOpts to set the script up. \n\nNote that this script ONLY WORKS ON" @ 
" SERVERS YOU HOST YOURSELF. I cannot create one that works on other servers because as a client you do " @ 
"not have access to velocity data. \n\nTwo things to set:\n\n* Begin Speed Tracking:  This finds the " @ 
"object that you are on the server. This allows us to track your speed. The script will do this" @ 
" automatically .. but if your speed zeros out for some reason (I have no idea why that would happen) .. " @ 
"then you can hit this key. You really should NOT need to bind this unless you have problems." @ 
"\n\n* Enable Speed-O-Meter: Speed-O-Meter is ALWAYS off by default every time you start Tribes. This is " @ 
"because there is no way for me to tell when you want it on or off, and if you're playing a game" @ 
" online, you can't track your speed anyway and you're going to waste your CPU power tracking the " @ 
"untrackable.\n\nTherefore, if you want to track your speed, go in with NewOpts and check this first. It" @ 
" will last for your entire Tribes session, so if you go to play normal games afterwards, " @ 
"you must uncheck it.");

NewOpts::Register("Speed-O-Meter", "config\\rayn\\speedometer.gui", "rayn::speed::OpenGui();", "rayn::speed::CloseGui();", TRUE);