//	exec("Presto\\Install.cs");
//	Include("NewOpts\\Install.cs");
// Include("Fudge\\TinyCapHUD.cs
//	Include("Fudge\\TinyKillHUD.cs");

$TinyKillHUD::Kills = 0;
$TinyKillHUD::Killed = 0;

if (!$Presto::installed || $Presto::version < 0.93) // Check presto pack is installed.
	echo("TinyKillHUD: requires Presto Pack 0.93 or later.");
else {

function TinyKillHUD::SetDefaults() {
	$FudgePref::TinyKillHUDPos = "0% bottom(TinyCapHUD)-1 40 17";
}

if(isFile("config\\FudgePrefs.cs")) {
	Include("FudgePrefs.cs");
} else {
	TinyKillHUD::SetDefaults();
}

if($FudgePref::TinyKillHUDPos == "") {
	TinyKillHUD::SetDefaults();
}

Include("Presto\\HUD.cs");
Include("Presto\\Event.cs");
Include("Presto\\TeamTrak.cs");

Event::Attach(eventConnected, "TinyKillHUD::Init();");
Event::Attach(eventChangeMission, "TinyKillHUD::Init();");
Event::Attach(eventKillTrak, TinyKillHUD::Kill);

function TinyKillHUD::AddBanner()
{
	Presto::AddScriptBanner(ObjectiveHUD,
		" <f2>TinyKillHUD <jr><f0>version 0.1 <jl>\n" @
		" \n" @
		" <f0>Displays number of <f1>kills<f0> and\n" @
		" <f1>deaths<f0>. Uses <f2>NewOpts<f0>\n" @
		" <f0>by <f1>Zear<f0>.\n" @
		" \n" @
		" \n" @
		" <f0>Written by: <f1>[TNT]Fudge\n" @
		" <f1>fudge@c2i.net");
}
TinyKillHUD::AddBanner();

//
// -- Begin code --
//

function TinyKillHUD::UpdateHUD()
{
	%kills = $TinyKillHUD::Kills;
	%killed = $TinyKillHUD::Killed;

	if( %kills >= %killed ) {
		%icon = "<B0,4:Fudge\\bmp\\small_kills.bmp>";
	} else {
		%icon = "<B0,4:Fudge\\bmp\\small_deaths.bmp>";
	}

	HUD::AddTextLine(TinyKillHUD, "<f1>"@%kills@%icon@%killed);

	return 0;
}

function TinyKillHUD::Kill(%killer, %victim, %weapon) {

	%me = getManagerID();

	if( %victim == %me ) {
		$TinyKillHUD::Killed += 1;
	} else if( %killer == %me ) {
		$TinyKillHUD::Kills += 1;
	}

	HUD::Update(TinyKillHUD);

}

function TinyKillHUD::Init() {
	$TinyKillHUD::Kills = 0;
	$TinyKillHUD::Killed = 0;

	if(HUD::Exists(TinyKillHUD)) {
		HUD::Move(TinyKillHUD, $FudgePref::TinyKillHUDPos );
		HUD::Update(TinyKillHUD);
	} else {
		HUD::New(TinyKillHUD, TinyKillHUD::UpdateHUD, $FudgePref::TinyKillHUDPos );
		HUD::Display(TinyKillHUD);
	}
}
//
// NewOpts
//

function TinyKillHUD::onOpen()
{
	Control::setText("TinyKillHUD::XPos", getWord($FudgePref::TinyKillHUDPos,0));
	Control::setText("TinyKillHUD::YPos", getWord($FudgePref::TinyKillHUDPos,1));
	Control::setText("TinyKillHUD::Width", getWord($FudgePref::TinyKillHUDPos,2));
	Control::setText("TinyKillHUD::Height", getWord($FudgePref::TinyKillHUDPos,3));
}

function TinyKillHUD::onClose()
{
	$FudgePref::TinyKillHUDPos = Control::getText("TinyKillHUD::XPos")@" "@
										  Control::getText("TinyKillHUD::YPos")@" "@
								        Control::getText("TinyKillHUD::Width")@" "@
								        Control::getText("TinyKillHUD::Height");

	if(HUD::Exists(TinyKillHUD))
		HUD::Move(TinyKillHUD, $FudgePref::TinyKillHUDPos);

	export("$FudgePref::*", "config\\FudgePrefs.cs", false);
}

TinyKillHUD::Init();

NewOpts::register("TinyKill HUD", "Fudge\\gui\\KillHUD.gui", "TinyKillHUD::onOpen();", "TinyKillHUD::onClose();", TRUE);
NewOpts::registerHelp("TinyKill HUD", "Positioning", "Read the documentation in Presto's HUD.cs.  This has a more in depth description of how to position HUDs in general.");
NewOpts::registerHelp("TinyKill HUD", "X Pos", "X posistion of the HUD. Examples: 0, 20%, left(TinyCapHUD).");
NewOpts::registerHelp("TinyKill HUD", "Y Pos", "Y posistion of the HUD. Examples: 0, 50%, bottom(TinyKillHUD)-1.");
NewOpts::registerHelp("TinyKill HUD", "Width", "Width of the HUD. Best left at the default value.");
NewOpts::registerHelp("TinyKill HUD", "Height", "Height of the HUD. Best left at the default value.");
NewOpts::registerHelp("TinyKill HUD", "Author", "TinyKillHUD was written by [TNT]Fudge.\nEmail: <f0>fudge@c2i.net<f1>");


} // PrestoPack installed check
