//This is the definitions file for the Poop faves Script.
//You can use this as a template to add in support for mods.
// Remember, the more info you give, the more useful this script is.
//The table file for any given mod should be named
//[MOD NAME].table.cs and be placed in the \Config\Poop\Tables 
//directory.
//One way to get a list of inventory numbers in a given mod, go to an inventory 
//station, and while the station is still active, type in the console screen:
//echo(CmdInventory::getVisibleSet(BuyList));
//This will give you a list of numbers in the same order as the items listed
//available to buy.  There may be better ways to do this, and if there is, please
//be sure and let us know :)

//Insomniax 0.9a

//-----------------------------------------------------------------------------
//                             Various Menu Variables
//-----------------------------------------------------------------------------

//These variables define what the NewOpts menus will look like.

//Variables to define the types of armors for newopts.  Currently, there is 
//support for 10 types of armor classes.  Please note that these must go in 
//the same order as the actual  Inventory Table.  ( i.e. $PoopINV::MenuArmor1
//MUST refer to the same item that $PoopINV::Armor1 does.)
$PoopINV::MaxArmors = 3;
$PoopINV::MenuArmor1 = "LIGHT ARMOR";
$PoopINV::MenuArmor2 = "MEDIUM ARMOR";
$PoopINV::MenuArmor3 = "HEAVY ARMOR";

//Variables to define the special menus.  You shouldnt need to mess with these
$PoopINV::MenuDeployables = "DEPLOYABLES";
$PoopINV::MenuPacks = "PACKS";
$PoopINV::MenuVehicles = "VEHICLES";

//Variables to define the types of packs and deployables for newopts.  Supports
//up to 40 defined packs.  The same rule applies as above.  $PoopINV::MenuNewOptsPack1
//MUST refer to the same item that $PoopINV:NewOpts:Pack1 does.
$PoopINV::MaxPacks = 20;
$PoopINV::MenuNewOptsPack1 = "Energy Pack";
$PoopINV::MenuNewOptsPack2 = "Repair Pack";
$PoopINV::MenuNewOptsPack3 = "Shield Pack";
$PoopINV::MenuNewOptsPack4 = "Sensor Jammer Pack";
$PoopINV::MenuNewOptsPack5 = "Ammo Pack";
$PoopINV::MenuNewOptsPack6 = "Cloaking Device";
$PoopINV::MenuNewOptsPack7 = "Heat Sink";
$PoopINV::MenuNewOptsPack8 = "Rocket Booster";
$PoopINV::MenuNewOptsPack9 = "Vebgeance Missile Pack";
$PoopINV::MenuNewOptsPack10 = "INV Station";
$PoopINV::MenuNewOptsPack11 = "Ammo Station";
$PoopINV::MenuNewOptsPack12 = "Motion Sensor";
$PoopINV::MenuNewOptsPack13 = "Pulse Sensor";
$PoopINV::MenuNewOptsPack14 = "Sensor Jammer";
$PoopINV::MenuNewOptsPack15 = "Camera";
$PoopINV::MenuNewOptsPack16 = "Turret";
$PoopINV::MenuNewOptsPack17 = "Sentry";
$PoopINV::MenuNewOptsPack18 = "Avenger";
$PoopINV::MenuNewOptsPack19 = "Flak Cannon";
$PoopINV::MenuNewOptsPack20 = "Small Force Field";


//Variables to define the types of Weapons for newopts.  Supports up to 35
//different weapons.  Please note that these must go in the same order as the
//actual Inventory Table.  ( i.e. $PoopINV::MenuWeapon1 MUST refer to the same
//item that $PoopINV::Weapon1 does.)
$PoopINV::MaxWeapons = 15;
$PoopINV::MenuWeapon1 = "Blaster";
$PoopINV::MenuWeapon2 = "ChainGun";
$PoopINV::MenuWeapon3 = "Plasma";
$PoopINV::MenuWeapon4 = "Grenade Launcher";
$PoopINV::MenuWeapon5 = "Mortar";
$PoopINV::MenuWeapon6 = "Disc Launcher";
$PoopINV::MenuWeapon7 = "Laser Rifle";
$PoopINV::MenuWeapon8 = "ELF Gun";
$PoopINV::MenuWeapon9 = "Rocket Launcher";
$PoopINV::MenuWeapon10 = "EMP Grenade Launcher";
$PoopINV::MenuWeapon11 = "Mag Gun";
$PoopINV::MenuWeapon12 = "IX-2000 Sniper Rifle";
$PoopINV::MenuWeapon13 = "Pyro Torch";
$PoopINV::MenuWeapon14 = "Shotgun";
$PoopINV::MenuWeapon15 = "Phalanxx Cannon";


//Variables to define the Extra Weapons for newopts.  Most mods do not yet support
//anything other than the targeting laser in this class. However, some do. Heres 
//that rule again... $PoopINV::MenuExtraWeapon1 MUST refer to the same item that
//$PoopINV::ExtraWeapon1 does.
$PoopINV::MaxExtraWeapon = 1;
$PoopINV::MenuExtraWeapon1 = "Targeting Laser";

//-----------------------------------------------------------------------------
//                              SPECIAL FUNCTIONS
//-----------------------------------------------------------------------------

//A few functions in the script require special parameters.
//Fill them in here.

//THROW HEALTH FUNCTION - Just enter the inventory number of the repair pack, 
//or any other pack you feel would be best to drop at an INV.
$PoopINV::RepairPack = "54";

//REPAIR KIT - This is the inventory number of the repair kit or its equivalent.  This will be
//bought automatically every time you enter an Inventory Station.
$PoopINV::RepairKit = "72";

//BUY EXTRA AMMO FUNCTION - Buy the items that are considered extra ammo. 
$PoopINV::ExtraAmmo1 = "20"; // Mortar Ammo
$PoopINV::ExtraAmmo2 = "73"; // Mines
$PoopINV::ExtraAmmo3 = "74"; // Beacons
$PoopINV::ExtraAmmo4 = "75"; // Grenades


//-----------------------------------------------------------------------------
//                             Inventory Table
//-----------------------------------------------------------------------------

//These functions define the inventory numbers for each of the menu items in the NewOpts menus.
//Remember that the comments after each number (ie, Light Armor) are there for convenience only and
//need not be duplicated in a Mod Table.

//ARMORS - Here you will define the inventory numbers for the armor types. Make
//note to remember that these values MUST refer to their counterparts in the 
//menu definitions section. (i.e. $PoopINV::Armor1 should refer to the same
//thing as $PoopINV::MenuArmor1)  Up to 10 armor types are supported.
$PoopINV::Armor1 = "2"; //Light armor
$PoopINV::Armor2 = "3"; //Medium armor
$PoopINV::Armor3 = "4"; //Heavy armor


//PACKS and DEPLOYABLES FOR NEWOPTS - Here you will define the inventory 
//numbers for the pack and deployable types used by the newopts page. Make note
//to remember that these values MUST refer to their counterparts in the menu
//definitions section. (i.e. $PoopINV::NewOptsPack1 should refer to the same
//thing as $PoopINV::NewOptsMenuPack1)  Up to 40 pack types are supported.
$PoopINV::NewOptsPack1 = "53"; //Energy Pack
$PoopINV::NewOptsPack2 = "54"; //RepairPack
$PoopINV::NewOptsPack3 = "55"; //Shield Pack
$PoopINV::NewOptsPack4 = "56"; //Sensor Jammer Pack
$PoopINV::NewOptsPack5 = "58"; //Ammo Pack
$PoopINV::NewOptsPack6 = "67"; //Cloaking Device
$PoopINV::NewOptsPack7 = "68"; //Heat Sink
$PoopINV::NewOptsPack8 = "69"; //Rocket Booster
$PoopINV::NewOptsPack9 = "71"; //Vengeance Missile Pack
$PoopINV::NewOptsPack10 = "51"; //Inventory Station
$PoopINV::NewOptsPack11 = "52"; //Ammo Station
$PoopINV::NewOptsPack12 = "57"; //Motion Sensor
$PoopINV::NewOptsPack13 = "59"; //Pulse Sensor
$PoopINV::NewOptsPack14 = "60"; //Sensor Jammer
$PoopINV::NewOptsPack15 = "61"; //Camera
$PoopINV::NewOptsPack16 = "62"; //Turret
$PoopINV::NewOptsPack17 = "63"; //Sentry
$PoopINV::NewOptsPack18 = "64"; //Avenger
$PoopINV::NewOptsPack19 = "65"; //Flak Cannon
$PoopINV::NewOptsPack20 = "66"; //Small Force Field

//PACKS ONLY - Here you will define the inventory numbers for the pack types.
//Ok, I know...  seems redundant.  But we are using this data to compile a
//separate menu choice in the game ( the packs menu )
$PoopINV::Pack1 = "53"; //Energy Pack
$PoopINV::Pack2 = "54"; //RepairPack
$PoopINV::Pack3 = "55"; //Shield Pack
$PoopINV::Pack4 = "56"; //Sensor Jammer Pack
$PoopINV::Pack5 = "58"; //Ammo Pack
$PoopINV::Pack6 = "67"; //Cloaking Device
$PoopINV::Pack7 = "68"; //Heat Sink
$PoopINV::Pack8 = "69"; //Rocket Booster
$PoopINV::Pack9 = "71"; //Vengeance Missile Pack


//DEPLOYABLES ONLY - Same reason as stated above.  :o)  
$PoopINV::Deployable1 = "51"; //INV Station
$PoopINV::Deployable2 = "52"; //Ammo Station
$PoopINV::Deployable3 = "57"; //Motion Sensor
$PoopINV::Deployable4 = "59"; //Pulse Sensor
$PoopINV::Deployable5 = "60"; //Sensor Jammer
$PoopINV::Deployable6 = "61"; //Camera
$PoopINV::Deployable7 = "62"; //Turret
$PoopINV::Deployable8 = "63"; //Sentry
$PoopINV::Deployable9 = "64"; //Avenger
$PoopINV::Deployable10 = "65"; //Flak Cannon
$PoopINV::Deployable11 = "66"; //Small Force Field


//WEAPONS - Here you will define the inventory numbers for the weapon types.
//Make note to remember that these values MUST refer to their counterparts in the 
//menu definitions section. (i.e. $PoopINV::Weapon1 should refer to the same
//thing as $PoopINV::MenuWeapon1)  Up to 35 weapon types are supported.
$PoopINV::Weapon1 = "13";
$PoopINV::Weapon2 = "15";
$PoopINV::Weapon3 = "17";
$PoopINV::Weapon4 = "19";
$PoopINV::Weapon5 = "21";
$PoopINV::Weapon6 = "23";
$PoopINV::Weapon7 = "24";
$PoopINV::Weapon8 = "26";
$PoopINV::Weapon9 = "29";
$PoopINV::Weapon10 = "31";
$PoopINV::Weapon11 = "32";
$PoopINV::Weapon12 = "34";
$PoopINV::Weapon13 = "39";
$PoopINV::Weapon14 = "41";
$PoopINV::Weapon15 = "48";

//EXTRA WEAPONS - Here you will define the inventory numbers for the weapon types.
//Make note to remember that these values MUST refer to their counterparts in the
//menu definitions section. (i.e. $PoopINV::ExtraWeapon1 should refer to the same
//thing as $PoopINV::MenuExtraWeapon1)  Inifinite extra weapons are allowed.
$PoopINV::ExtraWeapon1 = "23"; //Targeting Laser

//VEHICLES - Here you will define the inventory numbers for the vehicle types.
//Up to 10 vehicle types are supported.
$PoopINV::Vehicle1 = "5"; //Scout
$PoopINV::Vehicle2 = "6"; //LPC
$PoopINV::Vehicle3 = "7"; //FireStorm Bomber
$PoopINV::Vehicle4 = "8"; //HPC
$PoopINV::Vehicle5 = "9"; //Stealth LPC
$PoopINV::Vehicle6 = "";
$PoopINV::Vehicle7 = "";
$PoopINV::Vehicle8 = "";
$PoopINV::Vehicle9 = "";
$PoopINV::Vehicle10 = "";

//-----------------------------------------------------------------------------
//                    Inventory Number to Name conversion
//-----------------------------------------------------------------------------

//Just follow the pattern here that is set for the base menu.  Its pretty 
//simple. Heres what it means:
//	$PoopINV[Inventory Number] = "Inventory Name";


//Armors

$PoopINV::Name[2] = "Light Armor";
$PoopINV::Name[3] = "Medium Armor";
$PoopINV::Name[4] = "HeavyArmor";

//Packs

$PoopINV::Name[53] = "Energy Pack";
$PoopINV::Name[54] = "Repair Pack";
$PoopINV::Name[55] = "Shield Pack";
$PoopINV::Name[56] = "Sensor Jammer Pack";
$PoopINV::Name[58] = "Ammo Pack";
$PoopINV::Name[67] = "Cloaking Device";
$PoopINV::Name[68] = "Heat Sink";
$PoopINV::Name[69] = "Rocket Booster";
$PoopINV::Name[71] = "Vengeance Missile Pack";
$PoopINV::Name[51] = "INV Station";
$PoopINV::Name[52] = "Ammo Station";
$PoopINV::Name[57] = "Motion Sensor";
$PoopINV::Name[59] = "Pulse Sensor";
$PoopINV::Name[60] = "Sensor Jammer";
$PoopINV::Name[61] = "Camera";
$PoopINV::Name[62] = "Turret";
$PoopINV::Name[63] = "Sentry";
$PoopINV::Name[64] = "Avenger";
$PoopINV::Name[65] = "Flak Cannon";
$PoopINV::Name[66] = "Small Force Field";

//Weapons and Ammo

$PoopINV::Name[13] = "Blaster";
$PoopINV::Name[14] = "Bullet";
$PoopINV::Name[15] = "ChainGun";
$PoopINV::Name[16] = "PlasmaBolt";
$PoopINV::Name[17] = "PlasmaGun";
$PoopINV::Name[18] = "GrenadeAmmo";
$PoopINV::Name[19] = "GrenadeLauncher";
$PoopINV::Name[20] = "MortarAmmo";
$PoopINV::Name[21] = "Mortar";
$PoopINV::Name[22] = "Disc";
$PoopINV::Name[23] = "DiscLauncher";
$PoopINV::Name[24] = "LaserRifle";
$PoopINV::Name[25] = "TargetingLaser";
$PoopINV::Name[26] = "ELFGun";
$PoopINV::Name[28] = "Rocket Ammo";
$PoopINV::Name[29] = "Rocket Launcher";
$PoopINV::Name[30] = "EMP Grenade Ammo";
$PoopINV::Name[31] = "EMP Grenade Launcher";
$PoopINV::Name[32] = "Mag Gun";
$PoopINV::Name[33] = "Rifle Ammo";
$PoopINV::Name[34] = "IX-2000 Sniper Rifle";
$PoopINV::Name[38] = "Pyro Charge";
$PoopINV::Name[39] = "Pyro Torch";
$PoopINV::Name[40] = "Shotgun Shells";
$PoopINV::Name[41] = "Shotgun";
$PoopINV::Name[47] = "Phalanxx Ammo";
$PoopINV::Name[48] = "Phalanxx Cannon";

//Vehicles

$PoopINV::Name[5] = "Scout";
$PoopINV::Name[6] = "LPC";
$PoopINV::Name[7] = "FireStorm Bomber";
$PoopINV::Name[8] = "HPC";
$PoopINV::Name[9] = "Stealth LPC";

//Misc

$PoopINV::Name[72] = "Repair Kit";
$PoopINV::Name[73] = "Mine";
$PoopINV::Name[74] = "Beacon";
$PoopINV::Name[75] = "Grenade";

//-----------------------------------------------------------------------------
//              Some stuff you don't really need to mess with
//-----------------------------------------------------------------------------

//Variables to insert menu keybinds
$PoopINV::Bind1 = "1";
$PoopINV::Bind2 = "2";
$PoopINV::Bind3 = "3";
$PoopINV::Bind4 = "4";
$PoopINV::Bind5 = "5";
$PoopINV::Bind6 = "6";
$PoopINV::Bind7 = "7";
$PoopINV::Bind8 = "8";
$PoopINV::Bind9 = "9";
$PoopINV::Bind10 = "0";
$PoopINV::Bind11 = "a";
$PoopINV::Bind12 = "b";
$PoopINV::Bind13 = "c";
$PoopINV::Bind14 = "d";
$PoopINV::Bind15 = "e";
$PoopINV::Bind16 = "f";
$PoopINV::Bind17 = "g";
$PoopINV::Bind18 = "h";
$PoopINV::Bind19 = "i";
$PoopINV::Bind20 = "j";
$PoopINV::Bind21 = "k";
$PoopINV::Bind22 = "l";
$PoopINV::Bind23 = "m";
$PoopINV::Bind24 = "n";
$PoopINV::Bind25 = "o";
$PoopINV::Bind26 = "p";
$PoopINV::Bind27 = "q";
$PoopINV::Bind28 = "r";
$PoopINV::Bind29 = "s";
$PoopINV::Bind30 = "t";
$PoopINV::Bind31 = "u";
$PoopINV::Bind32 = "v";
$PoopINV::Bind33 = "w";
$PoopINV::Bind34 = "x";
$PoopINV::Bind35 = "y";
$PoopINV::Bind36 = "z";
$PoopINV::MaxArmors++;
$PoopINV::MaxWeapons++;
$PoopINV::MaxPacks++;
$PoopINV::MaxExtraWeapon++;