//This is the definitions file for the Poop faves Script.
//You can use this as a template to add in support for mods.
// Remember, the more info you give, the more useful this script is.
//The table file for any given mod should be named
//[MOD NAME].table.cs and be placed in the \Config\Poop\Tables 
//directory.
//One way to get a list of inventory numbers in a given mod, go to an inventory 
//station, and while the station is still active, type in the console screen:
//echo(CmdInventory::getVisibleSet(BuyList));
//This will give you a list of numbers in the same order as the items listed
//available to buy.  There may be better ways to do this, and if there is, please
//be sure and let us know :)

//BASE

//-----------------------------------------------------------------------------
//                             Various Menu Variables
//-----------------------------------------------------------------------------

//These variables define what the NewOpts menus will look like.

//Variables to define the types of armors for newopts.  Currently, there is 
//support for 10 types of armor classes.  Please note that these must go in 
//the same order as the actual  Inventory Table.  ( i.e. $PoopINV::MenuArmor1
//MUST refer to the same item that $PoopINV::Armor1 does.)
$PoopINV::MaxArmors = 3;
$PoopINV::MenuArmor1 = "LIGHT ARMOR";
$PoopINV::MenuArmor2 = "MEDIUM ARMOR";
$PoopINV::MenuArmor3 = "HEAVY ARMOR";

//Variables to define the special menus.  You shouldnt need to mess with these
$PoopINV::MenuDeployables = "DEPLOYABLES";
$PoopINV::MenuPacks = "PACKS";
$PoopINV::MenuVehicles = "VEHICLES";

//Variables to define the types of packs and deployables for newopts.  Supports
//up to 40 defined packs.  The same rule applies as above.  $PoopINV::MenuNewOptsPack1
//MUST refer to the same item that $PoopINV:NewOpts:Pack1 does.
$PoopINV::MaxPacks = 12;
$PoopINV::MenuNewOptsPack1 = "Energy Pack";
$PoopINV::MenuNewOptsPack2 = "Repair Pack";
$PoopINV::MenuNewOptsPack3 = "Shield Pack";
$PoopINV::MenuNewOptsPack4 = "Ammo Pack";
$PoopINV::MenuNewOptsPack5 = "Sensor Jammer Pack";
$PoopINV::MenuNewOptsPack6 = "INV Station";
$PoopINV::MenuNewOptsPack7 = "Ammo Station";
$PoopINV::MenuNewOptsPack8 = "Motion Sensor";
$PoopINV::MenuNewOptsPack9 = "Pulse Sensor";
$PoopINV::MenuNewOptsPack10 = "Sensor Jammer";
$PoopINV::MenuNewOptsPack11 = "Camera";
$PoopINV::MenuNewOptsPack12 = "Turret";


//Variables to define the types of Weapons for newopts.  Supports up to 35
//different weapons.  Please note that these must go in the same order as the
//actual Inventory Table.  ( i.e. $PoopINV::MenuWeapon1 MUST refer to the same
//item that $PoopINV::Weapon1 does.)
$PoopINV::MaxWeapons = 8;
$PoopINV::MenuWeapon1 = "Blaster";
$PoopINV::MenuWeapon2 = "ChainGun";
$PoopINV::MenuWeapon3 = "Plasma";
$PoopINV::MenuWeapon4 = "Grenade Launcher";
$PoopINV::MenuWeapon5 = "MortarGun";
$PoopINV::MenuWeapon6 = "Disc Launcher";
$PoopINV::MenuWeapon7 = "Laser Rifle";
$PoopINV::MenuWeapon8 = "ELF Gun";


//Variables to define the Extra Weapons for newopts.  Most mods do not yet support
//anything other than the targeting laser in this class. However, some do. Heres 
//that rule again... $PoopINV::MenuExtraWeapon1 MUST refer to the same item that
//$PoopINV::ExtraWeapon1 does.
$PoopINV::MaxExtraWeapon = 1;
$PoopINV::MenuExtraWeapon1 = "Targeting Laser";

//-----------------------------------------------------------------------------
//                              SPECIAL FUNCTIONS
//-----------------------------------------------------------------------------

//A few functions in the script require special parameters.
//Fill them in here.

//THROW HEALTH FUNCTION - Just enter the inventory number of the repair pack, 
//or any other pack you feel would be best to drop at an INV.
$PoopINV::RepairPack = "30";

//REPAIR KIT - This is the inventory number of the repair kit or its equivalent.  This will be
//bought automatically every time you enter an Inventory Station.
$PoopINV::RepairKit = "39";

//BUY EXTRA AMMO FUNCTION - Buy the items that are considered extra ammo. 
$PoopINV::ExtraAmmo1 = "18"; // Mortar Ammo
$PoopINV::ExtraAmmo2 = "40"; // Mines
$PoopINV::ExtraAmmo3 = "41"; // Beacons
$PoopINV::ExtraAmmo4 = "42"; // Grenades


//-----------------------------------------------------------------------------
//                             Inventory Table
//-----------------------------------------------------------------------------

//These functions define the inventory numbers for each of the menu items in the NewOpts menus.
//Remember that the comments after each number (ie, Light Armor) are there for convenience only and
//need not be duplicated in a Mod Table.

//ARMORS - Here you will define the inventory numbers for the armor types. Make
//note to remember that these values MUST refer to their counterparts in the 
//menu definitions section. (i.e. $PoopINV::Armor1 should refer to the same
//thing as $PoopINV::MenuArmor1)  Up to 10 armor types are supported.
$PoopINV::Armor1 = "2"; //Light armor
$PoopINV::Armor2 = "3"; //Medium armor
$PoopINV::Armor3 = "4"; //Heavy armor


//PACKS and DEPLOYABLES FOR NEWOPTS - Here you will define the inventory 
//numbers for the pack and deployable types used by the newopts page. Make note
//to remember that these values MUST refer to their counterparts in the menu
//definitions section. (i.e. $PoopINV::NewOptsPack1 should refer to the same
//thing as $PoopINV::NewOptsMenuPack1)  Up to 40 pack types are supported.
$PoopINV::NewOptsPack1 = "29"; //Energy Pack
$PoopINV::NewOptsPack2 = "30"; //RepairPack
$PoopINV::NewOptsPack3 = "31"; //Shield Pack
$PoopINV::NewOptsPack4 = "34"; //AmmoPack
$PoopINV::NewOptsPack5 = "32"; //Sensor Jammer pack
$PoopINV::NewOptsPack6 = "27"; //INV Station
$PoopINV::NewOptsPack7 = "28"; //Ammo Station
$PoopINV::NewOptsPack8 = "33"; //Motion Sensor
$PoopINV::NewOptsPack9 = "35"; //Pulse Sensor
$PoopINV::NewOptsPack10 = "36"; //Sensor Jammer
$PoopINV::NewOptsPack11 = "37"; //Camera
$PoopINV::NewOptsPack12 = "38"; //Turret


//PACKS ONLY - Here you will define the inventory numbers for the pack types.
//Ok, I know...  seems redundant.  But we are using this data to compile a
//separate menu choice in the game ( the packs menu )
$PoopINV::Pack1 = "29"; //Energy Pack
$PoopINV::Pack2 = "30"; //RepairPack
$PoopINV::Pack3 = "31"; //Shield Pack
$PoopINV::Pack4 = "34"; //AmmoPack
$PoopINV::Pack5 = "32"; //Sensor Jammer pack


//DEPLOYABLES ONLY - Same reason as stated above.  :o)  
$PoopINV::Deployable1 = "27"; //INV Station
$PoopINV::Deployable2 = "28"; //Ammo Station
$PoopINV::Deployable3 = "33"; //Motion Sensor
$PoopINV::Deployable4 = "35"; //Pulse Sensor
$PoopINV::Deployable5 = "36"; //Sensor Jammer
$PoopINV::Deployable6 = "37"; //Camera
$PoopINV::Deployable7 = "38"; //Turret



//WEAPONS - Here you will define the inventory numbers for the weapon types.
//Make note to remember that these values MUST refer to their counterparts in the 
//menu definitions section. (i.e. $PoopINV::Weapon1 should refer to the same
//thing as $PoopINV::MenuWeapon1)  Up to 35 weapon types are supported.
$PoopINV::Weapon1 = "11"; //Blaster
$PoopINV::Weapon2 = "13"; //ChainGun
$PoopINV::Weapon3 = "15"; //Plasma Gun
$PoopINV::Weapon4 = "17"; //Grenade Launcher
$PoopINV::Weapon5 = "19"; //Mortar
$PoopINV::Weapon6 = "21"; //Disc Launcher
$PoopINV::Weapon7 = "22"; //Laser Rifle
$PoopINV::Weapon8 = "24"; //Elf Gun

//EXTRA WEAPONS - Here you will define the inventory numbers for the weapon types.
//Make note to remember that these values MUST refer to their counterparts in the
//menu definitions section. (i.e. $PoopINV::ExtraWeapon1 should refer to the same
//thing as $PoopINV::MenuExtraWeapon1)  Inifinite extra weapons are allowed.
$PoopINV::ExtraWeapon1 = "23"; //Targeting Laser

//VEHICLES - Here you will define the inventory numbers for the vehicle types.
//Up to 10 vehicle types are supported.
$PoopINV::Vehicle1 = "5"; //Scout
$PoopINV::Vehicle2 = "6"; //LPC
$PoopINV::Vehicle3 = "7"; //HPC
$PoopINV::Vehicle4 = "";
$PoopINV::Vehicle5 = "";
$PoopINV::Vehicle6 = "";
$PoopINV::Vehicle7 = "";
$PoopINV::Vehicle8 = "";
$PoopINV::Vehicle9 = "";
$PoopINV::Vehicle10 = "";

//-----------------------------------------------------------------------------
//                    Inventory Number to Name conversion
//-----------------------------------------------------------------------------

//Just follow the pattern here that is set for the base menu.  Its pretty 
//simple. Heres what it means:
//	$PoopINV[Inventory Number] = "Inventory Name";


//Armors

$PoopINV::Name[2] = "Light Armor";
$PoopINV::Name[3] = "Medium Armor";
$PoopINV::Name[4] = "HeavyArmor";

//Packs

$PoopINV::Name[27] = "INV Station";
$PoopINV::Name[28] = "Ammo Station";
$PoopINV::Name[29] = "Energy Pack";
$PoopINV::Name[30] = "Repair Pack";
$PoopINV::Name[31] = "Shield Pack";
$PoopINV::Name[32] = "Sensor Jammer Pack";
$PoopINV::Name[33] = "Motion Sensor";
$PoopINV::Name[34] = "Ammo Pack";
$PoopINV::Name[35] = "Pulse Sensor";
$PoopINV::Name[36] = "Sensor Jammer";
$PoopINV::Name[37] = "Camera";
$PoopINV::Name[38] = "Turret";

//Weapons and Ammo

$PoopINV::Name[11] = "Blaster";
$PoopINV::Name[12] = "Bullet";
$PoopINV::Name[13] = "Chain Gun";
$PoopINV::Name[14] = "Plasma Bolt";
$PoopINV::Name[15] = "Plasma Gun";
$PoopINV::Name[16] = "Grenade Ammo";
$PoopINV::Name[17] = "Grenade Launcher";
$PoopINV::Name[18] = "Mortar Ammo";
$PoopINV::Name[19] = "Mortar";
$PoopINV::Name[20] = "Disc";
$PoopINV::Name[21] = "Disc Launcher";
$PoopINV::Name[22] = "Laser Rifle";
$PoopINV::Name[23] = "Targeting Laser";
$PoopINV::Name[24] = "ELF Gun";
$PoopINV::Name[25] = "Repair Gun";

//Vehicles

$PoopINV::Name[5] = "Scout";
$PoopINV::Name[6] = "LPC";
$PoopINV::Name[7] = "HPC";

//Misc

$PoopINV::Name[39] = "Repair Kit";
$PoopINV::Name[40] = "Mine";
$PoopINV::Name[41] = "Beacon";
$PoopINV::Name[42] = "Grenade";

//-----------------------------------------------------------------------------
//              Some stuff you don't really need to mess with
//-----------------------------------------------------------------------------

//Variables to insert menu keybinds
$PoopINV::Bind1 = "1";
$PoopINV::Bind2 = "2";
$PoopINV::Bind3 = "3";
$PoopINV::Bind4 = "4";
$PoopINV::Bind5 = "5";
$PoopINV::Bind6 = "6";
$PoopINV::Bind7 = "7";
$PoopINV::Bind8 = "8";
$PoopINV::Bind9 = "9";
$PoopINV::Bind10 = "0";
$PoopINV::Bind11 = "a";
$PoopINV::Bind12 = "b";
$PoopINV::Bind13 = "c";
$PoopINV::Bind14 = "d";
$PoopINV::Bind15 = "e";
$PoopINV::Bind16 = "f";
$PoopINV::Bind17 = "g";
$PoopINV::Bind18 = "h";
$PoopINV::Bind19 = "i";
$PoopINV::Bind20 = "j";
$PoopINV::Bind21 = "k";
$PoopINV::Bind22 = "l";
$PoopINV::Bind23 = "m";
$PoopINV::Bind24 = "n";
$PoopINV::Bind25 = "o";
$PoopINV::Bind26 = "p";
$PoopINV::Bind27 = "q";
$PoopINV::Bind28 = "r";
$PoopINV::Bind29 = "s";
$PoopINV::Bind30 = "t";
$PoopINV::Bind31 = "u";
$PoopINV::Bind32 = "v";
$PoopINV::Bind33 = "w";
$PoopINV::Bind34 = "x";
$PoopINV::Bind35 = "y";
$PoopINV::Bind36 = "z";
$PoopINV::MaxArmors++;
$PoopINV::MaxWeapons++;
$PoopINV::MaxPacks++;
$PoopINV::MaxExtraWeapon++;