//This is the definitions file for the Poop faves Script.
//You can use this as a template to add in support for mods.
//Remember, the more info you give, the more useful this script is.
//The table file for any given mod should be named
//[MOD NAME].table.cs and be placed in the \Config\Poop\Tables 
//directory.
//One way to get a list of inventory numbers in a given mod, go to an inventory 
//station, and while the station is still active, type in the console screen:
//echo(CmdInventory::getVisibleSet(BuyList));
//This will give you a list of numbers in the same order as the items listed
//available to buy.  There may be better ways to do this, and if there is, please
//be sure and let us know :)

//RENEGADES

//-----------------------------------------------------------------------------
//                             Various Menu Variables
//-----------------------------------------------------------------------------

//These variables define what the NewOpts menus will look like.

//Variables to define the types of armors for newopts.  Currently, there is 
//support for 10 types of armor classes.  Please note that these must go in 
//the same order as the actual  Inventory Table.  ( i.e. $PoopINV::MenuArmor1
//MUST refer to the same item that $PoopINV::Armor1 does.)
$PoopINV::MaxArmors = 8;
$PoopINV::MenuArmor1 = "SCOUT";
$PoopINV::MenuArmor2 = "SPY";
$PoopINV::MenuArmor3 = "SNIPER";
$PoopINV::MenuArmor4 = "MERCENARY";
$PoopINV::MenuArmor5 = "BURSTER";
$PoopINV::MenuArmor6 = "ENGINEER";
$PoopINV::MenuArmor7 = "ALIEN";
$PoopINV::MenuArmor8 = "CYBORG";


//Variables to define the special menus.  You shouldnt need to mess with these
$PoopINV::MenuDeployables = "DEPLOYABLES";
$PoopINV::MenuPacks = "PACKS";
$PoopINV::MenuVehicles = "VEHICLES";


//Variables to define the types of packs for newopts.  Supports up to 40 
//defined packs.  The same rule applies as above.  $PoopINV::MenuNewOptsPack1 MUST
//refer to the same item that $PoopINV::NewOptsPack1 does.
$PoopINV::MaxPacks = 38;
$PoopINV::MenuNewOptsPack1 = "Energy Pack";
$PoopINV::MenuNewOptsPack2 = "Repair Pack";
$PoopINV::MenuNewOptsPack3 = "Shield Pack";
$PoopINV::MenuNewOptsPack4 = "Sensor Jammer Pack";
$PoopINV::MenuNewOptsPack5 = "Cloaking Device";
$PoopINV::MenuNewOptsPack6 = "StealthShield Pack";
$PoopINV::MenuNewOptsPack7 = "Regeneration Pack";
$PoopINV::MenuNewOptsPack8 = "Lightning Pack";
$PoopINV::MenuNewOptsPack9 = "Cybernetic Laser";
$PoopINV::MenuNewOptsPack10 = "Auto-Rocket Cannon";
$PoopINV::MenuNewOptsPack11 = "Command Laptop";
$PoopINV::MenuNewOptsPack12 = "Suicide DetPack";
$PoopINV::MenuNewOptsPack13 = "Ammo Pack";
$PoopINV::MenuNewOptsPack14 = "INV Station";
$PoopINV::MenuNewOptsPack15 = "Ammo Station";
$PoopINV::MenuNewOptsPack16 = "Command Station";
$PoopINV::MenuNewOptsPack17 = "Motion Sensor";
$PoopINV::MenuNewOptsPack18 = "Pulse Sensor";
$PoopINV::MenuNewOptsPack19 = "Sensor Jammer";
$PoopINV::MenuNewOptsPack20 = "Camera";
$PoopINV::MenuNewOptsPack21 = "Ion Turret";
$PoopINV::MenuNewOptsPack22 = "Laser Turret";
$PoopINV::MenuNewOptsPack23 = "Shock Turret";
$PoopINV::MenuNewOptsPack24 = "Mortar Turret";
$PoopINV::MenuNewOptsPack25 = "Plasma Turret";
$PoopINV::MenuNewOptsPack26 = "Vulcan Turret";
$PoopINV::MenuNewOptsPack27 = "Rail Turret";
$PoopINV::MenuNewOptsPack28 = "Missile Turret";
$PoopINV::MenuNewOptsPack29 = "Force Field";
$PoopINV::MenuNewOptsPack30 = "Large Force Field";
$PoopINV::MenuNewOptsPack31 = "Blast Wall";
$PoopINV::MenuNewOptsPack32 = "Hologram";
$PoopINV::MenuNewOptsPack33 = "Mechanical Tree";
$PoopINV::MenuNewOptsPack34 = "Springboard";
$PoopINV::MenuNewOptsPack35 = "Deployable Platform";
$PoopINV::MenuNewOptsPack36 = "Teleport Pad";
$PoopINV::MenuNewOptsPack37 = "Interceptor Pack";
$PoopINV::MenuNewOptsPack38 = "StealthHPC";


//Variables to define the types of Weapons for newopts.  Supports up to 35
//different weapons.  Please note that these must go in the same order as the
//actual Inventory Table.  ( i.e. $PoopINV::MenuWeapon1 MUST refer to the same
//item that $PoopINV::Weapon1 does.)
$PoopINV::MaxWeapons = 20;
$PoopINV::MenuWeapon1 = "Blaster";
$PoopINV::MenuWeapon2 = "Chaingun";
$PoopINV::MenuWeapon3 = "Plasma Gun";
$PoopINV::MenuWeapon4 = "Grenade Launcher";
$PoopINV::MenuWeapon5 = "Mortar";
$PoopINV::MenuWeapon6 = "Disc Launcher";
$PoopINV::MenuWeapon7 = "Laser Rifle";
$PoopINV::MenuWeapon8 = "Hyper Blaster";
$PoopINV::MenuWeapon9 = "Rocket Launcher";
$PoopINV::MenuWeapon10 = "Sniper Rifle";
$PoopINV::MenuWeapon11 = "Dart Rifle";
$PoopINV::MenuWeapon12 = "Magnum";
$PoopINV::MenuWeapon13 = "Shockwave Cannon";
$PoopINV::MenuWeapon14 = "Railgun";
$PoopINV::MenuWeapon15 = "Vulcan";
$PoopINV::MenuWeapon16 = "Flame Thrower";
$PoopINV::MenuWeapon17 = "Ion Rifle";
$PoopINV::MenuWeapon18 = "Omega Cannon";
$PoopINV::MenuWeapon19 = "Thunderbolt";
$PoopINV::MenuWeapon20 = "Engineer Repair-Gun";

//Variables to define the Extra Weapons for newopts.  Most mods do not yet support
//anything other than the targeting laser in this class. However, some do. Heres 
//that rule again... $PoopINV::MenuExtraWeapon1 MUST refer to the same item that
//$PoopINV::ExtraWeapon1 does.
$PoopINV::MaxExtraWeapon = 1;
$PoopINV::MenuExtraWeapon1 = "Targeting Laser";

//-----------------------------------------------------------------------------
//                              SPECIAL FUNCTIONS
//-----------------------------------------------------------------------------


//A few functions in the script require special parameters.
//Fill them in here.

//THROW HEALTH FUNCTION - Just enter the inventory number of the repair pack, 
//or any other pack you feel would be best to drop at an INV.
$PoopINV::RepairPack = "57";

//REPAIR KIT - This is the inventory number of the repair kit or its equivalent.  This will be
//bought automatically every time you enter an Inventory Station.
$PoopINV::RepairKit = "93";

//BUY EXTRA AMMO FUNCTION - Buy the items that are considered extra ammo. 
$PoopINV::ExtraAmmo1 = "94"; // Mines
$PoopINV::ExtraAmmo2 = "96"; // Beacons
$PoopINV::ExtraAmmo3 = "95"; // Grenades
$PoopINV::ExtraAmmo4 = "25"; // Mortar Ammo


//-----------------------------------------------------------------------------
//                             Inventory Table
//-----------------------------------------------------------------------------

//These functions define the inventory numbers for each of the menu items in the NewOpts menus.

//ARMORS - Here you will define the inventory numbers for the armor types. Make
//note to remember that these values MUST refer to their counterparts in the 
//menu definitions section. (i.e. $PoopINV::Armor1 should refer to the same
//thing as $PoopINV::MenuArmor1)  Up to 10 armor types are supported.
$PoopINV::Armor1 = "2";
$PoopINV::Armor2 = "3";
$PoopINV::Armor3 = "4";
$PoopINV::Armor4 = "5";
$PoopINV::Armor5 = "6";
$PoopINV::Armor6 = "7";
$PoopINV::Armor7 = "8";
$PoopINV::Armor8 = "9";


//PACKS and DEPLOYABLES FOR NEWOPTS - Here you will define the inventory 
//numbers for the pack and deployable types used by the newopts page. Make note
//to remember that these values MUST refer to their counterparts in the menu
//definitions section. (i.e. $PoopINV::NewOptsPack1 should refer to the same
//thing as $PoopINV::NewOptsMenuPack1)  Up to 40 pack types are supported.
$PoopINV::NewOptsPack1 = "56";
$PoopINV::NewOptsPack2 = "57";
$PoopINV::NewOptsPack3 = "58";
$PoopINV::NewOptsPack4 = "59";
$PoopINV::NewOptsPack5 = "60";
$PoopINV::NewOptsPack6 = "61";
$PoopINV::NewOptsPack7 = "62";
$PoopINV::NewOptsPack8 = "63";
$PoopINV::NewOptsPack9 = "64";
$PoopINV::NewOptsPack10 = "65";
$PoopINV::NewOptsPack11 = "68";
$PoopINV::NewOptsPack12 = "69";
$PoopINV::NewOptsPack13 = "71";
$PoopINV::NewOptsPack14 = "53";
$PoopINV::NewOptsPack15 = "54";
$PoopINV::NewOptsPack16 = "55";
$PoopINV::NewOptsPack17 = "70";
$PoopINV::NewOptsPack18 = "72";
$PoopINV::NewOptsPack19 = "73";
$PoopINV::NewOptsPack20 = "74";
$PoopINV::NewOptsPack21 = "75";
$PoopINV::NewOptsPack22 = "76";
$PoopINV::NewOptsPack23 = "77";
$PoopINV::NewOptsPack24 = "78";
$PoopINV::NewOptsPack25 = "79";
$PoopINV::NewOptsPack26 = "80";
$PoopINV::NewOptsPack27 = "81";
$PoopINV::NewOptsPack28 = "82";
$PoopINV::NewOptsPack29 = "83";
$PoopINV::NewOptsPack30 = "84";
$PoopINV::NewOptsPack31 = "85";
$PoopINV::NewOptsPack32 = "86";
$PoopINV::NewOptsPack33 = "87";
$PoopINV::NewOptsPack34 = "88";
$PoopINV::NewOptsPack35 = "89";
$PoopINV::NewOptsPack36 = "90";
$PoopINV::NewOptsPack37 = "91";
$PoopINV::NewOptsPack38 = "92";


//PACKS ONLY - Here you will define the inventory numbers for the pack types.
//Ok, I know...  seems redundant.  But we are using this data to compile a
//separate menu choice in the game ( the packs menu )
$PoopINV::Pack1 = "56";
$PoopINV::Pack2 = "57";
$PoopINV::Pack3 = "58";
$PoopINV::Pack4 = "59";
$PoopINV::Pack5 = "60";
$PoopINV::Pack6 = "61";
$PoopINV::Pack7 = "62";
$PoopINV::Pack8 = "63";
$PoopINV::Pack9 = "64";
$PoopINV::Pack10 = "65";
$PoopINV::Pack11 = "68";
$PoopINV::Pack12 = "69";
$PoopINV::Pack13 = "71";


//DEPLOYABLES ONLY - Same reason as stated above.  :o) 
$PoopINV::Deployable1 = "53";
$PoopINV::Deployable2 = "54";
$PoopINV::Deployable3 = "55";
$PoopINV::Deployable4 = "70";
$PoopINV::Deployable5 = "72";
$PoopINV::Deployable6 = "73";
$PoopINV::Deployable7 = "74";
$PoopINV::Deployable8 = "75";
$PoopINV::Deployable9 = "76";
$PoopINV::Deployable10 = "77";
$PoopINV::Deployable11 = "78";
$PoopINV::Deployable12 = "79";
$PoopINV::Deployable13 = "80";
$PoopINV::Deployable14 = "81";
$PoopINV::Deployable15 = "82";
$PoopINV::Deployable16 = "83";
$PoopINV::Deployable17 = "84";
$PoopINV::Deployable18 = "85";
$PoopINV::Deployable19 = "86";
$PoopINV::Deployable20 = "87";
$PoopINV::Deployable21 = "88";
$PoopINV::Deployable22 = "89";
$PoopINV::Deployable23 = "90";
$PoopINV::Deployable24 = "91";
$PoopINV::Deployable25 = "92";


//WEAPONS - Here you will define the inventory numbers for the weapon types.
//Make note to remember that these values MUST refer to their counterparts in the 
//menu definitions section. (i.e. $PoopINV::Weapon1 should refer to the same
//thing as $PoopINV::MenuWeapon1)  Up to 35 weapon types are supported.
$PoopINV::Weapon1 = "18";
$PoopINV::Weapon2 = "20";
$PoopINV::Weapon3 = "22";
$PoopINV::Weapon4 = "24";
$PoopINV::Weapon5 = "26";
$PoopINV::Weapon6 = "28";
$PoopINV::Weapon7 = "29";
$PoopINV::Weapon8 = "31";
$PoopINV::Weapon9 = "33";
$PoopINV::Weapon10 = "35";
$PoopINV::Weapon11 = "37";
$PoopINV::Weapon12 = "39";
$PoopINV::Weapon13 = "40";
$PoopINV::Weapon14 = "42";
$PoopINV::Weapon15 = "44";
$PoopINV::Weapon16 = "45";
$PoopINV::Weapon17 = "46";
$PoopINV::Weapon18 = "47";
$PoopINV::Weapon19 = "49";
$PoopINV::Weapon20 = "51";

//EXTRA WEAPONS - Here you will define the inventory numbers for the weapon types.
//Make note to remember that these values MUST refer to their counterparts in the
//menu definitions section. (i.e. $PoopINV::ExtraWeapon1 should refer to the same
//thing as $PoopINV::MenuExtraWeapon1)  Inifinite extra weapons are allowed.
$PoopINV::ExtraWeapon1 = "50"; //Targeting Laser

//VEHICLES - Here you will define the inventory numbers for the vehicle types.
//Up to 10 vehicle types are supported.
$PoopINV::Vehicle1 = "10";
$PoopINV::Vehicle2 = "11";
$PoopINV::Vehicle3 = "12";
$PoopINV::Vehicle4 = "13";
$PoopINV::Vehicle5 = "14";
$PoopINV::Vehicle6 = "";
$PoopINV::Vehicle7 = "";
$PoopINV::Vehicle8 = "";
$PoopINV::Vehicle9 = "";
$PoopINV::Vehicle10 = "";


//-----------------------------------------------------------------------------
//                    Inventory Number to Name conversion
//-----------------------------------------------------------------------------


//Just follow the pattern here that is set for the base menu.  Its pretty 
//simple. Heres what it means:
//	$PoopINV[Inventory Number] = "Inventory Name";


//Armors
$PoopINV::Name[2] = "Scout";
$PoopINV::Name[3] = "Spy";
$PoopINV::Name[4] = "Sniper";
$PoopINV::Name[5] = "Mercenary";
$PoopINV::Name[6] = "Burster";
$PoopINV::Name[7] = "Engineer";
$PoopINV::Name[8] = "Alien";
$PoopINV::Name[9] = "Cyborg";


//Packs
$PoopINV::Name[53] = "Inventory Station";
$PoopINV::Name[54] = "Ammo Station";
$PoopINV::Name[55] = "Command Station";
$PoopINV::Name[56] = "Energy Pack";
$PoopINV::Name[57] = "Repair Pack";
$PoopINV::Name[58] = "Shield Pack";
$PoopINV::Name[59] = "Sensor Jammer Pack";
$PoopINV::Name[60] = "Cloaking Device";
$PoopINV::Name[61] = "StealthShield Pack";
$PoopINV::Name[62] = "Regeneration Pack";
$PoopINV::Name[63] = "Lightning Pack";
$PoopINV::Name[64] = "Cybernetic Laser";
$PoopINV::Name[65] = "Auto-Rocket Cannon";
$PoopINV::Name[68] = "Command Laptop";
$PoopINV::Name[69] = "Suicide DetPack";
$PoopINV::Name[70] = "Motion Sensor";
$PoopINV::Name[71] = "Ammo Pack";
$PoopINV::Name[72] = "Pulse Sensor";
$PoopINV::Name[73] = "Sensor Jammer";
$PoopINV::Name[74] = "Camera";
$PoopINV::Name[75] = "Ion Turret";
$PoopINV::Name[76] = "Laser Turret";
$PoopINV::Name[77] = "Shock Turret";
$PoopINV::Name[78] = "Mortar Turret";
$PoopINV::Name[79] = "Plasma Turret";
$PoopINV::Name[80] = "Vulcan Turret";
$PoopINV::Name[81] = "Rail Turret";
$PoopINV::Name[82] = "Missile Turret";
$PoopINV::Name[83] = "Force Field";
$PoopINV::Name[84] = "Large Force Field";
$PoopINV::Name[85] = "Blast Wall";
$PoopINV::Name[86] = "Hologram";
$PoopINV::Name[87] = "Mechanical Tree";
$PoopINV::Name[88] = "Springboard";
$PoopINV::Name[89] = "Deployable Platform";
$PoopINV::Name[90] = "Teleport Pad";
$PoopINV::Name[91] = "Interceptor Pack";
$PoopINV::Name[92] = "StealthHPC";


//Weapons and Ammo
$PoopINV::Name[18] = "Blaster";
$PoopINV::Name[19] = "Bullet";
$PoopINV::Name[20] = "Chaingun";
$PoopINV::Name[21] = "Plasma Bolt";
$PoopINV::Name[22] = "Plasma Gun";
$PoopINV::Name[23] = "Grenade Ammo";
$PoopINV::Name[24] = "Grenade Launcher";
$PoopINV::Name[25] = "Mortar Ammo";
$PoopINV::Name[26] = "Mortar";
$PoopINV::Name[27] = "Disc";
$PoopINV::Name[28] = "Disc Launcher";
$PoopINV::Name[29] = "Laser Rifle";
$PoopINV::Name[31] = "Hyper Blaster";
$PoopINV::Name[32] = "Rockets";
$PoopINV::Name[33] = "Rocket Launcher";
$PoopINV::Name[34] = "Sniper Bullet";
$PoopINV::Name[35] = "Sniper Rifle";
$PoopINV::Name[36] = "Poison Dart";
$PoopINV::Name[37] = "Dart Rifle";
$PoopINV::Name[38] = "Magnum Bullets";
$PoopINV::Name[39] = "Magnum";
$PoopINV::Name[40] = "Shockwave Cannon";
$PoopINV::Name[41] = "Railgun Bolt";
$PoopINV::Name[42] = "Railgun";
$PoopINV::Name[43] = "Vulcan Bullets";
$PoopINV::Name[44] = "Vulcan";
$PoopINV::Name[45] = "Flame Thrower";
$PoopINV::Name[46] = "Ion Rifle";
$PoopINV::Name[47] = "Omega Cannon";
$PoopINV::Name[49] = "Thunderbolt";
$PoopINV::Name[50] = "Targeting Laser";
$PoopINV::Name[51] = "Engineer Repair-Gun";


//Vehicles
$PoopINV::Name[10] = "Scout";
$PoopINV::Name[11] = "Wraith";
$PoopINV::Name[12] = "Interceptor";
$PoopINV::Name[13] = "Bomber LPC";
$PoopINV::Name[14] = "Stealth HPC";


//Misc
$PoopINV::Name[93] = "Repair Kit";
$PoopINV::Name[94] = "Mine";
$PoopINV::Name[95] = "Grenade";
$PoopINV::Name[96] = "Beacon";


//-----------------------------------------------------------------------------
//              Some stuff you don't really need to mess with
//-----------------------------------------------------------------------------


//Variables to insert menu keybinds
$PoopINV::Bind1 = "1";
$PoopINV::Bind2 = "2";
$PoopINV::Bind3 = "3";
$PoopINV::Bind4 = "4";
$PoopINV::Bind5 = "5";
$PoopINV::Bind6 = "6";
$PoopINV::Bind7 = "7";
$PoopINV::Bind8 = "8";
$PoopINV::Bind9 = "9";
$PoopINV::Bind10 = "0";
$PoopINV::Bind11 = "a";
$PoopINV::Bind12 = "b";
$PoopINV::Bind13 = "c";
$PoopINV::Bind14 = "d";
$PoopINV::Bind15 = "e";
$PoopINV::Bind16 = "f";
$PoopINV::Bind17 = "g";
$PoopINV::Bind18 = "h";
$PoopINV::Bind19 = "i";
$PoopINV::Bind20 = "j";
$PoopINV::Bind21 = "k";
$PoopINV::Bind22 = "l";
$PoopINV::Bind23 = "m";
$PoopINV::Bind24 = "n";
$PoopINV::Bind25 = "o";
$PoopINV::Bind26 = "p";
$PoopINV::Bind27 = "q";
$PoopINV::Bind28 = "r";
$PoopINV::Bind29 = "s";
$PoopINV::Bind30 = "t";
$PoopINV::Bind31 = "u";
$PoopINV::Bind32 = "v";
$PoopINV::Bind33 = "w";
$PoopINV::Bind34 = "x";
$PoopINV::Bind35 = "y";
$PoopINV::Bind36 = "z";
$PoopINV::MaxArmors++;
$PoopINV::MaxWeapons++;
$PoopINV::MaxPacks++;
$PoopINV::MaxExtraWeapon++;