//Stripped.cs
//This is the Stripped File Loader.
//If you are wondering where your prefs went, they now reside entirely in the
//StrippedPrefs.cs file.  Make any changes you want there.

//Need to get rid of that pesky intro
$Pref::SkipIntro = "TRUE";

$Stripped::Current = "1.21";
function Stripped::Install() {
	if(IsFile("Config\\Stripped.vol")) { 
		newObject("Stripped", SimVolume, "Stripped.vol");
		//Load the scheduler now
		newObject(ConsoleScheduler, SimConsoleScheduler);
		if(isFile("Config\\StrippedPrefs.cs")) { 
			exec("StrippedPrefs.cs");
			if($Stripped::Current != $Stripped::Version && $Stripped::Installed == "TRUE") {
				schedule("GuiPushDialog(MainWindow, \"StrippedDLG.gui\");", 10);
				if($Stripped::Version < 1.1) {
					$Stripped::Text = "<JC><F2>New Stripped Detected.\n\n<JL><F1>A new version of stripped has been installed.  This version has had some major modifications and your old preferences stored in StrippedPrefs.cs could not be carried over.  Your old StrippedPrefs.cs has been renamed to StrippedPrefs.cs.bak for recovery purposes. Please read the new StrippedPrefs.cs thoroughly as there are some important changes.";
				}
				else {
					$Stripped::Text = "<JC><F2>New Stripped Detected.\n\n<JL><F1>A new version of stripped has been installed.  Press OK to close Tribes, and open up StrippedPrefs.cs for details on additions and improvements.";
				}
				File::Copy("config\\StrippedPrefs.cs", "config\\StrippedPrefs.cs.bak");
				schedule("Control::SetValue(Stripped::dlgText, $Stripped::Text);", 10.1);
				$Stripped::dlgOK = "quit();";
				exec("MakePrefs.cs");
			}
			else if(!$Stripped::Installed) {
				//Force the proper 3d sound drivers since Tribes likes to default
				//to Aureal3d when the config folder is empty.
				$pref::useAureal3D = "false";
				$pref::useDSound = "true";
				schedule("GuiPushDialog(MainWindow, \"StrippedDLG.gui\");", 10);
				$Stripped::Text = "<JC><F2>Warning!\n\n<JL><F1>Stripped has not been installed properly.  You may continue with your game, but be aware that the StrippedPrefs.cs file has an error in it.";
				schedule("Control::SetValue(Stripped::dlgText, $Stripped::Text);", 10.1);
			}
		}
		else {
			schedule("GuiPushDialog(MainWindow, \"StrippedDLG.gui\");", 10);
			$Stripped::Text = "<JC><F2>First Time Installation\n\n<JL><F1>Thank you for downloading and installing Stripped.  A new preferences file has been generated in your config folder with the name \"StrippedPrefs.cs\".  Please open this with notepad and read the instructions provided inside.  Press <F2>OK<F1> to close Tribes.";
			schedule("Control::SetValue(Stripped::dlgText, $Stripped::Text);", 10.1);
			$Stripped::dlgOK = "quit();";
			exec("MakePrefs.cs");
		}
	}
	else { 
		echo("----------------------------------------------------------------------------------");
		echo("Stripped.vol not found!!! Stripped has NOT been installed.");
		echo("----------------------------------------------------------------------------------");
	}
}
Stripped::Install();

function Stripped::DialogResult(%btn) {
	if($Stripped::dlg[%btn] != "") { eval($Stripped::dlg[%btn]); }
	else { GuiPopDialog(MainWindow, 1); }
}