//Yap
//Hopefully allows you to say things easier

//Let's re-create all the Tribes Chat messages.. I like this version
//better than the default green text provided by tribes. It's also a 
//heck of a way to implement my new menuing system.  This version does 
//everything the default chat menu does... only better.


function Yap::TeamChat(%menu, %key, %title, %message, %wav) {
	if(%wav != "") {
		%message = %message@"~w"@%wav;
	}
	%function = "Say(1, \""@%message@"\");";
	MS::AddChoice(%menu, %key, %title, %function);
}

function Yap::GlobalChat(%menu, %key, %title, %message, %wav) {
	if(%wav != "") {
		%message = %message@"~w"@%wav;
	}
	%function = "Say(0, \""@%message@"\");";
	MS::AddChoice(%menu, %key, %title, %function);
}

function Yap::Local(%menu, %key, %title, %wav) {
	%function = "localMessage("@%wav@");";
	MS::AddChoice(%menu, %key, %title, %function);
}

function Yap::Animate(%menu, %key, %title, %anim, %wav) {
	if(%wav != "") { %function = "remoteEval(2048,playAnimWav,"@%anim@","@%wav@");"; }
	else {%function = "remoteEval(2048,playAnimWav,"@%anim@");"; }	
	MS::AddChoice(%menu, %key, %title, %function);
}


//Create the master Menu
MS::NewMenu("Chat Menu");

//Create the Offense Menu and add it to the main menu
MS::NewMenu("Offense");
MS::AddMenu("Chat Menu", "v", "Offense");

//Populate the Offense Menu
Yap::TeamChat("Offense", "a", "Attack", "Attack!", "attack");
Yap::TeamChat("Offense", "w", "Wait for my signal to attack.", "Wait for my signal to attack.", "waitsig");
Yap::TeamChat("Offense", "c", "Cease fire!", "Cease fire!", "cease");
Yap::TeamChat("Offense", "m", "Move out!", "Move out!", "moveout");
Yap::TeamChat("Offense", "r", "Retreat!", "Retreat!", "retreat");
Yap::TeamChat("Offense", "h", "Hit the deck!", "Hit the deck!", "hitdeck");
Yap::TeamChat("Offense", "e", "Regroup!", "Regroup!", "regroup");
Yap::TeamChat("Offense", "v", "Cover me!", "Cover me!", "coverme");
Yap::TeamChat("Offense", "g", "Going offense.", "Going offense", "ono");
Yap::TeamChat("Offense", "z", "APC Ready...", "APC ready to go.  Waiting for passengers..", "waitpas");
Yap::TeamChat("Offense", "o", "Go on the offensive.", "Go on the offensive!", "gooff");
Yap::TeamChat("Offense", "j", "Capture the objective!", "Capture the objective!", "capobj");
Yap::TeamChat("Offense", "t", "Get the objective!", "Get the objective!", "getobj");
Yap::TeamChat("Offense", "b", "Attack the enemy base!", "Attack the enemy base!", "attbase");
Yap::TeamChat("Offense", "n", "Attack the enemy!", "Attack the enemy!", "attenem");

//Create the Target Menu and add it to the main menu
MS::NewMenu("Target");
MS::AddMenu("Chat Menu", "t", "Target");

//Populate the Target Menu
Yap::TeamChat("Target", "a", "Target acquired.", "Target acquired.", "tgtacq");
Yap::TeamChat("Target", "f", "Fire on my target.", "Fire on my target.", "firetgt");
Yap::TeamChat("Target", "n", "I need a target.", "I need a target.", "needtgt");
Yap::TeamChat("Target", "o", "Target out of range.", "Target out of range.", "tgtout");
Yap::TeamChat("Target", "d", "Destroy enemy generator.", "Destroy enemy generator.", "desgen");
Yap::TeamChat("Target", "e", "Enemy generator destroyed", "Enemy generator destroyed", "gendes");
Yap::TeamChat("Target", "t", "Destroy enemy turret.", "Destroy enemy turret.", "destur");
Yap::TeamChat("Target", "s", "Enemy turret destroyed.", "Enemy turret destroyed.", "turdes");
Yap::TeamChat("Target", "l", "Target location.", "Target location.", "tgtobj");

//Create the Target Menu and add it to the main menu
MS::NewMenu("Defense");
MS::AddMenu("Chat Menu", "d", "Defense");

//Populate the Defense Menu
Yap::TeamChat("Defense", "i", "Incoming Enemies!", "Incoming Enemies!", "incom2");
Yap::TeamChat("Defense", "a", "We're being attacked!", "We're being attacked!", "basatt");
Yap::TeamChat("Defense", "e", "The enemy is attacking our base!", "The enemy is attacking our base!", "basundr");
Yap::TeamChat("Defense", "n", "We need more defense!", "We need more defense!", "needdef");
Yap::TeamChat("Defense", "t", "Our base has been taken!", "Our base has been taken!", "basetkn");
Yap::TeamChat("Defense", "c", "Our base is secure", "Our base is secure", "bsclr2");
Yap::TeamChat("Defense", "q", "Is our base clear?", "Is our base clear?", "isbsclr");
Yap::TeamChat("Defense", "g", "Go on the defensive.", "Go on the defensive.", "godef");
Yap::TeamChat("Defense", "d", "Defending our base.", "Defending our base.", "defend");
Yap::TeamChat("Defense", "o", "Defend the objective.", "Defend the objective.", "defobj");

//Create the Flag Menu and add it to the main menu
MS::NewMenu("Flag");
MS::AddMenu("Chat Menu", "f", "Flag");

//Populate the Flag Menu
Yap::TeamChat("Flag", "g", "Our flag is not in the base!", "Our flag is not in the base!", "flgtkn1");
Yap::TeamChat("Flag", "e", "The enemy has our flag!", "The enemy has our flag!", "flgtkm2");
Yap::TeamChat("Flag", "h", "I have the enemy flag, heading back to our base.", "I have the enemy flag, heading back to our base.", "haveflg");
Yap::TeamChat("Flag", "s", "Our flag is secure.", "Our flag is secure.", "flaghm");
Yap::TeamChat("Flag", "r", "Return our flag to our base.", "Return our flag to our base.", "retflag");
Yap::TeamChat("Flag", "f", "Get the enemy flag!", "Get the enemy flag!", "geteflg");
Yap::TeamChat("Flag", "m", "Our flag is mined.", "Our flag is mined.", "flgmine");
Yap::TeamChat("Flag", "c", "Clear the mines from our flag!", "Clear the mines from our flag!", "clrflg");
Yap::TeamChat("Flag", "d", "Mines have been cleared.", "Mines have been cleared.", "mineclr");
Yap::TeamChat("Flag", "n", "Mine the flag.", "Mine the flag.", "mineflg");
Yap::TeamChat("Flag", "o", "Our objective is mined." ,"Our objective is mined.", "mineobj");
Yap::TeamChat("Flag", "l", "Clear the mines from our objective.", "Clear the mines from our objective.", "clrobj");

//Create the Need Menu and add it to the main menu
MS::NewMenu("Need");
MS::AddMenu("Chat Menu", "r", "Need");

//Populate the Need Menu
Yap::TeamChat("Need", "r", "Need repairs.", "Need repairs.", "needrep");
Yap::TeamChat("Need", "a", "I need an APC pickup.", "I need an APC pickup.", "needpku");
Yap::TeamChat("Need", "e", "I need an escort back to base.", "I need an escort back to base.", "needesc");
Yap::TeamChat("Need", "t", "Can anyone bring me some ammo?", "Can anyone bring me some ammo?", "needamo");
Yap::Local("Need", "h", "Hurry up with that station!", "hurystn");

//Create the Need Menu and add it to the main menu
MS::NewMenu("Team");
MS::AddMenu("Chat Menu", "e", "Team");

//Populate the Team Menu
Yap::TeamChat("Team", "w", "Watch Shooting.", "Watch where you're shooting!", "wshoot3");
Yap::TeamChat("Team", "d", "Don't know", "I don't know.", "dontkno");
Yap::TeamChat("Team", "n", "No.", "No.", "no");
Yap::TeamChat("Team", "y", "Yes.", "Yes.", "yes");
Yap::TeamChat("Team", "t", "Thanks.", "Thanks.", "thanks");
Yap::TeamChat("Team", "a", "No problem.", "No problem.", "noprob");
Yap::TeamChat("Team", "s", "Sorry.", "Sorry.", "sorry");
Yap::Local("Team", "h", "Hurry up at that station.", "hurystn");

//Create the Need Menu and add it to the main menu
MS::NewMenu("Global");
MS::AddMenu("Chat Menu", "g", "Global");

//Populate the Global Menu
Yap::GlobalChat("Global", "z", "Doh!", "Doh!", "oops1");
Yap::GlobalChat("Global", "o", "Oops!", "Oops!", "oops2");
Yap::GlobalChat("Global", "s", "Shazbot!", "Shazbot!", "color2");
Yap::GlobalChat("Global", "q", "Damnit!", "Damnit!", "color6");
Yap::GlobalChat("Global", "c", "Crap!", "Crap!", "color7");
Yap::GlobalChat("Global", "e", "Duh!", "Duh!", "dsgst1");
Yap::GlobalChat("Global", "x", "You idiot!", "You idiot!", "dsgst2");
Yap::GlobalChat("Global", "n", "No.", "No.", "no");
Yap::GlobalChat("Global", "y", "Yes.", "Yes.", "yes");
Yap::GlobalChat("Global", "d", "I don't know.", "I don't know.", "dontkno");
Yap::GlobalChat("Global", "t", "Thanks.", "Thanks.", "thanks");
Yap::GlobalChat("Global", "a", "No problem.", "No problem.", "noprob");
Yap::GlobalChat("Global", "h", "Hi.", "Hi.", "hello");
Yap::GlobalChat("Global", "b", "Bye.", "Bye.", "bye");

//Create the Need Menu and add it to the main menu
MS::NewMenu("Animations");
MS::AddMenu("Chat Menu", "a", "Animations");

//Populate the Animation Menu
Yap::Animate("Animations", "o", "Over Here", "0", "ovrhere");
Yap::Animate("Animations", "d", "Move out of the way.", "1", "outway");
Yap::Animate("Animations", "r", "Retreat", "2", "retreat");
Yap::Animate("Animations", "s", "Stop", "3", "dsgst4");
Yap::Animate("Animations", "f", "Salute", "4", "yes");
Yap::Animate("Animations", "z", "Kneel Pose", "10");
Yap::Animate("Animations", "x", "Stand Pose", "11");
Yap::Animate("Animations", "q", "Celebrate 1", "5", "cheer1");
Yap::Animate("Animations", "e", "Celebrate 2", "6", "cheer2");
Yap::Animate("Animations", "w", "Celebrate 3", "7", "cheer3");
Yap::Animate("Animations", "v", "Taunt 1 - How'd that feel?", "8", "taunt10");
Yap::Animate("Animations", "g", "Taunt 2 - Come get some", "9", "taunt4");
Yap::Animate("Animations", "h", "Wave - Hi", "12", "hello");
Yap::Animate("Animations", "b", "Wave - Bye", "12", "bye");


keybind($Yap::Key, "MS::Display(\"Chat Menu\");", "", "", $Yap::Device, "Yap");