//PoopAutoMessges 0.85
//Auto-Messaging functions for your team.
//
//By: MrPoop

include("Presto\\Say.cs");
include("Presto\\Match.cs");
include("NewOpts\\MoreString.cs");

if(isfile("Config\\PoopAutoChatPrefs.cs"))
{
	include("PoopAutoChatPrefs.cs");
}
else
{
	$PoopAutoChatPref::UnitDisabled = "TRUE";
	$PoopAutoChatPref::UnitDisabledMsg = "Stations need repairs!";
	$PoopAutoChatPref::PowerDown = "TRUE";
	$PoopAutoChatPref::PowerDownMsg = "Repair our Generators!";
	$PoopAutoChatPref::Repair = "TRUE";
	$PoopAutoChatPref::RepairMsg1 = "Fixing !name.";
	$PoopAutoChatPref::RepairMsg2 = "!name has been patched.";
	$PoopAutoChatPref::TD = "TRUE";
	$PoopAutoChatPref::TDMsg1 = "Watch Where your shooting, !name!";
	$PoopAutoChatPref::TDMsg2 = "Sorry about that !name.";
	$PoopAutoChatPref::TDMine = "TRUE";
	$PoopAutoChatPref::TDMineMsg = "Be careful of my mines, !name.";
	$PoopAutoChatPref::FlagTaken = "TRUE";
	$PoopAutoChatPref::FlagTakenMsg = "!name has taken our flag!";
	$PoopAutoChatPref::FlagGrabbed = "TRUE";
	$PoopAutoChatPref::FlagGrabbedMsg = "!name is bringin' home the bacon!";
	$PoopAutoChatPref::BeingRepaired = "TRUE";
	$PoopAutoChatPref::BeingRepairedMsg = "Thanks for the repairs, !name";	
}

newObject(PoopAutoChat, SimVolume, "poop\\PoopAutoChat.vol");

function PoopAutoChat::AddBanner()
{
	Presto::AddScriptBanner(PoopAutoChat,
		"<B3,4:AutoChatPresto.bmp>");
}

PoopAutoChat::AddBanner();

Event::Attach(eventClientMessage, PoopAutoChat::Parse);

function PoopAutoChat::Parse(%cl, %msg)
{
	echo(%cl);
	if(%cl != 0)
	{
		return;
	}
	if(String::FindSubStr(%msg, "Unit is disabled") != -1 && $PoopAutoChatPref::UnitDisabled == "TRUE")
	{
		if(Flood::Protect(PoopAutoChat::StationDown, 10))
		{
			Say::Team(needRepairs, $PoopAutoChatPref::UnitDisabledMsg);
		}
	}
	else if(String::findSubstr(%msg, "Unit is not powered") != -1 && $PoopAutoChatPref::PowerDown == "TRUE")
	{
		echo("Unit not powered has been triggered");
		if(Flood::Protect(PoopAutoChat::PowerDown, 10))
		{
			Say::Team(needRepairs, $PoopAutoChatPref::PowerDownMsg);
		}
	}
	else if(String::findSubStr(%msg, "Repairing") != -1 && $PoopAutoChatPref::Repair == "TRUE")
	{
		$PoopAutoChat::Repairing = String::getSubStr(%msg, 10, 1000);
		if(GetClientByName($PoopAutoChat::Repairing) != 0)
		{
			return;
		}
		else if(Flood::Protect(PoopAutoChat::Repairing, 10))
		{
			say(1, String::replace($PoopAutoChatPref::RepairMsg1, "!name", $PoopAutoChat::Repairing));
		}
		return mute;
	}
	else if(String::findSubStr(%msg, "Repair Done") != -1 && $PoopAutoChatPref::Repair == "TRUE")
	{
		say(1, String::replace($PoopAutoChatPref::RepairMsg2, "!name", $PoopAutoChat::Repairing));
		return mute;
	}
	else if(Match::String(%msg, "You took Friendly Fire from *!") && $PoopAutoChatPref::TD == "TRUE")
	{
		if(Flood::Protect(PoopAutoChat::TDYou, 10))
		{
			Say::Team(sayHey, String::replace($PoopAutoChatPref::TDMsg1, "!name", Match::Result(0)));
		}
		return mute;
	}
	else if(Match::String(%msg, "You just harmed Teammate * with your mine!"))
	{
		if(Flood::Protect(PoopAutoChat::TDMine, 10))
		{
			Say::Team(sayHeyy, String::replace($PoopAutoChatPref::TDMineMsg, "!name", Match::Result(0)));
		}
		return mute;
	}
	else if(Match::String(%msg, "You just harmed Teammate *!") && $PoopAutoChatPref::TD == "TRUE")
	{
		if(Flood::Protect(PoopAutoChat::TDMe, 10))
		{
			Say::Team(saySorry, String::replace($PoopAutoChatPref::TDMsg2, "!name", Match::Result(0)));
		}
		return mute;
	}
	else if(String::findSubStr(%msg, "our team's flag has been taken.")!=-1 && $PoopAutoChatPref::FlagTaken == "TRUE")
	{
		%location = Team::GetFlagLocation(Team::Friendly());
		Say::Team(flagreturn, String::Replace($PoopAutoChatPref::FlagTakenMsg, "!name", %location));
		return mute;
	}
	else if(String::findSubStr(%msg, "our team has the")!=-1 && $PoopAutoChatPref::FlagGrabbed == "TRUE")
	{
		%location = Team::GetFlagLocation(Team::Enemy());
		if(%location == Client::GetName(GetManagerID()))
			return;
		Say::Team(yellWoohoo, String::Replace($PoopAutoChatPref::FlagGrabbedMsg, "!name", %location));
		return mute;
	}
	else if(Match::String(%msg, "Being repaired by *.") && $PoopAutoChatPref::BeingRepaired == "TRUE")
	{
		if(Flood::Protect(PoopAutoChat::BeingRepaired, 30))
		{
			Say::Team(sayThanks, String::Replace($PoopAutoChatPref::BeingRepairedMsg, "!name", Match::Result(0)));
		}
		return mute;
	}
}

NewOpts::register("PoopAutoChat", "PoopAutoChat.gui", "PoopAutoChat::OnOpen();", "PoopAutoChat::OnClose();", TRUE);
NewOpts::registerHelp("PoopAutoChat", "General", "OK, pretty self explanatory.  One neat trick.  For the messages you want to use the name of the object/player for, simply type \"!name\" wherever you want it to appear in the text.  Pretty snazzy.");
Newopts::registerHelp("PoopAutoChat", "Everything else...", "The following items are self explanatory.  Meaning they speak for themselves.  Read them.  Understand them.  It is probable that the list will grow over time.  Just remember to insert !name wherever you want the object\\players name inserted.");
function PoopAutoChat::OnOpen()
{
	Control::Setvalue("PoopAutoChat::01", "<B0,0:AutoChat01.bmp>");
	Control::Setvalue("PoopAutoChat::02", "<B0,0:AutoChat02.bmp>");
	Control::Setvalue("PoopAutoChat::03", "<B0,0:AutoChat03.bmp>");
	Control::Setvalue("PoopAutoChat::04", "<B0,0:AutoChat04.bmp>");
	Control::SetValue("PoopAutoChat::DisabledMsg", $PoopAutoChatPref::UnitDisabledMsg);
	Control::SetValue("PoopAutoChat::PowerDownMsg", $PoopAutoChatPref::PowerDownMsg);
	Control::SetValue("PoopAutoChat::RepairMsg1", $PoopAutoChatPref::RepairMsg1);//
	Control::SetValue("PoopAutoChat::RepairMsg2", $PoopAutoChatPref::RepairMsg2);
	Control::SetValue("PoopAutoChat::TDMsg1", $PoopAutoChatPref::TDMsg1);
	Control::SetValue("PoopAutoChat::TDMsg2", $PoopAutoChatPref::TDMsg2);
	Control::SetValue("PoopAutoChat::TDMineMsg", $PoopAutoChatPref::TDMineMsg);
	Control::SetValue("PoopAutoChat::FlagTakenMsg", $PoopAutoChatPref::FlagTakenMsg);
	Control::SetValue("PoopAutoChat::FlagGrabbedMsg", $PoopAutoChatPref::FlagGrabbedMsg);
	Control::SetValue("PoopAutoChat::BeingRepairedMsg", $PoopAutoChatPref::BeingRepairedMsg);
}

function PoopAutoChat::OnClose()
{
	$PoopAutoChatPref::UnitDisabledMsg = Control::GetValue("PoopAutoChat::DisabledMsg");
	$PoopAutoChatPref::PowerDownMsg = Control::GetValue("PoopAutoChat::PowerDownMsg");
	$PoopAutoChatPref::RepairMsg1 = Control::GetValue("PoopAutoChat::RepairMsg1");
	$PoopAutoChatPref::RepairMsg2 = Control::GetValue("PoopAutoChat::RepairMsg2");
	$PoopAutoChatPref::TDMsg1 = Control::GetValue("PoopAutoChat::TDMsg1");
	$PoopAutoChatPref::TDMsg2 = Control::GetValue("PoopAutoChat::TDMsg2");
	$POopAutoChatPref::TDMineMsg = Control::GetValue("PoopAutoChat::TDMineMsg");
	$PoopAutoChatPref::FlagTakenMsg = Control::GetValue("PoopAutoChat::FlagTakenMsg");
	$PoopAutoChatPref::FlagGrabbedMsg = Control::GetValue("PoopAutoChat::FlagGrabbedMsg");
	$PoopAutoChatPref::BeingRepairedMsg = Control::GetValue("PoopAutoChat::BeingRepairedMsg");
	export("$PoopAutoChatPref::*", "config\\PoopAutoChatPrefs.cs", false);
}
