function StaticShape::onPower(%this,%power,%generator) { if (%power) GameBase::playSequence(%this,0,"power"); else GameBase::stopSequence(%this,0); }
function StaticShape::onEnabled(%this) { if (GameBase::isPowered(%this)) GameBase::playSequence(%this,0,"power"); }
function StaticShape::onDisabled(%this) { GameBase::stopSequence(%this,0); }
function StaticShape::onDestroyed(%this) { GameBase::stopSequence(%this,0); StaticShape::objectiveDestroyed(%this); calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 2, 0.40, 0.1, 250, 100); }
function StaticShape::packUp(%this,%pos,%client,%player) {}
function StaticShape::onDamage(%this,%type,%value,%pos,%vec,%mom,%object) { %damageLevel = GameBase::getDamageLevel(%this); %dValue = %damageLevel + %value; %this.lastDamageObject = %object; %objTeam = GameBase::getTeam(%object); %thisTeam = GameBase::getTeam(%this); %this.lastDamageTeam = %objTeam; %name = GameBase::getDataName(%this); if(%thisTeam == %objTeam) { if(%name.className == Generator || %name.className == Station) { %TDS = $Server::TeamDamageScale; %dValue = %damageLevel + %value * %TDS; %disable = GameBase::getDisabledDamage(%this); if(!$Server::TourneyMode && %dValue > %disable - 0.05) { if(%damageLevel > %disable - 0.05) return; else %dValue = %disable - 0.05; } } } %stateThen = GameBase::getDamageState(%this); GameBase::setDamageLevel(%this,%dValue); if((%objectName = Client::getName(%object)) != "") { %stateNow = GameBase::getDamageState(%this); if((%stateNow == Destroyed) && (%stateThen != Destroyed)) { if(%thisTeam == %objTeam) { if((%name == DeployableTurret) || (%name == CameraTurret) || (%name == DeployableAvenger) || (%name == DeployableSentry) || (%name == DeployableSentinel) || (%name == DeployableDecimator)  || (%name == DeployableFlak) || (%name == DeployableForceField)) { %mapName = GameBase::getMapName(%this); %start = String::findSubStr(%mapName,": "); %end = String::findSubStr(%mapName," ."); %start += 2; %ownerName = String::getSubStr(%mapName, %start, %end-%start); if(%ownerName != Client::getName(%object)) { messageTeam(%object, 0, Client::getName(%object) @ " destroyed one of our " @ %name @ "'s Deployed by " @ %ownerName @ "."); } } } else if((%name == Generator) || (%name == PortGenerator) || (%name == SolarPanel)) { %pwr = GameBase::isPowered(%this); if((!%pwr) && ($ixRepairTeam[%thisTeam] != %objTeam)) { schedule("ixCheckPowerObjective(" @ %object @ "," @ %thisTeam @ "," @ $ixTeamPower[%thisTeam]++ @ ",1);",60); } } } } }
function ixCheckPowerObjective(%client, %team, %powerChange, %type) { if($ixTeamPower[%team] == %powerChange) { if(%type) { if(GameBase::getTeam(%client) != %team) { %client.score+=3; Game::refreshClientScore(%client); Client::sendMessage(%client, 0, "You receive 3 points for Destroying the Enemy's Power!"); messageTeamExcept(%client, 0, Client::getName(%client) @ " received 3 points for Destroying the Enemy's Power!"); } } else if(GameBase::getTeam(%client) == %team) { %client.score+=3; Game::refreshClientScore(%client); Client::sendMessage(%client, 0, "You receive 3 points for Restoring your Team's Power!"); messageTeamExcept(%client, 0, Client::getName(%client) @ " received 3 points for Restoring your Team's Power!"); } } }

function messageTeam(%client, %color, %msg) { %team = Client::getTeam(%client); %numPlayers = getNumClients(); for(%i = 0; %i < %numPlayers; %i++) { %cl = getClientByIndex(%i); %now = Client::getTeam(%cl); if(%team == %now) { Client::sendMessage(%cl,%color,%msg); } } }
function messageTeamExcept(%client, %color, %msg) { %team = Client::getTeam(%client); %numPlayers = getNumClients(); for(%i = 0; %i < %numPlayers; %i++) { %cl = getClientByIndex(%i); %now = Client::getTeam(%cl); if((%team == %now) && (%cl != %client)) { Client::sendMessage(%cl,%color,%msg); } } }
function messageEnemy(%client, %color, %msg) { %team = Client::getTeam(%client); %numPlayers = getNumClients(); for(%i = 0; %i < %numPlayers; %i++) { %cl = getClientByIndex(%i); %now = Client::getTeam(%cl); if(%team != %now) { Client::sendMessage(%cl,%color,%msg); } } }

function StaticShape::shieldDamage(%this,%type,%value,%pos,%vec,%mom,%object) { %damageLevel = GameBase::getDamageLevel(%this); %this.lastDamageObject = %object; %this.lastDamageTeam = GameBase::getTeam(%object); if (%this.shieldStrength) { %energy = GameBase::getEnergy(%this); %strength = %this.shieldStrength; if (%type == $ShrapnelDamageType) %strength *= 0.5; else if (%type == $MortarDamageType) %strength *= 0.25; else if (%type == $BlasterDamageType) %strength *= 2.0; %absorb = %energy * %strength; if (%value < %absorb) { GameBase::setEnergy(%this,%energy - (%value / %strength)); %centerPos = getBoxCenter(%this); %sphereVec = findPointOnSphere(getBoxCenter(%object),%centerPos,%vec,%this); %centerPosX = getWord(%centerPos,0); %centerPosY = getWord(%centerPos,1); %centerPosZ = getWord(%centerPos,2); %pointX = getWord(%pos,0); %pointY = getWord(%pos,1); %pointZ = getWord(%pos,2); %newVecX = %centerPosX - %pointX; %newVecY = %centerPosY - %pointY; %newVecZ = %centerPosZ - %pointZ; %norm = Vector::normalize(%newVecX @ " " @ %newVecY @ " " @ %newVecZ); %zOffset = 0; if(GameBase::getDataName(%this) == PulseSensor) %zOffset = (%pointZ-%centerPosZ) * 0.5; GameBase::activateShield(%this,%sphereVec,%zOffset); if(%type == $EMPDamageType || %type == $EMPWarheadDamageType || %type == $EMPMineDamageType) { GameBase::setEnergy(%this,0); playSound(SoundEMPDrain,GameBase::getPosition(%this)); } } else { GameBase::setEnergy(%this,0); StaticShape::onDamage(%this,%type,%value - %absorb,%pos,%vec,%mom,%object); } } else { StaticShape::onDamage(%this,%type,%value,%pos,%vec,%mom,%object); } }

StaticShapeData FlagStand { description = "Flag Stand"; shapeFile = "flagstand"; visibleToSensor = false; };
function calcRadiusDamage(%this,%type,%radiusRatio,%damageRatio,%forceRatio, %rMax,%rMin,%dMax,%dMin,%fMax,%fMin) { %radius = GameBase::getRadius(%this); if(%radius) { %radius *= %radiusRatio; %damageValue = %radius * %damageRatio; %force = %radius * %forceRatio; if(%radius > %rMax) %radius = %rMax; else if(%radius < %rMin) %radius = %rMin; if(%damageValue > %dMax) %damageValue = %dMax; else if(%damageValue < %dMin) %damageValue = %dMin; if(%force > %fMax) %force = %fMax; else if(%force < %fMin) %force = %fMin; GameBase::applyRadiusDamage(%type,getBoxCenter(%this), %radius, %damageValue,%force,%this); } }
function FlagStand::onDamage() { }

function Generator::onEnabled(%this) { GameBase::setActive(%this,true); }
function Generator::onDisabled(%this) { GameBase::stopSequence(%this,0); GameBase::generatePower(%this, false); }
function Generator::onDestroyed(%this) { Generator::onDisabled(%this); StaticShape::objectiveDestroyed(%this); calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 3, 0.55, 0.30, 250, 170); }
function Generator::onActivate(%this) { GameBase::playSequence(%this,0,"power"); GameBase::generatePower(%this, true); }
function Generator::onDeactivate(%this) { GameBase::stopSequence(%this,0); GameBase::generatePower(%this, false); }

StaticShapeData TowerSwitch { description = "Tower Control Switch"; className = "towerSwitch"; shapeFile = "tower"; showInventory = "false"; visibleToSensor = true; mapFilter = 4; mapIcon = "M_generator"; };

StaticShapeData Generator { description = "Generator"; shapeFile = "generator"; className = "Generator"; sfxAmbient = SoundGeneratorPower; debrisId = flashDebrisLarge; explosionId = flashExpLarge; maxDamage = 2.0; visibleToSensor = true; mapFilter = 4; mapIcon = "M_generator"; damageSkinData = "objectDamageSkins"; shadowDetailMask = 16; };
StaticShapeData SolarPanel { description = "Solar Panel"; shapeFile = "solar_med"; className = "Generator"; debrisId = flashDebrisMedium; maxDamage = 1.0; visibleToSensor = true; mapFilter = 4; mapIcon = "M_generator"; damageSkinData = "objectDamageSkins"; shadowDetailMask = 16; explosionId = flashExpLarge; };
StaticShapeData PortGenerator { description = "Portable Generator"; shapeFile = "generator_p"; className = "Generator"; debrisId = flashDebrisSmall; sfxAmbient = SoundGeneratorPower; maxDamage = 1.6; mapIcon = "M_generator"; damageSkinData = "objectDamageSkins"; shadowDetailMask = 16; explosionId = flashExpMedium; visibleToSensor = true; mapFilter = 4; };

StaticShapeData SmallAntenna { shapeFile = "anten_small"; debrisId = defaultDebrisSmall; maxDamage = 1.0; damageSkinData = "objectDamageSkins"; shadowDetailMask = 16; explosionId = flashExpMedium; description = "Small Antenna"; };
StaticShapeData MediumAntenna { shapeFile = "anten_med"; debrisId = flashDebrisSmall; maxDamage = 1.5; damageSkinData = "objectDamageSkins"; shadowDetailMask = 16; explosionId = flashExpMedium; description = "Medium Antenna"; };
StaticShapeData LargeAntenna { shapeFile = "anten_lrg"; debrisId = defaultDebrisSmall; maxDamage = 1.5; damageSkinData = "objectDamageSkins"; shadowDetailMask = 16; explosionId = debrisExpMedium; description = "Large Antenna"; };
StaticShapeData ArrayAntenna { shapeFile = "anten_lava"; debrisId = flashDebrisSmall; maxDamage = 1.5; damageSkinData = "objectDamageSkins"; shadowDetailMask = 16; explosionId = flashExpMedium; description = "Array Antenna"; };
StaticShapeData RodAntenna { shapeFile = "anten_rod"; debrisId = defaultDebrisSmall; maxDamage = 1.5; damageSkinData = "objectDamageSkins"; shadowDetailMask = 16; explosionId = debrisExpMedium; description = "Rod Antenna"; };

StaticShapeData ForceBeacon { shapeFile = "force"; debrisId = defaultDebrisSmall; maxDamage = 0.5; damageSkinData = "objectDamageSkins"; shadowDetailMask = 16; explosionId = debrisExpMedium; description = "Force Beacon"; };

StaticShapeData CargoCrate { shapeFile = "magcargo"; debrisId = flashDebrisSmall; maxDamage = 1.0; damageSkinData = "objectDamageSkins"; shadowDetailMask = 16; explosionId = flashExpMedium; description = "Cargo Crate"; };
StaticShapeData CargoBarrel { shapeFile = "liqcyl"; debrisId = defaultDebrisSmall; maxDamage = 1.0; damageSkinData = "objectDamageSkins"; shadowDetailMask = 16; explosionId = debrisExpMedium; description = "Cargo Barrel"; };

StaticShapeData SquarePanel { shapeFile = "teleport_square"; debrisId = flashDebrisSmall; maxDamage = 0.3; damageSkinData = "objectDamageSkins"; explosionId = flashExpMedium; description = "Panel"; };
StaticShapeData VerticalPanel { shapeFile = "teleport_vertical"; debrisId = defaultDebrisSmall; explosionId = debrisExpMedium; maxDamage = 0.5; damageSkinData = "objectDamageSkins"; description = "Panel"; };
StaticShapeData BluePanel { shapeFile = "panel_blue"; debrisId = flashDebrisSmall; explosionId = flashExpMedium; maxDamage = 0.5; damageSkinData = "objectDamageSkins"; description = "Panel"; };
StaticShapeData YellowPanel { shapeFile = "panel_yellow"; debrisId = defaultDebrisSmall; explosionId = debrisExpMedium; maxDamage = 0.5; damageSkinData = "objectDamageSkins"; description = "Panel"; };
StaticShapeData SetPanel { shapeFile = "panel_set"; debrisId = flashDebrisSmall; explosionId = flashExpMedium; maxDamage = 0.5; damageSkinData = "objectDamageSkins"; description = "Panel"; };
StaticShapeData VerticalPanelB { shapeFile = "panel_vertical"; debrisId = defaultDebrisSmall; explosionId = debrisExpMedium; maxDamage = 0.5; damageSkinData = "objectDamageSkins"; description = "Panel"; };
StaticShapeData DisplayPanelOne { shapeFile = "display_one"; debrisId = flashDebrisSmall; explosionId = flashExpMedium; maxDamage = 0.5; damageSkinData = "objectDamageSkins"; description = "Panel"; };
StaticShapeData DisplayPanelTwo { shapeFile = "display_two"; debrisId = defaultDebrisSmall; explosionId = debrisExpMedium; maxDamage = 0.5; damageSkinData = "objectDamageSkins"; description = "Panel"; };
StaticShapeData DisplayPanelThree { shapeFile = "display_three"; debrisId = flashDebrisSmall; explosionId = flashExpMedium; maxDamage = 0.5; damageSkinData = "objectDamageSkins"; description = "Panel"; };
StaticShapeData HOnePanel { shapeFile = "dsply_h1"; debrisId = defaultDebrisSmall; explosionId = debrisExpMedium; maxDamage = 0.5; damageSkinData = "objectDamageSkins"; description = "Panel"; };
StaticShapeData HTwoPanel { shapeFile = "dsply_h2"; debrisId = flashDebrisSmall; explosionId = flashExpMedium; maxDamage = 0.5; damageSkinData = "objectDamageSkins"; description = "Panel"; };
StaticShapeData SOnePanel { shapeFile = "dsply_s1"; debrisId = defaultDebrisSmall; explosionId = debrisExpMedium; maxDamage = 0.5; damageSkinData = "objectDamageSkins"; description = "Panel"; };
StaticShapeData STwoPanel { shapeFile = "dsply_s2"; debrisId = flashDebrisSmall; explosionId = flashExpMedium; maxDamage = 0.5; damageSkinData = "objectDamageSkins"; description = "Panel"; };
StaticShapeData VOnePanel { shapeFile = "dsply_v1"; debrisId = defaultDebrisSmall; explosionId = debrisExpMedium; maxDamage = 0.5; damageSkinData = "objectDamageSkins"; description = "Panel"; };
StaticShapeData VTwoPanel { shapeFile = "dsply_v2"; debrisId = flashDebrisSmall; explosionId = flashExpMedium; maxDamage = 0.5; damageSkinData = "objectDamageSkins"; description = "Panel"; };
StaticShapeData ForceField { shapeFile = "forcefield"; debrisId = defaultDebrisSmall; maxDamage = 10000.0; isTranslucent = true; description = "Force Field"; };

StaticShapeData ElectricalBeam { shapeFile = "zap"; maxDamage = 10000.0; isTranslucent = true; description = "Electrical Beam"; disableCollision = true; };
StaticShapeData ElectricalBeamBig { shapeFile = "zap_5"; maxDamage = 10000.0; isTranslucent = true; description = "Electrical Beam"; disableCollision = true; };

StaticShapeData PoweredElectricalBeam { shapeFile = "zap"; maxDamage = 10000.0; isTranslucent = true; description = "Electrical Beam"; disableCollision = true; };
function PoweredElectricalBeam::onPower(%this, %power, %generator) { if(%power) GameBase::startFadeIn(%this); else GameBase::startFadeOut(%this); }

StaticShapeData Cactus1 { shapeFile = "cactus1"; debrisId = defaultDebrisSmall; maxDamage = 0.4; description = "Cactus"; };
StaticShapeData Cactus2 { shapeFile = "cactus2"; debrisId = defaultDebrisSmall; maxDamage = 0.4; description = "Cactus"; };
StaticShapeData Cactus3 { shapeFile = "cactus3"; debrisId = defaultDebrisSmall; maxDamage = 0.4; description = "Cactus"; };

StaticShapeData SteamOnGrass { shapeFile = "steamvent_grass"; maxDamage = 999.0; isTranslucent = "True"; description = "Steam Vent"; };
StaticShapeData SteamOnMud { shapeFile = "steamvent_mud"; maxDamage = 999.0; isTranslucent = "True"; description = "Steam Vent"; };

StaticShapeData TreeShape { shapeFile = "tree1"; maxDamage = 10.0; isTranslucent = "True"; description = "Tree"; };
StaticShapeData TreeShapeTwo { shapeFile = "tree2"; maxDamage = 10.0; isTranslucent = "True"; description = "Tree"; };

StaticShapeData SteamOnGrass2 { shapeFile = "steamvent2_grass"; maxDamage = 999.0; isTranslucent = "True"; };
StaticShapeData SteamOnMud2 { shapeFile = "steamvent2_mud"; maxDamage = 999.0; isTranslucent = "True"; description = "Steam Vent"; };

StaticShapeData PlantOne { shapeFile = "plant1"; debrisId = defaultDebrisSmall; maxDamage = 0.4; description = "Plant"; };
StaticShapeData PlantTwo { shapeFile = "plant2"; debrisId = defaultDebrisSmall; maxDamage = 0.4; description = "Plant"; };

StaticShapeData DeployableForceField { shapeFile = "forcefield_3x4"; debrisId = defaultDebrisSmall; maxDamage = 2.25; visibleToSensor = true; isTranslucent = true; description = "Small Force Field"; };
function DeployableForceField::onDestroyed(%this) { StaticShape::onDestroyed(%this); $TeamItemCount[GameBase::getTeam(%this) @ "ForceFieldPack"]--; }
function DeployableForceField::packUp(%this,%pos,%client,%player) { %ownerName = ixGetOwnerName(%this); if(%ownerName != "") { %name = Client::getName(%client); if(%ownerName == %name) { if(!GameBase::getDamageLevel(%this)) { %player.isDeploying = true; GameBase::setSequenceDirection(%this,1,0); playSound(ForceFieldClose,%pos); GameBase::startFadeOut(%this); %player.deployPosition = %pos; schedule("deleteObject(" @ %this @ ");",1.9,%this); schedule("ixGivePack(" @ %player @ ",ForceFieldPack," @ Client::getTeam(%client) @ ");",2.0,%player); echo("MSG: ",%client," Packed up a Small Force Field"); } else Client::sendMessage(%client, 0,"This Deployable is damaged, it wont pack up.~werror_message.wav"); } else Client::sendMessage(%client, 0, %ownerName @ " is the only one that can pack up this Item.~werror_message.wav"); } } 

StaticShapeData BoomBoxBomb { shapeFile = "magcargo"; debrisId = flashDebrisLarge; maxDamage = 1.25; visibleToSensor = true; mapIcon = "M_generator"; mapFilter = 2; damageSkinData = "objectDamageSkins"; shadowDetailMask = 16; explosionId = BlankExp; description = "Boom Box"; };
function BoomBoxBomb::onDamage(%this,%type,%value,%pos,%vec,%mom,%object) { %damageLevel = GameBase::getDamageLevel(%this); %dValue = %damageLevel + %value; %this.lastDamageObject = %object; %objTeam = GameBase::getTeam(%object); %thisTeam = GameBase::getTeam(%this); %this.lastDamageTeam = %objTeam; %name = GameBase::getDataName(%this); %stateThen = GameBase::getDamageState(%this); if(%type == $BoomBoxNukeDamageType) { %this.BoxDetonated = 1; GameBase::setDamageLevel(%this,GameBase::getDataName(%this).maxDamage); } else GameBase::setDamageLevel(%this,%dValue); if((%objectName = Client::getName(%object)) != "") { %stateNow = GameBase::getDamageState(%this); if((%stateNow == Destroyed) && (%stateThen != Destroyed)) { if(%thisTeam == %objTeam) { if((%name == DeployableTurret) || (%name == CameraTurret) || (%name == DeployableAvenger) || (%name == DeployableSentry) || (%name == DeployableSentinel) || (%name == DeployableDecimator) || (%name == DeployableFlak) || (%name == DeployableForceField)) { %mapName = GameBase::getMapName(%this); %start = String::findSubStr(%mapName,": "); %end = String::findSubStr(%mapName," ."); %start += 2; %ownerName = String::getSubStr(%mapName, %start, %end-%start); if(%ownerName != Client::getName(%object)) { messageTeam(%object, 0, Client::getName(%object) @ " destroyed one of our " @ %name @ "'s Deployed by " @ %ownerName @ "."); } } } else if((%name == Generator) || (%name == PortGenerator) || (%name == SolarPanel)) { %pwr = GameBase::isPowered(%this); if((!%pwr) && ($ixRepairTeam[%thisTeam] != %objTeam)) { schedule("ixCheckPowerObjective(" @ %object @ "," @ %thisTeam @ "," @ $ixTeamPower[%thisTeam]++ @ ",1);",60); } } } } }
function BoomBoxBomb::onDestroyed(%this) { %client = %this.Owner; if(%client.BoomBox == %this) %client.BoomBox = ""; %pos = %this.BoomBoxPos; %player = Client::getOwnedObject(%client); %this.BoomBoxPos = ""; GameBase::stopSequence(%this,0); StaticShape::objectiveDestroyed(%this); if( %this.BoxDetonated == 1) { GameBase::applyRadiusDamage($BoomBoxNukeDamageType, %pos, 60, 10, 250, %client); pxMushroomCloud(%player, %pos); } else { GameBase::applyRadiusDamage($BoomBoxFizzleDamageType, %pos, 7.5, 0.625, 50, %client); Projectile::spawnProjectile("BoomBoxFizzle","0 0 1 0 0 1 0 0 1 " @ %pos,%player,"0 0 0",%player); Client::sendMessage(%client,0,"*** Your Boom Box has been destroyed."); echo("MSG: ",%client,":",Client::getName(%client),"'s Boom Box was detroyed"); } $TeamItemCount[GameBase::getTeam(%player) @ "BoomBoxPack"]--; }
