// This requires Presto Pack .93 or better, and Writer's Support
// Add this line to your autoexec
// Put this file in your config folder
//
//   Include("stregazoom.cs");
//
// Any questions, email me at strega@insanestyle.com
//


EditActionMap("playMap.sae");

include("Presto\\event.cs");
include("Writer\\inventory_table.cs");
include("Writer\\fire.cs");


//=======================================================================================
// Begin Banner 
//=======================================================================================

if ($Presto::version >= 0.93)

{
Presto::AddScriptBanner(AutoZoom,"<jc><f2> AutoZoom!        Version 1.0\n" @
	"<jc><f0>AutoZooming Sniper Rifle\n" @
	"<jc><f0>A Sniper's Crutch!\n" @		
	"\n" @	
	"<jc><f2>i$: Strega\n" @
        "<jc><f0>www.insanestyle.com\n" @
	"\n" @
	"<jc><f1>Thanks BigBunny");
}


$zoomAmount=0;


//=======================================================================================
// Swaps to the Laser Rifle when you zoom in.
//=======================================================================================

function zoom::zoomInAndSwap ()

{
	$AutoRifle::holdingLaser = false;
	postAction (2048, IDACTION_SNIPER_FOV, 1.000000);
	if (getMountedItem(0)!=getitemType("Chaingun"))
		{
		if (getItemCount ("Laser Rifle")==1)
			{
			if (getMountedItem(0)!=getItemType("Laser Rifle")) 
				{
				$previousWeapon=getMountedItem(0);
				use ("Laser Rifle");
				}
			else $AutoRifle::holdingLaser = true;
			}
		}
	return;
}

//=======================================================================================
// Swaps back to the weapon you had before the above function was called
//=======================================================================================

function zoom::zoomOutAndSwap ()
{
//	echo ("function zoom::zoomOutAndSwap ()");
	postAction (2048, IDACTION_SNIPER_FOV, 0.000000);
	if (getItemCount ("Laser Rifle")==1)
		{
		if (getMountedItem(0)==getItemType("Laser Rifle") && !$AutoRifle::holdingLaser)
			useItem ($previousWeapon);
		}
	zoom::backTo2x ();
	$AutoRifle::holdingLaser = false;
	return;
}


//=======================================================================================
// Backs the zoom level out to 2x
//=======================================================================================

function zoom::backTo2x ()
{
	for (%i=0;%i<$zoomAmount;%i++)
		postAction (2048, IDACTION_INC_SNIPER_FOV, -1.0000);
	zoom::reset ();
}


//=======================================================================================
// Zooms and keeps track of the zoom multiplier
//=======================================================================================

function zoom::zoomIn ()
{
	postAction (2048, IDACTION_INC_SNIPER_FOV, 1.0000);
	$zoomAmount++;
	if ($zoomAmount>=4)
		$zoomAmount=0;
}


//=======================================================================================
// Reset the zoom multiplier
//=======================================================================================

function zoom::reset ()
{
	$zoomAmount=0;
}


// ==================================== KEY BINDINGS ====================================
bindCommand(keyboard0, make, "rcontrol", TO, "zoom::zoomInAndSwap ();");
bindCommand(keyboard0, break, "rcontrol", TO, "zoom::zoomOutAndSwap ();");
bindCommand(keyboard0, make, "", TO, "zoom::zoomIn ();");
