// --	-----	-----	-----	-----	-----	-----	-----	-----	-----	-----	-----	------
// StatusHUD.CS (Version 1.0)						[Phx], April '99 
//
//	Display information about functions as required.
//
// 	This script displays a temporary HUD that presents some brief information to the player
//	for reference. At the moment, this is limited to;
//
//			Best weapon information as determined by ChooseBest.cs
//			Dynamic weapon allocatios as assigned by DynCycle.cs
//			Overall game stats as provided by SPADEs' StatTrak.cs script
//
// INSTALLATION
//
//	Copy this file into your TRIBES\config directory and add the following to the end of
//	your autoexec.cs file
//
//	Include("StatusHUD.cs");
//
// BINDINGS
//
//	None, the function works automatically according to events within the game.
//
// KNOWN PROBLEMS
//
//	- None at this time.
//
// FUTURE DEVELOPMENTS
//
//	- Any suggestions are welcome...or do them and circulate them.
//
// VERSION HISTORY
//
//	15/04/1999		v1.0 release
//
// That's about it for the mo'.
//
//	Phoenix 15/04/99
//

// PRESTOS material
Include("presto\\Event.cs");
Include("presto\\HUD.cs");

// Update the HUD to display the required information.
function StatusHUD::UpdateHUD() 
{

	HUD::Display(StatusHUD);
	
	// 3 seconds up on the screen, then gone...adjust this to a larger or smaller number
	// depending on how quick you can read the message
	if (getSimTime() <= $Status::LastUpdateTime + 5) 
	{

		HUD::AddTextLine(StatusHUD, "");

		// Process information from the ChooseBest script. This occurs every time you leave
		// the inventory station.
		if ($StatusHUD::FromScript == ChooseBest)
		{
			HUD::AddTextLine(StatusHUD, "<f2>   Best Weapons");
			HUD::AddTextLine(StatusHUD, "");
			HUD::AddTextLine(StatusHUD, "<f0> 1.  <f1>" @ $WeaponRealText[$ChosenWeaponSequence] @" ");
			HUD::AddTextLine(StatusHUD, "<f0> 2. <f1>" @ $WeaponRealText[$PrevWeaponSequence] @" ");

		}

		// Process information from the StatTrak script. This occurs every time the script
		// does something. Also, determine the players overall survivability chance to date.
		if ($StatusHUD::FromScript == StatTrak)
		{
			// Determine the chance of survival in any one game to date.
			%KillsToDate = $StatTrak::Kills[$StatTrak::ClientNum];

			// Need to prevent a divide by 0 error...that could be a problem
			if (%KillsToDate != 0)
			{
				%SurvivalChance = (FLOOR((1-($StatTrak::Deaths[$StatTrak::ClientNum]/$StatTrak::Kills[$StatTrak::ClientNum])) * 10000) / 100) + 0.01;
			}
			
			// If we have no kills, but are dead, we have no survival rate at this point
			if (%KillsTodate == 0)
			{
				%SurvivalChance = 0;
			}

			// We've died more times that we've killed...again we have no survival rate.
			if (%SurvivalChance < 0)
			{
				%SurvivalChance = 0;
			}

			HUD::AddTextLine(StatusHUD, "<f2>  Overall Progress ");
			HUD::AddTextLine(StatusHUD, "<f0> Survival is <f1>" @ %SurvivalChance @ "%" );
			HUD::AddTextLine(StatusHUD, "<f0>   Kills    : <f1>" @ $StatTrak::Kills[$StatTrak::ClientNum] @ " ");
			HUD::AddTextLine(StatusHUD, "<f0>   Deaths : <f1>" @ $StatTrak::Deaths[$StatTrak::ClientNum] @ " ");
			HUD::AddTextLine(StatusHUD, "<f0>   Flags   : <f1>" @ $StatTrak::Flagcaps[$StatTrak::ClientNum] @" ");

		}

		// Process information from the DynCycle script. This occurs every time you allocate
		// a new weapon to the cycle, or do something with the DynCycle script.

		if (String::GetSubStr($StatusHUD::FromScript,0,3) == "Dyn")
		{
			HUD::AddTextLine(StatusHUD, "<f2>   Weapon Cycle");
			HUD::AddTextLine(StatusHUD, "");

			// Weapon reallocation or initial OnConnect bindings
			if ($StatusHUD::FromScript == DynCycle || $StatusHUD::FromScript == DynConnect)
			{

				HUD::AddTextLine(StatusHUD, "<f0> 1.  <f1>" @ $DynCycleWeapon[1] @" ");
				HUD::AddTextLine(StatusHUD, "<f0> 2. <f1>" @ $DynCycleWeapon[2] @" ");
			}

			// The weapon has not been equipped...need to know.
			if ($StatusHUD::FromScript == DynNoWeap)
			{
				HUD::AddTextLine(StatusHUD, "<f1>   " @ $DynCycleWeapon::NOT @" ");
				HUD::AddTextLine(StatusHUD, "<f0>    Not EQUIPPED!!");
			}
		}

		return 1;
	}

	HUD::Display(StatusHUD,false);
	return 0;
}

// Invoked from the relevent scripts to display the required information.
function StatusHUD(%fromscript)
{
	$StatusHUD::FromScript = %fromscript;
	$Status::LastUpdateTime = getSimTime();
	HUD::Display(StatusHUD);

}

// Reset the HUd and its information.
function StatusHUD::Reset() 
{
	$Status::LastUpdateTime = getSimTime();
}

//
// Use PrestoPref::DynHudPosition, and CowBoy's positioning, to put this HUD a little bit 
// underneath his [CowBoy's].
//
HUD::New(StatusHUD, StatusHUD::UpdateHUD, getWord($PrestoPref::DynHudPosition, 0),
	getWord($PrestoPref::DynHudPosition, 1) + getWord($PrestoPref::DynHudPosition, 3) + $Cowboy::SizeX, 150, 85);

Event::Attach(eventConnected, StatusHUD::Reset);
Event::Attach(eventChangeMission, StatusHUD::Reset);
