// --	-----	-----	-----	-----	-----	-----	-----	-----	-----	-----	-----	------
// ChooseBest.CS (Version 1.0)					[Phx], April '99 
//
//	Choose the [most] powerful weapon available to you.
//
// 	This script determines what the most powerful weapon is that you are carrying and then
//	automatically changes to it as you leave the Inventory station. The purpose of this was
// 	to prevent the JumpJetPilotPresto.cs script from stuffing up your sensitivity when you
// 	leave the station without anything in your hands. The JJPP script thinks that you are in 
// 	a vehicle and alters your sensitivity accordingly when you use you jump jets without a
//	weapon in your hands.
//
// INSTALLATION
//
//	Copy this file into your TRIBES\config directory and add the following to the end of
//	your autoexec.cs file
//
//	Include("ChooseBest.cs");
//
// BINDINGS
//
//	None, the function works automatically according to events within the game.
//
// KNOWN PROBLEMS
//
//	- Does not choose the best weapon upon initial entering of the game. I tried to use
//	  some of PRESTO's events, but for some reason they decided to take a holiday. The
//	  best weapons are defaulted to in the DYNCYCLE.CS script upon entry into a game. 
//
// FUTURE DEVELOPMENTS
//
//	- Any suggestions are welcome...or do them and circulate them.
//
// VERSION HISTORY
//
//	15/04/1999		v1.0 release
//
// That's about it for the mo'.
//
//	Phoenix 15/04/99
//

// PRESTOS material.
Include("Presto\\Events.cs");

// Choose a weapon when EXITing a station.
Event::Attach(eventExitStation, ChooseBest::Weapon);

// Go and determine the best weapon to use.
function ChooseBest::Weapon() 
{
	// Initialise the variables
	$ChosenWeaponSequence = 0;
	$PrevWeaponSequence = 0;
	$TempWeaponSequence = 0;

	// Weapons are in the range 11 to 24, so this is the range of the loop.
	for (%i = 11; %i < 25; %i = %i +1) 
	{

		// Check if the weapon has ammo, if not, return to the top and continue processing.
		%ammoname   = $Ammo[$WeaponSlot[%i]];
		if (getItemCount(%ammoname) == 0)
		{
			// Make sure that those weapon NOT impacted by lack of ammo are excluded
			if ($WeaponRealName[$WeaponSlot[%i]] != "Laser Rifle" &&
			    $WeaponRealName[$WeaponSlot[%i]] != "Blaster"  &&
			    $WeaponRealName[$WeaponSlot[%i]] != "ELF gun")
			{
				continue;
			}
		}

		// Determine if a particular weapon is present or not. $WeaponRealName and $WeaponSlot are 
		// part of another function (OneKeyPackPresto.cs), so there's no point in duplicating them.
		if (getItemCount($WeaponRealName[$WeaponSlot[%i]]))
		{
			// If the previous weapon is more powerful that the current one, don't change it.
			if ($PrevWeaponSequence < $WeaponSequence[$WeaponSlot[%i]])
			{
				// Leave ou the Targeting Laser, it's not really a weapon is it...
				if ($WeaponSlot[%i] != "TargetingLaser")
				{

					// Store the sequence of the previous weapon.
					$PrevWeaponSequence = $ChosenWeaponSequence; 	
					$ChosenWeaponSequence = $WeaponSequence[$WeaponSlot[%i]];
	
					// If the previous weapon is further 'up' the sequence (eg Mortar) than the
					// current one (eg Grenade Launcher), keep the current weapon as the most powerful.
					if ($PrevWeaponSequence > $ChosenWeaponSequence)
					{
						$TempWeaponSequence = $ChosenWeaponSequence;
						$ChosenWeaponSequence = $PrevWeaponSequence;
						$PrevWeaponSequence = $TempWeaponSequence;
					}
				}
			}
		}
	}

	// If we have no weapon mounted, reset the weapon mount number
	if (getMountedItem(0) == "-1")
	{
		$WeaponMountedNumber = 0;
	}	

	// Use what has been determined to be the most powerful weapon being carried. Also, if
	// we have determined the most powerful weapon to be one that may be mounted, we need
	// to make sure that it will not fire when we leave the station. Only if the chosen weapon
	// is different to the previously determined most powerful weapon will we change to the 
	// new one.

	if ($ChosenWeaponSequence != $WeaponMountedNumber)
	{
		use($WeaponRealText[$ChosenWeaponSequence]);
		postAction(2048,IDACTION_BREAK1, 0);
		$WeaponMountedNumber = $ChosenWeaponSequence;

	}

	StatusHUD(ChooseBest);

}

// Weapon sequence according to the numeric keybindings...These can be altered to whatever
// you feel is correct for you. i have used the default numeric keys for ease of reference.
$WeaponSequence[Blaster] = 1;
$WeaponSequence[PlasmaGun] = 2;
$WeaponSequence[Chaingun] = 3;
$WeaponSequence[DiscLauncher] = 4;
$WeaponSequence[GrenadeLauncher] = 5;
$WeaponSequence[LaserRifle] = 6;
$WeaponSequence[EnergyRifle] = 7;
$WeaponSequence[Mortar] = 8;
     
// Weapon real name to class name
$WeaponRealText[1] = "Blaster";
$WeaponRealText[2] = "Plasma Gun";
$WeaponRealText[3] = "Chaingun";
$WeaponRealText[4] = "Disc Launcher";
$WeaponRealText[5] = "Grenade Launcher";
$WeaponRealText[6] = "Laser Rifle";
$WeaponRealText[7] = "ELF gun";
$WeaponRealText[8] = "Mortar";
     
// Weapon real name to class name
$WeaponRealName[Blaster] = "Blaster";
$WeaponRealName[PlasmaGun] = "Plasma Gun";
$WeaponRealName[Chaingun] = "Chaingun";
$WeaponRealName[DiscLauncher] = "Disc Launcher";
$WeaponRealName[GrenadeLauncher] = "Grenade Launcher";
$WeaponRealName[Mortar] = "Mortar";
$WeaponRealName[LaserRifle] = "Laser Rifle";
$WeaponRealName[EnergyRifle] = "ELF gun";
$WeaponRealName[TargetingLaser] = "Targeting Laser";

// weapon classname to ammo real name
$Ammo[Blaster] = "";
$Ammo[Chaingun] = "Bullet";
$Ammo[PlasmaGun] = "Plasma Bolt";
$Ammo[GrenadeLauncher] = "Grenade Ammo";
$Ammo[Mortar] = "Mortar Ammo";
$Ammo[DiscLauncher] = "Disc";
$Ammo[TargetingLaser] = "";
$Ammo[EnergyRifle] = "";

// getMountedItem(0) number to classname
$WeaponSlot[11] = "Blaster";
$WeaponSlot[13] = "Chaingun";
$WeaponSlot[15] = "PlasmaGun";
$WeaponSlot[17] = "GrenadeLauncher";
$WeaponSlot[19] = "Mortar";
$WeaponSlot[21] = "DiscLauncher";
$WeaponSlot[22] = "LaserRifle";
$WeaponSlot[23] = "TargetingLaser";
$WeaponSlot[24] = "EnergyRifle";


