// --	-----	-----	-----	-----	-----	-----	-----	-----	-----	-----	-----	------
// DynCycle.CS (Version 1.0)						[Phx], April '99 
//
//	Dynamically allocate weapons to a weapon cycle as required..
//
// 	This script allows you to bind 2 weapons to a cycle that is activated by one key/mouse press.
//	At this point in time it is a little clunky in that you have to allocate the first weapon, 
//	switch to it and the allocate the second and switch to it, from there the cycle works okay.
//	The script rebinds the numeric keys 1-8 from the "use" function to a choose weapon function.
//
//	A further note on its use...the weapon type (primary or secondary) MUST be chose first (default
//	is "]" = Primary, "[" = Secondary weapon). Once that has been determined, the weapon to be
//	allocated can be chosen.
//
//	The DynCycle::Allocate function had to use true/false values as I had problems with the script
//	defaulting to "false" if I tried to pass in numbers.
//
//	NOTE: This script depends on having the OneKeyPackPresto.cs script in use as well as the ChooseBest.cs
//		script...THIS WAS NOT INTENTIONAL, IT JUST WORKED OUT THAT WAY IS ALL. Both scripts are very handy. 
//
// INSTALLATION
//
//	Copy this file into your TRIBES\config directory and add the following to the end of
//	your autoexec.cs file
//
//	Include("DynCycle.cs");
//
// BINDINGS
//
//	]		---> Choose primary weapon in cycle to allocate
//	[		---> Choose secondary weapon in cycle to allocate
//	1-8		---> Rebound in the function to choose the weapon you want...reset to
//		   	     default upon completion of the allocation
//	Button2	---> Middle mouse button for me that does the cycling.
//
// KNOWN PROBLEMS
//
//	- For some reason, the initial setup of this will work when you respawn on some servers but not others. It
//	  may have to do with the MOD, I don't know.
//
// FUTURE DEVELOPMENTS
//
//	- Any suggestions are welcome...or do them and circulate them.
//
// VERSION HISTORY
//
//	15/04/1999		v1.0 release
//
// That's about it for the mo'.
//
//	Phoenix 15/04/99
//

// Key bindings...change these to whatever suits you.
EditActionMap("playMap.sae");

bindCommand(keyboard0, make, "]", TO, "DynCycle::Allocate(true);");
bindCommand(keyboard0, make, "[", TO, "DynCycle::Allocate(false);");

bindCommand(mouse0, make, button2, TO, "DynCycle::Cycling();");

// Event processing
Event::Attach(eventConnectionAccepted, "DynCycle::OnConnect();");
Event::Attach(eventExitStation, "DynCycle::Initialise();");

// On connecting to the game, assign the initial cycle weapons. These will default to the weapons
// we have for the BASIC MOD ONLY...no others.
function DynCycle::OnConnect()
{
	$WeaponMountedNumber = 4;			// This is to stop the Disc Launcher from firing if you go into
								// an inventory station and come out WITHOUT having changed anything...
	$DynCycle::CurrentWeapon = 2; 		// Primary weapon is there, go to the secondary next...
	$DynCycleWeapon[1] = $WeaponRealText[4]; 	// Disc Launcher...
	$DynCycleWeapon[2] = $WeaponRealText[3]; 	// ChainGun...

	StatusHUD(DynConnect);

}

// Initialise the weapons upon exiting from the Inventory station to the two most powerful ones on you.
function DynCycle::Initialise()
{
	$DynCycle::CurrentWeapon = 2; // Primary weapon is there, go to the secondary next...
	$DynCycleWeapon[1] = $WeaponRealText[$ChosenWeaponSequence]; // Primary Weapon: MUST have ChooseBest.cs included...
	$DynCycleWeapon[2] = $WeaponRealText[$PrevWeaponSequence]; // Secondary Weapon, as for Primary Weapon.

}

// Allocate the weapon to the cycle key (1 = Primary, 2 = Secondary). At the same time, change to the new
// weapon for immediate use. Check to see if the weapon chosen is actualy in the inventory, if not
// display a warning and do not allocate anything.
function DynCycle::WeaponAllocate(%DynCycleKey, %DynCycleWeapon)
{

	// Reset the numeric weapon keys to their original defaults
	bindCommand(keyboard0, make, "1", TO, "use(\"Blaster\");");
	bindCommand(keyboard0, make, "2", TO, "use(\"Plasma Gun\");");
	bindCommand(keyboard0, make, "3", TO, "use(\"Chaingun\");");
	bindCommand(keyboard0, make, "4", TO, "use(\"Disc Launcher\");");
	bindCommand(keyboard0, make, "5", TO, "use(\"Grenade Launcher\");");
	bindCommand(keyboard0, make, "6", TO, "use(\"Laser Rifle\");");
	bindCommand(keyboard0, make, "7", TO, "use(\"ELF gun\");");
	bindCommand(keyboard0, make, "8", TO, "use(\"Mortar\");");

	// The weapon is not in the inventory
	if (getItemCount($WeaponRealText[%DynCycleWeapon]) != 1)
	{
		$DynCycleWeapon::NOT = $WeaponRealText[%DynCycleWeapon];
		StatusHUD(DynNoWeap);
	}

	// The weapon is there, change to it.
	if (getItemCount($WeaponRealText[%DynCycleWeapon]) == 1)
	{
		$DynCycleWeapon[%DynCycleKey] = $WeaponRealText[%DynCycleWeapon];
		StatusHUD(DynCycle);
		$DynCycle::CurrentWeapon = %DynCycleKey;
		DynCycle::Cycling();
	}

}

// Rebind the weapon allocation depending on whether the primary or secondary weapons are changing. I tried to pass
// in a variable via the bindings, but for some reason it did not accept them, so I left it as is.
function DynCycle::Allocate(%PrimaryWeapon) 
{
	// Primary weapon (obviously)
	if (%PrimaryWeapon)
	{
		EditActionMap("playMap.sae");
		bindCommand(keyboard0, make, "1", TO, "DynCycle::WeaponAllocate(1,1);");
		bindCommand(keyboard0, make, "2", TO, "DynCycle::WeaponAllocate(1,2);");
		bindCommand(keyboard0, make, "3", TO, "DynCycle::WeaponAllocate(1,3);");
		bindCommand(keyboard0, make, "4", TO, "DynCycle::WeaponAllocate(1,4);");
		bindCommand(keyboard0, make, "5", TO, "DynCycle::WeaponAllocate(1,5);");
		bindCommand(keyboard0, make, "6", TO, "DynCycle::WeaponAllocate(1,6);");
		bindCommand(keyboard0, make, "7", TO, "DynCycle::WeaponAllocate(1,7);");
		bindCommand(keyboard0, make, "8", TO, "DynCycle::WeaponAllocate(1,8);");

	}

	// Secondary weapon (perhaps obviously)
	if (!%PrimaryWeapon)
	{
		EditActionMap("playMap.sae");
		bindCommand(keyboard0, make, "1", TO, "DynCycle::WeaponAllocate(2,1);");
		bindCommand(keyboard0, make, "2", TO, "DynCycle::WeaponAllocate(2,2);");
		bindCommand(keyboard0, make, "3", TO, "DynCycle::WeaponAllocate(2,3);");
		bindCommand(keyboard0, make, "4", TO, "DynCycle::WeaponAllocate(2,4);");
		bindCommand(keyboard0, make, "5", TO, "DynCycle::WeaponAllocate(2,5);");
		bindCommand(keyboard0, make, "6", TO, "DynCycle::WeaponAllocate(2,6);");
		bindCommand(keyboard0, make, "7", TO, "DynCycle::WeaponAllocate(2,7);");
		bindCommand(keyboard0, make, "8", TO, "DynCycle::WeaponAllocate(2,8);");

	}

}

// Cycle through the allocated weapons.
function DynCycle::Cycling()
{

	if ($DynCycle::CurrentWeapon == 1)
	{
		use($DynCycleWeapon[1]);
		$DynCycle::CurrentWeapon = 2;
	}
	else if ($DynCycle::CurrentWeapon == 2)
	{
		use($DynCycleWeapon[2]);
		$DynCycle::CurrentWeapon = 1;
	}

}