// --------------------------
// shokHUD 1.0 by shokugE
// --------------------------
//
// *** For bug/request/ideas, please contact me@ shokuge@geocities.com
//   shokHUD and my other scripts can be downloaded from
//   http://www.geocities.com/TimesSquare/Galaxy/6633/
//
// Intro:
//
// shokHUD 1.0 was a modification of FishHUD 1.1, which is a
// modified version of DynHUD.  For info on these two scripts please
// refer to www.planettribes.com's scripting section.  shokHUD 1.1 is
// a major re-write of shokHUD which utilize Presto Pack's libraries.
// For info on Presto Pack please go to
// http://www.cdc.net/~presto/tribes
//
// Version history:
//
// 3/21/99 - FishHUD 1.1 released
// 3/22/99 - shokHUD 1.0 released
// 3/23/99 - shokHUD 1.1 released
// 3/24/99 - shokHUD 1.11 released
// 3/25/99 - shokHUD 1.12 released
//
// Feature/Change/Addition List:
//
// shokHUD 1.11 to 1.12
// - Team Kill notification
// shokHUD 1.1 to shokHUD 1.11
// - Changed HUD display
// - PopUp message added
// - Minor bug fix
// shokHUD 1.0 to shokHUD 1.1
// - Nothing really, cept everything is Prestoish now
// FishHUD 1.1 to shokHUD 1.0
// - Changed all the messages
// - Changed the HUD display, most could be found in shokHUD::UpdateHUD
// - Changed the HUD location, in shokHUD::Create
// - Added objective status monitor and warning, in shokHUD::objEvents
// - Added death counter, in shokHUD::killEvents
// - Victim text #23 added
// - Killer text added
// - shokHUD::Parse modified to fit changes
// - Objective status changing routine in shokHUD::teamEvents added
// - New feature death notification added, with killer and murdured
//   weapon. Can be found in shokHUD::killEvents
// - New feature team warning added, warn teammates if you were killed
//   by laser rifle or heavy mortar.  Can be found in shokHUD::killEvents
//
// HUD Description:
//
// These are the items in the HUD, in order:
// - Red mark: enemy flag status monitor
// - Green mark: team flag status monitor
//     These two monitors shows "home" if the flag is at base, "field" if the
//     flag is dropped in the field, or the name of the flag carrier.  If the
//     monitor shows "?", it means the status of the flag is not yet
//     determined.
// - Kill/Death counter and Objective monitor:
//     Below the flags status there are two numbers and a color mark.  The
//     number to the left is you kill count and to the right is your death
//     count.  The mark in the middle is the objective status.  Green for
//     controld by your team, red for controled by enemy team, and yellow
//     for neutral or no objective in map.  An objective is anything that
//     can be controled other than flag such as the watch tower in Scarabrae.
// - Inventory icons: items counter
//     In order, grenade counter, mine counter, repair kit counter and beacon
//     counter.
//
// PopUp Window Description:
//
// The PopUp window pops up upon events.  Event types are differenciated
// by the icon in the window.
// - Flag icon: Red flag represents enemy flag while green represent yours.
//     Shows either a message or the flag carrier name.
// - Tower icon: Red for objective lost and green for objective captured.
// - Health icon: Red for you killed an enemy, green for you killed an
//     teammate, and skull for you're killed.  The text next to the icon is
//     the killer/victim's name and the murder weapon.  Note that team kills
//     are not tracked.
//
// By default, the HUD is toggled on/off using Alt-D.  This can be changed.
//
// Installation:
//
// 1) Install Presto Pack.  Please refer to his docs for this part.
// 2) Place this file in your Tribes /config/ directory.
// 3) Add the following line to the autoexec.cs file in your tribes /base/
//    directory:
//
//    exec("shokHUD.cs");
//
//    If you do not have an autoexec.cs file, you'll have to create one.
// 4) Be sure to change the key binding for HUD toggle if you don't like
//    Alt-D.
//
// Other notes:
//
// Thanx to KillerBunny for the original DynHUD, and SuckerFish for his
// FishHUD...  Specially thanx to Presto for his encouragement and, of
// course, his awesome Presto Pack. Great works, guys!!  Also thanks to
// all the cool ppl in PlanetTribes Scripting forums.
//
//		- shokugE, 3/24/99

// Keyboard bindings

bindCommand(keyboard0, make, alt, "d", TO, "HUD::ToggleDisplay(shokHUD);");

// ================
// Presto's stuff
// ================

// Includes
Include("presto\\Event.cs");
Include("presto\\HUD.cs");
Include("presto\\TeamTrak.cs");
Include("presto\\KillTrak.cs");
// Event Detachments (to clean things up)
Event::Detach(eventConnected);
Event::Detach(eventChangeMission);
Event::Detach(eventClientMessage);
Event::Detach(eventFlagsUpdated);
Event::Detach(eventClientChangeTeam);
Event::Detach(eventKillTrak);

// ======================================
// shokHUD routines
// ======================================

function shokHUD::Update() {
	if (Team::GetFlagLocation(Team::Friendly()) == "" || $shokHUD::FriendlyFlagStatus == "")
		$shokHUD::FriendlyFlagStatus = "<f3>?";
	else if (Team::GetFlagLocation(Team::Friendly()) == "home")
		$shokHUD::FriendlyFlagStatus = "<f3>home";
	else if (Team::GetFlagLocation(Team::Friendly()) == "field")
		$shokHUD::FriendlyFlagStatus = "<f1>field";
	else
		$shokHUD::FriendlyFlagStatus = "<f2>" @ Team::GetFlagLocation(Team::Friendly());

	if (Team::GetFlagLocation(Team::Enemy()) == "" || $shokHUD::EnemyFlagStatus == "")
		$shokHUD::EnemyFlagStatus = "<f3>?";
	else if (Team::GetFlagLocation(Team::Enemy()) == "home")
		$shokHUD::EnemyFlagStatus = "<f3>home";
	else if (Team::GetFlagLocation(Team::Enemy()) == "field")
		$shokHUD::EnemyFlagStatus = "<f1>field";
	else
		$shokHUD::EnemyFlagStatus = "<f2>" @ Team::GetFlagLocation(Team::Enemy());

	if($shokHUD::ObjectiveStatus == "")
		$shokHUD::ObjectiveStatus = "<B0, 4:LR_HH_End_Yellow.bmp>";

	if($shokHUD::KillCount == "")
		$shokHUD::KillCount = 0;

	if($shokHUD::DeathCount == "")
		$shokHUD::DeathCount = 0;

	HUD::AddText(shokHUD, "<jl>" @
		"<B0, 0:M_station_green.bmp>" @ $shokHUD::FriendlyFlagStatus @
		"\n<B0, 0:M_station_red.bmp>" @ $shokHUD::EnemyFlagStatus @
		"\n<f2>" @ $shokHUD::KillCount @
		" " @ $shokHUD::ObjectiveStatus @ $shokHUD::ObjectiveStatus @
		" " @ $shokHUD::DeathCount @
		" <f0>" @ $shokHUD::TeamKillCount @
		"\n<L4><Blr_grenade_on.bmp><f1>" @ getItemCount("Grenade") @
		"<BLR_I_mine_on.bmp><f1>" @ getItemCount("Mine") @
		"\n<BLR_I_health_on.bmp><f1>" @ getItemCount("Repair Kit") @
		"<Blr_targetlaser_on.bmp><f1>" @ getItemCount("Beacon"));

	return 2;
}

function shokHUD::Reset() {
	// initialize HUD variables
	$shokHUD::ObjectiveStatus = "<B0, 4:LR_HH_End_yellow.bmp>";
	$shokHUD::warnMsg = "watch out for enemy ";
	$shokHUD::KillCount = 0;
	$shokHUD::DeathCount = 0;
	HUD::Update(shokHUD);
}

// ============================================
// shokHUD parsing routines
// ============================================

function shokHUD::teamEvents() {
	%temp_carrier = $shokHUD::FriendlyFlagStatus;
	$shokHUD::FriendlyFlagStatus = $shokHUD::EnemyFlagStatus;
	$shokHUD::EnemyFlagStatus = %temp_carrier;
	if ($shokHUD::ObjectiveStatus == "<BLR_HH_End_green.bmp>")
		$shokHUD::ObjectiveStatus = "<B0, 4:LR_HH_End_red.bmp>";
	else if ($shokHUD::ObjectiveStatus == "<BLR_HH_End_red.bmp>")
		$shokHUD::ObjectiveStatus = "<B0, 4:LR_HH_End_green.bmp>";
	return;
}

function shokHUD::flagEvents(%team, %location) {
	if (%team == Team::Friendly())
		%string = "<B0, 0:flag_atbase.bmp>";
	else
		%string = "<B0, 0:flag_enemycaptured.bmp>";

	if (%location == "home")
		%string = %string @ "<f3>returned to base";
	else if (%location == "field")
		%string = %string @ "<f1>dropped in the field";
	else
		%string = %string @ "<f2>" @ %location;

	shokHUD::PopUp(%string);
}

function shokHUD::killEvents(%killer, %victim, %weapon) {
	%me = getManagerId();

	if (%weapon == "Mine") %weapon = "Explosive";

	if (%killer == %me && %weapon == "Team Kill")
		shokHUD::PopUp("<B0, 0:item_ok.bmp><f1>" @ client::getname(%victim) @"\n<f0>" @ %weapon);
	else if (%killer == %me && %weapon == "Team Mine")
		shokHUD::PopUp("<B0, 0:item_ok.bmp><f1>" @ client::getname(%victim) @"\n<f0>" @ %weapon);
	else if (%killer == %me && %victim != %me) {
		$shokHUD::KillCount++;
		shokHUD::PopUp("<B0, 0:item_damaged.bmp><f1>" @ client::getname(%victim) @"\n<f0>" @ %weapon);
		HUD::Update(shokHUD);

	} else if (%victim == %me) {
		$shokHUD::DeathCount++;

		shokHUD::PopUp("<B0, 0:skull_big.bmp><f1>" @ client::getname(%killer) @"\n<f0>" @ %weapon);

		if (KillTrak::GetWeapon() == "Laser Rifle")
			say(1, $shokHUD::warnMsg @ "sniper " @ client::getname(%killer));
		else if (KillTrak::GetWeapon() == "Mortar")
			say(1, $shokHUD::warnMsg @ "heavy " @ client::getname(%killer));

		HUD::Update(shokHUD);
	}
}

function shokHUD::objEvents(%client, %msg) {
	if(%client != 0)
		return;
	else if (%msg == "Your team has taken an objective.") {
		$shokHUD::ObjectiveStatus = "<B0, 4:LR_HH_End_green.bmp>";
		shokHUD::PopUp("<Btower_teamcontrol.bmp>objective taken");
	} else if (String::findSubStr(%msg, " team has taken your objective.") >= 0) {
		$shokHUD::ObjectiveStatus = "<BB0, 4:LR_HH_End_red.bmp>";
		shokHUD::PopUp("<Btower_enemycontrol.bmp>objective lost");
	}
	return;
}

function shokHUD::PopUp(%string) {
	%displayed = HUD::GetDisplayed(shokPopUp);
	if (%displayed)
		HUD::Display(shokPopUp, false);
	$shokHUD::PopUpString = %string;
	shokHUD::PopUpDisplay();
	return;
}

function shokHUD::PopUpDisplay() {
	HUD::AddText(shokPopUp, $shokHUD::PopUpString);
	HUD::Display(shokPopUp, true);
	schedule("HUD::Display(shokPopUp, false);", 5);
	return;
}

// killTrak team kill death messages
KillTrak::DeathMessage("%1 mows down %3 teammate, %2", "Team Kill");
KillTrak::DeathMessage("%1 killed %3 teammate, %2 with a mine.", "Team Mine");
// Event Attachments
Event::Attach(eventConnected, shokHUD::Reset);
Event::Attach(eventChangeMission, shokHUD::Reset);
Event::Attach(eventClientMessage, shokHUD::objEvents);
Event::Attach(eventFlagsUpdated, "HUD::Update(shokHUD);");
Event::Attach(eventFlagsUpdated, shokHUD::flagEvents);
Event::Attach(eventClientChangeTeam, shokHUD::teamEvents);
Event::Attach(eventKillTrak, shokHUD::killEvents);
//HUD Creation
HUD::New(shokHUD, shokHUD::Update, 540, 400, 90, 65);
HUD::Display(shokHUD, false);
HUD::Display(shokHUD, true);
HUD::New(shokPopUp, shokHUD::PopUpDisplay, 415, 420, 120, 40);
HUD::Display(shokPopUp, false);