if (IncludeFile("zear\\MoreStringPresto.cs")) {

//  String Pack for Tribes w/ the Presto Pack
//
//  Version 1.01
//
//  Written by Tim "Zear" Hammock
//
//
//  The functions supplied here are as follows:
//
// String::left(%string, %len)
// Returns the leftmost %len characters from %string. For example
// 	    String::left("What is at the left?", 7)
// will return the string
// 	    "What is"
// 
// String::right(%string, %len)
// Returns the rightmost %len characters from %string. For example
// 	    String::right("What is at the right?", 7)
// will return the string
// 	    " right?"
// 
// String::starts(%string, %search)
// Returns true if the beginning of %string exactly (including case)
// matches %search, character for character, otherwise returns false. For
// example
//      String::starts("What is at the left?", "What")
// will return true, but
//      String::starts("What is at the left?", "what")
// will return false.
// 
// String::ends(%string, %search)
// Returns true if the end of %string exactly (including case) matches
// %search, character for character, otherwise returns false. For example
// 	    String::starts("What is at the right?", "right?")
// will return true, but
// 	    String::starts("What is at the right?", "right")
// will return false (no '?').
// 
// String::insert(%string, %insert, %idx)
// Returns a string where %insert has been inserted into %string and
// position %idx. For example
// 	    String::insert("Insert into this", "Tribes ", 7)
// will return the string
// 	    "Insert Tribes into this"
// 
// String::replace(%string, %search, %replace)
// Returns a string where all instances of %search in %string have been
// replaced with an instance of %replace. For example
// 	    String::replace("Insert into this", "Insert into", "Replace")
// will return the string
// 	    "Replace this"
// 
// String::setString(%chars, %num)
// Returns a string consiting of %num repititions of %chars. For example
// 	    String::setString("Four", 4)
// will return the string
// 	    "FourFourFourFour"
// 
// String::trim(%string)
// Returns %string after stripping off any leading or trailing spaces. For
// example
//      String::trim("  too many spaces   ")
// will return the string
//      "too many spaces"
// 
// String::pad(%string, %char, %width, %justify)
// Returns %string after padding it with enough %char's to give it a
// length of %width. If %char is more than one character in length, or if
// %width is less than the initial length of %string, then %string will be
// returned unmodified. Justify can be "left", "right", or "center"
// (actually only the first character of %justify is significant and case
// doesn't matter). For example
// 	    String::pad("XXX", "o", 10, "center")
// will return the string
// 	    "oooXXXoooo"
// The most common use will likely be one where %char is passed as " "
// (single space) to allow text to be lined up in columns.
// 
// String::indexOf(%string, %search, %idx)
// Returns an index indicating the position of %search in %string, much
// like the Dynamix function String::findSubStr(). The difference here is
// that indexOf() begins searching %string after %idx characters, allowing
// you to skip over instances of %search already found earlier in %string.
// For example
// 	    String::indexOf("A string that repeats. String repeats.", "repeats", 24)
// will return 30.
// 
// String::len(%string)
// Returns the length of %string in chars. For example
// 	    String::len("A string with length.")
// will return 21.
// 
// String::getWordCount(%string)
// Returns the number of words in %string, using spaces as delimiters. For
// example
// 	    String::getWordCount("A string of words to count.")
// will return 6. Note that the period at the end is considered a part of
// the word 'count' as there is no space between them.
// 
// String::ascii(%string, %idx)
// Returns the ascii value of the %idx'th character of %string. For example:
//      String::ascii("ABC", 0)
// will return 65. %idx is zero-based, so the first character is at %idx == 0.
// Only ascii numbers 32 through 126 are returned. If the character falls
// outside that range, if %idx < 0, or if %idx >= String::len(%string), a -1
// will be returned.
//
// String::char(%ascii)
// Returns the character having the ascii value %ascii. For example:
//      String::char(65)
// will return "A". Only ascii numbers 32 through 126 are returned. If the
// value falls outside that range a "" will be returned.
//
// -------------------------------------------------
// 
// The Tribes-default string functions are:
//
// String::findSubStr(%string, %search)
// String::getSubStr(%string, %idx, %len)
// String::ICompare(%string, %search)
// String::NCompare(%string1, %string2, %len)
// String::empty(%string)
// getWord(%string, %idx)

function String::left(%string, %len)    
{
    if(%len >= String::len(%string))
        return %string;
    
    %left = String::getSubStr(%string, 0, %len);
    return %left;
}

function String::right(%string, %len)    
{
    if(%len >= String::len(%string))
        return %string;

    %idx = String::len(%string) - %len;
    %right = String::getSubStr(%string, %idx, %len);
    return %right;
}

function String::starts(%string, %search)    
{
    %idx = String::len(%search);
    if(%idx > String::len(%string))
        return false;
    
    if(String::left(%string, %idx) == %search)
        return true;
    else
        return false;
}

function String::ends(%string, %search)    
{
    %idx = String::len(%search);
    if(%idx > String::len(%string))
        return false;
    
    if(String::right(%string, %idx) == %search)
        return true;
    else
        return false;
}

function String::insert(%string, %insert, %idx)    
{
    %front = String::left(%string, %idx);
    %back = String::right(%string, String::len(%string) - %idx);
    %result = %front @ %insert @ %back;
    return %result;
}

function String::replace(%string, %search, %replace)    
{
    if(%search == %replace || String::findSubStr(%replace, %search) != -1) // prevent infinite loops
        return %string;
        
    while((%idx = String::findSubStr(%string, %search)) != -1)             
    {   
        %len = String::len(%string);
        %front = String::getSubStr(%string, 0, %idx);
        %idx += String::len(%search);
        %back = String::getSubStr(%string, %idx, %len - %idx);
        %string = %front @ %replace @ %back;
    }
    return %string; 
}

function String::setString(%chars, %num)
{
    for(%i = 0; %i < %num; %i++)
        %string = %string @ %chars;
        
    return %string;
}

function String::pad(%string, %char, %width, %justify)
{
    %len = String::len(%string);
    if(%len < %width && String::len(%char) == 1)
    {    
        %justify = String::getSubStr(%justify, 0, 1);
        if(%justify == "l" || %justify == "L")
        {
            %string = %string @ String::setString(%char, %width - %len);
            return %string;
        }
        if(%justify == "r" || %justify == "R")
        {
            %string = String::setString(%char, %width - %len) @ %string;
            return %string;
        }
        if(%justify == "c" || %justify == "C")
        {
            %right = (%width - %len) / 2;
            %string = %string @ String::setString(%char, %right);
            %left = %width - String::len(%string);
            %string = String::setString(%char, %left) @ %string;
            return %string;
        }
    }
    return %string;
}

function String::trim(%string)
{
    while(String::starts(%string, " "))
    {
        %string = String::right(%string, String::len(%string) - 1);
    }
    while(String::ends(%string, " "))
    {
        %string = String::left(%string, String::len(%string) - 1);
    }
    return %string;
}

function String::indexOf(%string, %search, %idx)
{
    %newString = String::getSubStr(%string, %idx, String::len(%string) - %idx);
    %newIdx = %idx + String::findSubStr(%newString, %search);
    return %newIdx;
}

function String::len(%string) 
{
    for(%length=0; String::getSubStr(%string, %length, 1) != ""; %length++)
    {} // it's all done above!
    return %length;
}
           
function String::getWordCount(%string)
{
    for(%num = 0; getWord(%string, %num) != -1; %num++)
    {} // it's all done above!
    return %num;
}

$String::asciiString = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";

function String::ascii(%string, %idx)
{
	if(String::len(%string) <= %idx || %idx < 0)
	    return -1;
	%char = String::getSubStr(%string, %idx, 1);
	%idx = String::findSubStr($String::asciiString, %char);
	if(%idx < 0)
		return -1;

	if(String::Compare(%char, String::getSubStr($String::asciiString, %idx, 1)) == 0)
		return %idx + 32;
    else
        return %idx + 64;
}

function String::char(%ascii)
{
	if(%ascii < 32 || %ascii > 126)
		return "";
	else
		return String::getSubStr($String::asciiString, %ascii-32, 1);
}

} // IncludeFile