// SplitMSG - Split Message Boxes!		05/15/99

// Note: My first original script, and it's still somewhat based on 
//	 someone else's code (only in some parts :)... thanx to Presto 
//	 for the very useful PRESTO Pack.

// A real simple script (hopefully to be improved upon) that separates 
// player death messages (using a variation of Presto's kill-tracking 
// code) and displays all death messages in a seperate window, so you
// can actually see those player messages in large servers!
// Since I'm new to scripting, feel free to modify or optimize this
// just try to tell me what you did so I can maybe apply the same
// technique sometime in the future :)
// (Most) Code by VKTR - jgill@on.aibn.com  

// NOTE: You need the PrestoPack AND GrimJack's string_lengths.cs (which
//       in turn requires Zear's MoreStringPresto.cs script...)
//       got all that? It should ALL be in the .ZIP you get this with

include("Presto\\HUD.cs");
include("Presto\\KillTrak.cs");
include("presto\\Events.cs");
include("GrimJack\\string_lengths.cs");
include("Presto\\match.cs");

// How many message rows to store?
$SplitMSG::NumRows     = 5;	

// SplitMSG HUD bar position on screen... still testing for now
// Note that the last value is the number of pixels **PER ROW**!!!
$SplitMSG::Position = "0% 90% 300 " @ ($SplitMSG::NumRows-1) @ "*17";
$SplitMSG::UpdateTeamHUD = false;

// The following code docks SplitMSG onto TeamHUD if it's included...
// If you don't like this, comment (put a // in front of) the
// following 4 lines
if (included("presto\\teamHUD.cs")) {
	echo("SplitMSG Docking to TeamHUD");
	$SplitMSG::Position = "0% top(hudTeam)-" @ (($SplitMSG::NumRows-1)*17) @ " 300 " @ ($SplitMSG::NumRows-1) @ "*17";
	$SplitMSG::UpdateTeamHUD = true;
}

// Key that toggles SplitMSG bar on/off. Note filtering does NOT occur
// when SplitMSG is hidden.
$SplitMSG::ToggleKey = "control n";

// The Master Filter variable. can be toggled on/off with
// the next line
$SplitMSG::FilterExtras = true;

// Toggle key
$SplitMSG::ToggleFilter = "alt f";

// Filter backpack messages (ie "repair on", "shield on", etc)
$SplitMSG::FilterBackPack = true;

// Filter inventory station messages? (ie "Station access on", etc)
$SplitMSG::FilterInvStation = true;

// Note: filtering the above "extra" messages will not cause them to
//       appear in the SplitMSG window, as they are generally really
//	 obvious information.

function SplitMSG::UpdateWindow() {
	for (%i = 0; (%i < $SplitMSG::NumRows); %i++) {	
		HUD::AddtextLine(SplitMSGWindow, "<f2>" @ $SplitMSG::Row[%i]);
	}
}

function SplitMSG::Init() {
	for (%i = 0; (%i < $SplitMSG::NumRows); %i++) {
		$SplitMSG::Row[%i] = "";
	}

	HUD::New(SplitMSGWindow, "SplitMSG::UpdateWindow", $SplitMSG::Position);
	HUD::Display(SplitMSGWindow);
}


function SplitMSG::PostNewMsg(%Msg) {	
	%msg = String::Trim(%msg);	// Nuke the empty spaces
	%msglen = String::FindPixelWidth(%msg);
	
	while(%msglen > 0) {
		%oldmessage = %msg;
		%oldlength = %msglen;

		%msg = String::TrimToPixelWidth(%msg, HUD::Width(SplitMSGWindow)-10);				

		if (getword(%msg, String::GetWordCount(%msg)-1) != getword(%oldmessage, String::GetWordCount(%oldmessage)-1)) {
			for (%i = 0; %i < (String::GetwordCount(%msg) - 1); %i++) {
				%displaymessage = %displaymessage @ " " @ getword(%msg, %i);	
			}
			%msg = %displaymessage;
		}
		
		%endofstring = String::len(%msg);
		%displaymessage = "";

		for (%i = 0; %i < ($SplitMSG::NumRows-1); %i++) {
			$SplitMSG::Row[%i] = $SplitMSG::Row[%i+1];
		}
		$SplitMSG::Row[$SplitMSG::NumRows-1] = %msg;
		HUD::Update(SplitMSGWindow);
		
		%msg = String::GetSubStr(%oldmessage, %endofstring, %oldlength);
		%msglen = String::FindPixelWidth(%msg);		
	}
}

function SplitMSG::ParseMessage(%client, %message) {
	if (%client != 0)
		return;

	// Don't filter it if the window isn't there!
	if (!HUD::GetDisplayed(SplitMSGWindow))
		return;

	// Cycle thru all known Death Messages and mute it if applicable
	// Note: if it's a DeathMsg, it will be muted... but also thrown
	// into another HUD window, so Don't worry about missing em.
	// Yeah, yeah, this IS how Presto did it...

	for (%i = 0; %i < $KillTrak::numDeaths; %i++) {
		if (Match::ParamString(%message, $KillTrak::death[%i])) {
			SplitMSG::PostNewMsg(%message);
			return mute;
			}
		}

	if ($SplitMSG::FilterExtras) 
		for (%i = 0; %i < $SplitMSG::ExtraMSGCount; %i++) {
			if (Match::ParamString(%message, $SplitMSG::FilterList[%i]))
				return mute;
		}
	return;
        
}

// This is better than the last version, I didn't know the HUD::Move
// function existed then... sorry :)
function SplitMSG::RecalcHUD() {
	%disp = HUD::GetDisplayed(SplitMSGWindow);	
	HUD::Move(SplitMSGWindow, $SplitMSG::Position);
	HUD::Update(SplitMSGWindow);
}

function SplitMSG::FilterMessage(%msg) {
	if ($SplitMSG::ExtraMSGCount == "") {
		$SplitMSG::ExtraMSGCount = 0;
	}
	$SplitMSG::FilterList[$SplitMSG::ExtraMSGCount] = %msg;
	$SplitMSG::ExtraMSGCount++;
}

function SplitMSG::ToggleExtraFilter() {
	if ($SplitMSG::FilterExtras) {
		SplitMSG::PostNewMsg("<f0>Extra Message Filtering Off");	
		$SplitMSG::FilterExtras = false;
	} else {
		SplitMSG::PostNewMsg("<f0>Extra Message Filtering On");
		$SplitMSG::FilterExtras = true;
	}
}

// Define extra message filtering:
if ($SplitMSG::FilterBackPack) {
	SplitMSG::FilterMessage("Shield %1");
	SplitMSG::FilterMessage("AutoRepair %1");
	SplitMSG::FilterMessage("Sensor Jammer %1");
	SplitMSG::FilterMessage("Nothing in range");
}

if ($SplitMSG::FilterInvStation) {
	SplitMSG::FilterMessage("Station Access %1");
	SplitMSG::FilterMessage("Resupply Complete");
	SplitMSG::FilterMessage("Bought Laser Rifle - Auto Buying Energy Pack");
	SplitMSG::FilterMessage("Sold Energy Pack - Auto Selling Laser Rifle");
}

// Attach all our pretty little events
Event::attach(eventClientMessage, SplitMSG::ParseMessage);
Event::attach(eventConnected, "SplitMSG::Init();");

// If we're using TeamHUD Docking, the TeamHUD can change size, so we should
// make sure SplitMSGWindow moves with it, not sure if Presto's top(%hud) will
// automatically do this, so better safe than sorry!
if ($SplitMSG::UpdateTeamHUD == true)
	if (included("presto\\TeamHUD.cs")) {
		Event::Attach(eventTeammateJoined, "SplitMSG::RecalcHUD();");
		Event::Attach(eventTeammateLeft, "SplitMSG::RecalcHUD();");
		Event::Attach(eventClientChangeTeam, "SplitMSG::RecalcHUD();");
	}

// Presto's Bindkey function
bindkey(play, $SplitMSG::ToggleKey, "HUD::ToggleDisplay(SplitMSGWindow);");
bindkey(play, $SplitMSG::ToggleFilter, "SplitMSG::ToggleExtraFilter();");