// -- New events -------------------------------------------------------------------------------------------
// Written by |HH|Crunchy (Jonathan Slark)
// Email: jonslark@barrysworld.co.uk
//
// New events:
//
//	eventMissionInfo(%server, %missionName, $ServerMissionType)
//
//		This event is triggered during the loading process as soon as the mission information is 
//		available to the client side.  The event returns the server ID, mission name and mission type.  
//		If the server ID is 2048 then you are hosting the game yourself.
//

//
// -- Event Triggers --
//

// Overriden function from client.cs
// Called with mission information.
function remoteMInfo(%server, %missionName)
{
	if(%server == 2048)
	{
		%file = "missions\\" @ %missionName @ ".dsc";
		$MDESC::Type = "";
		$MDESC::Text = "";
		if(File::findFirst(%file) != "")
			exec(%file);
		$ServerMission = %missionName;
		$ServerText = $MDESC::Text;
		$ServerMissionType = $MDESC::Type;
		if(isObject(LobbyGui))
			LobbyGui::onOpen();  // update lobby screen text.
	}

	Event::Trigger(eventMissionInfo, %server, %missionName, $ServerMissionType);
}
