// The key that toggles VKTRHUD on/off
$VHud::ToggleKey = "alt o";

// indicate how big each row is... best leave these alone.
$VHud::Dimensions = "120 17";

// $VHud::Position is where the HUD is... $VHud::Dimensions (Presto format)
// sorry to all you who got this before, I changed this ...it overlapped 
// DynHUD :)
$VHud::Position = "100% 100%";

// set to true to "attach" VKTRHUD to TeamHUD
$VHud::DockToTeamHUD = true;

if (($VHud::DockToTeamHUD) && (included("presto\\teamhud.cs"))) {
	$VHud::Position = "100% top(hudTeam)-" @ (getword($VHud::Dimensions, 1) * 3);
} else
	$VHud::DockToTeamHUD = false;

// Displayed by default?
$VHud::Display = true;

// make sure no data is left from prev missions
$VHud::Data[VHud0] = "";	// Friendly Destroy Data
$VHud::Data[VHud1] = "";	// Enemy Destroy Data
$VHud::Data[VHud2] = "";	// Global Capture Data

// Line captions on D&D, C&H, F&R mission lines
$VHud::Caption[VHud0] = "Fr:";		// Friendly objectve data
$VHud::Caption[VHud1] = "En:";		// Enemy objective data
$VHud::Caption[VHud2] = "Cap:";		// Global Capture data

// Mission Type Constants
$VHud::CTF = "Capture the Flag";
$VHud::DM = "Deathmatch";
$VHud::DD = "Defend and Destroy";
$VHud::FR = "Find and Retrieve";
$VHud::CH = "Capture and Hold";

include("presto\\event.cs");
include("presto\\HUD.cs");
include("crunchy\\events.cs");
include("crunchy\\ObjectiveTrak.cs");
include("presto\\match.cs");
include("presto\\Teamtrak.cs");

// For determining mission type reliably
$VHud::OldServerType = "";
$VHud::ServerTracking = false;
$VHud::ServerRetryCount = 0;

function VHud::Banner() {
	Presto::Addscriptbanner(VHud, 
		"<f0>VektorHUD v0.2\n"@
		"<f1>Objective/CTF tracking HUD\n"@
		"Toggle On/Off key: "@$VHud::ToggleKey@"\n"@
		"<f2>By: VeKToR <f1>jgill@on.aibn.com");
}

function VHud::GetServerType() {
	return $ServerMissionType;
}

function VHud::Reset() {
	$VHud::Score[0] = 0;
	$VHud::Score[1] = 0;
}

function VHud::Init() {
//	echo(VHud::GetServerType);
	if (VHud::GetServerType == "") {
//		echo("Checking Server type...");
		if ($VHud::Attempts < 7)
			Schedule("VHud::Init();", 3);
		$VHud::Attempts++;
		return;
	}

	if (VHud::GetServerType() == $VHud::CTF) {
//		echo("CTF!");
		%HudDimY = getword($VHud::Dimensions, 1);
		$VHud::Score[0] = 0;
		$VHud::Score[1] = 0;
		for (%i = 0; %i < 2; %i++) {
			HUD::New("VHudCTF"@%i, "VHud::CTFCheck"@%i, $VHud::Position @ "+" @ %HudDimY*%i, $VHud::Dimensions);
			HUD::Display("VHudCTF"@%i);
			HUD::Update("VHudCTF"@%i);
		}
		HUD::New(VHud2, VHud::ShowText, $VHud::Position @ "+" @ %HudDimY*2, $VHud::Dimensions);
		HUD::Display("VHud"@%i);
		Schedule("VHud::DisplayMe();", 1);		
	
	} else if (VHud::GetServerType() == $VHud::Dm) {
//		echo("DM!");
	} else {
//		echo("D&D, F&R, C&H!");
	
		%HudDimY = getword($VHud::Dimensions, 1);

		for (%i = 0; %i < 3; %i++) {
			HUD::New("VHud" @ %i, VHud::ShowText, $VHud::Position @ "+" @ %HudDimY*%i, $VHud::Dimensions);
			HUD::Display("VHud"@%i, true);
		}
		Schedule("VHud::DisplayMe();", 1);
	}
}

function VHud::HandleTeamChange(%clientID) {

	// Don't have to update if it wasn't us changing teams :)
	if (%clientID != getManagerID())
		return;

//	echo("Team Change!");

	if (VHud::GetServerType() == $VHud::CTF) {
		HUD::Update(VHudCTF0);
		HUD::Update(VHudCTF1);
	}
	if (VHud::GetServerType() != $VHud::DM)
		VHud::DisplayMe();
}

event::Attach(eventClientChangeTeam, VHud::HandleTeamChange);

function VHud::UpdateFlagCap(%flagteam) {
	// %flagteam points to the team that OWNS the flag
	// that gets captured, not the team that captured it
	// so, we gotta flip 1's to 0's and vice-versa
	%flagteam = 1 - %flagteam;
	
//	echo("Flag Cap'd: " @ %flagteam);
	
	$VHud::Score[%flagteam]++;

	HUD::Update(VHudCTF0);
	HUD::Update(VHudCTF1);
}
event::Attach(eventFlagCaptured, VHud::UpdateFlagCap);

// Individual CTF update functions for each HUD... inefficient?
// maybe... the code would be about the same length (maybe longer)
// if combined into one function, so who carez?

function VHud::CTFCheck0() {
	%Flagloc = Team::GetFlagLocation(Team::Friendly());	
	%team = Team::Friendly();
	
	HUD::AddText(VHudCTF0, "<B0,3:VeKToR\\flag_green.bmp>");
	if (%Flagloc == $Trak::locationhome) {
		HUD::AddtextLine(VHudCTF0, ": <f1>Home (" @ $VHud::Score[%team] @ ")" );
	} else if (%Flagloc == $Trak::locationField) {
		HUD::AddtextLine(VHudCTF0, ": <f1>Field (" @ $VHud::Score[%team] @ ")" );
	} else if (%Flagloc == "") {
		HUD::AddtextLine(VHudCTF0, ": <f1>???");
	} else {
		HUD::AddtextLine(VHudCTF0, ": <f2>" @ %Flagloc @ " (" @ $VHud::Score[%team] @ ")" );
	}

	return;
}

function VHud::CTFCheck1() {
	%Flagloc = Team::GetFlagLocation(Team::Enemy());	
	%team = Team::Enemy();	

	HUD::AddText(VHudCTF1, "<B0,3:VeKToR\\flag_red.bmp>");
	if (%Flagloc == $Trak::locationhome) {
		HUD::AddtextLine(VHudCTF1, ": <f1>Home (" @ $VHud::Score[%team] @ ")" );
	} else if (%Flagloc == $Trak::locationField) {
		HUD::AddtextLine(VHudCTF1, ": <f1>Field (" @ $VHud::Score[%team] @ ")" );
	} else if (%Flagloc == "") {
		HUD::AddtextLine(VHudCTF1, ": <f1>???");
	} else {
		if (%Flagloc == client::getname(getManagerID()))
			HUD::AddtextLine(VHudCTF1, ": <f2>YOU!<f1> (" @ $VHud::Score[%team] @ ")");
		else
			HUD::AddtextLine(VHudCTF1, ": <f2>" @ %Flagloc @ "<f1> (" @ $VHud::Score[%team] @ ")" );
	}

	return;
}
event::Attach(eventFlagsUpdated, "HUD::Update(VHudCTF0);HUD::Update(VHudCTF1);");

function VHud::ShowText(%hud) {	
	HUD::AddtextLine(%hud, $VHud::Caption[%hud] @ $VHud::Data[%hud]);
	return;
}

function VHud::DisplayMe() {
	// Get status of ALL current objectives, and update the HUD's

	for (%i = 0; %i < 3; %i++)	
		$VHud::Data["VHud"@%i] = "";
	
	%numobj = Objective::Number();
	if (%numobj > 0) {
		for (%ix = 0; %ix < %numobj; %ix++) {
			%status = Objective::GetStatus(%ix);
			%client = Objective::GetClient(%ix);
			%type = Objective::GetType(%ix);
			%textline = Objective::GetNameStripped(%ix);

			if (%type == $Objective::DandD) {
				%textline = Objective::InsertTeamName(%textline);
				%team = 0;

				if (String::FindSubStr(%textline, "Your") != -1)
					%team = 1;
				if (String::FindSubStr(%textline, "your") != -1)
					%team = 1;

				if (%team == 0) {
					if (String::findSubStr(%textline, "Turret") != -1) {						
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:M_turret_red.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:M_turret_green.bmp>";
					} else if (String::findSubStr(%textline, "Solar") != -1 || String::findSubStr(%textline, "Generator") != -1) {
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:M_generator_red.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:M_generator_green.bmp>";
					} else if (String::findSubStr(%textline, "Station") != -1 || String::findsubstr(%textline, "Command") != -1) {
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:M_station_red.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:M_station_green.bmp>";
					} else if (String::findSubStr(%textline, "Sensor") != -1) {
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:M_motionsensor_red.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:M_motionsensor_green.bmp>";
					} else {
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:CMD_DamageHigh.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,0:CMD_DamageLow.bmp>";
					}
					$VHud::Data[VHud1] = $VHud::Data[VHud1] @ %symbol;
				}
// _______________________________________________________________________________________
				else if (%team == 1) {
					if (String::findSubStr(%textline, "Turret") != -1) {						
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:M_turret_red.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:M_turret_green.bmp>";
					} else if (String::findSubStr(%textline, "Solar") != -1 || String::findSubStr(%textline, "Generator") != -1) {
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:M_generator_red.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:M_generator_green.bmp>";
					} else if (String::findSubStr(%textline, "Station") != -1 || String::findSubStr(%textline, "Command") != -1) {
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:M_station_red.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:M_station_green.bmp>";
					} else if (String::findSubStr(%textline, "Sensor") != -1) {
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:M_motionsensor_red.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:M_motionsensor_green.bmp>";
					} else {
						if (%status == $Objective::Destroyed)
							%symbol = "<B0,0:CMD_DamageHigh.bmp>";
						else if (%status == $Objective::Neutral)
							%symbol = "<B0,2:CMD_DamageLow.bmp>";
					}
					$VHud::Data[VHud0] = $VHud::Data[VHud0] @ %symbol;
				}

			} else if (%type == $Objective::CandH) {
				if (%status == $Objective::Enemy) {
					$VHud::Data[VHud2] = $VHud::Data[VHud2] @ "<B0,3:VeKToR\\tower_red.bmp>";
				} else if (%status == $Objective::Friendly) {
					$VHud::Data[VHud2] = $VHud::Data[VHud2] @ "<B0,3:VeKToR\\tower_green.bmp>";
				} else if (%status == $Objective::Neutral) {
					$VHud::Data[VHud2] = $VHud::Data[VHud2] @ "<B0,3:VeKToR\\tower_gray.bmp>";
				}
			} else if (%type == $Objective::FandR) {
				if ((%status == $Objective::Enemy) || (%status == $Objective::EnemyCarry)) {
					$VHud::Data[VHud2] = $VHud::Data[VHud2] @ "<B0,3:VeKToR\\flag_red.bmp>";
				} else if ((%status == $Objective::Friendly) || (%status == $Objective::FriendlyCarry)) {
					$VHud::Data[VHud2] = $VHud::Data[VHud2] @ "<B0,3:VeKToR\\flag_green.bmp>";
				} else if (%status == $Objective::Neutral) {
					$VHud::Data[VHud2] = $VHud::Data[VHud2] @ "<B0,3:VeKToR\\flag_gray.bmp>";
				}
			}
		}
	}
	
	if ((VHud::GetServerType() != $VHud::DM) && (VHud::GetServerType() != $VHud::CTF)) {
		for (%i = 0; %i < 2; %i++) {
			if (($VHud::Data["VHud"@%i] != "") && ($VHud::Display == true)) {
				HUD::Update("VHud" @ %i);
				HUD::Display("VHud" @ %i);		
			} else if (HUD::GetDisplayed("VHud" @ %i) == true)
				HUD::Display("VHud" @ %i, false);		
		}
	}

	if (($VHud::Data[VHud2] != "") && ($VHud::Display == true) && (VHud::GetServerType != $VHud::DM)) {
		HUD::Update(VHud2);
		HUD::Display(VHud2);		
	} else if (HUD::GetDisplayed(VHud2) == true)
		HUD::Display(VHud2, false);		

}
event::Attach(eventObjectiveReset, "VHud::Displayme();");
event::Attach(eventObjectiveLoaded, "VHud::Displayme();");
event::Attach(eventObjectiveMadeNeutral, "VHud::Displayme();");
event::Attach(eventObjectiveNew, "VHud::Displayme();");
event::Attach(eventObjectiveUpdated, "VHud::Displayme();");

function VHud::Toggle() {
	$VHud::Display = !($VHud::Display);
	
	if (VHud::GetServerType() == $VHud::CTF) {
		for (%i = 0; %i < 2; %i++) {
			HUD::Update("VHudCTF"@%i);
		}
	} else if (VHud::GetServerType() == $VHud::DM) 
//		echo("Do something! sometime....");

	VHud::DisplayMe();
}

// Make sure it's still aligned with Presto's teamhud (teamhud grows as
// clients join). If not, move it.
function VHud::UpdateDocking() {
	%VHud::HeightOfLine = getword($VHud::Dimensions, 1);
	
	for (%i = 0; %i < 3; %i++) {
		if (HUD::Exists("VHud"@%i)) {
			HUD::Move("VHud"@%i, $VHud::Position @ "+" @ (%VHud::HeightOfLine * %i) @ " " @ $VHud::Dimensions);
		}		
		if (HUD::Exists("VHud"@%i)) {
			HUD::Move("VHudCTF"@%i, $VHud::Position @ "+" @ (%VHud::HeightOfLine * %i) @ " " @ $VHud::Dimensions);
		}
	}
}

if ($VHud::DockToTeamHUD) {
	Event::Attach(eventTeammateJoined, "VHud::UpdateDocking();");
	Event::Attach(eventTeammateLeft, "VHud::UpdateDocking();");
	Event::Attach(eventClientChangeTeam, "VHud::UpdateDocking();");
}

// Only REALLY reliable way I could find to keep mission type
// constantly updated - eventChangeMission dosen't update
// servertype until the game actually starts, and I don't know 
// how to detect game startup... crude, but it works!

function VHud::UpdateMissionType() {
//	echo("Checking Server type");
	$VHud::ServerTracking = true;
	if (VHud::GetServerType() != $VHud::OldServerType) {
		$VHud::ServerTracking = false;
		// Hide ALL the HUD's (if we're changing types, some
		// HUDs are probably not going to be needed.
		HUD::Display(VHudCTF0, false);
		HUD::Display(VHudCTF1, false);
		HUD::Display(VHud0, false);
		HUD::Display(VHud1, false);
		HUD::Display(VHud2, false);

		VHud::Init();
		$VHud::OldServerType = VHud::GetServerType();
	} else if ($VHud::ServerRetryCount < 60) {
		// we don't need to check for more than 2 minutes, GUARANTEED
		// (dosen't matter HOW bad your connection is :)
		Schedule("VHud::UpdateMissionType();", 2);
		$VHud::ServerRetryCount++;
	} else {
		$VHud::ServerTracking = false;
		$VHud::ServerRetryCount = 0;
	}
}

event::attach(eventChangeMission, "if (!VHud::ServerTracking) { VHud::Reset();VHud::UpdateMissionType(); }");
event::attach(eventconnected, "if (!VHud::ServerTracking) { VHud::UpdateMissionType(); }");

bindkey(play, $VHud::ToggleKey, "VHud::Toggle();");