// --------------------------
// wepHUD 1.0 by shokugE
// --------------------------
//
// *** For bug/request/ideas, please contact me@ shokuge@geocities.com
//   wepHUD and my other scripts can be downloaded from
//   http://www.geocities.com/TimesSquare/Galaxy/6633/
//
// Intro:
//
// wepHUD is a simple kill/death tracker for different weapons.  You'll
// need Presto Pack installed to use wepHUD.
// For info on Presto Pack please go to
// http://www.cdc.net/~presto/tribes
//
// Version history:
//
// 3/24/99 - wepHUD 1.0 released
//
// Feature/Change/Addition List:
//
// wepHUD 1.0
// - A simple list of kills and deaths of certain weapon
//
// HUD Description:
//
// wepHUD is fairly simple.  It's just a list of kills and deaths
// of different weapons.  To the left of the weapon icon is the kills
// and to the right is deaths.  From top to bottom, the icons are:
// Blaster, Plasma, Chaingun, Disc Launcher, Grenade/Mine, Mortar,
// Laser Rifle, ELF gun.
//
// By default, the HUD is toggled on/off using Alt-N.  This can be changed.
//
// Note:
//
// This version is not yet commented due to my lack of sleep, however the
// code it pretty straight forward.  If you have knowledge of Presto Pack
// libraries it shouldn't be a problem.
//
// Installation:
//
// 1) Install Presto Pack.  Please refer to his docs for this part.
// 2) Place this file in your Tribes /config/ directory.
// 3) Add the following line to the autoexec.cs file in your tribes /base/
//    directory:
//
//    exec("wepHUD.cs");
//
//    If you do not have an autoexec.cs file, you'll have to create one.
// 4) Be sure to change the key binding for HUD toggle if you don't like
//    Alt-N.
//
//		- shokugE, 3/24/99

// Keyboard bindings

bindCommand(keyboard0, make, alt, "n", TO, "HUD::ToggleDisplay(wepHUD);");
bindCommand(keyboard0, break, alt, "n", TO, "");

// ================
// Presto's stuff
// ================

// Includes
Include("presto\\HUD.cs");
Include("presto\\KillTrak.cs");
// Event Detachments (to clean things up)
Event::Detach(eventConnected);
Event::Detach(eventChangeMission);
Event::Detach(eventKillTrak);

function wepHUD::Update() {
	if ($wepHUD::wepKill[1] == "") wepHUD::Reset();

	%imageTag = "<B";
	
	for (%i = 0; %i < 8; %i++) {
		HUD::AddTextLine(wepHUD,
			$wepHUD::wepKill[%i] @
			%imageTag @
			wepHUD::getWepIcon(%i) @
			">" @
			$wepHUD::wepDeath[%i]);
	}
}

function wepHUD::Reset() {
	for (%i = 0; %i < 8; %i++) {
		$wepHUD::wepKill[%i] = 0;
		$wepHUD::wepDeath[%i] = 0;
	}
	HUD::Update(wepHUD);
}

function wepHUD::killEvents(%killer, %victim, %weapon) {
	%me = getManagerId();

	if (%killer == %me && %victim != %me)
		$wepHUD::wepKill[wepHUD::getWepNum(%weapon)]++;
	else if (%victim == %me)
		$wepHUD::wepDeath[wepHUD::getWepNum(%weapon)]++;

	HUD::Update(wepHUD);
}

function wepHUD::getWepNum(%weapon) {
	if (%weapon == "Blaster")
		return 0;
	else if (%weapon == "Plasma")
		return 1;
	else if (%weapon == "Chaingun")
		return 2;
	else if (%weapon == "Disc Launcher")
		return 3;
	else if (%weapon == "Mine")
		return 4;
	else if (%weapon == "Mortar")
		return 5;
	else if (%weapon == "Laser Rifle")
		return 6;
	else if (%weapon == "ELF Gun")
		return 7;
	else
		return -1;
}

function wepHUD::getWepIcon(%weapon) {
	if (%weapon == 0)
		return "lr_blaster_on.bmp";
	else if (%weapon == 1)
		return "lr_plasma_on.bmp";
	else if (%weapon == 2)
		return "lr_chain_on.bmp";
	else if (%weapon == 3)
		return "lr_disk_on.bmp";
	else if (%weapon == 4)
		return "lr_grenade_on.bmp";
	else if (%weapon == 5)
		return "lr_mortar_on.bmp";
	else if (%weapon == 6)
		return "lr_sniper_on.bmp";
	else if (%weapon == 7)
		return "lr_energyrifle_on.bmp";
	else
		return -1;
}

// Event Attachments
Event::Attach(eventConnected, shokHUD::Reset);
Event::Attach(eventChangeMission, shokHUD::Reset);
Event::Attach(eventKillTrak, wepHUD::killEvents);
// HUD Creation
HUD::New(wepHUD, wepHUD::Update, 590, 290, 45, 105);
HUD::Display(wepHUD, false);
HUD::Display(wepHUD, true);