// Installation example:

//	exec("Presto\\Install.cs");
//	Include("NewOpts\\Install.cs");
//	Include("Fudge\\TinyNotifyHUD.cs");

// Created by [TNT]Fudge

if (!$Presto::installed || $Presto::version < 0.93) // Check presto pack is installed.
	echo("TinyNotifyHUD: requires Presto Pack 0.93 or later.");
else {


function TinyNotifyHUD::SetDefaults() {
	$FudgePref::TinyNotifyHUDPos = "45% 80% 200 51";
}

if(isFile("config\\FudgePrefs.cs")) {
	Include("FudgePrefs.cs");
} else {
	TinyNotifyHUD::SetDefaults();
}

if($FudgePref::TinyNotifyHUDPos == "") {
	TinyNotifyHUD::SetDefaults();
}

Include("Presto\\HUD.cs");
Include("Presto\\Event.cs");
Include("Presto\\TeamTrak.cs");

Event::Attach(eventConnected, TinyNotifyHUD::onInit);
Event::Attach(eventChangeMission, TinyNotifyHUD::onInit);
Event::Attach(eventFlagCaptured, TinyNotifyHUD::onFlagCaptured);
Event::Attach(eventFlagTaken, TinyNotifyHUD::onFlagTaken);
Event::Attach(eventFlagDropped, TinyNotifyHUD::onFlagDropped);
Event::Attach(eventFlagReturned, TinyNotifyHUD::onFlagReturned);
Event::Attach(eventKillTrak, TinyNotifyHUD::onDeath);

function TinyNotifyHUD::AddBanner()
{
	Presto::AddScriptBanner(TinyNotifyHUD,
		" <f2>TinyNotifyHUD <jr><f0>version 0.2 <jl>\n" @
		" \n" @
		" <f0>Pops up a HUD showing info when\n" @
		" <f0> - someone caps a flag.\n" @
		" <f0> - someone drops/returns it\n" @
		" <f0> - someone kills you.\n" @
		" <f0> - you kill someone.\n" @
		" <f0>Written by: <f1>[TNT]Fudge\n" @
		" <f1>fudge@c2i.net");
}

function TinyNotifyHUD::UpdateHUD()
{
	HUD::AddTextLine(TinyNotifyHUD, $TinyNotifyHUD::TextLine[0]);
	if( $TinyNotifyHUD::TextLine[1] != "" )
		HUD::AddTextLine(TinyNotifyHUD, $TinyNotifyHUD::TextLine[1]);
	if( $TinyNotifyHUD::TextLine[2] != "" )
		HUD::AddTextLine(TinyNotifyHUD, $TinyNotifyHUD::TextLine[2]);
	return 0;
}

function TinyNotifyHUD::Rescale() {

	if( $TinyNotifyHUD::TextLine[1] == "" ) 
		%nHeight = 16;
	else if( $TinyNotifyHUD::TextLine[2] == "" )
		%nHeight = 16*2;
	else
		%nHeight = 16*3;

	$FudgePref::TinyNotifyHUDPos = getWord($FudgePref::TinyNotifyHUDPos,0)@" "@
										    getWord($FudgePref::TinyNotifyHUDPos,1)@" "@
								          getWord($FudgePref::TinyNotifyHUDPos,2)@" "@%nHeight;

	HUD::Move(TinyNotifyHUD, $FudgePref::TinyNotifyHUDPos );
}

function TinyNotifyHUD::PopUp() {
	$TinyNotifyHUD::MsgCount += 1;
	TinyNotifyHUD::Rescale();
	HUD::Display(TinyNotifyHUD);
	HUD::Update(TinyNotifyHUD);
	schedule("TinyNotifyHUD::PopDown();", 4);
}

function TinyNotifyHUD::ShowCount() {
	echo("Popup Count = "@$TinyNotifyHUD::MsgCount@"\n");
}

function TinyNotifyHUD::PopDown() {
	if( $TinyNotifyHUD::MsgCount > 0 )
		$TinyNotifyHUD::MsgCount -= 1;

	if( $TinyNotifyHUD::MsgCount == 0 )
		HUD::Display(TinyNotifyHUD, false );

	echo("PopDown("@$TinyNotifyHUD::MsgCount@")");
}

function TinyNotifyHUD::onFlagCaptured( %teamNum, %client) {

	%sCapper = Client::getName(%client);

	if( %teamNum == Client::GetTeam(getManagerID()) ) {
		$TinyNotifyHUD::TextLine[0] = "<jc><f1>Your flag was captured by";
		$TinyNotifyHUD::TextLine[1] = "<jc><f2>"@%sCapper;
		$TinyNotifyHUD::TextLine[2] = "";
	} else if( ( 1 - %teamNum ) == Client::GetTeam(getManagerID() ) ) {
		$TinyNotifyHUD::TextLine[0] = "<jc><f2>"@%sCapper;
		$TinyNotifyHUD::TextLine[1] = "<jc><f1>captured the enemy flag";
		$TinyNotifyHUD::TextLine[2] = "";
	} else { 
		$TinyNotifyHUD::TextLine[0] = "<jc><f2>"@%sCapper;
		$TinyNotifyHUD::TextLine[1] = "<jc><f1>captured a flag";
		$TinyNotifyHUD::TextLine[2] = "";
	}

	TinyNotifyHUD::PopUp();
}

function TinyNotifyHUD::onFlagTaken(%teamNum, %client) {

	%sCapper = Client::getName(%client);

	if( %teamNum == Client::GetTeam(getManagerID()) ) {
		$TinyNotifyHUD::TextLine[0] = "<jc><f1>Your flag was <f2>taken <f1>by";
		$TinyNotifyHUD::TextLine[1] = "<jc><f2>"@%sCapper;
		$TinyNotifyHUD::TextLine[2] = "";
	} else if( ( 1 - %teamNum ) == Client::GetTeam(getManagerID() ) ) {
		$TinyNotifyHUD::TextLine[0] = "<jc><f2>"@%sCapper;
		$TinyNotifyHUD::TextLine[1] = "<jc><f2>took <f1>the enemy flag";
		$TinyNotifyHUD::TextLine[2] = "";
	} else { 
		$TinyNotifyHUD::TextLine[0] = "<jc><f2>"@%sCapper;
		$TinyNotifyHUD::TextLine[1] = "<jc><f2>took <f1>a flag";
		$TinyNotifyHUD::TextLine[2] = "";
	}

	TinyNotifyHUD::PopUp();
}

function TinyNotifyHUD::onFlagDropped(%teamNum, %client) {

	%sCapper = Client::getName(%client);

	if( %teamNum == Client::GetTeam(getManagerID()) ) {
		$TinyNotifyHUD::TextLine[0] = "<jc><f1>Your flag was <f2>dropped <f1>by";
		$TinyNotifyHUD::TextLine[1] = "<jc><f2>"@%sCapper;
		$TinyNotifyHUD::TextLine[2] = "";
	} else if( ( 1 - %teamNum ) == Client::GetTeam(getManagerID() ) ) {
		$TinyNotifyHUD::TextLine[0] = "<jc><f2>"@%sCapper;
		$TinyNotifyHUD::TextLine[1] = "<jc><f2>dropped <f1>the enemy flag";
		$TinyNotifyHUD::TextLine[2] = "";
	} else { 
		$TinyNotifyHUD::TextLine[0] = "<jc><f2>"@%sCapper;
		$TinyNotifyHUD::TextLine[1] = "<jc><f2>dropped <f1>a flag";
		$TinyNotifyHUD::TextLine[2] = "";
	}
	TinyNotifyHUD::PopUp();
}

function TinyNotifyHUD::onFlagReturned(%teamNum, %client) {

	if( %client == 0 ) {
		if( %teamNum == Client::GetTeam(getManagerID()) ) {
			$TinyNotifyHUD::TextLine[0] = "<jc><f1>Your flag was <f2>returned";
			$TinyNotifyHUD::TextLine[1] = "";
			$TinyNotifyHUD::TextLine[2] = "";
		} else if( ( 1 - %teamNum ) == Client::GetTeam(getManagerID() ) ) {
			$TinyNotifyHUD::TextLine[0] = "<jc><f1>The enemy flag was <f2>returned";
			$TinyNotifyHUD::TextLine[1] = "";
			$TinyNotifyHUD::TextLine[2] = "";
		} else { 
			$TinyNotifyHUD::TextLine[0] = "<jc><f1>A flag was <f2>returned";
			$TinyNotifyHUD::TextLine[1] = "";
			$TinyNotifyHUD::TextLine[2] = "";
		}
	} else {

		%sCapper = Client::getName(%client);

		if( %teamNum == Client::GetTeam(getManagerID()) ) {
			$TinyNotifyHUD::TextLine[0] = "<jc><f1>Your flag was <f2>returned <f1>by";
			$TinyNotifyHUD::TextLine[1] = "<jc><f2>"@%sCapper;
			$TinyNotifyHUD::TextLine[2] = "";
		} else if( ( 1 - %teamNum ) == Client::GetTeam(getManagerID() ) ) {
			$TinyNotifyHUD::TextLine[0] = "<jc><f2>"@%sCapper;
			$TinyNotifyHUD::TextLine[1] = "<jc><f2>returned <f1>the enemy flag";
			$TinyNotifyHUD::TextLine[2] = "";
		} else { 
			$TinyNotifyHUD::TextLine[0] = "<jc><f2>"@%sCapper;
			$TinyNotifyHUD::TextLine[1] = "<jc><f2>returned <f1>a flag";
			$TinyNotifyHUD::TextLine[2] = "";
		}
	}
	TinyNotifyHUD::PopUp();
}

function TinyNotifyHUD::onDeath(%killer, %victim, %weapon) {

	%me = getManagerID();
	%sKiller = Client::getName(%killer);
	%sVictim = Client::getName(%victim);

	if( %victim == %me && %weapon == "Suicide" ) {
		$TinyNotifyHUD::TextLine[0] = "<jc><f2>You killed yourself!";
		$TinyNotifyHUD::TextLine[1] = "";
		$TinyNotifyHUD::TextLine[2] = "";
	} else if( %victim == %me ) {
		$TinyNotifyHUD::TextLine[0] = "<jc><f2>"@%sKiller;
		$TinyNotifyHUD::TextLine[1] = "<jc><f1>killed you with the";
		$TinyNotifyHUD::TextLine[2] = "<jc><f1>"@%weapon;
	} else if( %killer == %me ) {
		$TinyNotifyHUD::TextLine[0] = "<jc><f1>You killed";
		$TinyNotifyHUD::TextLine[1] = "<jc><f2>"@%sVictim;
		$TinyNotifyHUD::TextLine[2] = "<jc><f1> with your "@%weapon;
	}

	if( %victim == %me || %killer == %me ) {
		TinyNotifyHUD::PopUp();
	}
}

function TinyNotifyHUD::onInit() {
	$TinyNotifyHUD::MsgCount = 0;

	if(HUD::Exists(TinyNotifyHUD)) {
		HUD::Move(TinyNotifyHUD, $FudgePref::TinyNotifyHUDPos );
		HUD::Update(TinyNotifyHUD);
	} else {
		HUD::New(TinyNotifyHUD, TinyNotifyHUD::UpdateHUD, $FudgePref::TinyNotifyHUDPos );
	}
	HUD::Display(TinyNotifyHUD, false );
}

//
// NewOpts
//

function TinyNotifyHUD::onOpen()
{
	Control::setText("TinyNotifyHUD::XPos", getWord($FudgePref::TinyNotifyHUDPos,0));
	Control::setText("TinyNotifyHUD::YPos", getWord($FudgePref::TinyNotifyHUDPos,1));
	Control::setText("TinyNotifyHUD::Width", getWord($FudgePref::TinyNotifyHUDPos,2));
	Control::setText("TinyNotifyHUD::Height", getWord($FudgePref::TinyNotifyHUDPos,3));
}

function TinyNotifyHUD::onClose()
{
	$FudgePref::TinyNotifyHUDPos = Control::getText("TinyNotifyHUD::XPos")@" "@
								   Control::getText("TinyNotifyHUD::YPos")@" "@
								   Control::getText("TinyNotifyHUD::Width")@" "@
								   Control::getText("TinyNotifyHUD::Height");

	if(HUD::Exists(TinyNotifyHUD))
		HUD::Move(TinyNotifyHUD, $FudgePref::TinyNotifyHUDPos);

	export("$FudgePref::*", "config\\FudgePrefs.cs", false);
}

TinyNotifyHUD::AddBanner();
TinyNotifyHUD::onInit();
NewOpts::register("TinyNotify HUD", "config\\Fudge\\gui\\NotifyHUD.gui", "TinyNotifyHUD::onOpen();", "TinyNotifyHUD::onClose();", TRUE);
NewOpts::registerHelp("TinyNotify HUD", "Positioning", "Read the documentation in Presto's HUD.cs.  This has a more in depth description of how to position HUDs in general.");
NewOpts::registerHelp("TinyNotify HUD", "X Pos", "X posistion of the HUD. Examples: 0, 20%, left(hudTeam).");
NewOpts::registerHelp("TinyNotify HUD", "Y Pos", "Y posistion of the HUD. Examples: 0, 50%, bottom(hudTeam).");
NewOpts::registerHelp("TinyNotify HUD", "Width", "Width of the HUD. Best left at the default value.");
NewOpts::registerHelp("TinyNotify HUD", "Height", "Height of the HUD. Doesn't really matter since the HUD recalculates it's height based on the number of lines to display.");
NewOpts::registerHelp("TinyNotify HUD", "Author", "TinyNotifyHUD was written by [TNT]Fudge.\nEmail: <f0>fudge@c2i.net<f1>");

} // PrestoPack installed check
