// BooMHUD 1.666 by [SS-08]GrymReaper
//      GrymReaper@netlane.com
//  ICQ: GrymReaper UIN: 4759210

// BooMHUD (formerly known as WeapHUD, not to 
// be confused with WepHUD by shokugE) is a small
// HUD for tracking/displaying almost all kills you made 
// as well as all deaths suffered, and flag captures.
// 
// Installation: extract these files into Tribes folder and add this line:
// exec("GrymReaper\\BooMHUD.cs");
// to your autoexec.cs.

// Features: Easy to read HUD.
//           Dark enough to read in any background (optional setting).
//           Toggling at the press of a key.
//           User Customizeable position.
// Note: This script REQUIRES PrestoPack 0.93 or greater!
//           <*cough Raven that means you!cough*>
//       Also, this script is optimized for 800x600 resolution!
//       Any other resolution MAY mess up the displaying of the HUD!
//
// Left to right, the icons represent:
// |Blaster|Plasma|Chaingun|Disc_Launcher|Grenades/Mines|Laser_Rifle|ELF|
// |Mortars|Total Enemy Kills/Deaths|Team_Kills|Suicides|Miscellaneous Deaths|Flag Captures|

// BooMHUD 1.667 Lifetime Kill Tracking by [SS-A3]Mannkind++
// Mannkind@netzero.net
// ICQ: Mannkind UIN: 13224133
// BooMHUD 1.666 modified by permission from [SS-12]GrymReaper (Formerly [SS-08]GrymReaper

// BooMHUD was modified to allow on the fly tracking of in game kills (ie. mission you are in now) and lifetime
// (ie. FOREVER) by using the Toggle Key, you can view Game/Lifetime Stats on the fly....

// And Now BooMHUD supports NewOpts

// Follow the same installation instructions as above...

// Set the following to #s to the X and Y coordinates
// at which you would like the HUD to be displayed.
// Neither value can be negative, and too large can 
// have the HUD appear offscreen.
// The default coordinates have it start at the bottom 
// left corner of the game screen.

if (included("newopts\\newopts.cs") != 1)
{
	// Turns on lifetime tracking
	$BooMHUD::LifeTimePref = true;
	// Auto turns on BooMHUD, change this to false to turn it on yourself
	$BooMHUD::AutoOn = true;
	// Makes BooMHUD easier to see, change to false to make it lighter
	$BooMHUD::DarkBackground = true;
	// Toggles BooMHUD on//off
	$BooMHUD::ToggleKey = "w";
	// Toggles between Game/Lifetime stats
	$BooMHUD::TrakToggleKey = "control w";
	// Sets where BooMHUD will show up.
	$BooMHUD::Coords = "0% 70% 316 44";
	$BooMHUD::CoordX = getWord($BooMHUD::Coords,0);
	$BooMHUD::CoordY = getWord($BooMHUD::Coords,1);
	$BooMHUD::Width = getWord($BooMHUD::Coords,2);
	$BooMHUD::Height = getWord($BooMHUD::Coords,3);
		bindKey(play, $BooMHUD::ToggleKey, "BooMHUD::Toggle();");
		bindKey(play, $BooMHUD::TrakToggleKey, "BooMHUD::ToggleStats();");
}

// That's it for the user customizeable settings.
// Everything below should NOT be edited unless
// you know what you are doing.


function BooMHUD::Default()
{
	if(isFile("config\\BooMHUDPrefs.cs"))
	{
		File::delete("config\\BooMHUDPrefs.cs");	
	}
	$BooMHUD::LifeTimePref = true;
	$BooMHUD::AutoOn = true;
	$BooMHUD::DarkBackground = true;
	$BooMHUD::ToggleKey = "w";
	$BooMHUD::TrakToggleKey = "control w";
	$BooMHUD::Coords = "0% 70% 316 44";
	export("$BooMHUD::*", "config\\BooMHUDPrefs.cs", true);
	BooMHUD::OnOpen();
}

if(isFile("config\\BooMHUDPrefs.cs"))
{
	Include("BooMHUDPrefs.cs");
}
else
{
	BooMHUD::Default();
}

if ($Presto::version >= 0.93) {
	Presto::AddScriptBanner(GrymReaper,
		"<jc><f1>B<f2>oo<f1>M <f0>HUD<f2>!\n" @
		"<f0>This script will track all\n" @
		"of your <f1>kills <f2>and <f1>deaths <f0>of\n" @
		"almost all types, as well as flag captures.\n" @
		"<jc><B0,6:lr_blaster_on.bmp><B6,6:lr_plasma_on.bmp>" @
		"<B0,6:lr_chain_on.bmp><B6,6:lr_disk_on.bmp>" @ 
		"<B0,6:lr_grenade_on.bmp><B6,6:lr_sniper_on.bmp>" @
		"<B0,6:lr_energyrifle_on.bmp><B6,6:lr_mortar_on.bmp>\n\n" @ 
		"by <f1>GrymReaper<f2>@<f1>netlane.com" @ 
		"<f0>Note: <f1>Optimized for <f2>800<f0>x<f2>600");
	}

if ($Presto::version >= 0.93) {
	Presto::AddScriptBanner(GrymReaper2,
		"<jc><f1>B<f2>oo<f1>M <f0>HUD<f2>!\n" @
		"Modified by: <f1> Mannkind <f0>\n" @
		"Now Supports: <f2>Lifetime Stats <f0>\n" @
		"Now Supports: <f2>NewOpts!");
	}

// These 2 KillTrak functions add the kill/death type of Team_Kill
// to the tracking system.

KillTrak::DeathMessage("%1 mows down %3 teammate, %2","Team Kill");
KillTrak::DeathMessage("%1 killed %3 teammate, %2 with a mine.","Team Kill");

// This function is used to update the HUD numbers (and weapon icons as well, 
// but that isn't really necessary.)

function BooMHUD::Update()
{	
	HUD::Update(hudBooMMain);
        
        // For some reason I had to split up the strings or 
        // they wouldn't display correctly... weird.
        $BooM::IconString =  "<B4,4:lr_blaster_on.bmp>" @
		             "<B2,4:lr_plasma_on.bmp>" @
		             "<B4,4:lr_chain_on.bmp>" @
		             "<B2,4:lr_disk_on.bmp>" @
		             "<B4,4:lr_grenade_on.bmp>";
	$BooM::IconString2 = "<B2,4:lr_sniper_on.bmp>" @
		             "<B4,4:lr_energyrifle_on.bmp>" @
		             "<B2,4:lr_mortar_on.bmp>" @
		             "<B4,4:GrymReaper\\kills_icon.bmp>" @
		             "<B2,4:GrymReaper\\teamkill_icon.bmp>" @
		             "<B4,4:GrymReaper\\suicide_icon.bmp>" @ 
		             "<B2,4:GrymReaper\\miscdeaths_icon.bmp>" @
		             "<B4,4:GrymReaper\\flag_icon.bmp>";
        
        $BooM::String["Blaster"] =       "\n<jc><f2>" @ $BoomKills["",$TrakType,"Blaster"] @ 
        			                 "\n" @ $BoomDeaths["",$TrakType,"Blaster"];
	$BooM::String["Plasma"] =        "\n<jc><f2>" @ $BoomKills["",$TrakType,"Plasma"] @ 
				                 "\n" @ $BoomDeaths["",$TrakType,"Plasma"];
	$BooM::String["Chaingun"] =      "\n<jc><f2>" @ $BoomKills["",$TrakType,"Chaingun"] @ 
	 				         "\n" @ $BoomDeaths["",$TrakType,"Chaingun"];
	$BooM::String["Disc_Launcher"] = "\n<jc><f2>" @ $BoomKills["",$TrakType,"Disc_Launcher"] @ 
	    				         "\n" @ $BoomDeaths["",$TrakType,"Disc_Launcher"];
	$BooM::String["Explosives"] =    "\n<jc><f2>" @ $BoomKills["",$TrakType,"Explosives"] @ 
					         "\n" @ $BoomDeaths["",$TrakType,"Explosives"];
	$BooM::String["Laser_Rifle"] =   "\n<jc><f2>" @ $BoomKills["",$TrakType,"Laser_Rifle"] @ 
					         "\n" @ $BoomDeaths["",$TrakType,"Laser_Rifle"];
	$BooM::String["Elf_Gun"] =       "\n<jc><f2>" @ $BoomKills["",$TrakType,"Elf_Gun"] @ 
					         "\n" @ $BoomDeaths["",$TrakType,"Elf_Gun"];
	$BooM::String["Mortar"] =        "\n<jc><f2>" @ $BoomKills["",$TrakType,"Mortar"] @ 
				                 "\n" @ $BoomDeaths["",$TrakType,"Mortar"];
	$BoomKills["",$TrakType,"Total"] = $BoomKills["",$TrakType,"Blaster"] + 
			  $BoomKills["",$TrakType,"Plasma"] +
			  $BoomKills["",$TrakType,"Chaingun"] +
			  $BoomKills["",$TrakType,"Disc_Launcher"] +
			  $BoomKills["",$TrakType,"Explosives"] +
			  $BoomKills["",$TrakType,"Laser_Rifle"] +
			  $BoomKills["",$TrakType,"Elf_Gun"] +
			  $BoomKills["",$TrakType,"Mortar"];
			  
	$BoomDeaths["",$TrakType,"Total"] = $BoomDeaths["",$TrakType,"Blaster"] + 
			   $BoomDeaths["",$TrakType,"Plasma"] +
			   $BoomDeaths["",$TrakType,"Chaingun"] +
			   $BoomDeaths["",$TrakType,"Disc_Launcher"] +
			   $BoomDeaths["",$TrakType,"Explosives"] +
			   $BoomDeaths["",$TrakType,"Laser_Rifle"] +
			   $BoomDeaths["",$TrakType,"Elf_Gun"] +
			   $BoomDeaths["",$TrakType,"Mortar"];
	
	$BooM::String["Total"] =         "\n<jc><f2>" @ $BoomKills["",$TrakType,"Total"] @
						 "\n" @ $BoomDeaths["",$TrakType,"Total"];
	$BooM::String["Team_Kill"] =     "\n<jc><f2>" @ $BoomKills["",$TrakType,"Team_Kill"] @ 
				                 "\n" @ $BoomDeaths["",$TrakType,"Team_Kill"];
	$BooM::String["Suicide"] =       "\n<jc><f2>" @ $BoomDeaths["",$TrakType,"Suicide"];
	
	$BooM::String["Misc"] =          "\n<jc><f2>" @ $BoomDeaths["",$TrakType,"Misc"];
	
	$BooM::String["Flag_Caps"] =     "\n<jc><f2>" @ $BooM::FlagCaps["",$TrakType];
	
	Control::setValue("HUD::hudBooMMain::14", $BooM::IconString);
	Control::setValue("HUD::hudBooMMain::15", $BooM::IconString2);
	Control::setValue("HUD::hudBooMMain::16", $BooM::String["Blaster"]);
	Control::setValue("HUD::hudBooMMain::17", $BooM::String["Plasma"]);
	Control::setValue("HUD::hudBooMMain::18", $BooM::String["Chaingun"]);
	Control::setValue("HUD::hudBooMMain::19", $BooM::String["Disc_Launcher"]);
	Control::setValue("HUD::hudBooMMain::20", $BooM::String["Explosives"]);

Control::setValue("HUD::hudBooMMain::21", $BooM::String["Laser_Rifle"]);
	Control::setValue("HUD::hudBooMMain::22", $BooM::String["Elf_Gun"]);
	Control::setValue("HUD::hudBooMMain::23", $BooM::String["Mortar"]);
	Control::setValue("HUD::hudBooMMain::24", $BooM::String["Total"]);
	Control::setValue("HUD::hudBooMMain::25", $BooM::String["Team_Kill"]);
	Control::setValue("HUD::hudBooMMain::26", $BooM::String["Suicide"]);
	Control::setValue("HUD::hudBooMMain::27", $BooM::String["Misc"]);
	Control::setValue("HUD::hudBooMMain::28", $BooM::String["Flag_Caps"]);
	
}

function BooMHUD::StatsUpdate()
{
	File::delete("config\\BooM.cs");
	if($BoomKills_Lifetime_Blaster == "")
	{
		$BoomKills_Lifetime_Blaster = 0;
	}
	if($BoomKills_Lifetime_Plasma == "")
	{
		$BoomKills_Lifetime_Plasma = 0;
	}
	if($BoomKills_Lifetime_Chaingun == "")
	{
		$BoomKills_Lifetime_Chaingun = 0;
	}
	if($BoomKills_Lifetime_Disc_Launcher == "")
	{
		$BoomKills_Lifetime_Disc_Launcher = 0;
	}
	if($BoomKills_Lifetime_Explosives == "")
	{
		$BoomKills_Lifetime_Explosives = 0;
	}
	if($BoomKills_Lifetime_Laser_Rifle == "")
	{
		$BoomKills_Lifetime_Laser_Rifle = 0;
	}
	if($BoomKills_Lifetime_Elf_Gun == "")
	{
		$BoomKills_Lifetime_Elf_Gun = 0;
	}
		if($BoomKills_Lifetime_Mortar == "")
	{
		$BoomKills_Lifetime_Mortar = 0;
	}
	if($BoomKills_Lifetime_Total == "")
	{
		$BoomKills_Lifetime_Total = 0;
	}
	if($BoomKills_Lifetime_Team_Kill == "")
	{
		$BoomKills_Lifetime_Team_Kill = 0;
	}
	if($BoomKills_Lifetime_Suicide == "")
	{
		$BoomKills_Lifetime_Suicide = 0;
	}
	if($BoomKills_Lifetime_Misc == "")
	{
		$BoomKills_Lifetime_Misc = 0;
	}
	if($BoomKills_Lifetime_Flag_Caps == "")
	{
		$Boom::Flag_Caps_Lifetime = 0;
	}
	if($BoomDeaths_Lifetime_Blaster == "")
	{
		$BoomDeaths_Lifetime_Blaster = 0;
	}
	if($BoomDeaths_Lifetime_Plasma == "")
	{
		$BoomDeaths_Lifetime_Plasma = 0;
	}
	if($BoomDeaths_Lifetime_Chaingun == "")
	{
		$BoomDeaths_Lifetime_Chaingun = 0;
	}
	if($BoomDeaths_Lifetime_Disc_Launcher == "")
	{
		$BoomDeaths_Lifetime_Disc_Launcher = 0;
	}
	if($BoomDeaths_Lifetime_Explosives == "")
	{
		$BoomDeaths_Lifetime_Explosives = 0;
	}
	if($BoomDeaths_Lifetime_Laser_Rifle == "")
	{
		$BoomDeaths_Lifetime_Laser_Rifle = 0;
	}
	if($BoomDeaths_Lifetime_Elf_Gun == "")
	{
		$BoomDeaths_Lifetime_Elf_Gun = 0;
	}
		if($BoomDeaths_Lifetime_Mortar == "")
	{
		$BoomDeaths_Lifetime_Mortar = 0;
	}
	if($BoomDeaths_Lifetime_Total == "")
	{
		$BoomDeaths_Lifetime_Total = 0;
	}
	if($BoomDeaths_Lifetime_Team_Kill == "")
	{
		$BoomDeaths_Lifetime_Team_Kill = 0;
	}
	if($BoomDeaths_Lifetime_Suicide == "")
	{
		$BoomDeaths_Lifetime_Suicide = 0;
	}
	if($BoomDeaths_Lifetime_Misc == "")
	{
		$BoomDeaths_Lifetime_Misc = 0;
	}
	if($Boom::FlagCaps_Lifetime == "")
	{
		$Boom::FlagCaps_Lifetime = 0;
	}

	export("$BoomKills_Lifetime_*", "config\\BooM.cs", True);
	export("$BoomDeaths_Lifetime_*", "config\\BooM.cs", True);
	export("$Boom::FlagCaps_Lifetime", "config\\BooM.cs", True);
	BooMHUD::Update();
}
	

function BooM::ReadStats()
{
	exec("BooM.cs");
	BooMHUD::StatsUpdate();
}

// This function resets all scores to 0 after joining a new game or
// the server changes missions.

function BooM::Reset()
{
      $BoomKills["",Game,"Blaster"] = 0;
	$BoomKills["",Game,"Plasma"] = 0;
	$BoomKills["",Game,"Chaingun"] = 0;
	$BoomKills["",Game,"Disc_Launcher"] = 0;
	$BoomKills["",Game,"Explosives"] = 0;
	$BoomKills["",Game,"Laser_Rifle"] = 0;
	$BoomKills["",Game,"Elf_Gun"] = 0;
     	$BoomKills["",Game,"Mortar"] = 0;
     	$BoomKills["",Game,"Total"] = 0;
     	$BoomKills["",Game,"Suicide"] = 0;
     	$BoomKills["",Game,"Team_Kill"] = 0;
      $BoomDeaths["",Game,"Blaster"] = 0;
      $BoomDeaths["",Game,"Plasma"] = 0;
      $BoomDeaths["",Game,"Chaingun"] = 0;
      $BoomDeaths["",Game,"Disc_Launcher"] = 0;
      $BoomDeaths["",Game,"Explosives"] = 0;
      $BoomDeaths["",Game,"Laser_Rifle"] = 0;
      $BoomDeaths["",Game,"Elf_Gun"] = 0;
      $BoomDeaths["",Game,"Mortar"] = 0;
      $BoomDeaths["",Game,"Total"] = 0;
      $BoomDeaths["",Game,"Suicide"] = 0;
      $BoomDeaths["",Game,"Misc"] = 0;
      $BoomDeaths["",Game,"Team_Kill"] = 0;
    	
     	$BooM::FlagCaps_Game = 0;
     	
	BooMHUD::Update();
	
	if($BooM::KillsSet == "")
	   $BooM::KillsSet = true;
}

if($BooM::KillsSet == "")
{
BooM::Reset();
}

if($BooMHUD::LifeTimePref)
	{
		$TrakType = "Lifetime";
		Event::Attach(eventConnected, BooM::ReadStats);
		Event::Attach(eventChangeMission, BooM::ReadStats);
		Event::Attach(eventConnected, BooM::Reset);
		Event::Attach(eventChangeMission, BooM::Reset);
	}
else
	{
            $TrakType = "Game";
		Event::Attach(eventConnected, BooM::ReadStats);
		Event::Attach(eventConnected, BooM::Reset);
		Event::Attach(eventChangeMission, BooM::ReadStats);
		Event::Attach(eventChangeMission, BooM::Reset);
	}

// The following functions lets BooMHUD detect via KillTrak, 
// and incrementing the proper weapon's kill or death value.

function ParseForBooMKills(%killer, %victim, %weapon)
{
	%me = getManagerId();
	if(%weapon != "Falling" && 
	   %weapon != "Crushed" && 
	   %weapon != "Turret" &&
	   %weapon != "Debris" &&
	   %weapon != "Vehicle")
	   {
		if(%weapon == "Disc Launcher")
		{
			%weapon = "Disc_Launcher";
		}
		if(%weapon == "Laser Rifle")
		{
			%weapon = "Laser_Rifle";
		}
		if(%weapon == "ELF Gun")
		{
			%weapon = "Elf_Gun";
		}
		if(%weapon == "Team Kill")
		{
			%weapon = "Team_Kill";
		}
		if(%killer == %me)
	   	{
		   $BoomKills["",Game,%weapon]++;
		   $BoomKills["",Lifetime,%weapon]++;
		   BooMHUD::StatsUpdate();
		}
		if(%victim == %me)
		{
	   	   $BoomDeaths["",Game,%weapon]++;
		   $BoomDeaths["",Lifetime,%weapon]++;
		   BooMHUD::StatsUpdate();
		}
	   }
	if(%weapon == "Falling" || 
	   %weapon == "Crushed" ||
	   %weapon == "Turret" ||
	   %weapon == "Debris" ||
	   %weapon == "Vehicle")
	   {
	   	if(%victim == %me && %weapon != "Suicide")
		{
	    	   $BoomDeaths["",Game,"Misc"]++;	
		   $BoomDeaths["",Lifetime,"Misc"]++;
		}
  	   }
  	HUD::Update(hudBooMMain);

	$BooM::String["Blaster"] =       "\n<jc><f2>" @ $BoomKills["",$TrakType,"Blaster"] @ 
			                         "\n" @ $BoomDeaths["",$TrakType,"Blaster"];
	$BooM::String["Plasma"] =        "\n<jc><f2>" @ $BoomKills["",$TrakType,"Plasma"] @ 
				                 "\n" @ $BoomDeaths["",$TrakType,"Plasma"];
	$BooM::String["Chaingun"] =      "\n<jc><f2>" @ $BoomKills["",$TrakType,"Chaingun"] @ 
				                 "\n" @ $BoomDeaths["",$TrakType,"Chaingun"];
	$BooM::String["Disc_Launcher"] = "\n<jc><f2>" @ $BoomKills["",$TrakType,"Disc_Launcher"] @ 
				                 "\n" @ $BoomDeaths["",$TrakType,"Disc_Launcher"];
	$BooM::String["Explosives"] =    "\n<jc><f2>" @ $BoomKills["",$TrakType,"Explosives"] @ 
					         "\n" @ $BoomDeaths["",$TrakType,"Explosives"];
	$BooM::String["Laser_Rifle"] =   "\n<jc><f2>" @ $BoomKills["",$TrakType,"Laser_Rifle"] @ 
					         "\n" @ $BoomDeaths["",$TrakType,"Laser_Rifle"];
	$BooM::String["Elf_Gun"] =       "\n<jc><f2>" @ $BoomKills["",$TrakType,"ELF_Gun"] @ 
					         "\n" @ $BoomDeaths["",$TrakType,"Elf_Gun"];
	$BooM::String["Mortar"] =        "\n<jc><f2>" @ $BoomKills["",$TrakType,"Mortar"] @ 
				                 "\n" @ $BoomDeaths["",$TrakType,"Mortar"];
	$BooM::String["Total"] =         "\n<jc><f2>" @ $BoomKills["",$TrakType,"Total"] @
						 "\n" @ $BoomDeaths["",$TrakType,"Total"];
	$BooM::String["Team_Kill"] =     "\n<jc><f2>" @ $BoomKills["",$TrakType,"Team_Kill"] @ 
				                 "\n" @ $BoomDeaths["",$TrakType,"Team_Kill"];
	$BooM::String["Suicide"] =       "\n<jc><f2>" @ $BoomDeaths["",$TrakType,"Suicide"];
	
	$BooM::String["Misc"] =          "\n<jc><f2>" @ $BoomDeaths["",$TrakType,"Misc"];
	
	$BooM::String["Flag_Caps"] =     "\n<jc><f2>" @ $BooM::FlagCaps["",$TrakType];
	
	BooMHUD::Update();
	
	BooMHUD::StatsUpdate();
}

Event::Attach(eventKillTrak, ParseForBooMKills);	   

function ParseForBooMFlagCaps(%client, %msg)
{
	if(%client == 0 && 
	String::findSubStr(%msg, "You captured the") != -1 &&
	String::findSubStr(%msg, "flag") != -1)
		{
		$BooM::FlagCaps["",Game]++;
		$BooM::FlagCaps["",Lifetime]++;
		}
	BooMHUD::Update();
	BooMHUD::StatsUpdate();
	return true;
}

Event::Attach(eventClientMessage, ParseForBooMFlagCaps);
// This creates the HUDs for later use and are the main HUD string functions.

function BoomHUD::Main()
{
	HUD::AddText(hudBooMMain, "<f1>BooM!\n<f0>Kills\nDeaths");
}

if(included("newopts\\newopts.cs") == 1)
{
	$BooMHUD::CoordX = getWord($BooMHUD::Coords,0);
	$BooMHUD::CoordY = getWord($BooMHUD::Coords,1);
	$BooMHUD::Width = getWord($BooMHUD::Coords,2);
	$BooMHUD::Height = getWord($BooMHUD::Coords,3);
}

if($BooMHUD::DarkBackground)
{
	HUD::NewFrame(hudBooMBackground, "", $BooMHUD::CoordX, $BooMHUD::CoordY, $BooMHUD::Width, $BooMHUD::Height);
}
	// Main HUD.
	HUD::New(hudBooMMain, BoomHUD::Main, $BooMHUD::CoordX, $BooMHUD::CoordY, $BooMHUD::Width, $BooMHUD::Height);

	// Column frames.
	HUD::AddObject(hudBooMMain, FearGui::FearGuiMenu, 56, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGui::FearGuiMenu, 76, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGui::FearGuiMenu, 96, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGui::FearGuiMenu, 116, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGui::FearGuiMenu, 136, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGui::FearGuiMenu, 156, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGui::FearGuiMenu, 176, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGui::FearGuiMenu, 196, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGui::FearGuiMenu, 216, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGui::FearGuiMenu, 236, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGui::FearGuiMenu, 256, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGui::FearGuiMenu, 276, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGui::FearGuiMenu, 296, 0, 20, 44);
	
	// Text boxes.
	HUD::AddObject(hudBooMMain, FearGuiFormattedText, 55, 0, 296, 44);
	HUD::AddObject(hudBooMMain, FearGuiFormattedText, 157, 0, 296, 44);
	HUD::AddObject(hudBooMMain, FearGuiFormattedText, -91, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGuiFormattedText, -71, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGuiFormattedText, -51, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGuiFormattedText, -31, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGuiFormattedText, -11, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGuiFormattedText, 9, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGuiFormattedText, 29, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGuiFormattedText, 49, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGuiFormattedText, 69, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGuiFormattedText, 89, 0, 20, 44);
	HUD::AddObject(hudBooMMain, FearGuiFormattedText, 109, 7, 20, 44);
	HUD::AddObject(hudBooMMain, FearGuiFormattedText, 129, 7, 20, 44);
	HUD::AddObject(hudBooMMain, FearGuiFormattedText, 149, 7, 20, 44);
	
	// Weapon kill strings.
	Control::setValue("HUD::hudBooMMain::14", $BooM::IconString);
	Control::setValue("HUD::hudBooMMain::15", $BooM::IconString2);
	Control::setValue("HUD::hudBooMMain::16", $BooM::String["Blaster"]);
	Control::setValue("HUD::hudBooMMain::17", $BooM::String["Plasma"]);
	Control::setValue("HUD::hudBooMMain::18", $BooM::String["Chaingun"]);
	Control::setValue("HUD::hudBooMMain::19", $BooM::String["Disc_Launcher"]);
	Control::setValue("HUD::hudBooMMain::20", $BooM::String["Explosives"]);
	Control::setValue("HUD::hudBooMMain::21", $BooM::String["Laser_Rifle"]);
	Control::setValue("HUD::hudBooMMain::22", $BooM::String["Elf_Gun"]);
	Control::setValue("HUD::hudBooMMain::23", $BooM::String["Mortar"]);
	Control::setValue("HUD::hudBooMMain::24", $BooM::String["Total"]);
	Control::setValue("HUD::hudBooMMain::25", $BooM::String["Team_Kill"]);
	Control::setValue("HUD::hudBooMMain::26", $BooM::String["Suicide"]);
	Control::setValue("HUD::hudBooMMain::27", $BooM::String["Misc"]);
	Control::setValue("HUD::hudBooMMain::28", $BooM::String["Flag_Caps"]);

function BooMHUD::Toggle()
{
	HUD::ToggleDisplay(hudBooMMain);
     if($BooMHUD::DarkBackground)
	{
        HUD::ToggleDisplay(hudBooMBackground); 
	}
     
}

function BooMHUD::ToggleStats()
{
	if($BooMHUD::LifeTime)
		{
			$BooMHUD::LifeTime = "false";
			echo("SETTING TO GAME");
			Client::centerPrint(" Now Viewing BoomHUD Game Tracking Stats! " @ %text, 1);
			schedule("Client::centerPrint(\"\", 1);", 5);
			$TrakType = "Game";
			BooMHUD::Update();
		}
	else
		{
			echo("SETTING TO LIFETIME");
			$BooMHUD::LifeTime = "true";
			$TrakType = "Lifetime";
			exec("BooM.cs");
			Client::centerPrint(" Now Viewing BoomHUD Lifetime Tracking Stats!  " @ %text, 1);
			schedule("Client::centerPrint(\"\", 1);", 5);
			BooMHUD::StatsUpdate();
			BooMHUD::Update();
		}
}


// This checks to see if the player wants the HUDs created automatically.
// If not, remove them.
if($BooMHUD::AutoOn)
{
HUD::Display(hudBooMMain);
if($BooMHUD::DarkBackground)
	{
   HUD::Display(hudBooMBackground);      
	}
}

function BooMHUD::OnOpen()
{
	Control::setText("BooMHUD::CoordX", getWord($BooMHUD::Coords,0));
	Control::setText("BooMHUD::CoordY", getWord($BooMHUD::Coords,1));
	Control::setText("BooMHUD::Width", getWord($BooMHUD::Coords,2));
	Control::setText("BooMHUD::Height", getWord($BooMHUD::Coords,3));
	if(Included("NewOpts\\HudMover.cs") == 1)
	{
		Control::setActive("BooMHUD::Width", FALSE);
		Control::setActive("BooMHUD::Height", FALSE);
		Control::setActive("BooMHUD::CoordX", FALSE);
		Control::setActive("BooMHUD::CoordY", FALSE);
	}
	if(HUD::Exists(hudBooMMain))
	{
		Control::setActive("BooMHUD::Width", FALSE);
		Control::setActive("BooMHUD::Height", FALSE);
	}	
}

function BooMHUD::OnClose()
{
	$BooMHUD::Coords = Control::getText("BooMHUD::CoordX")@" "@
	Control::getText("BooMHUD::CoordY")@" "@
	Control::getText("BooMHUD::Width")@" "@
	Control::getText("BooMHUD::Height");
	
	if(!$BooMHUD::DarkBackground)
	{
		HUD::Display(hudBooMBackground, false);
	}
	else
	{
		HUD::Display(hudBooMBackground);
	}
	if(Included("NewOpts\\HudMover.cs") != 1)
	{
		if(HUD::Exists(hudBooMMain))
		{
			if(HUD::Exists(hudBooMBackground))
			{
				HUD::Move(hudBooMBackground, $BooMHUD::Coords);
				HUD::Move(hudBooMMain, $BooMHUD::Coords);
			}
			else
			{
				HUD::Move(hudBooMMain, $BooMHUD::Coords);
			}
	
	}	}
	File::delete("config\\BooMHUDPrefs.cs");
	export("$BooMHUD::*", "config\\BooMHUDPrefs.cs", true);

}

if (included("newopts\\newopts.cs") == 1)
{
			NewOpts::register("BooMHUD",
				  "config\\GrymReaper\\BooMHUD.gui",
				  "BooMHUD::OnOpen();",
				  "BooMHUD::OnClose();",
				  TRUE);
Include("GrymReaper\\BooMHUDHelp.cs");
}


