// KillCountHUD made by Mannkind @ Netzero.net
// Thanks to Spades for some of the code.
// NOTE: Spades, if you don't want me using your code, e-mail me at Mannkind@netzero.net and tell me
// NOTE: and as soon as I get the message the file will come down.

// To install extract the files into your Tribes folder (winzip will put them in config\Mannkind)
// Then in your autoexec.cs file add "Include("Mannkind\\KillCount.cs");"
// After "Exec("Presto\\Install.cs"); and if you have NewOpts put it after "Exec("Newopts\\Install.cs");"

//----------------------------------------------//
// ---- SECTION FOR PEOPLE WITHOUT NEWOPTS ---- //
// ---- PEOPLE WITHOUT NEWOPTS CAN CHANGE  ---- //
// ---- THIS SECTION, BUT DON'T GO BEYOND  ---- //
// ---- IT.                                ---- //

// This function checks to see if NewOpts is loaded.
// It will Execute if NewOpts has not been loaded.

$Died = False;
$Killed = False;

if (Included("NewOpts\\NewOpts.cs") != 1)
{
        // The following varibles will set up your preferences
        // You may change these to your likings.

        $KillCount::CoordsPref = "98% 60% 200 60";
        $KillCount::ToggleKey = "alt k";
        $KillCount::AutoOn = true;

        // The following commands are setup, do NOT change these
        // Unless you are sure you know what you are doing

        $KillCount::CoordX = getWord($KillCount::CoordsPref,0);
        $KillCount::CoordY = getWord($KillCount::CoordsPref,1);
        $KillCount::Width = getWord($KillCount::CoordsPref,2);
        $KillCount::Height = getWord($KillCount::CoordsPref,3);

        // Binds set toggle key to Toggle on/off HUD

        bindKey(play, $ToggleKey, "KillCount::ToggleHUD();");

}

// ---- SECTION FOR PEOPLE WITHOUT NEWOPTS ---- //
// ---- IS NOW COMPLETE, DO NOT CHANGE     ---- //
// ---- ANYTHING BELOW THIS POINT, UNLESS  ---- //
// ---- YOU KNOW WHAT YOU ARE DOING        ---- //

// ---- SECTION FOR PEOPLE WITH NEWOPTS    ---- //

// This function will check to see if NewOpts is installed.
// It will Execute if you have NewOpts installed.
if (Included("NewOpts\\NewOpts.cs") == 1)
{
        // Checks to see if you already have KillCountPrefs.
        // Executes if you do.
        if (IsFile("Config\\KillCountPrefs.cs"))
        {
                // Found your preferences, reading them.
                Include("KillCountPrefs.cs");
        }
        // if you didn't have any prefs, well
        // We need to make some.
        else
        {
                // Run this to make new KillCount Prefs.
                KillCount::Defaults();
        }
}

// function to make Preferences for KillCount
function KillCount::Defaults()
{
        // These varibles are the main varibles.
        $KillCount::ToggleKey = "alt k";
        $KillCount::CoordsPref = "98% 60% 200 60";
        $KillCount::AutoOn = true;

        // These will export your preferences later.
        Export("$KillCount::CoordsPref", "config\\KillCountPrefs.cs", True);
        Export("$KillCount::ToggleKey", "config\\KillCountPrefs.cs", True);
        Export("$KillCount::AutoOn", "config\\KillCountPrefs.cs", True);

        // Opens the GUI
        KillCount::OnOpen();
}

// function that is activated when GUI is opened
function KillCount::OnOpen()
{
        // Sets the text in KillCount NewOpts Page to the Coords. of HUD
        Control::setText("KillCount::CoordX", getWord($KillCount::CoordsPref,0));
        Control::setText("KillCount::CoordY", getWord($KillCount::CoordsPref,1));
        Control::setText("KillCount::Width", getWord($KillCount::CoordsPref,2));
        Control::setText("KillCount::Height", getWord($KillCount::CoordsPref,3));
   	  if(Included("NewOpts\\HudMover.cs") == 1)
	  {
		Control::setActive("KillCount::Width", FALSE);
            Control::setActive("KillCount::Height", FALSE);
		Control::setActive("KillCount::CoordX", FALSE);
            Control::setActive("KillCount::CoordY", FALSE);
	  }
        // Checks to see if you are running the HUD already
        if (HUD::Exists(KillCount))
        {
                // Sets it so you cannot make HUD wider/longer
                Control::setActive("KillCount::Width", FALSE);
                Control::setActive("KillCount::Height", FALSE);
        }

}

//function that is activated when GUI is closed
function KillCount::OnClose()
{
        // Sets varible to Coords you inputed
        $KillCount::CoordsPref = Control::getText("KillCount::CoordX")@" "@
        Control::getText("KillCount::CoordY")@" "@
        Control::getText("KillCount::Width")@" "@
        Control::getText("KillCount::Height");

	if(Included("NewOpts\\HudMover.cs") != 1)
	{
        // Checks to see if your hud is runnig, and if you changed where you wanted the hud
        // It will move it there.
        if(HUD::Exists(KillCount))
        {
                HUD::Move(KillCount, $KillCount::CoordsPref);
        }
	}

        // This will delete your old prefs and make new ones.
        File::delete("config\\KillCountPrefs.cs");

        // Starts to make new prefs.
        Export("$KillCount::CoordsPref", "config\\KillCountPrefs.cs", true);
        Export("$KillCount::ToggleKey", "config\\KillCountPrefs.cs", true);
        Export("$KillCount::AutoOn", "config\\KillCountPrefs.cs", true);
}

// This again checks and makes sure NewOpts is running
if (Included("Newopts\\Newopts.cs") == 1)
{
        // Makes a new page in NewOpts for your prefs
        NewOpts::register("KillCountHUD",
        "config\\Mannkind\\KCHUD.gui",
        "KillCount::OnOpen();",
        "KillCount::OnClose();",
        TRUE);

        // This is the help file
        Include("Mannkind\\KillCountHelp.cs");
}

// ---- THIS IS THE END OF THE NEWOPTS STUFF ---- //

// ---- THIS SECTION IS FOR UPDATING THE HUD ---- //

// This function updates the HUD itself
function UpdateHUD::KillCount()
{
         %KilledBy = "<B0,5:Mannkind\\Death0.bmp><f2> " @ $MyKiller @ "\n";
         %NumberOfTimes = "<B-14,5:Mannkind\\Times.bmp><f2>    "  @ $KillCount::KillerKills[$KillCount::KillerClientNum] @ "\n";
         %Killed = "<B0,5:Mannkind\\Killed0.bmp><f2> " @ $MyVictim @ "\n";
         %Kills = "<B-14,5:Mannkind\\Times.bmp><f2>    " @ $KillCount::VictimKills[$KillCount::VictimClientNum] @ "\n";

         Hud::AddText(KillCount, %KilledBy @ %NumberOfTimes @ %Killed @ %Kills);
}

function KillCount::Update()
{

        // This will delete your old file, as to not remake older names again.
        File::delete("config\\KillCount.cs");

        // Rewrite stats file and records
        Export("$KillCount::KillerNextRec", "config\\KillCount.cs", True);
        Export("$KillCount::KillerName*", "config\\KillCount.cs", True);
        Export("$KillCount::KillerKills*", "config\\KillCount.cs", True);
        Export("$KillCount::VictimNextRec", "config\\KillCount.cs", True);
        Export("$KillCount::VictimName*", "config\\KillCount.cs", True);
        Export("$KillCount::VictimKills*", "config\\KillCount.cs", True);

        // This will update the HUD itself.
        HUD::Update(KillCount);
}

// This will read your data, and then update the hud.
function KillCount::ReadKillCounts()
{
        Exec("KillCount.cs");

        KillCount::Update();
}

// ---- THIS IS THE END OF UPDATING THE HUD ---- //

// ---- THIS SECTION IS FOR GETTING         ---- //
// ---- KILLER/KILLED DATA                  ---- //

//This function tracks your deaths by other people
//This function was taken from Spades, with permission, I would like to thank Spades very much, for without me finding this function, this KillCountHUD wouldn't have worked properly.
function KillCount::DeathDataBase()
{
        // Sets these varibles to nothing
        $KillCount::KillerClientNum = "";
        $KillCount::KillerNextRec = "";

        // Reads your lifetime kill stats
        Exec("KillCount.cs");

        for(%i=0; %i<$KillCount::KillerNextRec; %i++)
                 {
                        // Checks to see if the person had already killed you and if so, add one more to their kill amount
                        if($KillCount::KillerName[%i] == $MyKiller)
                                {
                                        $KillCount::KillerClientNum = %i;

                                        if($KillCount::KillerKills[$KillCount::KillerClientNum] == "")
                                                {
                                                        $KillCount::KillerKills[$KillCount::KillerClientNum] = 1;
                                                }
                                        $KillCount::KillerKills[$KillCount::KillerClientNum]++;
                                        KillCount::Update();
                                }
                }

        // if they haven't killed you, then make a complete new record of them...
        if($KillCount::KillerClientNum == "")
                {
                        if($KillCount::KillerNextRec == "")
                                {
                                        $KillCount::KillerNextRec = 0;
                                        KillCount::Update();
                                }

                        $KillCount::KillerClientNum = $KillCount::KillerNextRec;
                        $KillCount::KillerNextRec++;
                        $KillCount::KillerName[$KillCount::KillerClientNum] = $MyKiller;
                        $KillCount::KillerKills[$KillCount::KillerClientNum] = 1;
                }

        // Update Stats and HUD
        KillCount::Update();
        HUD::Update(KillCount);
}

// Tracks your kills
//This function was taken from Spades, with permission, I would like to thank Spades very much, for without me finding this function, this KillCountHUD wouldn't have worked properly.
function KillCount::KillsDataBase()
{
        //Sets varibles to nothing..
        $KillCount::VictimClientNum = "";
        $KillCount::VictimNextRec = "";

        //Reads your lifetime kill stats
        Exec("KillCount.cs");

        for(%i=0; %i<$KillCount::VictimNextRec; %i++)

                {
                        // if you've killed this person before, add one more to your kill amount
                        if($KillCount::VictimName[%i] == $MyVictim)
                                {
                                        $KillCount::VictimClientNum = %i;

                                        if($KillCount::VictimKills[$KillCount::VictimClientNum] == "")
                                                {
                                                        $KillCount::VictimKills[$KillCount::VictimClientNum] = 1;
                                                }
                                        $KillCount::VictimKills[$KillCount::VictimClientNum]++;
                                        KillCount::Update();
                                }
                }
        // if you haven't killed them, make a new record..
        if($KillCount::VictimClientNum == "")
                {
                        if($KillCount::VictimNextRec == "")
                                {
                                        $KillCount::VictimNextRec = 0;
                                        KillCount::Update();
                                }

                        $KillCount::VictimClientNum = $KillCount::VictimNextRec;
                        $KillCount::VictimNextRec++;
                        $KillCount::VictimName[$KillCount::VictimClientNum] = $MyVictim;
                        $KillCount::VictimKills[$KillCount::VictimClientNum] = 1;
                }

        //Update Stats and HUD
        KillCount::Update();
        HUD::Update(KillCount);
}

// Code to check wiether you died or you killed.
function KillCount::KilledOrKill(%killer, %victim, %weapon)
{
        if(%victim == getManagerId() && %killer != getManagerId())
                {
                        $MyKiller = Client::GetName(%killer);
                        KillCount::DeathDataBase();
                }
        else if(%killer == getManagerId() && %victim != getManagerId())
                {
                        $MyVictim = Client::GetName(%victim);
                        KillCount::KillsDataBase();
                }
}

// ---- THIS IS THE END OF THE GETTING DATA SECTION ---- //

// ---- THIS SECTION IS FOR MISC STUFF              ---- //

        // Sets Coordinates for HUD
        $KillCount::CoordX = getWord($KillCount::CoordsPref,0);
        $KillCount::CoordY = getWord($KillCount::CoordsPref,1);
        $KillCount::Width = getWord($KillCount::CoordsPref,2);
        $KillCount::Height = getWord($KillCount::CoordsPref,3);

// Creates the HUD but doesn't display it.
HUD::New(KillCount,UpdateHUD::KillCount, $KillCount::CoordX, $KillCount::CoordY, $KillCount::Width, $KillCount::Height);

// Toggle HUD on/Off
function KillCount::ToggleHUD()
{
        // Returns 0 if HUD isn't there, 1 if HUD is there
        %KillCount::Displayed = HUD::GetDisplayed(KillCount);

        // Checks to see if HUD is there or not
        if (%KillCount::Displayed == 0)
        {
                HUD::ToggleDisplay(KillCount);
        }
        else
        {
                HUD::ToggleDisplay(KIllCount);
        }
}

// if you just loaded the HUD, it will produce fillers until something happens.
function KillCount::NewHUD()
{
        if ($MyKiller == "" && $MyVictim == "")
        {
                $KillCount::KillerClientNum = 1000000000;
                $KillCount::VictimClientNum = 1000000000;
                $KillCount::KillerKills[$KillCount::KillerClientNum] = "0";
                $KillCount::VictimKills[$KillCount::VictimClientNum] = "0";
                $MyKiller = "Nobody";
                $MyVictim = "Nobody";
        }
}

if($KillCount::AutoOn)
{
        HUD::Display(KillCount);
}

// ---- END MISC STUFF ---- //

// ---- THIS SECTION WILL ATTACH NEEDED ---- //
// ---- EVENTS TO functionS.            ---- //

Event::Attach(eventConnected, KillCount::ReadKillCounts);
Event::Attach(eventConnected, KillCount::NewHUD);
Event::Attach(eventKillTrak, KillCount::KilledOrKill);