//----------------------------------//
//    Help At Beacon By Mannkind	//
//	   Put Help.cs in your		//
//     Tribes\Config\Mannkind		//
//		    Add  			//
//  Include("Mannkind\\Help.cs");	//
//    To your Autoexec.cs file	//
//----------------------------------//

//----------------------------------//
// 	This section is for people	//
//   without NewOpts, only modify	//
//   this section. Unless you know	//
//        what you are doing. I	//
//  recommend not touching anything	//
//                else.			//
//----------------------------------//

// $BeaconDeploy is for beacons, $PackDeploy is for packs.
if(Included("NewOpts\\NewOpts.cs") != 1)
{
	$BeaconDeploy = "B";
	$PackDeploy = "P";
	
	EditActionMap("actionMap.sae");
	bindCommand(keyboard0, make, $PackDeploy, TO, "PacDeploy();");
	bindCommand(keyboard0, break, $PackDeploy, TO, "PacDone();");
	bindCommand(keyboard0, make, $BeaconDeploy, TO, "BeaconDeploy();");
	bindCommand(keyboard0, break, $BeaconDeploy, TO, "BeaconDone();");
}

//----------------------------------//
// 	This section is for people	//
//     with NewOpts, only modify	//
//     this section if you know	//
//        what you are doing.		//
//----------------------------------//

if(Included("NewOpts\\NewOpts.cs") == 1)
{
	NewOpts::register("Help@Beacon",
	"config\\Mannkind\\HelpAtBeacon.gui",
	"",
	"",
	TRUE);

	// This is the help file
	Include("Mannkind\\HelpHelp.cs");
}

//----------------------------------//
//        The Presto banner		//
//----------------------------------//

if ($Presto::version >= 0.93)
{
	Presto::AddScriptBanner(BCN,"<jc><f2>Beacon Addons\n" @
	"<f1><jc>This will add Fire On Beacon\n" @
	"<f1><jc>and Help At Beacon Scripts\n" @
	"<f1><jc>This also allows missed deployments\n" @
	"<f1><jc>to be tried again, until deployed\n" @
	"<f1><jc>Ideas from:<f2> DS.Poker\n" @
	"<jc><f1>By<f2> Mannkind");
}

//----------------------------------//
//        Functions to deploy		//
//         Packs and Beacons		//
//----------------------------------//

function BeaconDeploy()
{
	use("Beacon");
	$BeaconDeployed = 1;
}

function BeaconDone()
{
	$BeaconDeployed = 0;
}

function PacDeploy()
{
	use("BackPack");
	$PackDeployed = 1;
}

function PacDone()
{
	$PackDeployed = 0;
}

//----------------------------------//
//      These check to see if		//
//    you are have the enemy flag	//
//      and deployed a beacon		//
//----------------------------------//

// The function to help the flag carrier
function HelpFlagCarrier::OnClientMessage(%client, %msg)
{
	if (%client != 0)
		return;
	//Check to see if you are holding the Enemys Flag
	$EFlag = getMountedItem(2);
	// If you are holding the flag, do this....
	if ($EFlag == 0)
		{
			// If you deployed a beacon, do this....
			if (%msg == "Beacon deployed")
				{
					// Calls for help
					say(1,"'Flag Carrier in Danger at Beacon!~whelp");
				}
			// Incase you try to deploy out of range, it will try again over and over until beacon is deployed
			else if (%msg == "Deploy position out of range")
				{
					if($BeaconDeployed == 1)
						{
							schedule("use(\"Beacon\");",0.2);						
						}
				}
			// Incase you try to deploy, and an item is in the way, it will try again and again until deployed
			else	if (%msg == "Unable to deploy - Item in the way")
				{
					if($BeaconDeployed == 1)
						{
							schedule("use(\"Beacon\");",0.2);					
						}
				}
			return;
		}
	return;
}

//----------------------------------//
//  This will tell your teammates	//
//  to fire on the beacon you just	//
// 		   deployed			//
//----------------------------------//

function FireOnBeacon::OnClientMessage(%client, %msg)
{	
	//Make sure message is from Client
	if (%client != 0)
		return;
	//Check to see if you aren't holding the Enemys Flag
	$EFlag = getMountedItem(2);
	// If you aren't holding the flag, do this....
	if ($EFlag == -1)
		{
			// If you deploy a beacon, do this....
			if (%msg == "Beacon deployed")
				{
					// Yell Fire on my Target
					say(1,"Fire on my target!~wfiretgt");
				}
			return;
		}
	return;
}


//----------------------------------//
//      This Aids in deployment	//
//----------------------------------//

function DeployAnyways::OnClientMessage(%client, %msg)
{
	//Make sure message is from Client
	if (%client != 0)
		return;
	// Get thing you are trying to deploy
	$ThingToDeploy = getMountedItem(1);
			if ($BeaconDeployed == 1)
			{		
				if (%msg == "Deploy position out of range")
						{
							schedule("use(\"Beacon\");",0.2);
						}
					else	if (%msg == "Unable to deploy - Item in the way")
						{
							schedule("use(\"Beacon\");",0.2);
						}
					else	if (%msg == "Unable to deploy - You're in the way")
						{
							schedule("use(\"Beacon\");",0.2);
						}
			}
			if ($ThingToDeploy > -1)
			{
				if($PackDeployed == 1)
					{
	//Listen for any message telling that you cannot deploy
					if (%msg == "Deploy position out of range")
						{
							schedule("use(\"Backpack\");",0.4);
						}
					else	if (%msg == "Unable to deploy - Item in the way")
						{
							schedule("use(\"Backpack\");",0.4);
						}
					else	if (%msg == "Unable to deploy - You're in the way")
						{
							schedule("use(\"Backpack\");",0.4);
						}
					return;
					}
			}
	return;
}

//----------------------------------//
// 	     Event Attachments		//
//----------------------------------//

Event::Attach(eventClientMessage, HelpFlagCarrier::OnClientMessage);
Event::Attach(eventClientMessage, FireOnBeacon::OnClientMessage);
Event::Attach(eventClientMessage, DeployAnyways::OnClientMessage);