// -- DeeHUD -- v1.0 -----------------------------------------------------------------------------------
// Idea based on CamHUD by Presto and this script is based on |HH|Waldaize's original DeeHUD script.
// Modified by |HH|Crunchy (Jonathan Slark) on request by |HH|Waldaize
//
// This HUD should help when navigating whilst flying.  You can bring up the map screen and see where
// you are going.  Use the key that is set for the CamHUD free look feature, default is f, to actually
// fly the vehicle!  Hold the key down, and you will get normal mouse control.  You can toggle the DeeHUD 
// using the key bound in the header below, default is ctrl-a.  Note the HUD only comes on when you are
// in a vehicle and in the map screen.  It will come on by default unless you toggle it off.
//
// -- DeeHUD prefs --
//
// Set the coordinates of the DeeHUD in "x y width height" to something other than the default:
// $WalPref::DeeHudPosition = "35 355 133 100";

//
// -- Header --
//

EditActionMap("actionMap.sae");
bindCommand(keyboard0, make, control, "a", TO, "DeeHUD::ToggleDisplay();");

Include("Presto\\HUD.cs");
Include("Presto\\CamHUD.cs");
Include("Presto\\Events.cs");

Event::Attach(eventGuiOpen, DeeHUD::On);
Event::Attach(eventGuiClose, DeeHUD::Off);

// Set default pos and size for CamHUD
if($WalPref::DeeHudPosition == "")	$WalPref::DeeHudPosition = "35 355 133 100";

//
// -- Begin code --
//

$DeeHUD::Toggle = true;  // HUD will come on by default

// Create the HUD
HUD::NewFrame(DeeHud, "", getWord($WalPref::DeeHudPosition, 0),
			  getWord($WalPref::DeeHudPosition, 1),
			  getWord($WalPref::DeeHudPosition, 2),
			  getWord($WalPref::DeeHudPosition, 3));
HUD::SetGui(DeeHud,CommandGui);
HUD::AddObject(DeeHud, SimGui::TSControl , 4,2, HUD::Width(DeeHud)-8, HUD::Width(DeeHud)-4);

// Toggle on and off DeeHUD from any screen
function DeeHUD::ToggleDisplay()
{
	if($DeeHUD::Toggle)
	{
		$DeeHUD::Toggle = false;
		HUD::Display(DeeHud, false);
	}
	else
	{
		$DeeHUD::Toggle = true;
		HUD::Display(DeeHud);
	}
}

// Display the DeeHUD if you are in a ship and its the Map screen
function DeeHUD::On(%gui)
{
	if(%gui == CommandGui && getMountedItem(0) == -1 && $DeeHUD::Toggle) // Got ship?
		HUD::Display(DeeHud);
}

// Turn off the DeeHUD when you leave the Map screen.
function DeeHUD::Off(%gui)
{
	if(%gui == CommandGui && $DeeHUD::Toggle) // Don't check if got ship - we could've just died.
		HUD::Display(DeeHud, false);
}
