//
// Match Server Configuration Script (Presto Pack Only) v1.0 by UKTL-Poker 19/04/99
// Originally for the BarrysWorld UK Tribes League
//
// Purpose:
// To allow easy initial configuration of the a match server.
//
// Requirements:
// You must have the Presto Pack Installed to use this script.
// 
// Activation:
// Place this script in your tribes/config folder and then specify match_admin.cs as your custom
// script on the player setup screen or put Include("match_admin.cs"); in your autoexec.cs  
//
// Usage:
// To activate the script connect to the server and say setupserver (all one word).
//
// Please follow the onscreen prompts which will instruct you to:
// 1. specify a match length if not set within this file. 
// 2. say the player password you wish the server to have.
// 3. specify skin for Team 0 if not set within this file.	
// 4. say the name of Team 0.
// 5. specify skin for Team 1 if not set within this file.
// 6. say the name of Team 1.
// You will hear the Objective Completed sound indicating that the server is configured.
//

// - Additional scripts required

Include("presto\\Event.cs");
Include("presto\\Events.cs");


// - Begin User defined settings -

$match_admin::adminPass = "poker";	// You MUST insert the correct admin password
$match_admin::timeLimit = ""; 		// Insert standard timelimit if you wish, otherwise you will be asked for one
$match_admin::defaultskin0 = "beagle";	// Default skin, alter if desired or delete to set manually
$match_admin::defaultskin1 = "dsword";	// Default skin, alter if desired or delete to set manually

// - End user defined settings -


// - Begin Code -

function match_admin::setTeamName0(%client, %msg)
{
	if(%client != getmanagerID())
	  return;
	ADSetTeamInfo(0, %msg, $match_admin::skin0);
	Event::Detach(eventClientMessage, match_admin::setTeamName0);
	if($match_admin::defaultskin1 == "")
	{
		Event::Attach(eventClientMessage, match_admin::setTeamSkin1);
		remoteEval(2048, "IssueCommand", 0, "Say Skin for Team 1", "", "", getManagerId());
	}
	else
	{
		$match_admin::skin1 = $match_admin::defaultskin1;
		Event::Attach(eventClientMessage, match_admin::setTeamName1);
		remoteEval(2048, "IssueCommand", 0, "Say Name for Team 1", "", "", getManagerId());
	}
}

function match_admin::setTeamName1(%client, %msg)
{
	if(%client != getmanagerID())
	  return;	
	ADSetTeamInfo(1, %msg, $match_admin::skin1);
	Event::Detach(eventClientMessage, match_admin::setTeamName1);
	remoteEval(2048, "IssueCommand", 0, "Match Server Configured", "", "", getManagerId());
	commandCompleted();
	$match_admin::skin0 = $match_admin::defaultskin0;
	$match_admin::skin1 = $match_admin::defaultskin1;	
}	

function match_admin::setTeamSkin0(%client, %msg)
{
	if(%client != getmanagerID())
	  return;
	$match_admin::skin0 = %msg;
	Event::Detach(eventClientMessage, match_admin::setTeamSkin0);
	Event::Attach(eventClientMessage, match_admin::setTeamName0);
	remoteEval(2048, "IssueCommand", 0, "Say Name for Team 0", "", "", getManagerId());
}

function match_admin::setTeamSkin1(%client, %msg)
{
	if(%client != getmanagerID())
	  return;	
	$match_admin::skin1 = %msg;
	Event::Detach(eventClientMessage, match_admin::setTeamSkin1);
	Event::Attach(eventClientMessage, match_admin::setTeamName1);
	remoteEval(2048, "IssueCommand", 0, "Say Name for Team 1", "", "", getManagerId());
}	


function match_admin::setPassword(%client, %msg)
{
	if(%client != getmanagerID())
	  return;
	SADSetPassword(%msg);
	Event::Detach(eventClientMessage, match_admin::setPassword);
	remoteEval(2048, "IssueCommand", 0, "Player Password is now: " @ %msg, "", "", getManagerId());
	if($match_admin::defaultskin0 == "")
	{
		schedule("remoteEval(2048, \"IssueCommand\", 0, \"Say Skin for Team 0\", \"\", \"\", getManagerId());", 3);
		Event::Attach(eventClientMessage, match_admin::setTeamSkin0);
	}
	else
	{
		$match_admin::skin0 = $match_admin::defaultskin0;
		schedule("remoteEval(2048, \"IssueCommand\", 0, \"Say Name for Team 0\", \"\", \"\", getManagerId());", 3);
		Event::Attach(eventClientMessage, match_admin::setTeamName0);
	}
}

function match_admin::setTimeLimit(%client, %msg)
{
	if(%client != getmanagerID())
	  return;
	remoteEval(2048, SetTimeLimit, %msg);
	Event::Detach(eventClientMessage, match_admin::setTimeLimit);
	Event::Attach(eventClientMessage, match_admin::setPassword);
	remoteEval(2048, "IssueCommand", 0, "Say Player Password", "", "", getManagerId());
}
	

function match_admin::setUpServer(%client, %msg)
{
	if(%client != getmanagerID())
	  return;
	if(String::findSubStr(%msg, "setupserver") != -1)	
	{
		if($match_admin::adminPass == "")
		  return;
		remoteEval(2048, AdminPassword, $match_admin::adminPass);
		if($match_admin::timeLimit)
		{
			remoteEval(2048, SetTimeLimit, $match_admin::timeLimit);
			remoteEval(2048, "IssueCommand", 0, "Say Player Password", "", "", getManagerId());
			schedule("Event::Attach(eventClientMessage, match_admin::setPassword);", 0.5);
		}
		else
		{
			schedule("Event::Attach(eventClientMessage, match_admin::setTimeLimit);", 0.5);
			remoteEval(2048, "IssueCommand", 0, "Say Time Limit In Minutes", "", "", getManagerId());
		}
	}
}

Event::Attach(eventClientMessage, match_admin::setUpServer);

// - End Code -