//----------------------------------------------------------------
//----------------    BWAdmin Presto Support   -------------------
//----------------------------------------------------------------
//
//	bwadminsupport.cs					Wizard_TPG, August 2000
//
//	This script, on connection to a server, checks for compatible
//	bwadmin support.  If it is not present it will enable legacy
//	message parsing support.
//
//	This will only work for mods with bwadmin script support v 5
//	and later.
//
//----------------------------------------------------------------


//	If you have any trouble with kills or detah counts being doubled
//	on bwadmin servers try putting a false value here.

$bwadmin::prestoSupport = true;


Include("presto\\Event.cs");
Include("presto\\Install.cs");

function BWAdminSupport::Reset()
{
	if(!$bwadmin::prestoSupport)
	{
		$BWAdminSupport::bwadminObjectiveInfo = false;
		$BWAdminSupport::bwadminKillInfo = false;
		event::trigger(eventKillModeVersion);
	}
	else
	{
		remoteEval (2048, bwadmin::isCompatible, getManagerId());
		schedule("BWAdminSupport::CheckKillLegacy();",3);
	}
}

function BWAdminSupport::CheckKillLegacy()
{
	if($BWAdminSupport::bwadminKillInfo == "")
	{
		$BWAdminSupport::bwadminKillInfo = false;
		event::trigger(eventKillModeVersion);
	}
	return;
}

function remotebwadmin::Compatible(%client, %version)
{
	//%version is the returned version of bwadmin
	//now that you know it is bwadmin you can request what
	//data you wish to recieve from bwadmin support

	$BWAdminSupport::Version = %version;
	if(%version >= 5)
	{
		//Check for support
		remoteEval (2048, bwadmin::EnableSupport, getManagerId(),"ObjectiveInfo");
		remoteEval (2048, bwadmin::EnableSupport, getManagerId(),"KillInfo");
	}
	else
	{
		$BWAdminSupport::bwadminObjectiveInfo = false;
		$BWAdminSupport::bwadminKillInfo = false;
		event::trigger(eventKillModeVersion);
	}
}


function remotebwadmin::SupportVerify(%client, %type, %enable)
{
	if(%enable)
	{
		if(%type == "ObjectiveInfo")
		{
			$BWAdminSupport::bwadminObjectiveInfo = true;
			echo("** Compatible bwadmin ",%type," support detected");
		}
		else if(%type == "KillInfo")
		{
			$BWAdminSupport::bwadminKillInfo = true;
			event::trigger(eventKillModeVersion);
			echo("** Compatible bwadmin ",%type," support detected");
		}
	}
	else
	{
		if(%type == "ObjectiveInfo")
		{
			$BWAdminSupport::bwadminObjectiveInfo = false;
			echo("** No Compatible bwadmin ",%type,", support detected, reverting to legacy support");
		}
		else if(%type == "KillInfo")
		{
			$BWAdminSupport::bwadminKillInfo = false;
			event::trigger(eventKillModeVersion);
			echo("** No Compatible bwadmin ",%type,", support detected, reverting to legacy support");
		}
	}
}

function BWAdminSupport::ResetVariables()
{
	$BWAdminSupport::bwadminObjectiveInfo = "";
	$BWAdminSupport::bwadminKillInfo = "";
}

Event::Attach(eventConnectionAccepted, "BWAdminSupport::Reset();");
Event::Attach(eventConnectionRejected, "BWAdminSupport::ResetVariables();");
Event::Attach(eventConnectionLost, "BWAdminSupport::ResetVariables();");
Event::Attach(eventConnectionTimeout, "BWAdminSupport::ResetVariables();");
Event::Attach(eventExit, "BWAdminSupport::ResetVariables();");
