//----------------------------------------------------------------------------------
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! SixPak Script Pack !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//----------------------------------------------------------------------------------
// FILE NAME    | FlagHunterHUD.cs 
// AUTHOR       | SixStringz - Icons by Neuromancer  
// AUTHOR EMAIL | mccleans@inreach.com
// VERSION      | 1.6
// RELEASE DATE | 09/16/99
// REQUIREMENTS | 
// DESCRIPTION  | Flags, points, kills, deaths HUD for Hunter mission type!
// DESCRIPTION  | This script is based on a script by Gryphin++. The version I 
// DESCRIPTION  | downloaded was kinda plain looking I could not even get it to  
// DESCRIPTION  | work. Props go out to him for the idea and inspiration though!
//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
// REQUIRED FILES:
// Presto Pack >= 0.93
//
// INSTALL NOTES:
// Although this script was written for my SixPak it will function outside of the 
// pack as long as you at least have Presto installed.
//
// Unzip to your tribes\config directory and with paths enabled and everything 
// should unzip to the correct place as shown.
//
//   config\six\FlagHunterHUD.cs 
//   config\six\bmp\FlagHunterHUD*.bmp
//   config\docs\readme_FlagHunterHUD.txt 
//
// Add the following line (without the //) to config\autoexec.cs file
//
// Include("six\\FlagHunterHUD.cs");
//
// The default key to toggle the display is set to CONTROL H, if you already have 
// something bound to that key you will need to change it. If you are running this 
// script without SixPak you will need to change the binding at the bottom of this 
// file. If you are using SixPak, you can change the binding in config\six\sixkeys.cs
//
// LIMITATIONS:
//
// I noticed some Hunter servers have modified the death messages. This will cause
// FlagHunterHUD as well as any other scripts that use KillTrak to not work
// correctly. I have modified the KillTrak script in SixPak 3.0+ to include the 
// additional messages that I was able to catch, but there may be more... If you use 
// this script with SixPak 3.0+ you should not have any problems, but if you use it 
// without SixPak and you play on one of these modified servers it is likely that the 
// HUD will not track correctly.
//

Include("presto\\HUD.cs");
Include("presto\\Match.cs");
Include("presto\\events.cs");
Include("presto\\KillTrak.cs");

if ($FlagHunterHUD::ShowKiller == "")       $FlagHunterHUD::ShowKiller = true;
if ($FlagHunterHUD::ShowVictim == "")       $FlagHunterHUD::ShowVictim = true;


$FlagHunterHUD::Position = "0 82 75 21";

function FlagHunterHUD::UpdateFlags()
{
   if($FlagHunterHUD::Flags < 1)
      %flagsicon = "<B4,2:six\\bmp\\FlagHunterHUD_noflags.bmp>";
   else if(($FlagHunterHUD::Flags > 0) && ($FlagHunterHUD::Flags < 6))
      %flagsicon = "<B4,2:six\\bmp\\FlagHunterHUD_flags1.bmp>";
   else if(($FlagHunterHUD::Flags > 5) && ($FlagHunterHUD::Flags < 11))
      %flagsicon = "<B4,2:six\\bmp\\FlagHunterHUD_flags2.bmp>";
   else if($FlagHunterHUD::Flags > 10)
      %flagsicon = "<B4,2:six\\bmp\\FlagHunterHUD_flags3.bmp>";

   HUD::AddText(FlagHunterHUD_Flags,  %flagsicon @"<f2> "@$FlagHunterHUD::Flags);
   HUD::Update(FlagHunterHUD_Worth);
   return 0;
}


function FlagHunterHUD::UpdateWorth()
{
   if($FlagHunterHUD::Worth < 1)
      %worthicon = "<B4,2:six\\bmp\\FlagHunterHUD_noWorth.bmp>";
   else 
      %worthicon = "<B4,2:six\\bmp\\FlagHunterHUD_Worth.bmp>";

   HUD::AddText(FlagHunterHUD_Worth,  %worthicon @"<f2> "@$FlagHunterHUD::Worth);    
   return 0;
}


function FlagHunterHUD::UpdatePoints()
{
   if($FlagHunterHUD::Points < 1)
      %pointsicon = "<B4,2:six\\bmp\\FlagHunterHUD_noPoints.bmp>";
   else 
      %pointsicon = "<B4,2:six\\bmp\\FlagHunterHUD_Points.bmp>";

   HUD::AddText(FlagHunterHUD_Points, %pointsicon @"<f2> "@$FlagHunterHUD::Points);    
   return 0;
}


function FlagHunterHUD::UpdateKills()
{
   if($FlagHunterHUD::Kills < 1)
      %killsicon = "<B4,2:six\\bmp\\FlagHunterHUD_noKills.bmp>";
   else 
      %killsicon = "<B4,2:six\\bmp\\FlagHunterHUD_Kills.bmp>";

   HUD::AddText(FlagHunterHUD_Kills,  %killsicon @"<f2> "@$FlagHunterHUD::Kills);    
   return 0;
}


function FlagHunterHUD::UpdateDeaths()
{
   if($FlagHunterHUD::Deaths < 1)
      %deathsicon = "<B4,2:six\\bmp\\FlagHunterHUD_noDeaths.bmp>";
   else 
      %deathsicon = "<B4,2:six\\bmp\\FlagHunterHUD_Deaths.bmp>";

   HUD::AddText(FlagHunterHUD_Deaths, %deathsicon @"<f2> "@$FlagHunterHUD::Deaths);    
   return 0;
}


function FlagHunterHUD::Reset()
{
   $FlagHunterHUD::Flags = 0;
   $FlagHunterHUD::Worth = 0;
   $FlagHunterHUD::Points = 0;
   $FlagHunterHUD::Kills = 0;
   $FlagHunterHUD::Deaths = 0;
   HUD::Update(FlagHunterHUD_Flags);
   HUD::Update(FlagHunterHUD_Points);
   HUD::Update(FlagHunterHUD_Kills);
   HUD::Update(FlagHunterHUD_Deaths);
}


function FlagHunterHUD::GetFlagCount(%client, %msg)
{
   if(%client != 0)
      return;

   if(Match::String(%msg, "You now have * flag.") == true)
   {
      $FlagHunterHUD::Flags = Match::Result(0);
      FlagHunterHUD::FlagPointsWorth();
      HUD::Update(FlagHunterHUD_Flags);
   } 
   else if(Match::String(%msg, "You now have * flags!") == true)
   {
      $FlagHunterHUD::Flags = Match::Result(0);
      FlagHunterHUD::FlagPointsWorth();
      HUD::Update(FlagHunterHUD_Flags);
   }
   else if(Match::String(%msg, "You returned *") == true)
   {
      $FlagHunterHUD::Points = $FlagHunterHUD::Points + $FlagHunterHUD::Worth;
      $FlagHunterHUD::Flags = 0;
      $FlagHunterHUD::Worth = 0;
      HUD::Update(FlagHunterHUD_Flags);
      HUD::Update(FlagHunterHUD_Points);
   }
}


function FlagHunterHUD::Death(%s1, %s2, %s3)
{
   %me = getManagerId();	
   if (%s2 == %me)
   {
      if ($FlagHunterHUD::ShowKiller)
      {
         if (%s1 != %s2)
         {
            schedule::Add("THGoAway();",0);
            Client::centerPrint("<jc><f1>You died!\n<f0>Killed by: <f2>" @ Client::getName(%s1) @"\n <f0>Weapon: <f2>" @ %s3, 1); 
            schedule("Client::centerPrint(\"\", 1);", 5);
         }
         else 
            $FlagHunterHUD::Points--;
      }

      $FlagHunterHUD::Deaths++;		
      $FlagHunterHUD::Flags = 0;
      $FlagHunterHUD::Worth = 0;
      HUD::Update(FlagHunterHUD_Flags);
      HUD::Update(FlagHunterHUD_Deaths);
      HUD::Update(FlagHunterHUD_Points);
   }
   else if (%s1 == %me)	
   {
      if ($FlagHunterHUD::ShowVictim)
      {
         schedule::Add("THGoAway();",0);
         Client::centerPrint("<jc><f1>Kill Added\n<f0>Killed: <f2>" @ Client::getName(%s2) @"\n <f0>Weapon: <f2>" @ %s3, 1); 
         schedule("Client::centerPrint(\"\", 1);", 5);
      }

      $FlagHunterHUD::Points++;
      $FlagHunterHUD::Kills++;		
      HUD::Update(FlagHunterHUD_Kills);
      HUD::Update(FlagHunterHUD_Points);
   }
}


function FlagHunterHUD::FlagPointsWorth()
{
   $FlagHunterHUD::Worth = 0;
   for(%i = $FlagHunterHUD::Flags; %i >= 0; %i--)
   {
      $FlagHunterHUD::Worth = $FlagHunterHUD::Worth + %i; 
   }
}


function FlagHunterHUD::MakeHUDs()
{
   if (HUD::GetDisplayed(FlagHunterHUD_Flags))
   {
      HUD::Move(FlagHunterHUD_Flags, FlagHunterHUD::UpdateFlags, $FlagHunterHUD::Position);
      HUD::Move(FlagHunterHUD_Worth, FlagHunterHUD::UpdateWorth, "left(FlagHunterHUD_Flags) bottom(FlagHunterHUD_Flags)-1 75 21");
      HUD::Move(FlagHunterHUD_Points, FlagHunterHUD::UpdatePoints, "left(FlagHunterHUD_Flags) bottom(FlagHunterHUD_Worth)-1 75 21");
      HUD::Move(FlagHunterHUD_Kills, FlagHunterHUD::UpdateKills, "left(FlagHunterHUD_Flags) bottom(FlagHunterHUD_Points)-1 75 21");
      HUD::Move(FlagHunterHUD_Deaths, FlagHunterHUD::UpdateDeaths, "left(FlagHunterHUD_Flags) bottom(FlagHunterHUD_Kills)-1 75 21");
      HUD::Update(FlagHunterHUD_Flags);
      HUD::Update(FlagHunterHUD_Worth);
      HUD::Update(FlagHunterHUD_Points);
      HUD::Update(FlagHunterHUD_Kills);
      HUD::Update(FlagHunterHUD_Deaths);
   }
   else 
   {
      HUD::New(FlagHunterHUD_Flags, FlagHunterHUD::UpdateFlags, $FlagHunterHUD::Position);
      HUD::New(FlagHunterHUD_Worth, FlagHunterHUD::UpdateWorth, "left(FlagHunterHUD_Flags) bottom(FlagHunterHUD_Flags)-1 75 21");
      HUD::New(FlagHunterHUD_Points, FlagHunterHUD::UpdatePoints, "left(FlagHunterHUD_Flags) bottom(FlagHunterHUD_Worth)-1 75 21");
      HUD::New(FlagHunterHUD_Kills, FlagHunterHUD::UpdateKills, "left(FlagHunterHUD_Flags) bottom(FlagHunterHUD_Points)-1 75 21");
      HUD::New(FlagHunterHUD_Deaths, FlagHunterHUD::UpdateDeaths, "left(FlagHunterHUD_Flags) bottom(FlagHunterHUD_Kills)-1 75 21");
      HUD::Display(FlagHunterHUD_Flags);
      HUD::Display(FlagHunterHUD_Worth);
      HUD::Display(FlagHunterHUD_Points);
      HUD::Display(FlagHunterHUD_Kills);
      HUD::Display(FlagHunterHUD_Deaths);
   }
}


function FlagHunterHUD::Toggle()
{
   if (HUD::GetDisplayed(FlagHunterHUD_Flags))
   {
      HUD::Display(FlagHunterHUD_Flags, false);
      HUD::Display(FlagHunterHUD_Worth, false);
      HUD::Display(FlagHunterHUD_Points, false);
      HUD::Display(FlagHunterHUD_Kills, false);
      HUD::Display(FlagHunterHUD_Deaths, false);
   }
   else
   {
      HUD::Display(FlagHunterHUD_Flags, true);
      HUD::Display(FlagHunterHUD_Worth, true);
      HUD::Display(FlagHunterHUD_Points, true);
      HUD::Display(FlagHunterHUD_Kills, true);
      HUD::Display(FlagHunterHUD_Deaths, true);
   }
}


FlagHunterHUD::MakeHUDs();
FlagHunterHUD::Reset();


Event::Attach(eventChangeMission, FlagHunterHUD::Reset);
Event::Attach(eventConnected, FlagHunterHUD::Reset);
Event::Attach(eventClientMessage, FlagHunterHUD::GetFlagCount);
Event::Attach(eventKillTrak, FlagHunterHUD::Death);


if(!included("six\\sixkeys.cs"))
{
   editActionMap("playMap.sae");
   bindCommand(keyboard0, make, control, "h", to, "FlagHunterHUD::Toggle();");
   bindCommand(keyboard0, break, control, "h", to, "");
}