// AutoDrop v1.0 - 1999 10 15
// By Jason "VeKToR++" Gill
// Automatically drops a repair pack when you enter a station. Be sure to turn around
// a bit while the station bar is lifting, otherwise you will end up throwing the
// pack AT the station instead of away. I could have scheduled it to wait until
// you have turned away (using presto's CamHUD) but then autobuy with Fast Favorites
// becomes unreliable...

// This variable is the toggle key to switch auto-Drop on and off just change this to
// whichever key you want to toggle the Auto-Drop feature (ex. "control d", "alt m", "shift c", "period")
// only needed if you do NOT use NewOpts.
$AD::ToggleKey = "shift comma";

// this variable sets whether or not you want to drop a pack by default.
// if this is set to TRUE, when you start up Tribes, you will be set to drop a repair pack
// when you go to an inv station, and will do so until you toggle AutoDrop off.
// Set to TRUE or FALSE:
// Only Required if you do not use NewOpts
$AD::DropPack = TRUE;

// Set this variable to the thing you wanna drop by default
$AD::DropDefault = "Repair Pack";

// 36 characters should be enough =)
$AD::Alphabet = "a b c d e f g h i j k l m n o p q r s t u v w x y z 1 2 3 4 5 6 7 8 9 0";

if (isFile("config\\AutoDropSettings.cs")) {
	if (include("NewOpts\\Install.cs") == notfound) 
		bindkey(play, $AD::ToggleKey, "AD::ToggleDrop();");

	exec("AutoDropSettings.cs");
} else {
	if (include("NewOpts\\Install.cs") == notfound) 
		bindkey(play, $AD::ToggleKey, "AD::ToggleDrop();");
}

if (include("presto\\event.cs") == notfound)
	include("writer\\event.cs");

if ((include("writer\\station_events.cs") != notfound) && (isFile("config\\writer\\station_events.cs"))) {
	$AD::CallStatEvent = true;
	Event::Detach(eventClientMessage, Station::onClientMessage);
} else
	$AD::CallStatEvent = false;

function AD::AddItem(%item) {
	if ($AD::TotalItems == "")
		$AD::TotalItems = 0;

	if ($AD::ItemNumber[%item] != "")
		return;

	$AD::ItemIndex[$AD::TotalItems] = %item;
	$AD::ItemNumber[%item] = $AD::TotalItems;

	$AD::TotalItems++;
}

function AD::HandleMsg(%client, %msg) {
	if (%client)
		return true;

	if ((%msg == "Station Access On") && ($AD::DropPack)) {
		remoteeval(2048, BuyItem, GetItemType($AD::DropDefault));
		remoteeval(2048, DropItem, GetItemType($AD::DropDefault));
	}

	if ($AD::CallStatEvent)
		return Station::onClientMessage(%client, %msg);
}
Event::Attach(eventClientMessage, AD::HandleMsg);

function AD::ToggleDrop() {
	$AD::DropPack = !$AD::DropPack;
	if ($AD::DropPack)
		RemoteCP(2048, "AutoDrop is: <f2>ON", 5);
	else
		RemoteCP(2048, "AutoDrop is: <f2>OFF", 5);
}

function AD::Addentry(%obj, %name, %value) {
	$AD::Index[%name] = %value;
	FGCombo::AddEntry(%obj, %name, %value);
}

function AD::BoxON() {
	$AD::DropPack = true;
	control::setvalue(AD::BoxHeader, "AutoDrop is ON by default");
	control::setactive(AD::BoxHeader, true);
}

function AD::BoxOFF() {
	$AD::DropPack = false;
	control::setvalue(AD::BoxHeader, "AutoDrop is OFF by default");
	control::setactive(AD::BoxHeader, false);
}

function AD::Select() {
	$AD::DropDefault = FGCombo::getSelectedText(AD::Chooser);
}

function AD::OnOpen() {
	if ($AD::DropPack) {
		control::setvalue(AD::BoxHeader, "AutoDrop is ON by default");
		control::setactive(AD::BoxHeader, true);
		control::setvalue(AD::Box, true);
	} else {
		control::setvalue(AD::BoxHeader, "AutoDrop is OFF by default");
		control::setactive(AD::BoxHeader, false);
		control::setvalue(AD::Box, false);
	}

	FGCombo::Clear(AD::Chooser);

	for (%i = 0; %i < $AD::TotalItems; %i++) {
		AD::AddEntry(AD::Chooser, $AD::ItemIndex[%i], %i);
	}	

	FGCombo::SetSelected(AD::Chooser, $AD::ItemNumber[$AD::DropDefault]);
}

function AD::MenuChoice(%item, %letter) {
	Menu::AddChoice(AutoDropMenu, %letter @ %item, "$AD::DropDefault = \"" @ %item @ "\"; RemoteCP(2048, \"AutoDrop set to: <f2>\" @ $Ad::DropDefault, 5);");
}

function AD::InGameMenu() {
	Menu::Display(AutoDropMenu);
}

function AD::BuildMenu() {
	Menu::New(AutoDropMenu);

	for (%i = 0; %i < $AD::TotalItems; %i++) {
		AD::MenuChoice($AD::ItemIndex[%i], getword($AD::Alphabet, %i));
		echo("Adding - " @ $AD::ItemIndex[%i] @ " -> " @ getword($AD::Alphabet, %i));
	}	
}
event::attach(eventConnected, AD::BuildMenu);

function AD::OnClose() {
	export("$AD::DropPack", "config\\AutoDropSettings.cs", false);
	export("$AD::DropDefault", "config\\AutoDropSettings.cs", true);
}
event::attach(eventExit, AD::OnClose);

NewOpts::Register("AutoDrop(tm) Settings", "config\\vektor\\gui\\AUtoDrop.gui", "AD::OnOpen();", "AD::OnClose();", TRUE);

// Item definitions - define a list of items you wanna be able to drop
AD::AddItem("Repair Pack");
AD::AddItem("Energy Pack");
AD::AddItem("Shield Pack");
AD::AddItem("Ammo Pack");
AD::AddItem("Sensor Jammer Pack");

AD::AddItem("Inventory Station");
AD::AddItem("Ammo Station");

AD::AddItem("Turret");
AD::AddItem("Camera");
AD::AddItem("Pulse Sensor");
AD::AddItem("Motion Sensor");
AD::AddItem("Sensor Jammer");

AD::AddItem("Repair Kit");
AD::AddItem("Mortar Ammo");