//************************************************************
//AutoPoint 1.3                                              
//By MrPoop                                                 
//Email: Poop@tampabay.rr.com                                
//Based on Crunchy's TargetFlag.cs script.
//Sets Auto Waypoints to either friendly or enemy flaggers. Also supports Manual Mode.                                   
//************************************************************

newObject(AutoPoint, SimVolume, "poop\\AutoPoint.vol");

function AutoPoint::AddBanner()
{
	Presto::AddScriptBanner(AutoPoint,
		"<B3,4:AutoPointPresto.bmp>");
}

AutoPoint::AddBanner();

Include("Presto\\Event.cs");
Include("Presto\\TeamTrak.cs");

function AutoPoint::Defaults()
{
	$PoopPrefs::AutoPointSayTeam = "True";
}
	
if(isFile("config\\PoopPrefs.cs"))
{
	include("PoopPrefs.cs");
	if($PoopPrefs::AutoPointSayTeam == "")
		AutoPoint::Defaults();
}
else
{
	AutoPoint::Defaults();
}

function targetClientByName(%name, %msg)
  {
	%clientId = getClientByName(%name);
	remoteEval(2048, "IssueTargCommand", 0, %msg, %clientID - 2048, getManagerId());
  }

function AutoPoint::Flagger()
{
	$EFlag = getmountedItem(2);
	if($EFlag != 0)
	{	
		if($AutoPoint::Item == "Friendly")
		{
			%location = Team::GetFlagLocation(Team::Enemy());
			if(%location == $Trak::locationHome || %location == $Trak::locationField)
				return;
			targetClientByName(%location, "Escort the flag carrier " @ %location @ ".~wescfr");
			if($PoopPrefs::AutoPointSayTeam && Flood::Protect("AutoPoint::Flagger"@%location, 30))
			{
				schedule("Say::Team(targetAcquired, \"I'm escorting you "@%location@".\");", 1);
			}
		}
	}
}

function AutoPoint::AutoMessages(%client, %msg)
{
	if(String::FindSubStr(%msg, "!AP") != -1)
	{
		return mute;
	}
	if(%client != 0)
		return;
	if (String::findSubStr (%msg, "flag")!=-1)
	{
		if(String::findSubStr(%msg, "our team has the")!=-1)
		{
			//Needed to place this portion of the flag tracking somewhere else because the flag mount point does not isntantly reflect whether or not youhave the flag.
			schedule("AutoPoint::Flagger();", 0.1);
			$AutoPoint::Targetting = "FRIENDLY";
		}
		else if(String::findSubStr(%msg, "our team's flag has been taken.")!=-1)	
		{			
			if($AutoPoint::Item == "Enemy")
			{
				%location = Team::GetFlagLocation(Team::Friendly());
				if(%location == $Trak::locationHome || %location == $Trak::locationField)
					return;
				targetClientByName(%location, "Kill the flag carrier " @ %location @ "!~wattway");
				$AutoPoint::Targetting = "ENEMY";
			}
		}
		else if(String::findSubStr(%msg, "our team captured the")!=-1)
		{
			if($AutoPoint::Item != "Manual" && $AutoPoint::Targetting == "FRIENDLY")
			{
				remoteEval(2048, CStatus, 0, "!AP Off");
				$AutoPoint::Targetting = "";
			}
		}
		else if(string::findsubstr(%msg, "our team's flag was captured") != -1)
		{
			if($AutoPoint::Item != "Manual" && $AutoPoint::Targetting == "ENEMY")
			{
				remoteEval(2048, CStatus, 0, "!AP Off");
				$AutoPoint::Targetting = "";
			}
		}
		else if(String::findSubStr(%msg, "our flag was returned to base.")!=-1)	
		{
			if($AutoPoint::Item != "Manual" && $AutoPoint::Targetting == "ENEMY")
			{
				remoteEval(2048, CStatus, 0, "!AP Off");
				$AutoPoint::Targetting = "";
			}
		}
		else if(String::findSubStr(%msg, "flag was returned to base.")!=-1)
		{
			if($AutoPoint::Item != "Manual" && $AutoPoint::Targetting == "FRIENDLY")
			{
				remoteEval(2048, CStatus, 0, "!AP Off");
				$AutoPoint::Targetting = "";
			}
		}
	}
}
//This Code here is a direct rip from Crunchy's Target Flag
function AutoPoint::ManualMessages(%friendly)
{
	if(%friendly)
	{
		%location = Team::GetFlagLocation(Team::Enemy());
		if(%location == $Trak::locationHome || %location == $Trak::locationField)
			return;

		targetClientByName(%location, "Escort the flag carrier " @ %location @ ".~wescfr");

		if($PoopPrefs::AutoPointSayTeam && Flood::Protect("AutoPoint::ManualMessages"@%location, 30))
		schedule("Say::Team(targetAcquired, \"I'm escorting you "@%location@".\");", 1);
	}
	else
	{
		%location = Team::GetFlagLocation(Team::Friendly());
		if(%location == $Trak::locationHome || %location == $Trak::locationField)
			return;

		targetClientByName(%location, "Kill the flag carrier " @ %location @ "!~wattway");
	}
}

//Variables for AutoPoint::Next
$AutoPoint::Option[0] = "Manual";
$AutoPoint::Option[1] = "Friendly";
$AutoPoint::Option[2] = "Enemy";

$AutoPoint::maxitem = 2;
$AutoPoint::current = 0;

$AutoPoint::item = $AutoPoint::Option[$AutoPoint::current];

function AutoPoint::next()
{
	$AutoPoint::current++;
	if($AutoPoint::current > $AutoPoint::maxitem)
	$AutoPoint::current = 0;
	$AutoPoint::item = $AutoPoint::Option[$AutoPoint::current];
	remoteBP(2048, "<L5>AutoPoint set to <f2>" @ $AutoPoint::item, 5);
}

function AutoPoint::OnOpen()
{
	Control::Setvalue("AutoPoint::01", "<B0,0:AutoPoint01.bmp>");
	Control::Setvalue("AutoPoint::02", "<B0,0:AutoPoint02.bmp>");
}
function AutoPoint::OnClose()
{
	export("$PoopPrefs::*", "config\\PoopPrefs.cs", false);
}

Event::Attach(eventClientMessage, AutoPoint::AutoMessages);

NewOpts::register("AutoPoint", "AutoPoint.gui", "AutoPoint::OnOpen();", "AutoPoint::OnClose();", TRUE);
NewOpts::registerHelp("AutoPoint", "General", "AutoPoint is the smartest auto flag waypointer around. It can be set to auto waypoint friendly or enemy flag carriers or can be set for manual activation.  AutoPoint also turns off the waypoint if the flag is returned to base or capped.");
NewOpts::registerHelp("AutoPoint", "Auto Toggle", "Cycles through friendly, enemy, or manual settings.");
NewOpts::registerHelp("AutoPoint", "Manual Friendly", "If the enemy has your flag, press this key to manually waypoint yourself to him.");
NewOpts::registerHelp("AutoPoint", "Manual Enemy", "If a teammate has the enemy flag, press this key to manually waypoint yourself to him.");
NewOpts::registerHelp("AutoPoint", "Author", "AutoPoint written by MrPoop. Code based upon Crunchy's Target Flag script.");