// Popup HUD position on the screen (Presto HUD-format)
// Here's a couple examples:
//	$BudHud::Position = "50% 50%";   would put the HUD right in the middle of the screen
//	$BudHud::Position = "100% 100%"; would put the HUD in the lower-right corner.
//	$BudHud::Position = "100 200";   would put the HUD 100 pixels from the left side of 
//					 the screen, and 200 pixels from the top edge.
$BudHud::Position = "100% 50%";

// Don't mess with this line, it loads the "default" prefs for BudHUd
exec("VeKToR\\BudHudDefaults.cs");

// Leave this one alone too. It loads your custom settings, if they exist.
if (isFile("config\\BudHudPrefs.cs"))
	exec("BudHudPrefs.cs");

// _______________________________________________________________________________________
// _______________________________________________________________________________________
// THIS SECTION IS WHERE YOU GET TO ADD YOUR SETTINGS
// _______________________________________________________________________________________
// _______________________________________________________________________________________

echo("Including External Prefs");

// =============================================================================================
// Add BudHud::TextScan calls here.
// =============================================================================================
// Text to scan for
// Just enter any piece of text you want to scan for, and have displayed on the pager.
// feel free to add as many lines as you want
//
// Here's some examples!
//
//	BudHud::TextScan("VeKToR");
//		Scans incoming messages for the text "VeKToR" and pops up a pager if it's
//		found.
//
//	BudHud::TextScan("Gen", "M_Generator_Green");
//		Scans incoming messages for the text "Gen", and pops up a pager if it's
//		found. The generator bitmap ("M_Generator_Green") will be displayed on the
//		popup Pager HUD.
//
//	Note: the following example is intended to be used in the next section of this
//	      prefs file, as it defines buddies. For simplicity, the "Text Scan" will be
//	      "attached" to the last bud that you defined.
//	BudHud::AddFriend("Some_Guy", false);
//	BudHud::TextScan("Help!");
//		Scans incoming messages from the player Some_Guy. If his message contains
//		the text "Help!", a pager HUD will popup.
// =============================================================================================
// =============================================================================================
// Here's a few blank lines to get you started - Just add info between the brackets!

BudHud::TextScan("Vek");
BudHud::TextScan("need ammo");
BudHud::TextScan("enemy flag");

// =============================================================================================
// =============================================================================================
// Friend's name(s) / Tribe symbol(s) / Sound Setting(s)
// Just uncomment them (remove the // in front) and enter your buddy's
// name. Do the same for the SetSound() Line to add custom sounds (see above)
// Feel free to add as many lines as you want
//
// Here's some examples:
//
//	BudHud::AddFriend("Vita", false);
//		Adds a player named "Vita" to your bud list. The player's ENTIRE name must
//		exactly match the text "Vita" (though upper-case letters make no difference)
//		The false represents that this is NOT *PART* of a player's name, but the
//		name EXACTLY as it should appear in Tribes
//
//	BudHud::AddFriend("FlyChic", false, "f");
//		Adds a player named "FlyChic" to your bud list. Again, the name must exactly
//		the text entered. The "f" at the end means that this player's PREFERRED
//		letter on the Bud menu is "f", though if the letter "f" has already been
//		used, this bud will be automatically assigned a new letter or number.
//
//	BudHud::AddFriend("[QB]", true, "q");
//	BudHud::TextScan("Need");
//		Adds a "part of name" search for all players with the text "[QB]" in their
//		name. Useful for quickly marking all the members of a specific tribe. Anyone
//		who matches this, and sends a message with "Need" in it will trigger a page.
//		The preferred letter, "q", will apply to anyone who matches this search,
//		provided that the letter has not already been used in the menu.
//
//	BudHud::SetSound("MyPage", "MyJoin", "MyDrop", "MyChang");
//		Defines custom sounds for the Bud entered DIRECTLY ABOVE the settext line.
//		The values should be the names of sound files in the voice directory, and
//		should follow the same name rules seen in the BudHud.txt file.
//		The file "wMyPage.wav" will be played when you get a page from this player,
//		"wMyJoin.wav" will play when he joins, "wMyDrop" will play when he drops,
//		and "wMyChange.wav" will play when he switches teams. Leaving any of these
//		fields blank (ie "") will set the sound to the default value.
// =============================================================================================
// =============================================================================================
// Here's some blank fields to get you started.

	BudHud::AddFriend("Vita", false, "v");
	BudHud::SetSound();
	BudHud::TextScan();

	BudHud::AddFriend("VeKToR", false, "v");
	BudHud::SetSound();
	BudHud::TextScan();

	BudHud::AddFriend("FlyChic", false, "f");
	BudHud::SetSound();
	BudHud::TextScan();

	BudHud::AddFriend("[QB]", true, "q");
	BudHud::SetSound();
	BudHud::TextScan();

	BudHud::AddFriend("[KoB]FireStorm", false, "f");
	BudHud::SetSound();
	BudHud::TextScan();

	BudHud::AddFriend("CaptShazbot", false, "c");
	BudHud::SetSound();
	BudHud::TextScan();

// =============================================================================================
// =============================================================================================
// These custom filters block out certain messages from popping up on the pager HUD.
// Some defaults have been put in. These are useful, because if you put your name in
// as a TextScan, and someone repairs your RMT Turret, you won't be annoyed by a page
// telling you this (assuming they're using an auto-repair notification script)
// These filters block out commonly used scripts that might trigger useless pages.
// Use presto-format string matching paramaters, but try not to put too many filters
// in, as a lot of filters means slightly more cpu overhead.
// =============================================================================================
// =============================================================================================
        BudHud::AddMuteFilter("%1RMT Turret%2");
        BudHud::AddMuteFilter("Thanks%1");
        BudHud::AddMuteFilter("%1Camera#%2");
        BudHud::AddMuteFilter("Sorry%1");

// =============================================================================================
// =============================================================================================
// This function will allow you to block out specific clients from matching a budhud scan.
// If you defined "ABA" as a "part-of-name" bud, but some guy named "Abacus" keeps coming
// up as a buddy, and you don't want him to, Just block him out like this:
// BudHud::IgnoreMatch("Abacus");
// and he will never bother your Buddy list again.
// (BTW if anyone out there is named abacus, no offense! Just an example :)
// =============================================================================================
// =============================================================================================

	BudHud::IgnoreMatch();
	BudHud::IgnoreMatch();
	BudHud::IgnoreMatch();

// =================================================================
// Don't add ANY info below this line --------------------------
// It loads up and adds your permanent (in-game defined) buds
// =================================================================

// Includes buddies from external buddy list.

if (IsFile("config\\BudHudData.cs")) {
	exec("BudHudData.cs");

        if (($BudHud::PermFriends[true] > 0) && ($BudHud::PermFriends[true] != "")) {
                for (%i = 0; %i < $BudHud::PermFriends[true]; %i++)
                        BudHud::AddFriend($BudHud::PermFriendString[true, %i], false);
	}
}

