// BudHud - The last word in buddy-tracking software :)
// _______________________________________________________________________________

// For sequential menu choice letters, for which the number of choices is unknown.
// All alphanumeric characters here :)
// (well, except for that smiley)
// note that "o" is left out (it's used for the "o" hotkey for the "more" option
// I didn't use M because I like O better. (good enough reason!)
$BudHud::Alphabet = "1 2 3 4 5 6 7 8 9 0 a b c d e f g h i j k l m n p q r s t u v w x y z";

$BudHud::Version = "beta 3";

// Added support for WarPoints, if available :)
if (isfile("Config\\Rayn\\Warpointer.cs")) {
	include("Rayn\\Warpointer.cs");
	$BudHud::UseWarpoints = true;
	event::attach(eventWarpointNewWaypoint, "BudHud::AddWPData");
	event::attach(eventWarpointInitLevel, "BudHud::KillWPData");	
} else
	$BudHud::UseWarpoints = false;

// for our HUD management code
include("Presto\\HUD.cs");

include("Presto\\events.cs");
include("Presto\\Menu.cs");
include("Presto\\match.cs");
include("Presto\\TeamTrak.cs");

// Waypointing stuff
include("Vektor\\Waypoint.cs");
include("VeKToR\\BudHudMenus.cs");

// Initial settings
$BudHud::PagerActive = true;
$BudHud::SoundActive = true;

// Debug info on/off variable
$BudHud::Debug = true;

function Debug(%text) {
	if ($BudHud::Debug)
		echo(%text);
}

// Connected variable so we don't get 16 "join" messages when we join
// a server (from clients that're already on the server). 
$BudHud::Connected = false;

// Adds your name or your tribe name for "pager" element
function BudHud::TextScan(%name, %bitmap) {

	// Don't add empty names!
	if (%name == "")
		return;

	if (($BudHud::NumClientNames == "") || ($BudHUd::NumClientNames < 1))
		%index = -1;
	else
		%index = $BudHud::NumClientNames-1;

	if ($BudHud::NumNames[%index] == "")
		$BudHud::NumNames[%index] = 0;

	// check if name is already added so we don't get repeats
	// check all the global "general masses" textscans
	if (($BudHud::NumNames[-1] > 0) && (%index != -1))
		for (%i = 0; %i < $BudHud::NumNames[-1]; %i++)
			if (String::ICompare(%name, $BudHud::Name[%i, -1]) == 0)
				return;

	// check all buddy specific textscans
	if ($BudHud::NumNames[%index] > 0)
		for (%i = 0; %i < $BudHud::NumNames[%index]; %i++)
			if (String::ICompare(%name, $BudHud::Name[%i, %index]) == 0)
				return;

	debug("Adding Textscan - " @ %name @ " for bud # " @ %index);

	$BudHud::Name[$BudHud::NumNames[%index], %index] = %name;
	$BudHud::NameBitMap[$BudHud::NumNames[%index], %index] = %bitmap;
	$BudHud::NumNames[%index]++;
}

// Adds a client name for Join/Drop/Changeteam tracking.
// should be different than your names above, as it's used for
// a different type of tracking (though your "tribe name" like [QB]
// might be in here)
function BudHud::AddFriend(%name, %partname, %letter) {

	// Don't add empty names!
	if (%name == "")
		return;

	if ($BudHud::NumClientNames == "")
		$BudHud::NumClientNames = 0;

	// check if name is already added so we don't get repeats
	if ($BudHud::NumClientNames > 0)
		for (%i = 0; %i < $BudHud::NumClientNames; %i++)
			if (String::ICompare(%name, $BudHud::ClientName[%i]) == 0)
				return;

	$BudHud::ClientName[$BudHud::NumClientNames] = %name;

	// Automatically default sounds, must be changed later
	$BudHud::Sound[$BudHud::NumClientNames, pager] = $BudHud::DefaultPager;
	$BudHud::Sound[$BudHud::NumClientNames, hi] = $BudHud::DefaultHi;
	$BudHud::Sound[$BudHud::NumClientNames, bye] = $BudHud::DefaultBye;
	$BudHud::Sound[$BudHud::NumClientNames, change] = $BudHud::DefaultChangeTeam;
	
	// don't have to worry about repeated letters - it's handled by the buildmenu code
	// but still... well, try to keep the letters non-repeated.
	$BudHud::Letter[$BudHud::NumClientNames] = %letter;

	// Will use partnames only if false is matched, otherwise defaults to 
	// true.
	if (%partname == false)
		$BudHud::FilterType[$BudHud::NumClientNames] = false;
	else
		$BudHud::FilterType[$BudHud::NumClientNames] = true;
	
	debug("Added client to buddy list - " @ %name @ " | PartOfName - " @ $BudHud::FilterType[$BudHud::NumClientNames]);

	$BudHud::NumClientNames++;
	
}

// Changes buddy sounds, but MUST be called immediately after you
// define a buddy, otherwise it will set the wrong client's sound prefs
// (I did it this way so nobody had to re-enter a buddy's name, or know
//  their array index number)
function BudHud::SetSound(%pager, %hi, %bye, %change) {

	// Uhh, we have to have clients to set sounds for :)
	if (($BudHud::NumClientNames == "") || ($BudHud::NumClientNames < 1))
		return;

	debug("Initial sound settings sounds:");
	debug("P: "@%pager@" | H: "@%hi@" | B: "@%bye@" |C: "@%change);
	debug("Client Array Index = " @ $BudHud::NumClientNames-1 @ " | Client = " @ $BudHud::ClientName[$BudHud::NumClientNames-1]);

	// Pager blip sound for this client!
	if (%pager != "")
		$BudHud::Sound[$BudHud::NumClientNames-1, pager] = %pager;
	else
		$BudHud::Sound[$BudHud::NumClientNames-1, pager] = $BudHud::DefaultPager;

	// Join sound for this client!
	if (%hi != "")
		$BudHud::Sound[$BudHud::NumClientNames-1, hi] = %hi;
	else
		$BudHud::Sound[$BudHud::NumClientNames-1, hi] = $BudHud::DefaultHi;

	// Drop sound for this client!
	if (%bye != "")
		$BudHud::Sound[$BudHud::NumClientNames-1, bye] = %bye;
	else
		$BudHud::Sound[$BudHud::NumClientNames-1, bye] = $BudHud::DefaultBye;

	// ChangeTeam sound for this client!
	if (%change != "")
		$BudHud::Sound[$BudHud::NumClientNames-1, change] = %change;
	else
		$BudHud::Sound[$BudHud::NumClientNames-1, change] = $BudHud::DefaultChangeTeam;

	debug("-----------Sounds set to:");
	debug("P: "@$BudHud::Sound[$BudHud::NumClientNames-1, pager]@" | H: "@$BudHud::Sound[$BudHud::NumClientNames-1, hi]@" | B: "@$BudHud::Sound[$BudHud::NumClientNames-1, bye]@" |C: "@$BudHud::Sound[$BudHud::NumClientNames-1, change]);
}

// Adds a mute filter that makes certain messages NEVER appear on the pager
// (so far, only used for "Thanks, %1" and "%1 RMT Turret %2")
function BudHud::AddMuteFilter(%msg) {

	if (%msg == "")
		return;

	if ($BudHud::FilterCount == "")
		$BudHud::Filtercount = 0;

	// Check if filter exists already - We DON'T want multiple copies
	// of the same filter (string matching = cpu overhead)
	if ($BudHud::FilterCount > 0)
		for (%i = 0; %i < $BudHud::FilterCount; %i++)
			if ($BudHud::MuteFilter[%i] == %msg)
				return;

	debug("Adding mute filter: " @ %msg);	

	$BudHud::MuteFilter[$BudHud::FilterCount] = %msg;
	$BudHud::FilterCount++;
}

function BudHud::IgnoreMatch(%ignorestring) {
	$BudHud::HardCodeIgnore[ValidateName(%ignorestring)] = true;
}

// The Prefs file - can't include it until functions for prefs are defined, so it
// goes here --------------------------------------------------------------------
// (the dashes are so I can easily spot it - I do that a lot :)
include("VeKToR\\BudHudPrefs.cs");

// Display the next message in the queue (see below)
function BudHud::DisplayText(%hud) {

	debug("Updating BudHud!");

	if (String::ICompare($BudHud::CurrentGui, "playGui") != 0) {
		return 0.75;
	}

	if ($BudHud::Init != true)
		BudHud::Init();

	if ($BudHud::QueueNext != -1) {

		// 'cause %link is easier to type... duh!
		%link = $BudHud::QueueNext;

		debug("------------------------------------------------");
		debug($BudHud::MessageQueue-1, " messages left in queue");
		debug("Queue Message: " @ $BudHud::Queue[%link]);
		debug("Queuesound: "@$BudHud::QueueSound[%link]);
		debug("------------------------------------------------");

		// Green for friendly, Red for enemy, yello for observer!
		if ($BudHud::QueueTeam[%link] == -1)
			%teaminfo = "<B-1,2:CMD_DamageMed.bmp> ";
		else if ($BudHud::QueueTeam[%link] == Team::Friendly())
			%teaminfo = "<B-1,2:CMD_DamageLow.bmp> ";
		else 
			%teaminfo = "<B-1,2:CMD_DamageHigh.bmp> ";

		// independant FearGuiFormattedText boxes to get around the blasted bitmap
		// bug!
		control::SetValue(object::getname($BudHud::NamePlate), %teaminfo @ $BudHud::QueueName[%link] @ "   " @ $BudHud::QueueBitMap[%link]);
		control::SetValue(object::getname($BudHud::TextPlate), "<jc><f2>" @ $BudHud::Queue[%link]);

		control::SetVisible(Object::Getname($BudHud::NamePlate), true);
		control::SetVisible(Object::Getname($BudHud::TextPlate), true);

		if ($BudHud::SoundActive)
			localMessage($BudHud::QueueSound[%link]);

		$BudHud::QueueNext = $BudHud::QueueNext[%link];
		
		$BudHud::QueueUsed[%link] = false;
		$BudHud::Queue[%link] = "";
		$BudHud::QueuePriority[%link] = "";
		$BudHud::QueueSound[%link] = "";
		$BudHud::QueueName[%link] = "";
		$BudHud::QueueTeam[%link] = "";
		$BudHud::QueueBitMap[%link] = "";
		$BudHud::QueueNext[%link] = "";
		$BudHud::QueuePrev[%link] = "";

		return $BudHud::DisplayTime;
	}

	HUD::Display(%hud, false);

	return;
}

// Queue the messages so if a message gets triggered while a message
// is already being displayed, we wait until the previous message is done before
// triggering the new one. Can theoretically handle a LOT of messages at once.
function BudHud::AddTextQueue(%client, %text, %priority, %sound, %bitmap) {

	if (($BudHud::Mute[%client]) || (!$BudHud::PagerActive))
		return;

	if ($BudHud::QueueNext == "")
		$BudHud::QueueNext = -1;

	if (%priority == "")
		%priority = 10;

	// 'cause we can't actually use pointers in Tribes scripts, I assign an ID value to
	// the array index to keep each variable unique
	%id = 0;
	while($BudHud::QueueUsed[%id] == true) {
		%id++;
	}

	%link = $BudHud::QueueNext;	
	%linkto = -1;
	%linkfrom = -1;
	while(%link != -1) {
		%linkto = %link;
		%linkfrom = $BudHud::QueuePrev[%link];
		debug("Checking ID#" @ %link @ "... priority=" @ $BudHud::QueuePriority[%link] @ "  | Next Link is: " @ $BudHud::QueueNext[%link]);
		if ($BudHud::QueuePriority[%link] > %priority) {
			debug("Priority lower - insert crap here");
			break;
		} else {
			%linkto = -1;
			%linkfrom = %link;
		}

		%link = $BudHud::QueueNext[%link];
	}

	$BudHud::QueueUsed[%id] = true;
	$BudHud::Queue[%id] = %text;
	$BudHud::QueuePriority[%id] = %priority;
	$BudHud::QueueSound[%id] = %sound;
	$BudHud::QueueName[%id] = $BudHudData::ClientName[%client];
	$BudHud::QueueTeam[%id] = $BudHudData::ClientTeam[%client];
	$BudHud::QueueBitMap[%id] = "<B1,2:" @ %bitmap @ ".bmp>";
	$BudHud::QueueNext[%id] = %linkto;
	$BudHud::QueuePrev[%id] = %linkfrom;

	if (%linkto != -1)
		$BudHud::QueuePrev[%linkto] = %id;

	if (%linkfrom != -1)
		$BudHud::QueueNext[%linkfrom] = %id;

	if ($BudHud::QueueNext == -1) 
		$BudHud::QueueNext = %id;

	debug("Adding txt ID# " @ %id @ "  | Prev Obj: " @ %linkfrom @ "  | Next Obj: " @ %linkto);
	debug("Adding text to queue: " @ %text @ " | Sound: " @ %sound);

	// Store name and team in a var (in case client drops before message arrives
	// on top of the queue - team/name info will not be available or will be wrong)

	if (HUD::GetDisplayed(BudHud) == false) {
		// Updates itself when displayed.
		HUD::Display(BudHud);
	}
}

function BudHud::ClearQueue() {

	debug("Clearing Pager Queue");
	deletevariables("$BudHud::Queue*");

	HUD::Display(BudHud, false);
}

function BudHud::Init() {
	debug("Initializing BudHud");

	if ($BudHud::Init == true)
		return;

	$BudHud::Init = true;

	if (!HUD::Exists("BudHud")) {
		HUD::NewFrame(BudHud, BudHud::DisplayText, $BudHud::Position, "180 56");
		$BudHud::NamePlate = HUD::AddObject(BudHud, FearGuiFormattedText, 4, -1, HUD::Width(BudHud)-4, 16);
		$BudHud::TextPlate = HUD::AddObject(BudHud, FearGuiFormattedText, 4, -1, HUD::Width(BudHud)-4, HUD::Height(BudHud)-15);

		control::SetVisible(Object::Getname($BudHud::NamePlate), true);
		control::SetVisible(Object::Getname($BudHud::TextPlate), true);
	} else {
		HUD::Move(BudHud, $BudHud::Position, "180 56");

		control::SetVisible(Object::Getname($BudHud::NamePlate), true);
		control::SetVisible(Object::Getname($BudHud::TextPlate), true);
	}

	HUD::Display(BudHud, false);	

}

// Identify buddy function (by clientname) returns the array index number that the
// client data is located at, or -1 if buddy is not in list.
function BudHud::IDBuddy(%name) {
	debug("  Performing buddy namesearch");

	if (($BudHud::Ignore[%name] == true) || ($BudHud::HardCodeIgnore[%name] == true))
		return -1;

	// **** loop thru all the available filters!
	for (%i = 0; %i < $BudHud::NumClientNames; %i++) {
		if ((String::findSubStr(%name, $BudHud::ClientName[%i]) != -1) && ($BudHud::FilterType[%i])) {

			debug("Found PartName string match!");

			return %i;

		} else if (String::ICompare(%name, $BudHud::ClientName[%i]) == 0)
				return %i;
	}

	return -1;
}

function BudHud::AddtoDropList(%name) {
	for (%i = 0; %i < 15; %i++)
                if (%name == $BudHud::DropList[%i])
			return;

	// Shift em all down by one.
	for (%i = 14; %i >= 0; %i--) {
                $BudHud::DropList[%i+1] = $BudHud::DropList[%i];
	}

        $BudHud::Droplist[0] = %name; 
}

// Handles all out Join/Drop/ChangeTeam tracking, since they are all very
// similar, but with different text.
function BudHud::ClientUpdate(%client, %text, %sound)
{	
	if ((!$BudHud::Connected) || (%client == getmanagerid()))
		return false;

	if ($BudHud::Init != true)
		BudHud::Init();

	debug("Updating Client - using: " @ %sound @ " sound");

	// **** Make sure we have tribe/player names to check, and that we're not checking ourself
	// **** otherwise we're just wasting valuable CPU time
	if (($BudHud::NumClientNames == "") || ($BudHud::NumClientNames == 0) || (%client == getManagerID()))
		return false;

	// **** I just cram the client name into a local variable 'cause I'm lazy
	%name = $BudHudData::ClientName[%client];

	%i = -1;

	if ( (%i = BudHud::IDBuddy(%name)) != -1 ) {
		debug("Buddy located! index #" @ %i);
		BudHud::AddToMuteMenu(%client);
		BudHud::AddTextQueue(%client, "\n<jc><f2>" @ %text, 7, $BudHud::Sound[%i, %sound]);
		return true;
	}

	return false;
}

function BudHud::OnClientJoin(%client) {
	if ($BudHud::Init != true)
		BudHud::Init();

	$BudHudData::NeedUpdate = true;

	debug("-----------------");
	debug("Client Joined - " @ client::getname(client));

	if ((%client > $BudHud::HighestClient) || ($BudHud::HighestClient == ""))
		$BudHud::HighestClient = %client;

	$BudHudData::ClientName[%client] = client::getname(%client);
	$BudHudData::ClientTeam[%client] = client::getteam(%client);

	// Record that he just joined, so we don't display a changeteam msg on his
	// initial team assignment.
	$BudHud::LastJoined[%client] = true;

	if ($BudHud::Connected)
		BudHud::ClientUpdate(%client, "Connected.", "hi");

	// re-init changeteam data to guaranteed "safe values"
	for (%i = 0; %i < $BudHud::ChangeTeamFreq-1; %i++)
		$BudHud::CTData[%client, %i] = getsimtime() - $BudHud::ChangeTeamTime*60 - 1;

	$BudHud::Mute[%client] = false;

	debug("-----------------");
}

function BudHud::OnClientDrop(%client) {
	if ($BudHud::Init != true)
		BudHud::Init();

	$BudHudData::NeedUpdate = true;

	if (BudHud::ClientUpdate(%client, "Dropped.", "bye"))
		BudHud::AddtoDropList($BudHudData::ClientName[%client]);

	$BudHudData::ClientName[%client] = "";
	$BudHudData::ClientTeam[%client] = -1;

	debug("-----------------");
	debug("Client Dropping");

	// Assume they joined long enough ago so it won't trigger an
	// excessive changeteam msg.
	$BudHud::CTime[%client] = getsimtime() - ($BudHud::TeamTime * 60) - 1;

	$BudHud::Mute[%client] = false;
}

function BudHud::OnClientChangeTeam(%client, %team) {
	if ($BudHud::Init != true)
		BudHud::Init();

	$BudHudData::NeedUpdate = true;

	$BudHudData::ClientTeam[%client] = %team;

	debug("-------------------");
	debug("TeamChange!");

	%teamname = Team::GetName(%team);

	if (!$BudHud::LastJoined[%client]) {
		
		if ((%teamname == "") || (%team == -1)) {
			debug("Team Name unknown");
			if (%team == client::getteam(getmanagerid()) )
				%teamname = "Changed to your team";
			else if (%team != -1)
				%teamname = "Changed to the enemy team";
			else
				%teamname = "Became an observer";
		} else
			%teamname = "Changed to team " @ %teamname;

		if (($BudHud::ChangeTeamFreq > 0) && (%team != -1)) {

			for (%i = $BudHud::ChangeTeamFreq-1; %i > 0; %i--)
				$BudHud::CTData[%client, %i] = $BudHud::CTData[%client, %i-1];

			$BudHud::CTData[%client, 0] = getSimTime();

			if ((getsimtime() - $BudHud::CTData[%client, $BudHud::ChangeTeamFreq-1]) < $BudHud::ChangeTeamTime*60) {
				// long line!
				BudHud::AddTextQueue(%client, "\n<jc><f2>Has Changed Teams " @ $BudHud::ChangeTeamFreq @ "+ times in the last " @ floor((getsimtime() - $BudHud::CTData[%client, $BudHud::ChangeTeamFreq-1])/60)+1 @ " minutes!\n<B-1,2:skull_small.bmp><B-1,2:skull_small.bmp><B-1,2:skull_small.bmp>", 
	                                             8, $BudHud::DefaultChangeTeam);
	                        BudHud::AddToMuteMenu(%client);
			} else 
				BudHud::ClientUpdate(%client, %teamname, change);

		} else
				BudHud::ClientUpdate(%client, %teamname, change);


	} else {

		if (%teamname == "") {
			debug("Team Name unknown");
			if (%team == client::getteam(getmanagerid()) )
				%teamname = "your";
			else if (%team != -1)
				%teamname = "the enemy ";
		} else
			%teamname = "the " @ %teamname;

		BudHud::ClientUpdate(%client, "Joined " @ %teamname @ " team", change);
		$BudHud::LastJoined[%client] = false;
	}

	debug("-------------------");
}

function BudHud::OnMessage(%client, %msg)
{
	if ($BudHud::Init != true)
		BudHud::Init();

	// **** automatically reject server-based messages or messages from yourself!
	if ((%client == 0) || (%client == getManagerID()) || (NumNames == ""))
		return;

	debug("-------------------");
	debug("client message - not from yourself");

	%bud = BudHud::IDBuddy($BudHudData::clientname[%client]);

	if ($BudHud::FilterCount > 0)
		for (%i = 0; %i < $BudHud::FilterCount; %i++) 
			if (Match::ParamString(%msg, $BudHud::MuteFilter[%i])) {
				debug("never mind, it's muted: " @ %msg);
				debug("-------------------");
				return;
			}

	// I have two searches (global, bud-specific) to scan through, so I use this
	// do determine whether or not to post the pager msg rather than doing the 
	// same code twice to post.
	%postit = false;

	// bud-specific messages take precedance
	if (($BudHud::NumNames[%bud] > 0) && (%bud != -1))
		for (%i = 0; %i < $BudHud::NumNames[%bud]; %i++) {
			if (String::findsubstr(%msg, $BudHud::Name[%i, %bud]) != -1) {
				debug("found match - bud specific");
				%pagerbudnum = %bud;
				%postit = true;
				%matchnum = %i;
				break;
			}				
		}

	if ((!%postit) && ($BudHud::NumNames[-1] > 0))
		for (%i = 0; %i < $BudHud::NumNames[-1]; %i++) {
			if (String::findsubstr(%msg, $BudHud::Name[%i, -1]) != -1) {
				debug("found match - general masses");
				%postit = true;
				%pagerbudnum = -1;
				%matchnum = %i;
				break;
			}				
		}

	debug("Post the message? " @ %postit);
	debug("%matchnum = " @ %matchnum);

	if (%postit) {
		if (%bud != -1) {
			debug("He's a buddy, use his specific pager sound");
                        %sound = $BudHud::Sound[%bud, pager];
			%pri = 2;	// buds get a slightly higher priority...
		} else {
			debug("nope, not a buddy - use default pager sound");
                        %sound = $BudHud::DefaultPager;
			%pri = 3;	// ... than non-buds, who are still very important people :)
		}

                BudHud::AddToMuteMenu(%client);
                BudHud::AddTextQueue(%client, "\n<jc><f2>" @ %msg, %pri, %sound, $BudHud::NameBitMap[%matchnum, %pagerbudnum]);
	}

	debug("-------------------");
}


function BudHud::RememberGui(%gui) {
	// Keeps track of the current GUI so we can only display pager
	// messages if the player's in the PlayGui (so they don't miss
	// any messages!)
        $BudHud::CurrentGui = %gui;
}

// Used to add permanent Friends, now it adds both perm/temp buds
function BudHud::DynAddFriend(%name, %perm) {
        if ($BudHud::Permfriends[%perm] == "")
                $BudHud::PermFriends[%perm] = 0;

	// Check if client's already added to list.
        if (($BudHud::NumClientNames > 0) && ($BudHud::NumClientNames != ""))
                for (%i = 0; %i < $BudHud::NumClientNames; %i++)
                        if (String::ICompare(%name, $BudHud::ClientName[%i]) == 0)
				return -1;

        $BudHud::PermFriendString[%perm, $BudHud::PermFriends[%perm]] = %name;
        $BudHud::PermFriends[%perm]++;

        BudHud::AddFriend(%name, false);

	return $BudHud::PermFriends[%perm]-1;
}

function BudHud::RemoveBuddy(%index, %perm) {

        %name = $BudHud::PermFriendString[%perm, %index];
	
        for (%i = %index; %i < $BudHud::PermFriends[%perm]; %i++) 
                $BudHud::PermFriendString[%perm, %i] = $BudHud::PermFriendString[%perm, %i+1];

        $BudHud::PermFriends[%perm]--;
        deletevariables("$BudHud::PermFriendString[" @ %perm @ ", " @ $BudHud::PermFriends @ "]");

        if (($BudHud::NumClientNames > 0) && ($BudHud::NumClientNames != "")) {
                for (%i = 0; %i < $BudHud::NumClientNames; %i++)
                        if (String::ICompare(%name, $BudHud::ClientName[%i]) == 0)
				%index = %i;

                for (%i = %index; %i < $BudHud::NumClientNames; %i++) {
                        $BudHud::ClientName[%i] = $BudHud::ClientName[%i+1];
	
                        $BudHud::Sound[%i, pager] = $BudHud::Sound[%i+1, pager];
                        $BudHud::Sound[%i, hi] = $BudHud::Sound[%i+1, hi];
                        $BudHud::Sound[%i, bye] = $BudHud::Sound[%i+1, bye];
                        $BudHud::Sound[%i, change] = $BudHud::Sound[%i+1, change];

                        $BudHud::Letter[%i] = $BudHud::Letter[%i+1]; 

                        $BudHud::FilterType[%i] = $BudHud::FilterType[%i+1];
		}

                $BudHud::NumClientNames--;

                deletevariables("$BudHud::ClientName[" @ $BudHud::NumClientNames @ "]");

                deletevariables("$BudHud::Sound[" @ $BudHud::NumClientNames @ ", pager]");
                deletevariables("$BudHud::Sound[" @ $BudHud::NumClientNames @ ", hi]");
                deletevariables("$BudHud::Sound[" @ $BudHud::NumClientNames @ ", bye]");
                deletevariables("$BudHud::Sound[" @ $BudHud::NumClientNames @ ", change]");

                deletevariables("$BudHud::Letter[" @ $BudHud::NumClientNames @ "]");

                deletevariables("$BudHud::FilterType[" @ $BudHud::NumClientNames @ "]");

	}

}

function BudHud::ToggleList(%droplist) {
	if (Hud::GetDisplayed(BudHudList))
		Hud::Display(BudHudList, false);
	else if (%droplist)
		BudHud::ShowDropList();
	else
		BudHud::ShowExisting(false);
}

function BudHud::ShowDropList() {
	if ($BudHud::DropList[0] == "")
		return;

	if (!Hud::Exists(BudHudList)) {
		Hud::NewFrame(BudHudList, "", "50% 50%+64 90% 84");
		Hud::NewText(BudHudList, true);
	}

	for (%i = 0; %i < 15; %i++)
		if ($BudHud::DropList[%i] != "")
			%droplist = %droplist @ "<f2>" @ $BudHud::DropList[%i] @ "<f0> | ";

	HUD::Display(BudHudList);
	%objID = HUD::GetTextObject(BudHudList);
	Control::SetValue(Object::GetName(%objID), "<jc><f1>Last 15 Dropped Buds:\n\n<jc><f1>" @ %droplist);
}

function BudHud::ShowExisting(%sound) {
	debug("Execing ListExisting");

	%clientlist = "";

	%myteam = client::getteam(getmanagerID());

	for (%i = 2049; %i <= $BudHud::HighestClient; %i++)
		if ((BudHud::IDBuddy($BudHudData::ClientName[%i]) != -1) && (%i != getmanagerID()))
			if ($BudHudData::ClientTeam[%i] == %myteam)
				%clientlist = "<f2>" @ $BudHudData::ClientName[%i] @ "<f1> | " @ %clientlist;
			else
				%clientlist = %clientlist @ "<f0>" @ $BudHudData::ClientName[%i] @ "<f1> | ";

	debug("ClientList: " @ %clientlist);

	if (%clientlist == "")
		return;

	// handle text object myself -- make it easier to upgrade to a nice column format
	// later ;)
	if (!Hud::Exists(BudHudList)) {
		Hud::NewFrame(BudHudList, "", "50% 50%+64 90% 84");
		Hud::NewText(BudHudList, true);
	}

	if ((%sound) && ($BudHud::SoundActive))
		localmessage($BudHud::DefaultHi);

	echo(%clientlist);

//	remoteCP(2048, "\n<jc><f1>Buds Online:\n<jc><f1>" @ %clientlist, 10);
	HUD::Display(BudHudList);
	%objID = HUD::GetTextObject(BudHudList);
	Control::SetValue(Object::GetName(%objID), "<jc><f1>Buds Online:\n\n<jc><f1>" @ %clientlist);

	// only schedule if a sound is played - ie called internally (saves me an extra param)
	if (%sound)
		schedule("Hud::Display(BudHudList, false);", 5);
}

function BudHud::ListExisting() {
	debug(" ---------INIT---------- Waiting to Display ClientList");

	if (!$BudHudOpts::AutoDisplayBuds)
		return;

	// If we're in the play window, and we have a weapon mounted (ie we're definately in
	// the game by now!)
	if (($BudHud::CurrentGui == "playGui") && (getmounteditem(0) != -1)) {
		schedule("BudHud::ShowExisting(true);", 3);
	} else 
		schedule("BudHud::ListExisting();", 1);
}

function BudHud::SaveBuds() {

        if (($BudHud::PermFriends[true] <= 0) || ($BudHud::PermFriends[true] == "")) {
                $BudHud::PermFriends[true] = 0;
                export("$BudHud::PermFriends" @ "true", "config\\BudHudData.cs", false);
		return;
	}

        export("$BudHud::PermFriends" @ "true", "config\\BudHudData.cs", false);
        export("$BudHud::PermFriendString" @ "true*", "config\\BudHudData.cs", true);
}

function BudHud::ClearData() {
	debug("Clearing all unnecessary BudHud data");
	
	// Get rid of any left-over messages
	BudHud::ClearQueue();


	$BudHud::Connected = false;

	// get rid of temporary ignore settings
	deletevariables("$BudHud::Ignore*");

	// clean out client data
	deletevariables("$BudHudData*");
	deletevariables("$BudHud::HighestClient");
}

Event::Attach(eventClientMessage, BudHud::OnMessage);
Event::Attach(eventClientJoin, BudHud::OnClientJoin);
Event::Attach(eventClientDrop, BudHud::OnClientDrop);
Event::Attach(eventClientChangeTeam, BudHud::OnClientChangeTeam);
Event::Attach(eventConnected, "$BudHud::Alive = false; $BudHud::Connected = true; BudHud::Init(); BudHud::ListExisting();");
Event::Attach(eventGuiOpen, BudHud::RememberGui);

Event::Attach(eventConnectionAccepted, "BudHud::ClearData(); $BudHudData::NeedUpdate = true;");

// Clean up queue if disconnected, etc.
Event::Attach(eventExit, "BudHud::SaveBuds();");

// Clear message queues, hide pager window, clear connected status.
Event::Attach(eventConnectionLost, "BudHud::ClearData();");
Event::Attach(eventConnectionTimeout, "BudHud::ClearData();");

// ------------------------------------------------------
// PrestoPack banner
// ------------------------------------------------------

Presto::AddScriptBanner(BudHud, "\n" @
		"<jc><f0>BudHud - " @ $BudHud::Version @ "\n" @
		"<jc><f2>The Last word in <f1>Buddy-Tracking<f2> Software\n\n" @
		"\n<jc><f0>Concept by <f1>[QB]Vita\n" @
		"<jc><f0>Coding by <f1>VeKToR\n");

// ------------------------------------------------------
// NewOpts code
// ------------------------------------------------------

function BudHudOpts::OpenPrefs() {
	%dur = ($BudHud::DisplayTime - 2) / 13;
	Control::SetValue("BudHudOpts::Duration", %dur);

	// round it to the nearest decimal pt.
	Control::SetValue("BudHudOpts::DDisplay", floor($BudHud::DisplayTime) @ "sec");

	Control::SetValue("BudHudOpts::PagerSound", $BudHud::DefaultPager);
	Control::SetValue("BudHudOpts::JoinSound", $BudHud::DefaultHi);
	Control::SetValue("BudHudOpts::DropSound", $BudHud::DefaultBye);
	Control::SetValue("BudHudOpts::ChangeSound", $BudHud::DefaultChangeTeam);

	Control::SetValue("BudHudOpts::CTTime", $BudHud::ChangeTeamTime);
	Control::SetValue("BudHudOpts::CTFreq", $BudHud::ChangeTeamFreq);

}

function BudHud::SetDuration() {
	%slider = Control::GetValue("BudHudOpts::Duration");

	$BudHud::DisplayTime = (%slider * 13)+2;

	// round it to the nearest decimal pt.
	Control::SetValue("BudHudOpts::DDisplay", floor($BudHud::DisplayTime) @ "sec");
}

function BudHudOpts::ClosePrefs() {
	export("$BudHud::Default*", "config\\BudHudPrefs.cs", false);

	export("$BudHud::ChangeTeam*", "config\\BudHudPrefs.cs", true);
	export("$BudHud::DisplayTime", "config\\BudHudPrefs.cs", true);
	export("$BudHudOpts::AutoDisplayBuds", "config\\BudHudPrefs.cs", true);
}

// Key Bindings
NewOpts::register("BudHud Keys", "config\\VeKToR\\gui\\BudHudKeys.gui", "", "", TRUE);

// Options
NewOpts::register("BudHud Prefs", "config\\VeKToR\\gui\\BudHudPref.gui", "BudHudOpts::OpenPrefs();", "BudHudOpts::ClosePrefs();", TRUE);

include("VeKToR\\BudHudHelp.cs");
