// - - - - - - - - - - - - - - - - - - - - - - - - -
// ClearSight v0.94.5                     I/O deRost
// 09-19-2000
// http://www.tribalwar.com/derost
// derost@telusplanet.net
// - - - - - - - - - - - - - - - - - - - - - - - - -

// Add this line to the end of your autoexec.cs
// 		Include("deRost\\ClearSight.cs");

// This baby will give you translucent reticles. It took a bit of scripting, and a little chunk
// of gui editing, but it works, and it works pretty darned good. :)

// Anyways... there MAY be some bugs, SO BE WARNED! Let me know what you find, please. This script
// can only get better.

// Until I can figure out how to load the builtin HUD Menu from within a function, you must toggle
// the reticle off manually. Otherwise, you simply wont be able to click on the menu. :P Not a huge
// deal, I hope. Another note is that in order to see the braces when you zoom in and out, you also
// have to have the regular reticle turned on.

// If you want to use your own reticle, save it in the \config\deRost\reticles folder using any name
// you like. Make sure the .bmp is 256x256 though, otherwise it'll stretch and look bad. Then you
// just use the NewOpts interface to select which reticle you want. Unfortunately you need to restart
// Tribes for the change to take effect. Sorry about this, but it's a caveat of the method used. :-/
// Worth it, I think.
// Note: This baby works with mHUD and xHUD. They simply overlay. Looks awesome.

// Credits: Most of the code is my own, except for the screensize checking function by Presto. Those
// 		groovy ass reticles are thanks to {ASK}Scourge. Nice job.

// Changes in v0.94.5:
// - Added event to remove the reticle from the playGui on exit.
// - Added screensize info for higher resolutions (Thanks Radium)
// - Streamlined a little bit of code
 
// Changes in v0.94:
// - NewOpts support added
// - ability to change reticle brightness via NewOpts or in-game
// - can now select any reticle from within the game (unfortunately you need to restart Tribes)
// - added a bunch of custom reticles, thanks to {ASK}Scourge! W00t!
// - fixed a slight bug with window resizing (still isn't perfect, but as good as tribes scripting
//	will allow. :-/




// ============= DO NOT CROSS THIS LINE! =============
// (unless of course you want to fix some bugs? :)

$ClearSight::version = "0.94";

newObject( ClearSightGui, SimVolume, "deRost\\ClearSightGui.vol" );

include( "Presto\\event.cs" );

// Code from Presto
$screenSize["320x240(V)"] = "320 240";
$screenSize["400x300(V)"] = "400 300";
$screenSize["480x360(V)"] = "480 360";
$screenSize["512x384"] = "512 384";
$screenSize["640x400"] = "640 400";
$screenSize["640x480"] = "640 480";
$screenSize["800x600"] = "800 600";
$screenSize["1024x768"] = "1024 768";
$screenSize["1280x1024"] = "1280 1024";
$screenSize["1600x1200"] = "1600 1200";

function getScreenSize()
{
	%res = $pref::videoFullScreenRes;
	if ($pref::VideoFullScreen) {
		%res = $screenSize[%res];
		if (%res != "")
			return %res;
		}
	return $screenSize["640x480"];

	//return %res; // The above check only works if you use the options page to change between windowed,
			// and full screen, and not when you alt+enter. So just default to fullscreen.
			// transparency doesn't work in software mode anyways, and you can still turn the
			// reticle off with the keybind.
}
// end Presto code

function RostRet::getPosition()
{
	%res = getScreenSize();
	%x = floor((( getWord( %res, 0 ) - 256 ) / 100 ) * 50 );
	%y = floor((( getWord( %res, 1 ) - 256 ) / 100 ) * 50 );
	%w = 256;
	%h = 256;
	return sprintf( "%1 %2 %3 %4", %x + 1, %y + 1, %w, %h );
}

function RostRet::ToggleMenu()
{
	if( $ClearSightPrefs::showRet == true )
	{
		$ClearSightPrefs::showRet = false;
		
	}
	else
	{
		$ClearSightPrefs::showRet = true;
	}
	postAction( 2048, IDACTION_MENU_PAGE, 2.000000 );
	RostRet::initHUD();
	//Control::setVisible( RRHUD, $ClearSightPrefs::showRet );
}

function RostRet::Toggle()
{
	if( $ClearSightPrefs::showRet == true )
	{
		$ClearSightPrefs::showRet = false;
		RostRet::remove();
	}
	else
	{
		$ClearSightPrefs::showRet = true;
		RostRet::initHUD();
	}
	//RostRet::initHUD();
	Control::setVisible( RRHUD, $ClearSightPrefs::showRet );
}

function RostRet::Brightness()
{
	%lo = 0;
	%hi = 6;
	%b = $ClearSightPrefs::brightness;
	if( %b == %hi ) %b = %lo;
	else %b++;
	$ClearSightPrefs::brightness = %b;
	RostRet::initHUD();
	Control::setVisible( RRHUD, $ClearSightPrefs::showRet );
}

function RostRet::remove()
{
	//deleteObject( "playGui\\RRHUD\\RostRet" );
	deleteObject( "playGui\\RRHUD" );
	//echo( "Removed ClearSight junk." );
}

function RostRet::Init()
{
	%b = $ClearSightPrefs::brightness;
	//deleteObject( "playGui\\RRHUD\\RostRet" ); // Just in case it's already there.
	//loadObject( RostRet, "config\\deRost\\ClearSightRet.gui" );
	loadObject( RostRet, "ClearSightRet.gui" );
	addToSet( "playGui\\RRHUD", "RostRet\\RostRet" @ %b );
	Control::setVisible( RRHUD, $ClearSightPrefs::showRet );
	//echo( "$ClearSightPrefs::showRet = " @ $ClearSightPrefs::showRet );
}

Event::Attach ( eventExit,	RostRet::remove	);
Event::Attach ( eventExit,	RostRetOpts::onClose );
Event::Attach ( eventGuiOpen,	RostRet::onGuiOpen );
Event::Attach ( eventGuiOpen,	RostRet::initHUD );

function RostRet::onGuiOpen( %gui )
{
	$RostRet::currentGui = %gui;
}

function RostRet::initHUD()
{
	//echo( "$RostRet::currentGui = " @ $RostRet::currentGui );
	if( $RostRet::currentGui != playGui )
		return;		
	
	%pos = RostRet::getPosition();
	%posX = getWord( %pos, 0 ) + 1;
	%posY = getWord( %pos, 1 ) + 1;
	%sizeX = getWord( %pos, 2 );
	%sizeY = getWord( %pos, 3 );
	
	if( nameToId( playGui ) != -1 )
	{
		RostRet::remove();
		%hud = newObject( RRHUD, SimGui::Control, %posX, %posY, %sizeX, %sizeY );
		addToSet( playGui, %hud );
		RostRet::Init();
		echo( "Reticle Loaded." );
	}
	else
	{
		schedule( "RostRet::initHUD();", 2 ); // Try again in 2 seconds.
		echo( "Waiting 2 seconds..." );
	}
}

function RostRet::setDefaults()
{
}
	
if( isFile( "config\\ClearSightPrefs.cs" ) )
{
	Include( "ClearSightPrefs.cs" );
}
else
{
	RostRet::setDefaults();
}

// NewOpts
function RostRetOpts::checkToggle()
{
	Control::setActive( ClearSight::Reticle, $ClearSightPrefs::showRet );
	Control::setActive( ClearSight::brightness, $ClearSightPrefs::showRet );
	Control::setVisible( ClearSight::brightValue, $ClearSightPrefs::showRet );
	Control::setVisible( RRHUD, $ClearSightPrefs::showRet );
}

function RostRet::SelectReticle()
{
	%ret = FGCombo::getSelected( ClearSight::Reticle );
	$ClearSightPrefs::Reticle = $ClearSight::reticleArray1[ %ret ];
	$ClearSight::reticleChanged = true;
	Control::setValue( ClearSight::reticleNote, "<jl><f2>Note: You must restart Tribes in order\n for this change to take effect." );
	Control::setVisible( ClearSight::reticleNote, $ClearSight::reticleChanged );
}

function RostRetOpts::SetBrightness()
{
	%brightness = Control::getValue( ClearSight::brightness );
	%percent = floor( ( ( %brightness / 8 ) * 100 ) + 12.5 );
	$ClearSightPrefs::brightness = %brightness;
	Control::setValue( ClearSight::brightValue, "<jl><f0>Brightness: " @ %percent @ "%" );
	RostRet::initHUD();
	//echo( "RostRetOpts::SetBrightness();" );
}

function RostRetOpts::OnOpen()
{
	Control::setValue( ClearSight::version, "<jl><f1>v" @ $ClearSight::version );
	Control::setValue( ClearSight::TitleL, "<B0,0:ClearSight_bgL.bmp>" );
	Control::setValue( ClearSight::TitleR, "<B0,0:ClearSight_bgR.bmp>" );

	FGCombo::clear( ClearSight::Reticle );
	
	%reticleCount = 0;
	%reticleFile = File::findFirst("deRost\\reticles\\*.bmp");
	while ( %reticleFile != "" )
	{
		%reticleFile = String::getSubStr(  %reticleFile, 16, 32 );
		$ClearSight::reticleArray1[ %reticleCount ] = %reticleFile;
		$ClearSight::reticleArray2[ %reticleFile ] = %reticleCount;
		FGCombo::addEntry( ClearSight::reticle, %reticleFile, %reticleCount );
		%reticleCount = %reticleCount + 1;
		%reticleFile = File::findNext( "deRost\\reticles\\*.bmp" );
	}
	
	%ret = $ClearSightPrefs::Reticle;
	FGCombo::setSelected( ClearSight::reticle, $ClearSight::reticleArray2[ %ret ] );
	
	Control::setValue( ClearSight::toggleRet, $ClearSightPrefs::showRet );
	Control::setValue( ClearSight::brightness, $ClearSightPrefs::brightness );
	
	Control::setVisible( ClearSight::reticleNote, $ClearSight::reticleChanged );
	Control::setVisible( deRostScriptsURL, true );
	
	Control::setVisible( ClearSight::toggleDefault, false ); // disabled until next version
	Control::setVisible( ClearSight::text01, false ); // disabled until next version
	
	RostRetOpts::SetBrightness();
	RostRetOpts::checkToggle();
}

function RostRetOpts::OnClose()
{
	export( "$ClearSightPrefs::*", "config\\ClearSightPrefs.cs", false );
	echo( "ClearSights Prefs file saved." );
}

Presto::AddScriptBanner( ClearSight, "<B3,4:ClearSight_Presto.bmp>" );
NewOpts::register( "ClearSight", "ClearSightOpts.gui", "RostRetOpts::OnOpen();", "RostRetOpts::OnClose();", true );
NewOpts::registerHelp( "ClearSight", "General", "ClearSight is a fairly simple script that allows you to use translucent reticles in your Tribes game." );
NewOpts::registerHelp( "ClearSight", "Custom Reticles", "You can use your own custom reticles with ClearSight by simply putting a 256x256 reticle bmp in the config\\deRost\\reticles folder. You can then select the reticle via the dropdown menu. Please note however that you must restart Tribes in order for the changes to take effect. A bit of a pain, but better than having to manually rename your reticle files. :)" );
NewOpts::registerHelp( "ClearSight", "Adjusting Brightness", "To adjust the brightness of the reticle, simply use the slider in the options page, or in-game by using the keybind. There are 7 levels of brightness. 12%, 25%, 37%, 50%, 67%, 75%, and 87%." );
NewOpts::registerHelp( "ClearSight", "Tips and Tricks", "- leave the default Tribes reticle turned on to see the zoom braces and IFF; you can use a blank h_reticle.bmp in your \\base folder if you dont want to see the default - you can use Cowboy's mHUD, and Writer's xHUD with this script. They will make some interesting over-lays. - if you go into the Tribes HUD menu 'k', you must toggle the ClearSight reticle off temporarily. Otherwise, you will not be able to click on anything." );
NewOpts::registerHelp( "ClearSight", "Author", "Written and performed by I/O deRost... that Shaun guy. He's pretty cool. Yes, uh huh. He's Canadian. He lives in an igloo, and sleeps with a moose. Eh." );
NewOpts::registerHelp( "ClearSight", "Credits", "Packaged reticles are custom made and supplied by {ASK}Scourge. One code snippet was taken from Presto's script pack, used for checking screen dimensions." );

RostRet::initHUD();

function deRostScriptsURL()
{
	HTMLOpen( "http://www.tribalwar.com/derost/" );
}

IDBMP_ROST_RETICLE = 00160533, "deRost\\reticles\\" @ $ClearSightPrefs::Reticle;
//echo( "IDBMP_ROST_RETICLE = 00160533, \"deRost\\reticles\\" @ $ClearSightPrefs::Reticle @ "\";");
echo( "====== ClearSight v" @ $ClearSight::version @ " loaded ======" );
