// ==========================================================================
// File:      DeathHud.cs
// Author:    Bryan "daerid" Ross
// Date:      3/7/2001
// Notes:     Basically a SplitMsg style hud, but all text based.
// 
// Version:   S1.0  (S is for Stripped)
// 
// ==========================================================================

// ==========================================================================
// User Config Section
// ============================================================================
$DH::Top = "0";
$DH::Left = "688";

// How to display HUD
$DHPref::Transparent = "TRUE";

// How many lines is the hud
$DHPref::Lines = "5";

// Menu Key
$DHPref::MenuKey = "alt d";
// ==========================================================================


// ==========================================================================
// Scripting Section
// ==========================================================================

Event::Attach(EventPlayGuiCreated,DH::Create);
Event::Attach(EventExit,DH::OnExit);

Event::Attach(EventKillTrak,DH::OnKillTrak);

if (IsFile("Config\\DeathHudPrefs.cs"))
  exec("DeathHudPrefs.cs");
  
if ($DHPref::Width == "")
  $DHPref::Width = 300;
  
if ($DHPref::Height == "")
  $DHPref::Height = 72;

function DH::Create()
{
  $DH::Cont = newObject(DeathHud,SimGui::Control,$DH::Left,$DH::Top,$DHPref::Width,$DHPref::Height);
  $DH::BG = newObject(DeathHud_BG,FearGui::FearGuiMenu,0,0,$DHPref::Width,$DHPref::Height);
  $DH::Text = newObject(DeathHud_Text, FearGuiFormattedText, 5, -1, 1000, 1000);

  if(!$DHPref::Transparent)
    addToSet($DH::Cont,$DH::BG);
  addToSet($DH::Cont,$DH::Text);
  addToSet(PlayGui,$DH::Cont);
}

// Track kills
function DH::OnKillTrak(%killer,%victim,%weapon)
{
  for (%i=1;%i<$DHPref::Lines;%i++)
  {
    $DH::Row[%i] = $DH::Row[%i+1];
  }
  %kname = DH::Replace(Client::GetName(%killer),"<","<<");
  %vname = DH::Replace(Client::GetName(%victim),"<","<<");
  if (Client::GetTeam(%killer)==$MyTeam)
    %kname = "<F1>"@%kname;
  else
    %kname = "<F0>"@%kname;
  if (Client::GetTeam(%victim)==$MyTeam)
    %vname = "<F1>"@%vname;
  else
    %vname = "<F0>"@%vname;
  $DH::Row[$DHPref::Lines] = %kname@"<F2> --> "@%vname@" <F2>: "@%weapon;
  DH::Update();
  return "FALSE";
}

// Improved String Replace function
function DH::replace(%string, %search, %replace)    
{
  while ((%idx=String::FindSubStr(%string,%search))!=-1)
  {
    %left = %left @ String::GetSubStr(%string,0,%idx) @ %replace;
    %string = String::GetSubStr(%string,%idx+String::Len(%search),String::Len(%string));
  }
  %left = %left @ %string;
  return %left;
}


function DH::Update()
{
  for (%i=1;%i<=$DHPref::Lines;%i++)
    %display = %display @ escapestring($DH::Row[%i]) @ "\n";
  Control::SetValue(DeathHud_Text, %display);
}


function DH::OnExit()
{
  removeFromSet(PlayGui,$DH::Cont);
  deleteObject($DH::Cont);
  export("DHPref::*","config\\DeathHudPrefs.cs");
}

// ============================================================================
// Administrative Section - For in game configurations
// ============================================================================

keybind($DHPref::MenuKey,"MS::Display(\"Death Hud Menu\");","","",DeathHudMenu);

MS::NewMenu("Death Hud Menu");
MS::AddChoice("Death Hud Menu","s","Toggle Death Hud Display","Control::SetVisible(DeathHud,!Control::GetVisible(DeathHud));");
MS::AddChoice("Death Hud Menu","h","Set Height (lines) of Death Hud.","DH::GetLines();");
MS::AddChoice("Death Hud Menu","w","Set Width of Death Hud.","DH::GetWidth();");

function DH::GetLines()
{
  TI::Init("<JC>Please specify how high (in lines) you would like Death Hud to be (max of 10).",DH::SetLines);
}

function DH::SetLines(%text)
{
  if (!IsNum(%text) || %text > 10)
  {
    remoteCP(2048,"Incorrect value for height.",3);
    Schedule("DH::GetLines();",3.1);
    return;
  }
  $DHPref::Lines = %text;
  $DHPref::Height = ($DHPref::Lines * 14);
  Control::SetExtent(DeathHud,getWord(Control::GetExtent(DeathHud),0),$DHPref::Height);
  Control::SetExtent(DeathHud_BG,getWord(Control::GetExtent(DeathHud),0),$DHPref::Height);
}

function DH::GetWidth()
{
  if (!$DH::WidthActionMap)
  {
    //keybind(%keybind, %onPress, %onRelease, %actionMap, %device, %handle);
    newActionMap("DHWidthActionMap.sae");
    keybind("left","DH::AddWidth(-1);","","DHWidthActionMap.sae");
    keybind("right","DH::AddWidth(1);","","DHWidthActionMap.sae");

    keybind("shift left","DH::AddWidth(-10);","","DHWidthActionMap.sae");
    keybind("shift right","DH::AddWidth(10);","","DHWidthActionMap.sae");

    keybind("control left","DH::AddWidth(-25);","","DHWidthActionMap.sae");
    keybind("control right","DH::AddWidth(25);","","DHWidthActionMap.sae");

    keybind("enter","DH::WidthDone();","","DHWidthActionMap.sae");
    keybind("numpadenter","DH::WidthDone();","","DHWidthActionMap.sae");

    keybind("escape","DH::WidthCancel();","","DHWidthActionMap.sae");
    $DH::WidthActionMap = "TRUE";
  }
  $DH::PrevWidth = getWord(Control::GetExtent(DeathHud),0);
  pushActionMap("DHWidthActionMap.sae");
  $DH::WidthCheck="TRUE";
  DH::WidthCheck();
}

function DH::WidthCheck()
{
  if ($DH::WidthCheck=="TRUE")
  {
    remoteBP(2048,"Press the left or right arrow key to resize the hud.\nPress <F2>enter<F0> when done,\nor <F2>escape <F0>to cancel.");
    Schedule("DH::WidthCheck();",1);
  }
}

function DH::AddWidth(%amt)
{
  %cur = Control::GetExtent(DeathHud);
  %curW = getWord(%cur,0);
  %curH = getWord(%cur,1);
  Control::SetExtent(DeathHud,%curW+%amt,%curH);
  Control::SetExtent(DeathHud_BG,%curW+%amt,%curH);
  $DHPref::Width = %curW+%amt;
}

function DH::WidthDone()
{
  $DH::PrevWidth = "";
  $DH::WidthCheck="FALSE";
  popActionMap("DHWidthActionMap.sae");
  remoteBP(2048,"");
}

function DH::WidthCancel()
{
  %currentH = getWord(Control::GetExtent(DeathHud),1);
  Control::SetExtent(DeathHud,$DH::PrevWidth,%currentH);
  DH::WidthDone();
}