// ============================================================================
// Created as a Drop in replacement for KillTrak.cs
// I basically took all the functions from KillTrak.cs, and replaced the code inside 'em :)
// ============================================================================// 
function KillTrak::Reset() 
{
  deleteVariables("KillTrak::*");
}

function KillTrak::DeathMessage(%msg, %weapon, %mod) 
{
  // Strip out the %1,%2 so we have a base message to compare to, and store a weapon for that message
  $KillTrak::Weapon[sprintf(%msg,"","","his","his")] = %weapon;
  $KillTrak::Weapon[sprintf(%msg,"","","her","her")] = %weapon;
  $KillTrak::Weapon[sprintf(%msg,"","","his","her")] = %weapon;
  $KillTrak::Weapon[sprintf(%msg,"","","her","his")] = %weapon;

  // Check to see the format for this msg
  %pos["%1"] = String::FindSubStr(%msg,"%1");
  %pos["%2"] = String::FindSubStr(%msg,"%2");
  
  %kfirst = (%pos["%1"] < %pos["%2"]);

  $KillTrak::KillerFirst[sprintf(%msg,"","","his","his")] = 
  $KillTrak::KillerFirst[sprintf(%msg,"","","her","her")] = 
  $KillTrak::KillerFirst[sprintf(%msg,"","","his","her")] = 
  $KillTrak::KillerFirst[sprintf(%msg,"","","her","his")] = %kfirst;
  
  %single = (%pos["%1"] == -1);

  $KillTrak::Single[sprintf(%msg,"","","his","his")] = 
  $KillTrak::Single[sprintf(%msg,"","","her","her")] = 
  $KillTrak::Single[sprintf(%msg,"","","his","her")] = 
  $KillTrak::Single[sprintf(%msg,"","","her","his")] = %single;
// echo("Added Kill Message: "@%msg@", Weapon: "@$KillTrak::Weapon[%base]@", Killer First: "@$KillTrak::KillerFirst[%base]@", BASE MSG: "@%base);

}

function KillTrak::GetKiller() {
	return $KillTrak::killer;
	}
function KillTrak::GetVictim() {
	return $KillTrak::victim;
	}
function KillTrak::GetWeapon() {
  return $KillTrak::weapon;
	}

function KillTrak::Parse(%cl,%msg) {
  %names = 0;
  for (%i=1;%i<=$KillTrak::NumClients;%i++)
  {
    %name = Client::GetName($KillTrak::ClientList[%i]);
    if ((%pos = String::FindSubStr(%msg,%name))!=-1)
    {
      %names++;
      %name[%names] = %name;
      %pos[%names] = %pos;
    }
  }
  if (%names==0) { return; } // No names were found in this message
  %base = String::Slice(%msg,%name1);
  %base = String::Slice(%base,%name2);
  if ((%wpn=$KillTrak::Weapon[%base])=="") { return; }  // This is not a kill message
  else
  {
    if ($KillTrak::KillerFirst[%base] == (%pos1 < %pos2))
    {
      $KillTrak::Killer = getClientByName(%name1);
      $KillTrak::Victim = getClientByName(%name2);
    }
    else
    {
      $KillTrak::Killer = getClientByName(%name2);
      $KillTrak::Victim = getClientByName(%name1);
    }
    $KillTrak::Weapon = %wpn;
    if ($KillTrak::Single[%base]) { $KillTrak::Killer = $KillTrak::Victim; }
    return Event::Trigger(EventKillTrak,$KillTrak::Killer,$KillTrak::Victim,$KillTrak::Weapon);
  }
}

// ============================================================================
// Support for Stripped
function KillTrak::Stripped(%killer,%victim,%weapon)
{
  if ((%killer != getManagerID()) && (%victim != getManagerID()))
    return;
  else if (%killer==getManagerID() && %victim != getManagerID())
    return Event::Trigger(EventYouKilled,%weapon);
  else if (%victim == getManagerID())
    return Event::Trigger(EventYouDied,%weapon);
}
Event::Attach(EventKillTrak,KillTrak::Stripped);
// ============================================================================

Event::Attach(EventServerMessage, KillTrak::Parse);
Event::Attach(EventClientJoin,KillTrak::ClientJoin);
Event::Attach(EventClientDrop,KillTrak::ClientDrop);
Event::Attach(EventChangeMission,KillTrak::ResetClients);
Event::Attach(EventConnected,KillTrak::ResetClients);

// ============================================================================
// Functions that I added.

function KillTrak::ClientJoin(%client)
{
  $KillTrak::NumClients++;
  $KillTrak::ClientList[$KillTrak::NumClients] = %client;
  $KillTrak::ClientIdx[%client] = $KillTrak::NumClients;
  // echo("Added Client "@%client@" to KillTrak.");
}

function KillTrak::ClientDrop(%client)
{
  %lastClient = $KillTrak::ClientList[$KillTrak::NumClients];
  %thisIDX = $KillTrak::ClientIdx[%client];
  $KillTrak::ClientList[%thisIdx] = %lastClient;
  $KillTrak::ClientIdx[%lastClient] = %thisIdx;
  $KillTrak::ClientIdx[%client] = "";
  $KillTrak::ClientList[$KillTrak::NumClients] = "";
  $KillTrak::NumClients--;
  // echo("Removed Client "@%client@" from KillTrak.");
}

function KillTrak::ResetClients()
{
   deleteVariables("KillTrak::Client*");
   $KillTrak::NumClients = 0;
   for (%cl=2100;%cl>2048;%cl--)
  {
    if (Client::GetName(%cl)!="")
      KillTrak::ClientJoin(%cl);
  }
}

// ============================================================================

// ============================================================================
// For purely testing purposes
// 
// Event::Attach(EventKillTrak,Kill::Test);

function Kill::Test(%killer,%victim,%weapon)
{
  %kname = Client::GetName(%killer);
  %vname = Client::GetName(%victim);

  echo();
  echo(""@%kname@" killed "@%vname@" with a "@%weapon);
  echo();
//   remoteBP(2048,"<jc><F2>"@%kname@" <F0>killed <F2>"@%vname@" <F0>with a <F2>"@%weapon,3);
}
// 
// ============================================================================


// ============================================================================
// These functions taken out of Stripped's KillTracking.cs, so as to maintain compatibility.

//Event for when you die.  This is a crazy way to do it, but it seems pretty stable
Event::Attach(EventYouDied, Death::Check);
function Death::Check() {
	$Player::Dead = "True";
	$Player::DeathTimeout = "True";
	//check to see if we were firing a weapon while dying
	if($AF::Firing != "TRUE") { 
		$Player::DiedFiring = "";
		schedule("Life::Check();", 2);
	}
	else { $Player::DiedFiring = "True"; }
	schedule("$Player::DeathTimeout = \"\";", 2);
}

//Event For when you spawn.  This works.. most of the time.
Event::Attach(eventYouFired, Life::Check);
function Life::Check() {
	if($Player::Dead == "TRUE") {
		//run through this routine if we died while firing
		if($Player::DeathTimeout == "" && $Player::DiedFiring == "True") {
			$Player::Dead = "";
			$Player::DiedFiring = "";
			schedule("Event::Trigger(EventYouSpawned);", 1);
		}
		//run through this one if we did not, and loop back to it every second
		else {
			if(GetMountedItem(0) != -1) {
				$Player::Dead = "";
				Event::Trigger(EventYouSpawned);
			}
			schedule("Life::Check();", 1);
		}
	}
}
// ============================================================================


// ============================================================================
// Support functions
function String::Slice(%string,%substr)
{
	if ((%idx = String::FindSubStr(%string,%substr)) == -1)
		return %string;
	else
	{
		%left = String::GetSubStr(%string,0,%idx);
		%lensub = String::Len(%substr);
		%idxstart = %idx+%lensub;
		%right = String::GetSubStr(%string,%idxstart,1024);
		return %left @ %right;
	}
}
// ============================================================================


// ============================================================================
// THE KILL MESSAGES!!!! The beauty of this system is that we don't need to separate these killmessages by mod!!!

// ============================================================================
// Base Kill Messages
KillTrak::DeathMessage("%2 falls to %3 death.", "Falling");
KillTrak::DeathMessage("%2 forgot to tie %3 bungie cord.", "Falling");
KillTrak::DeathMessage("%2 bites the dust in a forceful manner.", "Falling");
KillTrak::DeathMessage("%2 fall down go boom.", "Falling");

KillTrak::DeathMessage("%1 makes quite an impact on %2.", "Vehicle");
KillTrak::DeathMessage("%2 becomes the victim of a fly-by from %1.", "Vehicle");
KillTrak::DeathMessage("%2 leaves a nasty dent in %1's fender.", "Vehicle");
KillTrak::DeathMessage("%1 says, 'Hey %2, you scratched my paint job!'", "Vehicle");

KillTrak::DeathMessage("%1 ventilates %2 with %3 chaingun.", "Chaingun");
KillTrak::DeathMessage("%1 gives %2 an overdose of lead.", "Chaingun");
KillTrak::DeathMessage("%1 fills %2 full of holes.", "Chaingun");
KillTrak::DeathMessage("%1 guns down %2.", "Chaingun");

KillTrak::DeathMessage("%2 dies of turret trauma.", "Turret");
KillTrak::DeathMessage("%2 is chewed to pieces by a turret.", "Turret");
KillTrak::DeathMessage("%2 walks into a stream of turret fire.", "Turret");
KillTrak::DeathMessage("%2 ends up on the wrong side of a turret.", "Turret");
KillTrak::DeathMessage("%2 dies.", "Turret");


KillTrak::DeathMessage("%2 feels the warm glow of %1's plasma.", "Plasma");
KillTrak::DeathMessage("%1 gives %2 a white-hot plasma injection.", "Plasma");
KillTrak::DeathMessage("%1 asks %2, 'Got plasma?'", "Plasma");
KillTrak::DeathMessage("%1 gives %2 a plasma transfusion.", "Plasma");

KillTrak::DeathMessage("%2 catches a Frisbee of Death thrown by %1.", "Disc Launcher");
KillTrak::DeathMessage("%1 blasts %2 with a well-placed disc.", "Disc Launcher");
KillTrak::DeathMessage("%1's spinfusor caught %2 by surprise.", "Disc Launcher");
KillTrak::DeathMessage("%2 falls victim to %1's Stormhammer.", "Disc Launcher");

KillTrak::DeathMessage("%1 blows %2 up real good.", "Explosives");
KillTrak::DeathMessage("%2 gets a taste of %1's explosive temper.", "Explosives");
KillTrak::DeathMessage("%1 gives %2 a fatal concussion.", "Explosives");
KillTrak::DeathMessage("%2 never saw it coming from %1.", "Explosives");

KillTrak::DeathMessage("%1 adds %2 to %3 list of sniper victims.", "Laser Rifle");
KillTrak::DeathMessage("%1 fells %2 with a sniper shot.", "Laser Rifle");
KillTrak::DeathMessage("%2 becomes a victim of %1's laser rifle.", "Laser Rifle");
KillTrak::DeathMessage("%2 stayed in %1's crosshairs for too long.", "Laser Rifle");

KillTrak::DeathMessage("%1 mortars %2 into oblivion.", "Mortar");
KillTrak::DeathMessage("%2 didn't see that last mortar from %1.", "Mortar");
KillTrak::DeathMessage("%1 inflicts a mortal mortar wound on %2.", "Mortar");
KillTrak::DeathMessage("%1's mortar takes out %2.", "Mortar");

KillTrak::DeathMessage("%2 gets a blast out of %1.", "Blaster");
KillTrak::DeathMessage("%2 succumbs to %1's rain of blaster fire.", "Blaster");
KillTrak::DeathMessage("%1's puny blaster shows %2 a new world of pain.", "Blaster");
KillTrak::DeathMessage("%2 meets %1's master blaster.", "Blaster");

KillTrak::DeathMessage("%2 gets zapped with %1's ELF gun.", "ELF Gun");
KillTrak::DeathMessage("%1 gives %2 a nasty jolt.", "ELF Gun");
KillTrak::DeathMessage("%2 gets a real shock out of meeting %1.", "ELF Gun");
KillTrak::DeathMessage("%1 short-circuits %2's systems.", "ELF Gun");

KillTrak::DeathMessage("%2 didn't stay away from the moving parts.", "Crushed");
KillTrak::DeathMessage("%2 is crushed.", "Crushed");
KillTrak::DeathMessage("%2 gets smushed flat.", "Crushed");
KillTrak::DeathMessage("%2 gets caught in the machinery.", "Crushed");

KillTrak::DeathMessage("%2 is a victim among the wreckage.", "Debris");
KillTrak::DeathMessage("%2 is killed by debris.", "Debris");
KillTrak::DeathMessage("%2 becomes a victim of collateral damage.", "Debris");
KillTrak::DeathMessage("%2 got too close to the exploding stuff.", "Debris");

KillTrak::DeathMessage("%2 takes a missile up the keister.", "Missile");
KillTrak::DeathMessage("%2 gets shot down.", "Missile");
KillTrak::DeathMessage("%2 gets real friendly with a rocket.", "Missile");
KillTrak::DeathMessage("%2 feels the burn from a warhead.", "Missile");

KillTrak::DeathMessage("%2 ends it all.", "Suicide");
KillTrak::DeathMessage("%2 takes %3 own life.", "Suicide");
KillTrak::DeathMessage("%2 kills %3 own dumb self.", "Suicide");
KillTrak::DeathMessage("%2 decides to see what the afterlife is like.", "Suicide");
// ============================================================================

// ============================================================================
// Insomniax Kill Messages
KillTrak::DeathMessage("%1 ripps %2 apart.", "MAG Gun");
KillTrak::DeathMessage("%2 Felt %1's magnetic Personality.", "MAG Gun");
KillTrak::DeathMessage("%1 Zapped %2 into Oblivion.", "MAG Gun");
KillTrak::DeathMessage("%2 was torn apart by %1's MAG Gun", "MAG Gun");

KillTrak::DeathMessage("%2 caught a chest full of %1's shotgun blast.", "Shotgun");
KillTrak::DeathMessage("%2 went down after %1's viscious shotgun assault.", "Shotgun");
KillTrak::DeathMessage("%1 filled %2 full of shotgun pellets.", "Shotgun");

KillTrak::DeathMessage("%2 was seriously torn up by %1's Phalanxx Cannon.", "Phalanxx Cannon");
KillTrak::DeathMessage("%1 unleashed his Phalanxx on %2.", "Phalanxx Cannon");
KillTrak::DeathMessage("%1 force fed %2 and extra helping of lead.", "Phalanxx Cannon");
KillTrak::DeathMessage("%1 leaned into %2 with %3 Phalanxx.", "Phalanxx Cannon");

KillTrak::DeathMessage("%2 was Killed by %1's EMP Blast.", "EMP");

KillTrak::DeathMessage("%1 shoots %2 down.", "Rocket");
KillTrak::DeathMessage("%2 was scorched by %1's Rocket.", "Rocket");

KillTrak::DeathMessage("%2 is Clueless after %1's Sniper Shot.", "Sniper Rifle");
KillTrak::DeathMessage("%1 punches a hole through %2's armor.", "Sniper Rifle");
KillTrak::DeathMessage("%2 becomes a victim of %1's IX-2000.", "Sniper Rifle");
KillTrak::DeathMessage("%2 REALLY never saw it coming from %1.", "Sniper Rifle");

KillTrak::DeathMessage("%1 bombed the crap outa %2.", "Bombs");

KillTrak::DeathMessage("%1 roasted %2 to a nice golden brown.", "Pyro-Torch");
KillTrak::DeathMessage("%2 was left with a burning sensation after %4 encounter with %1.", "Pyro-Torch");
KillTrak::DeathMessage("%1 overcooked %2.", "Pyro-Torch");
KillTrak::DeathMessage("%1 incinerated %2 with %3 Pyro-Torch.", "Pyro-Torch");
KillTrak::DeathMessage("%1 Overheated %2 with his Pyro-Torch.", "Pyro-Torch");
KillTrak::DeathMessage("%2 should have ran from %1's hot advances.", "Pyro-Torch");
KillTrak::DeathMessage("%2's Rocket Booster couldn't handle %1's Pyro-Torch.", "Pyro-Torch");
KillTrak::DeathMessage("%2 Exploded from the heat of %1's Pyro-Torch.", "Pyro-Torch");

KillTrak::DeathMessage("%2 was blown to bits by %1's Exploding Rocket Booster.", "Booster");
KillTrak::DeathMessage("%2 was caught in %1's blast.", "Booster");
KillTrak::DeathMessage("%2 was caught in %1's Backwash.", "Booster");
KillTrak::DeathMessage("%1's Backwash Overheated %2's Rocket Booster.", "Booster");
KillTrak::DeathMessage("%1 Overheated %2's Rocket Booster.", "Booster");

KillTrak::DeathMessage("%1 didn't recycle and it cost %2's %4 Life.", "Detonation");
KillTrak::DeathMessage("%2 gets caught by %1's discarded Booster.", "Detonation");
KillTrak::DeathMessage("%2 didnt want %1's old booster to go to waste.", "Detonation");
KillTrak::DeathMessage("%2 is going to keep clear of %1's litter from now on.", "Detonation");

KillTrak::DeathMessage("%2's Rocket Booster exploded on Impact.", "Suicide");
KillTrak::DeathMessage("%2 Overheated %4 Rocket Booster.", "Suicide");
KillTrak::DeathMessage("%2 was playing with fire and Overheated %4 Rocket Booster.", "Suicide");
KillTrak::DeathMessage("%2 discarded %4 Rocket Booster only to be killed by it anyway.", "Suicide");

KillTrak::DeathMessage("%1 reaped Vengeance upon %2", "Vengeance Missle Pack");
KillTrak::DeathMessage("%2 felt %1's hand of Vengeance", "Vengeance Missle Pack");
KillTrak::DeathMessage("%2 succumbed to %1's Vengeance", "Vengeance Missle Pack");
KillTrak::DeathMessage("%1's Vengeance anihiliated %2", "Vengeance Missle Pack");

KillTrak::DeathMessage("A Turret Overheated %2's Rocket Booster.", "Turret");
KillTrak::DeathMessage("%2 was downed by a Flak Cannon.", "Turret");
KillTrak::DeathMessage("%2 caught a little too much Flak.", "Turret");
KillTrak::DeathMessage("%2 heard someone yell PULL!", "Turret");

KillTrak::DeathMessage("%1's turret ripped up %2.", "Turret");
KillTrak::DeathMessage("%2 is chewed to pieces by %1's turret.", "Turret");
KillTrak::DeathMessage("%2 walked into %1's turret.", "Turret");
KillTrak::DeathMessage("%2 ends up on the wrong side of %1's turret.", "Turret");

KillTrak::DeathMessage("%1's sentry ripped up %2.", "Sentry");
KillTrak::DeathMessage("%2 is chewed to pieces by %1's sentry.", "Sentry");
KillTrak::DeathMessage("%2 walked into %1's sentry.", "Sentry");
KillTrak::DeathMessage("%2 ends up on the wrong side of %1's sentry.", "Sentry");

KillTrak::DeathMessage("%1's Avenger blasted %2 out of the sky.", "Avenger");
KillTrak::DeathMessage("%2 is torn up by %1's Avenger", "Avenger");
KillTrak::DeathMessage("%2 didn't spot %1's Avenger soon enough.", "Avenger");
KillTrak::DeathMessage("%2 was downed by %1's Avenger.", "Avenger");
// ============================================================================