// ======---- Defense HUD v1.31 ----====== //
// by I/O deRost     07/30/2000    derost@telusplanet.net
// http://www.planetstarsiege.com/blitzkrieg/scripts

// Defense HUD is a simple hud meant for defenders who want to keep track of teammates
// being killed. For example, if I'm front door HD with I/O MeSlayer on Siege, I wan't
// to know if he gets killed, so I can cover him. Or as another example, your an LD and
// need to cover the HoF, and dont want to be always checking the death messages. This
// method is quicker, and easier. You can also set it to track specific enemies. Lets
// say you're a capper, and want to check on the enemy HoF. Or LO escorting an HO. Or
// a two man LO team, or what have you. Or the resident floater needs to see in a hurry
// which defender to cover if they die.

// I was going to add mission specific locations as well, ie Front Door and Back Door
// on Siege, etc so that you could see where the most action was. I may still do this,
// but for now, this will work fine. Can't make it TOO easy on ya'll. :)


// Whats new in version 1.31
//		- Fixed a little silly bug that caused the hud to not show up.
//			oops. :(

// Whats new in version 1.3
//		- There is now a way to preload position settings via file. Not the most elegant
//			method, but it was the easiest. I have included an example file:
//					deRost_Siege.dpl.cs
//			The file name minus the extensions, is used to identify the file in NewOpts.
//			Pretty self explanitory.
//		- Fixed NewOpts (huge thanks to MrPoop for telling me how. That guy owns.)

// Whats new in version 1.2
// 		- NewOpts support added
//		- Few minor fixes and adjustments
//		- Sound stuff fixed. Now you can choose between sounds via newopts, and toggle
//			usage on/off.

// Whats new in version 1.1
//		- Sound support added. Will now play sounds to differentiate between enemy and
//			friendly deaths. For now it only uses localMessage(); and thus, if other ppl
//			use DefenseHUD, they will hear the sounds. Plus, you will not hear sounds in
//			demos. Not to big of a drawback, I hope.


Include( "Presto//HUD.cs"		);
Include( "Presto//TeamTrak.cs"	);
Include( "Presto//event.cs"		);

$deRostPrefs::dHUDPos = "50% 80% 240 20";
$dHUD::version = "v1.31";

// =================== DEBUG MODE true/false =================== //
$dHUD::Debug = false;
// ============================================================= //


// ===== DO NOT CROSS THIS LINE! THE CODE BELOW IS MESSY!! ===== //
// (consider yourself warned)

// ============== Bitmaps for friendly positions =============== //
$BMP::[fHD]  = "fHD.bmp";
$BMP::[fHoF] = "fHoF.bmp";
$BMP::[fTB]  = "fTB.bmp";
$BMP::[fLD]  = "fLD.bmp";
$BMP::[fHO]  = "fHO.bmp";
$BMP::[fMO]  = "fMO.bmp";
$BMP::[fLO]  = "fLO.bmp";
$BMP::[fCAP] = "fCAP.bmp";
// =============== Bitmaps for enemy positions ================= //
$BMP::[eHD]  = "eHD.bmp";
$BMP::[eHoF] = "eHoF.bmp";
$BMP::[eTB]  = "eTB.bmp";
$BMP::[eLD]  = "eLD.bmp";
$BMP::[eHO]  = "eHO.bmp";
$BMP::[eMO]  = "eMO.bmp";
$BMP::[eLO]  = "eLO.bmp";
$BMP::[eCAP] = "eCAP.bmp";
// ============================================================= //

Event::Attach ( eventKillTrak,			dHUD::onKillTrak	);
Event::Attach ( eventMissionInfo,		dHUD::initScript	);
Event::Attach ( eventConnected,			dHUD::initScript	);
Event::Attach ( eventChangeMission,		dHUD::Reset			);
Event::Attach ( eventClientDrop,		dHUD::PosSet		);
Event::Attach ( eventClientChangeTeam,	dHUD::initPlayers	);
Event::Attach ( eventClientMessage,		dHUD::matchStart	);

newObject( DefenseHUD, SimVolume, "deRost\\DefenseHUDgui.vol" );
newObject( DefenseHUD, SimVolume, "deRost\\DefenseHUDSounds.vol" );

function dHUD::setDefaults()
{
	$dHUDPrefs::soundFriendly = 0;
	$dHUDPrefs::soundEnemy = 0;
	$dHUDPrefs::useSoundF = true;
	$dHUDPrefs::useSoundE = true;
}
	
if( isFile( "config\\dHUDPrefs.cs" ) )
{
	Include( "dHUDPrefs.cs" );
	if( $dHUDPrefs::soundFriendly == "" )
		dHUD::setDefaults();
}
else
{
	dHUD::setDefaults();
}

function dHUD::SoundSelect( %team )
{
	if( %team == 0 )
		$dHUDPrefs::soundFriendly = FGCombo::getSelected( DefenseHUD::Combo_PlayF );
	else
		$dHUDPrefs::soundEnemy = FGCombo::getSelected( DefenseHUD::Combo_PlayE );
}

function dHUD::PreloadSelect()
{
	$dHUD::Preload = FGCombo::getSelected( DefenseHUD::Combo_PreLoad );
}

function dHUD::initScript()
{
	if( dHUD::Reset() && dHUD::initHUD() &&	dHUD::initPlayers() )
		return 1;
}

// ===== HEY, I TOLD YOU NOT TO LOOK DOWN HERE! DON'T YOU KNOW WHAT'S GOOD FOR YOU? =====

function dHUD::initHUD()
{
	dHUD::Reset();
	if( HUD::Exists ( dHUD ) )
	{
		HUD::Move( dHUD, $deRostPrefs::dHUDPos );
		HUD::Update( dHUD );
		return 1;
	}
	else
	{
		HUD::New( dHUD, dHUD::UpdateHUD, $deRostPrefs::dHUDPos );
		HUD::Display( dHUD, false );
		return 1;
	}
}

function dHUD::initMenu()
{
	dHUD::DebugPrintout();
	%char = "x1234567890abcdefghijklmnopqrst";
	Menu::New( dHUDmain, "Defense HUD" );
	%tnum = 1;
	for( %team = 0; %team <= 1; %team++ )
	{
		Menu::New( "dHUDteam" @ %team, "Choose Player" );
		
		if( %team == Client::getTeam( getManagerId() ) )
			Menu::addMenu( dHUDmain, %tnum @ "Friendly Team", 	"dHUDteam" @ %team );
		else
			Menu::addMenu( dHUDmain, %tnum @ "Enemy Team",		"dHUDteam" @ %team );
		%tnum++;

		for( %player = 1; %player <= $dHUD::TeamCount[ %team ]; %player++ )
		{
			%plId = $dHUDPlayerIndex::[ %team @ %player ];
			%plName = Client::getName( %plId );
			%choice = String::GetSubStr(%char, %player, 1);
			
			if( $dHUDPlayerWatch::[ %plId ] != "")
			{
				%flag = "*ON*  ";
				if( $dHUD::Debug )
					echo( %plName );
			}
			else
			{
				%flag = "";
			}
			
			Menu::addChoice( "dHUDteam" @ %team,
							 %choice @ %flag @ %plName,
							 "dHUD::PlayerPosMenu( " @ %plId @ " );" );
		}
	}
	Menu::addChoice( dHUDmain, %tnum @ " - Reset - ", "deleteVariables( \"$dHUDPlayerWatch::*\" );" );
	Menu::Display( dHUDmain );
	return 1;
}

function dHUD::PlayerPosMenu( %clientId )
{
	if( $dHUDPlayerWatch::[ %clientId ] == "" )
	{
//		%plName = Client::getName( %clientId );
		Menu::New( dHUDpos, "Choose Position" );
		Menu::addChoice( dHUDpos, "1Heavy Defense",			"dHUD::PosSet( " @ %clientId @ ", \"HD\"	);" );
		Menu::addChoice( dHUDpos, "2Heavy on Flag",			"dHUD::PosSet( " @ %clientId @ ", \"HoF\"	);" );
		Menu::addChoice( dHUDpos, "3Medium Defense/Turret",	"dHUD::PosSet( " @ %clientId @ ", \"TB\"	);" );
		Menu::addChoice( dHUDpos, "4Light Defense",			"dHUD::PosSet( " @ %clientId @ ", \"LD\"	);" );
		Menu::addChoice( dHUDpos, "5Heavy Offense",			"dHUD::PosSet( " @ %clientId @ ", \"HO\"	);" );
		Menu::addChoice( dHUDpos, "6Medium Offense",		"dHUD::PosSet( " @ %clientId @ ", \"MO\"	);" );
		Menu::addChoice( dHUDpos, "7Light Offense",			"dHUD::PosSet( " @ %clientId @ ", \"LO\"	);" );
		Menu::addChoice( dHUDpos, "8Flag Capper",			"dHUD::PosSet( " @ %clientId @ ", \"CAP\"	);" );
		Menu::Display( dHUDpos );
	}
	else
	{
		dHUD::PosSet( %clientId, false );
	}
}

function dHUD::PosSet( %clientId, %pos )
{
	if( %pos == false || %pos == "" )
	{
		//if( $dHUDPlayerWatch::[ %clientId ] != "")
			//remoteBP(2048, "<jc>"@ Client::getName( %clientId ) @ " removed from DefenseHUD death watch.", 2 );
		deleteVariables( "$dHUDPlayerWatch::" @ %clientId );
	}
	else
	{
		$dHUDPlayerWatch::[ %clientId ] = %pos;
		remoteBP(2048, "<jc>"@ Client::getName( %clientId ) @ " marked for DefenseHUD death watch.", 2 );
	}
	if( $dHUD::Debug )
		echo( "Client " @ %clientId @ " set for " @ %pos );
}

function dHUD::initPlayers()
{
	$dHUD::TeamCount[ 0 ] = 0;
	$dHUD::TeamCount[ 1 ] = 0;
	deleteVariables( "$dHUDPlayerIndex::*" );
	
	for( %i = 2049; %i <= 2083; %i++ ) {
		if( Client::getName( %i ) != "" ) {
			dHUD::addPlayer( %i );
		}
	}
	return 1;
}

function dHUD::addPlayer( %clientId )
{
	if( $dHUD::Debug )
		echo( "Adding Player: " @ Client::getName( %clientId ) );
  
	%team = Client::getTeam( %clientId );
	if( %team < -1 || %team > 1 )
		return;
		
	$dHUD::TeamCount[ %team ]++;
	
	$dHUDPlayerIndex::[ %team @ $dHUD::TeamCount [ %team ] ] = %clientId;
}

function dHUD::performPreload()
{
	echo( "match has started." );
	%fileNum = $dHUD::Preload;
	if( isFile( "config\\deRost\\" @ $dHUD::Preload[ %fileNum ] @ ".dpl.cs" ) )
	{
		echo( "Found File." );
		Exec( "deRost\\" @ $dHUD::Preload[ %fileNum ] @ ".dpl.cs" );
		%num = 0;
		while( $dHUDPreSelect[ %num ] != "" )
		{
			%blar = $dHUDPreSelect[ %num ];
			%pos = getWord( %blar, 0 );
			%len = Match::strLen( %pos );
			%name = String::getSubStr( %blar, %len + 1, Match::strLen( %blar ) - %len - 1 );
			%clientId = getClientByName( %name );
			if( %clientId != -1 )
				$dHUDPlayerWatch::[ %clientId ] = %pos;
			%num++;
		}
	}
	else
		echo( "File not found: " @ $dHUD::Preload[ %fileNum ] );
}

function dHUD::FlashHUD()
{
	if( $dHUDPlayerWatch::Current != "" )
	{
		localMessage( $dHUD::Sound );
		Schedule( "HUD::Display( dHUD, true  );", 0   );
		Schedule( "HUD::Display( dHUD, false );", 3   );
		Schedule( "HUD::Display( dHUD, true  );", 3.5 );
		Schedule( "HUD::Display( dHUD, false );", 4   );
		Schedule( "HUD::Display( dHUD, true  );", 4.5 );
		Schedule( "HUD::Display( dHUD, false );", 5   );
		Schedule( "HUD::Display( dHUD, true  );", 5.5 );
		Schedule( "HUD::Display( dHUD, false );", 6   );
	}
}

function dHUD::UpdateHUD()
{
	if( $dHUDPlayerWatch::Current != "" )
	{
		%plId = $dHUDPlayerWatch::Current;
		%plPos = $dHUDPlayerWatch::[ %plId ];
		%plName = Client::getName( %plId );
		%plTeam = Client::getTeam( %plId );
		
		if( %plTeam == Client::getTeam( getManagerId() ) )
		{
			%team = "f";
			%sound = $dHUDPrefs::soundFriendly;
			if( $dHUDPrefs::useSoundF == true )
				$dHUD::Sound = $dHUDSounds[ %sound ];
			else
				$dHUD::Sound = "";
		}
		else
		{
			%team = "e";
			%sound = $dHUDPrefs::soundEnemy;
			if( $dHUDPrefs::useSoundE == true )
				$dHUD::Sound = $dHUDSounds[ %sound ];
			else
				$dHUD::Sound = "";
		}
		
		HUD::AddText( dHUD,"<b0,0:" @ $BMP::[ %team @ %plPos ] @ "><jr><f2>" @ %plName @ "      " );
	}
	else
		HUD::AddText( dHUD, "" );
	return 1;
}

function dHUD::Reset()
{
	$dHUD::TeamCount[ 0 ] = 0;
	$dHUD::TeamCount[ 1 ] = 0;
	deleteVariables( "$dHUDPlayerIndex::*" );
	deleteVariables( "$dHUDPlayerWatch::*" );
	return 1;
}

function dHUD::DebugPrintout()
{
	if( $dHUD::Debug )
	{
		echo( "$dHUD::TeamCount[ 0 ] = " @ $dHUD::TeamCount[ 0 ] );
		echo( "$dHUD::TeamCount[ 1 ] = " @ $dHUD::TeamCount[ 1 ] );
		echo( "$dHUDPlayerWatch::Current = " @ $dHUDPlayerWatch::Current );
		for( %team = 0; %team <= 1; %team++ )
		{
			for( %plNum = 1; %plNum <= $dHUD::TeamCount[ %team ]; %plNum++ )
			{
				%plId = $dHUDPlayerIndex::[ %team @ %plNum ];
				echo( "$dHUDPlayerIndex::[ " @ %team @ " @ " @ %plNum @ " ] = " @ %plId );
			}

			for( %plNum = 1; %plNum <= $dHUD::TeamCount[ %team ]; %plNum++ )
			{
				%plId = $dHUDPlayerIndex::[ %team @ %plNum ];
				echo( "$dHUDPlayerWatch::[ " @ %plId @ " ] = " @ $dHUDPlayerWatch::[ %plId ] );
			}
		}
	}
}

function dHUD::onKillTrak( %killer, %victim, %weapon )
{
	if( $dHUDPlayerWatch::[ %victim ] != "" )
	{
		$dHUDPlayerWatch::Current = %victim;
		if( dHUD::UpdateHUD() )
		{
			dHUD::FlashHUD();
		}
	}
	if( $dHUD::Debug )
	{
		echo( "%killer = " @ %killer @ "; %victim = " @ %victim @ "; %weapon = " @ %weapon @ ";" );
		echo( "$dHUDPlayerWatch::[" @ %victim @ "] = " @ $dHUDPlayerWatch::[ %victim ] );
	}
}

function CheckSound( %team )
{
	if( %team == 0 )
	{
		Control::setActive( DefenseHUD::Combo_PlayF, $dHUDPrefs::useSoundF );
		Control::setActive( DefenseHUD::PlayFriendly, $dHUDPrefs::useSoundF );
	}
	else
	{
		Control::setActive( DefenseHUD::Combo_PlayE, $dHUDPrefs::useSoundE );
		Control::setActive( DefenseHUD::PlayEnemy, $dHUDPrefs::useSoundE );
	}
}

function dHUD::matchStart( %client, %msg )
{
	if( String::findSubStr( %msg, "Match Started" ) != -1 )
	{
		dHUD::performPreload();
		return;
	}
}

function DefenseHUD::OnOpen()
{
	Control::setValue( "DefenseHUD::version", "<jl><f1>" @ $dHUD::version );
	Control::setValue( "DefenseHUD::Title01", "<B0,0:dHUD_BG1.bmp>" );
	Control::setValue( "DefenseHUD::Title02", "<B0,0:dHUD_BG2.bmp>" );
	FGCombo::clear( DefenseHUD::Combo_PlayF );
	FGCombo::clear( DefenseHUD::Combo_PlayE );
	if( isFile( "config\\deRost\\dHUDSoundList.cs" ) )
	{
		Include( "deRost\\dHUDSoundList.cs" );
		for( %i = 0; %i <= 10; %i++ )
		{
			if( $dHUDSounds[ %i ] != "" )
			{
				FGCombo::addEntry( DefenseHUD::Combo_PlayF, $dHUDSounds[ %i ], %i );
				FGCombo::addEntry( DefenseHUD::Combo_PlayE, $dHUDSounds[ %i ], %i );
			}
		}
	}
	FGCombo::setSelected( DefenseHUD::Combo_PlayF, $dHUDPrefs::soundFriendly );
	FGCombo::setSelected( DefenseHUD::Combo_PlayE, $dHUDPrefs::soundEnemy );
	CheckSound( 0 );
	CheckSound( 1 );
	
	FGCombo::clear( DefenseHUD::Combo_PreLoad );
	FGCombo::addEntry( DefenseHUD::Combo_PreLoad, " - NONE -", %fileCount );
	%fileCount = 1;
	%file = File::findFirst( "deRost\\*.dpl.cs" );
	while( %file != "" )
	{
		%strIndex = String::findSubStr( %file, ".dpl.cs" );
		%listName = String::getSubStr(  %file, 7, %strIndex - 7 );

		if( %listName != "" )
		{
			$dHUD::Preload[ %fileCount ] = %listName;
			FGCombo::addEntry( DefenseHUD::Combo_PreLoad, %listName, %fileCount );
			%fileCount++;
		}

      %file = File::findNext( "deRost\\*.dpl.cs" );
	}
	FGCombo::setSelected( DefenseHUD::Combo_PreLoad, $dHUD::Preload );
	
	Control::setVisible( DefenseHUD::PlayFriendly, false );		// disabled for now. :(
	Control::setVisible( DefenseHUD::PlayEnemy, false );		// disabled for now. :(
}

function DefenseHUD::OnClose()
{
	export( "$dHUDPrefs::*", "config\\dHUDPrefs.cs", false );
}

Presto::AddScriptBanner( DefenseHUD, "<B3,4:dHUD_PBanner.bmp>" );
NewOpts::register( "DefenseHUD", "DefenseHUD.gui", "DefenseHUD::OnOpen();", "DefenseHUD::onClose();", true );
NewOpts::registerHelp("DefenseHUD", "General", "Defense HUD " @ $dHUD::version @ " is a simple tool for keeping track of the deaths of key players. It was designed for HD originally, where 2 HD needed to keep tabs on each other, so that one could cover the other, in case of death. This just makes it easier. And it is not limited to HD; you can use this for any position played, on any team.");
NewOpts::registerHelp("DefenseHUD", "Preload List", "This is a feature I dont use much, myself, for the simple reason that in my Tribe, we alternate roles a fair bit. However, it helps if you want to set up your death-list before a match. I've provided a file as an example: deRost_Siege.dpl.cs  It should be pretty self explanitory. Filename can be anything, as long as the extension is .dpl.cs");
NewOpts::registerHelp("DefenseHUD", "Friendly Sound", "This allows you to select what sound file you wish to play when a teammate dies.");
NewOpts::registerHelp("DefenseHUD", "Enemy Sound", "This allows you to select what sound file you wish to play when an enemy player dies.");
NewOpts::registerHelp("DefenseHUD", "Author", "Written and performed by I/O deRost... that Shaun guy. He's pretty cool. Yes, uh huh. He's Canadian. He lives in an igloo, and sleeps with a moose. Eh.");
if( dHUD::InitScript() )
	echo( "========== Defense HUD " @ $dHUD::version @ " loaded ==========" );