$clock::Xoffset = "54";
$clock::Yoffset = "18";

function Clock::Init() {

	if($Clock::Loaded)
	  return;

	$Clock::Loaded = true;
	
	$Clock::Container = newObject("Clock_Container", SimGui::Control, 0, 0, 86, 19);
	$Clock::HUD = newObject("Clock_Text", FearGuiFormattedText, 4, 0, 66, 19);

	addtoset($Clock::Container, $Clock::HUD);
}

function Clock::Update(%min, %sec) {

	$ClockHud::Hour = floor(%min / 60);
	$ClockHud::Min = %min % 60;
	$ClockHud::Sec = %sec;

	$ClockHud::CountingDown = true;

	schedule::Add("Clock::Iterate();", 1);

	Control::setValue("Clock_Text", "<f2>" @ LZero($ClockHud::Hour) @ ":" @ LZero($ClockHud::Min) @ ":" @ LZero($ClockHud::Sec));
}

function Clock::SetReverse() {

	$ClockHud::Hour = $ClockHud::Min = $clockHud::Sec = 0;
	$ClockHud::CountingDown = false;
}

function LZero(%number) {

	if (%number < 10) 
	  return "0" @ %number;
	else 
	  return %number;
}

function Clock::Iterate() {

	if(!$Mode::PlayMode)
	  return;

	if($ClockHud::CountingDown) {

		if($ClockHud::Sec > 0) {
		  $ClockHud::Sec--;
		}

		else {
		  $ClockHud::Sec = 59;
		
			if ($ClockHud::Min > 0) {
			  $ClockHud::Min--;
			}

			else {
			  $ClockHud::Min = 59;
			  $ClockHud::Hour--;
			}
		}

	} else {

		if ($ClockHud::Sec < 59) {
		  $ClockHud::Sec++;
		}

		else {
		  $ClockHud::Sec = 0;
		
			if ($ClockHud::Min < 59) {
			  $ClockHud::Min++;
			}

			else {
			  $ClockHud::Min = 0;
			  $ClockHud::Hour++;
			}
		}
	}

	schedule::add("Clock::Iterate();", 1);

	Control::setValue("Clock_Text", "<f2>" @ LZero($ClockHud::Hour) @ ":" @ LZero($ClockHud::Min) @ ":" @ LZero($ClockHud::Sec));
}

function Clock::GuiOpen(%gui) {

	if(%gui != playGui)
	  return;

	addToSet(playGui, $Clock::Container);

    	$clock::PosX = ($ScreenX-$clock::Xoffset);
    	$clock::PosY = ($ScreenY-$clock::Yoffset);

	control::setPosition("Clock_Container", $clock::PosX, $clock::PosY);
}

function Clock::GuiClose(%gui) {

	if(%gui != playGui)
	  return;

	removeFromSet(playGui, $Clock::Container);
}

function Clock::Set() {

	$ClockHud::Hour = $ClockHud::Min = $clockHud::Sec = 0;
	schedule("ClockHud::Iterate();", 1);
	Control::setValue("Clock_Text", "<f2>" @ LZero($ClockHud::Hour) @ ":" @ LZero($ClockHud::Min) @ ":" @ LZero($ClockHud::Sec));
}

function Clock::Destroy() {

        removeFromSet(playGui, $Clock::Container);
        deleteObject($Clock::Container);
}

Event::Attach(eventGuiOpen, Clock::GuiOpen);
Event::Attach(eventGuiClose, Clock::GuiClose);
Event::Attach(eventConnected, Clock::Set);
Event::Attach(eventExitGame, Clock::Destroy);
Event::Attach(eventMatchStarted, Clock::SetReverse);
Event::Attach(eventUpdateTime, Clock::Update);

Clock::Init();

